"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip


class QDBusUnixFileDescriptor(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qdbusunixfiledescriptor.html

    **Detailed Description**

    The QDBusUnixFileDescriptor class is used to hold one Unix file descriptor
    for use with the Qt D-Bus module. This allows applications to send and
    receive Unix file descriptors over the D-Bus connection, mapping
    automatically to the D-Bus type 'h'.

    Objects of type QDBusUnixFileDescriptors can be used also as parameters in
    signals and slots that get exported to D-Bus by registering with
    **QDBusConnection::registerObject** .

    QDBusUnixFileDescriptor does not take ownership of the file descriptor.
    Instead, it will use the Unix system call `dup(2)` to make a copy of the
    file descriptor. This file descriptor belongs to the QDBusUnixFileDescriptor
    object and should not be stored or closed by the user. Instead, you should
    make your own copy if you need that.

    **Availability**

    Unix file descriptor passing is not available in all D-Bus connections. This
    feature is present with D-Bus library and bus daemon version 1.4 and upwards
    on Unix systems. Qt D-Bus automatically enables the feature if such a
    version was found at compile-time and run-time.

    To verify that your connection does support passing file descriptors, check
    if the **QDBusConnection::UnixFileDescriptorPassing**  capability is set
    with **QDBusConnection::connectionCapabilities** (). If the flag is not
    active, then you will not be able to make calls to methods that have
    QDBusUnixFileDescriptor as arguments or even embed such a type in a variant.
    You will also not receive calls containing that type.

    Note also that remote applications may not have support for Unix file
    descriptor passing. If you make a D-Bus to a remote application that cannot
    receive such a type, you will receive an error reply. If you try to send a
    signal containing a D-Bus file descriptor or return one from a method call,
    the message will be silently dropped.

    Even if the feature is not available, QDBusUnixFileDescriptor will continue
    to operate, so code need not have compile-time checks for the availability
    of this feature.

    On non-Unix systems, QDBusUnixFileDescriptor will always report an invalid
    state and **QDBusUnixFileDescriptor::isSupported** () will return false.

    **See also** **QDBusConnection::ConnectionCapabilities**  and
    **QDBusConnection::connectionCapabilities** ().
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qdbusunixfiledescriptor.html#QDBusUnixFileDescrip
        tor

        **QDBusUnixFileDescriptor::QDBusUnixFileDescriptor()**

        Constructs a QDBusUnixFileDescriptor without a wrapped file descriptor.
        This is equivalent to constructing the object with an invalid file
        descriptor (like -1).

        **See also** **fileDescriptor** () and **isValid** ().
        """
        ...

    @typing.overload
    def __init__(self, fileDescriptor: int) -> None:
        """
        https://doc.qt.io/qt-6/qdbusunixfiledescriptor.html#QDBusUnixFileDescrip
        tor-1

        **QDBusUnixFileDescriptor::QDBusUnixFileDescriptor(int fileDescriptor
        )**

        Constructs a QDBusUnixFileDescriptor object by copying the
        **fileDescriptor** parameter. The original file descriptor is not
        touched and must be closed by the user.

        Note that the value returned by **fileDescriptor** () will be different
        from the **fileDescriptor** parameter passed.

        If the **fileDescriptor** parameter is not valid, **isValid** () will
        return false and **fileDescriptor** () will return -1.

        **See also** **setFileDescriptor** () and **fileDescriptor** ().
        """
        ...

    @typing.overload
    def __init__(self, other: "QDBusUnixFileDescriptor") -> None:
        """
        https://doc.qt.io/qt-6/qdbusunixfiledescriptor.html#QDBusUnixFileDescrip
        tor-2

        **QDBusUnixFileDescriptor::QDBusUnixFileDescriptor(const
        QDBusUnixFileDescriptor & other )**

        Constructs a QDBusUnixFileDescriptor object by copying **other**.
        """
        ...

    def swap(self, other: "QDBusUnixFileDescriptor") -> None:
        """
        https://doc.qt.io/qt-6/qdbusunixfiledescriptor.html#swap

        **[since 5.0] void QDBusUnixFileDescriptor::swap(QDBusUnixFileDescriptor
        & other )**

        Swaps this file descriptor instance with **other**. This function is
        very fast and never fails.

        This function was introduced in Qt 5.0.
        """
        ...

    @staticmethod
    def isSupported() -> bool:
        """
        https://doc.qt.io/qt-6/qdbusunixfiledescriptor.html#isSupported

        **[static] bool QDBusUnixFileDescriptor::isSupported()**

        Returns `true` if Unix file descriptors are supported on this platform.
        In other words, this function returns `true` if this is a Unix platform.

        Note that **QDBusUnixFileDescriptor**  continues to operate even if this
        function returns `false`. The only difference is that the
        **QDBusUnixFileDescriptor**  objects will always be in the **isValid**
        () == false state and **fileDescriptor** () will always return -1. The
        class will not consume any operating system resources.
        """
        ...

    def setFileDescriptor(self, fileDescriptor: int) -> None:
        """
        https://doc.qt.io/qt-6/qdbusunixfiledescriptor.html#setFileDescriptor

        **void QDBusUnixFileDescriptor::setFileDescriptor(int fileDescriptor )**

        Sets the file descriptor that this **QDBusUnixFileDescriptor**  object
        holds to a copy of **fileDescriptor**. The original file descriptor is
        not touched and must be closed by the user.

        Note that the value returned by **fileDescriptor** () will be different
        from the **fileDescriptor** parameter passed.

        If the **fileDescriptor** parameter is not valid, **isValid** () will
        return false and **fileDescriptor** () will return -1.

        **See also** **isValid** () and **fileDescriptor** ().
        """
        ...

    def fileDescriptor(self) -> int:
        """
        https://doc.qt.io/qt-6/qdbusunixfiledescriptor.html#fileDescriptor

        **int QDBusUnixFileDescriptor::fileDescriptor() const**

        Returns the Unix file descriptor contained by this
        **QDBusUnixFileDescriptor**  object. An invalid file descriptor is
        represented by the value -1.

        Note that the file descriptor returned by this function is owned by the
        **QDBusUnixFileDescriptor**  object and must not be stored past the
        lifetime of this object. It is ok to use it while this object is valid,
        but if one wants to store it for longer use, the file descriptor should
        be cloned using the Unix `dup(2)`, `dup2(2)` or `dup3(2)` functions.

        **See also** **setFileDescriptor** () and **isValid** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qdbusunixfiledescriptor.html#isValid

        **bool QDBusUnixFileDescriptor::isValid() const**

        Returns `true` if this Unix file descriptor is valid. A valid Unix file
        descriptor is not -1.

        **See also** **fileDescriptor** ().
        """
        ...
