"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
from PyQt6 import QtCore
from PyQt6.QtGui import *
import enum


class QActionGroup(QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qactiongroup.html

    **Detailed Description**

    QActionGroup is a base class for classes grouping classes inhheriting
    **QAction**  objects together.

    In some situations it is useful to group **QAction**  objects together. For
    example, if you have a **Left Align** action, a **Right Align** action, a
    **Justify** action, and a **Center** action, only one of these actions
    should be active at any one time. One simple way of achieving this is to
    group the actions together in an action group, inheriting QActionGroup.

    **See also** **QAction** .
    """

    class ExclusionPolicy(enum.Enum):
        None_: QActionGroup = ...
        Exclusive: QActionGroup = ...
        ExclusiveOptional: QActionGroup = ...

    def __init__(self, parent: QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-6/qactiongroup.html#QActionGroup

        **QActionGroup::QActionGroup(QObject * parent )**

        Constructs an action group for the **parent** object.

        The action group is exclusive by default. Call **setExclusive** (false)
        to make the action group non-exclusive. To make the group exclusive but
        allow unchecking the active action call instead **setExclusionPolicy**
        (**QActionGroup::ExclusionPolicy::ExclusiveOptional** )
        """
        ...

    def hovered(self, a0: QAction) -> None:
        ...

    def triggered(self, a0: QAction) -> None:
        ...

    def setExclusionPolicy(self, policy: "QActionGroup.ExclusionPolicy") -> None:
        """
        https://doc.qt.io/qt-6/qactiongroup.html#exclusionPolicy-prop

        **exclusionPolicy : QActionGroup::ExclusionPolicy**

        This property holds the group exclusive checking policy

        If exclusionPolicy is set to Exclusive, only one checkable action in the
        action group can ever be active at any time. If the user chooses another
        checkable action in the group, the one they chose becomes active and the
        one that was active becomes inactive. If exclusionPolicy is set to
        ExclusionOptional the group is exclusive but the active checkable action
        in the group can be unchecked leaving the group with no actions checked.

        **Access functions:**

        QActionGroup::ExclusionPolicy **exclusionPolicy** () const
        void
        **setExclusionPolicy** (QActionGroup::ExclusionPolicy **policy** )

        **See also** **QAction::checkable** .
        """
        ...

    def setExclusive(self, a0: bool) -> None:
        """
        https://doc.qt.io/qt-6/qactiongroup.html#setExclusive

        **[slot] void QActionGroup::setExclusive(bool b )**

        Enable or disable the group exclusion checking

        This is a convenience method that calls **setExclusionPolicy**
        (**ExclusionPolicy::Exclusive** ) when **b** is true, else
        **setExclusionPolicy** (**QActionGroup::ExclusionPolicy::None** ).

        **See also** **isExclusive** () and **QActionGroup::exclusionPolicy** .
        """
        ...

    def setVisible(self, a0: bool) -> None:
        """
        https://doc.qt.io/qt-6/qactiongroup.html#visible-prop

        **visible : bool**

        This property holds whether the action group is visible

        Each action in the action group will match the visible state of this
        group unless it has been explicitly hidden.

        **Access functions:**

        bool **isVisible** () const
        void **setVisible** (bool)

        **See also** **QAction::setEnabled** ().

        **Member Function Documentation**
        """
        ...

    def setDisabled(self, b: bool) -> None:
        """
        https://doc.qt.io/qt-6/qactiongroup.html#setDisabled

        **[slot] void QActionGroup::setDisabled(bool b )**

        This is a convenience function for the **enabled**  property, that is
        useful for signals--slots connections. If **b** is true the action group
        is disabled; otherwise it is enabled.
        """
        ...

    def setEnabled(self, a0: bool) -> None:
        """
        https://doc.qt.io/qt-6/qactiongroup.html#enabled-prop

        **enabled : bool**

        This property holds whether the action group is enabled

        Each action in the group will be enabled or disabled unless it has been
        explicitly disabled.

        **Access functions:**

        bool **isEnabled** () const
        void **setEnabled** (bool)

        **See also** **QAction::setEnabled** ().
        """
        ...

    def exclusionPolicy(self) -> "QActionGroup.ExclusionPolicy":
        """
        https://doc.qt.io/qt-6/qactiongroup.html#exclusionPolicy-prop

        **exclusionPolicy : QActionGroup::ExclusionPolicy**

        This property holds the group exclusive checking policy

        If exclusionPolicy is set to Exclusive, only one checkable action in the
        action group can ever be active at any time. If the user chooses another
        checkable action in the group, the one they chose becomes active and the
        one that was active becomes inactive. If exclusionPolicy is set to
        ExclusionOptional the group is exclusive but the active checkable action
        in the group can be unchecked leaving the group with no actions checked.

        **Access functions:**

        QActionGroup::ExclusionPolicy **exclusionPolicy** () const
        void
        **setExclusionPolicy** (QActionGroup::ExclusionPolicy **policy** )

        **See also** **QAction::checkable** .
        """
        ...

    def isVisible(self) -> bool:
        ...

    def isEnabled(self) -> bool:
        ...

    def isExclusive(self) -> bool:
        """
        https://doc.qt.io/qt-6/qactiongroup.html#isExclusive

        **bool QActionGroup::isExclusive() const**

        Returns true if the group is exclusive

        The group is exclusive if the **ExclusionPolicy**  is either Exclusive
        or ExclusionOptional.
        """
        ...

    def checkedAction(self) -> QAction:
        """
        https://doc.qt.io/qt-6/qactiongroup.html#checkedAction

        **QAction *QActionGroup::checkedAction() const**

        Returns the currently checked action in the group, or `nullptr` if none
        are checked.
        """
        ...

    def actions(self) -> typing.List[QAction]:
        """
        https://doc.qt.io/qt-6/qactiongroup.html#actions

        **QList<QAction *> QActionGroup::actions() const**

        Returns the list of this groups's actions. This may be empty.
        """
        ...

    def removeAction(self, a: QAction) -> None:
        """
        https://doc.qt.io/qt-6/qactiongroup.html#removeAction

        **void QActionGroup::removeAction(QAction * action )**

        Removes the **action** from this group. The action will have no parent
        as a result.

        **See also** **QAction::setActionGroup** ().
        """
        ...

    @typing.overload
    def addAction(self, a: QAction) -> QAction:
        """
        https://doc.qt.io/qt-6/qactiongroup.html#addAction

        **QAction *QActionGroup::addAction(QAction * action )**

        Adds the **action** to this group, and returns it.

        Normally an action is added to a group by creating it with the group as
        its parent, so this function is not usually used.

        **See also** **QAction::setActionGroup** ().
        """
        ...

    @typing.overload
    def addAction(self, text: str) -> QAction:
        """
        https://doc.qt.io/qt-6/qactiongroup.html#addAction-1

        **QAction *QActionGroup::addAction(const QString & text )**

        Creates and returns an action with **text**. The newly created action is
        a child of this action group.

        Normally an action is added to a group by creating it with the group as
        parent, so this function is not usually used.

        **See also** **QAction::setActionGroup** ().
        """
        ...

    @typing.overload
    def addAction(self, icon: "QIcon", text: str) -> QAction:
        """
        https://doc.qt.io/qt-6/qactiongroup.html#addAction-2

        **QAction *QActionGroup::addAction(const QIcon & icon , const QString &
        text )**

        Creates and returns an action with **text** and an **icon**. The newly
        created action is a child of this action group.

        Normally an action is added to a group by creating it with the group as
        its parent, so this function is not usually used.

        **See also** **QAction::setActionGroup** ().
        """
        ...
