"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtGui import *


class QColorTransform(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qcolortransform.html

    **Detailed Description**

    QColorTransform is an instantiation of a transformation between color
    spaces. It can be applied on color and pixels to convert them from one color
    space to another.

    Setting up a QColorTransform takes some preprocessing, so keeping around
    QColorTransforms that you need often is recommended, instead of generating
    them on the fly.
    """

    @typing.overload
    def __init__(self) -> None:
        ...

    @typing.overload
    def __init__(self, colorTransform: "QColorTransform") -> None:
        ...

    @typing.overload
    def map(self, argb: int) -> int:
        """
        https://doc.qt.io/qt-6/qcolortransform.html#map

        **QRgb QColorTransform::map(QRgb argb ) const**

        Applies the color transformation on the **QRgb**  value **argb**.

        The input should be opaque or unpremultiplied.
        """
        ...

    @typing.overload
    def map(self, rgba64: "QRgba64") -> "QRgba64":
        """
        https://doc.qt.io/qt-6/qcolortransform.html#map-1

        **QRgba64 QColorTransform::map(QRgba64 rgba64 ) const**

        Applies the color transformation on the **QRgba64**  value **rgba64**.

        The input should be opaque or unpremultiplied.
        """
        ...

    @typing.overload
    def map(
        self, color: typing.Union[QColor, QtCore.Qt.GlobalColor, int, QGradient]
    ) -> QColor:
        """
        https://doc.qt.io/qt-6/qcolortransform.html#map-2

        **QColor QColorTransform::map(const QColor & color ) const**

        Applies the color transformation on the **QColor**  value **color**.
        """
        ...

    def swap(self, other: "QColorTransform") -> None:
        ...
