"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt6 import QtCore
from PyQt6.QtGui import *


class QEnterEvent(QSinglePointEvent):
    """
    https://doc.qt.io/qt-6/qenterevent.html

    **Detailed Description**

    Enter events occur when the mouse cursor enters a window or a widget.
    """

    def __init__(
        self,
        localPos: QtCore.QPointF,
        scenePos: QtCore.QPointF,
        globalPos: QtCore.QPointF,
        device: typing.Optional["QPointingDevice"] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qenterevent.html#QEnterEvent-2

        **QEnterEvent::QEnterEvent(const QPointF & localPos , const QPointF &
        scenePos , const QPointF & globalPos , const QPointingDevice * device =
        QPointingDevice::primaryPointingDevice())**

        Constructs an enter event object originating from **device**.

        The points **localPos** , **scenePos** and **globalPos** specify the
        mouse cursor's position relative to the receiving widget or item,
        window, and screen or desktop, respectively.
        """
        ...

    def clone(self) -> "QEnterEvent":
        ...
