"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
from PyQt6 import QtCore
from PyQt6.QtGui import *
import enum


class QInputDevice(QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qinputdevice.html

    **Detailed Description**

    Each **QInputEvent**  contains a QInputDevice pointer to allow accessing
    device-specific properties like type, capabilities and seat. It is the
    responsibility of the platform or generic plug-ins to discover, create and
    register an instance of this class corresponding to each available input
    device, via QWindowSystemInterface::registerInputDevice(), before generating
    any input event referring to that device.

    Applications do not need to instantiate this class, but can read the
    instances pointed to by **QInputEvent::device** () and
    **QInputDevice::devices** ().
    """

    class Capability(enum.Flag):
        None_: QInputDevice = ...
        Position: QInputDevice = ...
        Area: QInputDevice = ...
        Pressure: QInputDevice = ...
        Velocity: QInputDevice = ...
        NormalizedPosition: QInputDevice = ...
        MouseEmulation: QInputDevice = ...
        PixelScroll: QInputDevice = ...
        Scroll: QInputDevice = ...
        Hover: QInputDevice = ...
        Rotation: QInputDevice = ...
        XTilt: QInputDevice = ...
        YTilt: QInputDevice = ...
        TangentialPressure: QInputDevice = ...
        ZPosition: QInputDevice = ...
        All: QInputDevice = ...

    class DeviceType(enum.Flag):
        Unknown: QInputDevice = ...
        Mouse: QInputDevice = ...
        TouchScreen: QInputDevice = ...
        TouchPad: QInputDevice = ...
        Puck: QInputDevice = ...
        Stylus: QInputDevice = ...
        Airbrush: QInputDevice = ...
        Keyboard: QInputDevice = ...
        AllDevices: QInputDevice = ...

    @typing.overload
    def __init__(
        self,
        name: str,
        systemId: int,
        type: "QInputDevice.DeviceType",
        seatName: str = ...,
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qinputdevice.html#QInputDevice

        **QInputDevice::QInputDevice(QObject * parent = nullptr)**

        Creates a new invalid input device instance as a child of **parent**.
        """
        ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qinputdevice.html#QInputDevice-1

        **QInputDevice::QInputDevice(const QString & name , qint64 id ,
        QInputDevice::DeviceType type , const QString & seatName = QString(),
        QObject * parent = nullptr)**

        Creates a new input device instance. The given **name** is normally a
        manufacturer-assigned model name if available, or something else
        identifiable; **id** is a platform-specific number that will be unique
        per device (for example the xinput ID on X11); **type** identifies what
        kind of device. On window systems that are capable of handling input
        from multiple users or sets of input devices at the same time (such as
        Wayland or X11), **seatName** identifies the name of the set of devices
        that will be used together. If the device is a child or slave device
        (for example one of several mice that can take turns moving the "core
        pointer"), the master device should be given as the **parent**.

        The platform plugin creates, registers and continues to own each device
        instance; usually **parent** should be given for memory management
        purposes even if there is no master for a particular device.

        By default, **capabilities** () are `None`.
        """
        ...

    def availableVirtualGeometryChanged(self, area: QtCore.QRect) -> None:
        ...

    @staticmethod
    def primaryKeyboard(seatName: str = ...) -> "QInputDevice":
        """
        https://doc.qt.io/qt-6/qinputdevice.html#primaryKeyboard

        **[static] const QInputDevice *QInputDevice::primaryKeyboard(const
        QString & seatName = QString())**

        Returns the core or master keyboard on the given seat **seatName**.
        """
        ...

    @staticmethod
    def devices() -> typing.List["QInputDevice"]:
        """
        https://doc.qt.io/qt-6/qinputdevice.html#devices

        **[static] QList<const QInputDevice *> QInputDevice::devices()**

        Returns a list of all registered input devices (keyboards and pointing
        devices).

        **Note:** The returned list cannot be used to add new devices. To add a
        simulated touch screen for an autotest, **QTest::createTouchDevice** ()
        can be used. Platform plugins should call
        QWindowSystemInterface::registerInputDevice() to add devices as they are
        discovered.
        """
        ...

    def availableVirtualGeometry(self) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qinputdevice.html#availableVirtualGeometry

        **QRect QInputDevice::availableVirtualGeometry() const**

        Returns the region within the **virtual desktop**  that this device can
        access.

        For example a **TouchScreen**  input device is fixed in place upon a
        single physical screen, and usually calibrated so that this area is the
        same as **QScreen::geometry** (); whereas a **Mouse**  can probably
        access all screens on the virtual desktop. A Wacom graphics tablet may
        be configured in a way that it's mapped to all screens, or only to the
        screen where the user prefers to create drawings, or to the window in
        which drawing occurs. A **Stylus**  device that is integrated with a
        touchscreen may be physically limited to that screen.

        If the returned rectangle is **null** , it means this device can access
        the entire virtual desktop.

        **Note:** Getter function for property availableVirtualGeometry.
        """
        ...

    def seatName(self) -> str:
        """
        https://doc.qt.io/qt-6/qinputdevice.html#seatName

        **QString QInputDevice::seatName() const**

        Returns the seat with which the device is associated, if known;
        otherwise empty.

        Devices that are intended to be used together by one user may be
        configured to have the same seat name. That is only possible on Wayland
        and X11 platforms so far.

        **Note:** Getter function for property seatName.
        """
        ...

    def systemId(self) -> int:
        """
        https://doc.qt.io/qt-6/qinputdevice.html#systemId

        **qint64 QInputDevice::systemId() const**

        Returns the platform specific system ID (for example xinput ID on the
        X11 platform).

        All platforms are expected to provide a unique system ID for each
        device.

        **Note:** Getter function for property systemId.
        """
        ...

    def hasCapability(self, cap: "QInputDevice.Capability") -> bool:
        """
        https://doc.qt.io/qt-6/qinputdevice.html#hasCapability

        **bool QInputDevice::hasCapability(QInputDevice::Capability capability )
        const**

        Returns whether the device capabilities include the given
        **capability**.
        """
        ...

    def capabilities(self) -> "QInputDevice.Capability":
        """
        https://doc.qt.io/qt-6/qinputdevice.html#capabilities

        **QInputDevice::Capabilities QInputDevice::capabilities() const**

        Returns the device capabilities.

        **Note:** Getter function for property capabilities.
        """
        ...

    def type(self) -> "QInputDevice.DeviceType":
        """
        https://doc.qt.io/qt-6/qinputdevice.html#type

        **QInputDevice::DeviceType QInputDevice::type() const**

        Returns the device type.

        **Note:** Getter function for property type.
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-6/qinputdevice.html#name

        **QString QInputDevice::name() const**

        Returns the device name.

        This string may be empty. It is however useful on systems that have
        multiple input devices: it can be used to differentiate from which
        device a **QPointerEvent**  originates.

        **Note:** Getter function for property name.
        """
        ...
