"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt6 import QtCore
from PyQt6.QtGui import *


class QLinearGradient(QGradient):
    """
    https://doc.qt.io/qt-6/qlineargradient.html

    **Detailed Description**

    Linear gradients interpolate colors between start and end points. Outside
    these points the gradient is either padded, reflected or repeated depending
    on the currently set **spread**  method:

    ![](images/qlineargradient-pad.png)![](images/qlineargradient-
    reflect.png)![](images/qlineargradient-repeat.png)
    **PadSpread**
    (default)**ReflectSpread** **RepeatSpread**

    The colors in a gradient is defined using stop points of the
    **QGradientStop**  type, i.e. a position and a color. Use the
    **QGradient::setColorAt** () or the **QGradient::setStops** () function to
    define the stop points. It is the gradient's complete set of stop points
    that describes how the gradient area should be filled. If no stop points
    have been specified, a gradient of black at 0 to white at 1 is used.

    In addition to the functions inherited from **QGradient** , the
    QLinearGradient class provides the **finalStop** () function which returns
    the final stop point of the gradient, and the **start** () function
    returning the start point of the gradient.

    **See also** **QRadialGradient** , **QConicalGradient** , and **The
    Gradients Example** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qlineargradient.html#QLinearGradient

        **QLinearGradient::QLinearGradient()**

        Constructs a default linear gradient with interpolation area between (0,
        0) and (1, 1).

        **See also** **QGradient::setColorAt** (), **setStart** (), and
        **setFinalStop** ().
        """
        ...

    @typing.overload
    def __init__(self, start: QtCore.QPointF, finalStop: QtCore.QPointF) -> None:
        """
        https://doc.qt.io/qt-6/qlineargradient.html#QLinearGradient-1

        **QLinearGradient::QLinearGradient(const QPointF & start , const QPointF
        & finalStop )**

        Constructs a linear gradient with interpolation area between the given
        **start** point and **finalStop**.

        **Note:** The expected parameter values are in pixels.

        **See also** **QGradient::setColorAt** () and **QGradient::setStops**
        ().
        """
        ...

    @typing.overload
    def __init__(
        self, xStart: float, yStart: float, xFinalStop: float, yFinalStop: float
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlineargradient.html#QLinearGradient-2

        **QLinearGradient::QLinearGradient(qreal x1 , qreal y1 , qreal x2 ,
        qreal y2 )**

        Constructs a linear gradient with interpolation area between ( **x1** ,
        **y1** ) and ( **x2** , **y2** ).

        **Note:** The expected parameter values are in pixels.

        **See also** **QGradient::setColorAt** () and **QGradient::setStops**
        ().
        """
        ...

    @typing.overload
    def __init__(self, a0: "QLinearGradient") -> None:
        """
        https://doc.qt.io/qt-6/qlineargradient.html#QLinearGradient

        **QLinearGradient::QLinearGradient()**

        Constructs a default linear gradient with interpolation area between (0,
        0) and (1, 1).

        **See also** **QGradient::setColorAt** (), **setStart** (), and
        **setFinalStop** ().
        """
        ...

    @typing.overload
    def setFinalStop(self, stop: QtCore.QPointF) -> None:
        """
        https://doc.qt.io/qt-6/qlineargradient.html#setFinalStop

        **void QLinearGradient::setFinalStop(const QPointF & stop )**

        Sets the final stop point of this linear gradient in logical coordinates
        to **stop**.

        **See also** **finalStop** ().
        """
        ...

    @typing.overload
    def setFinalStop(self, x: float, y: float) -> None:
        """
        https://doc.qt.io/qt-6/qlineargradient.html#setFinalStop-1

        **void QLinearGradient::setFinalStop(qreal x , qreal y )**

        This is an overloaded function.

        Sets the final stop point of this linear gradient in logical coordinates
        to **x** , **y**.

        **See also** **start** ().
        """
        ...

    @typing.overload
    def setStart(self, start: QtCore.QPointF) -> None:
        """
        https://doc.qt.io/qt-6/qlineargradient.html#setStart

        **void QLinearGradient::setStart(const QPointF & start )**

        Sets the start point of this linear gradient in logical coordinates to
        **start**.

        **See also** **start** ().
        """
        ...

    @typing.overload
    def setStart(self, x: float, y: float) -> None:
        """
        https://doc.qt.io/qt-6/qlineargradient.html#setStart-1

        **void QLinearGradient::setStart(qreal x , qreal y )**

        This is an overloaded function.

        Sets the start point of this linear gradient in logical coordinates to
        **x** , **y**.

        **See also** **start** ().
        """
        ...

    def finalStop(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qlineargradient.html#finalStop

        **QPointF QLinearGradient::finalStop() const**

        Returns the final stop point of this linear gradient in logical
        coordinates.

        **See also** **setFinalStop** () and **QGradient::stops** ().
        """
        ...

    def start(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qlineargradient.html#start

        **QPointF QLinearGradient::start() const**

        Returns the start point of this linear gradient in logical coordinates.

        **See also** **setStart** () and **QGradient::stops** ().
        """
        ...
