"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtGui import *


class QMatrix4x4(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qmatrix4x4.html

    **Detailed Description**

    The QMatrix4x4 class in general is treated as a row-major matrix, in that
    the constructors and **operator** () functions take data in row-major
    format, as is familiar in C-style usage.

    Internally the data is stored as column-major format, so as to be optimal
    for passing to OpenGL functions, which expect column-major data.

    When using these functions be aware that they return data in **column-
    major** format:

    * **data** ()
      * **constData** ()

    **See also** **QVector3D**  and **QGenericMatrix** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#QMatrix4x4

        **QMatrix4x4::QMatrix4x4()**

        Constructs an identity matrix.
        """
        ...

    @typing.overload
    def __init__(self, values: typing.Sequence[float]) -> None:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#QMatrix4x4-2

        **QMatrix4x4::QMatrix4x4(const float * values )**

        Constructs a matrix from the given 16 floating-point **values**. The
        contents of the array **values** is assumed to be in row-major order.

        If the matrix has a special type (identity, translate, scale, etc), the
        programmer should follow this constructor with a call to **optimize** ()
        if they wish QMatrix4x4 to optimize further calls to **translate** (),
        **scale** (), etc.

        **See also** **copyDataTo** () and **optimize** ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        m11: float,
        m12: float,
        m13: float,
        m14: float,
        m21: float,
        m22: float,
        m23: float,
        m24: float,
        m31: float,
        m32: float,
        m33: float,
        m34: float,
        m41: float,
        m42: float,
        m43: float,
        m44: float,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#QMatrix4x4-3

        **QMatrix4x4::QMatrix4x4(float m11 , float m12 , float m13 , float m14 ,
        float m21 , float m22 , float m23 , float m24 , float m31 , float m32 ,
        float m33 , float m34 , float m41 , float m42 , float m43 , float m44
        )**

        Constructs a matrix from the 16 elements **m11** , **m12** , **m13** ,
        **m14** , **m21** , **m22** , **m23** , **m24** , **m31** , **m32** ,
        **m33** , **m34** , **m41** , **m42** , **m43** , and **m44**. The
        elements are specified in row-major order.

        If the matrix has a special type (identity, translate, scale, etc), the
        programmer should follow this constructor with a call to **optimize** ()
        if they wish QMatrix4x4 to optimize further calls to **translate** (),
        **scale** (), etc.

        **See also** **optimize** ().
        """
        ...

    @typing.overload
    def __init__(self, transform: "QTransform") -> None:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#QMatrix4x4-4

        **template <int N, int M> QMatrix4x4::QMatrix4x4(const QGenericMatrix<N,
        M, float> & matrix = N)**

        Constructs a 4x4 matrix from the left-most 4 columns and top-most 4 rows
        of **matrix**. If **matrix** has less than 4 columns or rows, the
        remaining elements are filled with elements from the identity matrix.

        **See also** **toGenericMatrix** ().
        """
        ...

    @typing.overload
    def __init__(self, a0: "QMatrix4x4") -> None:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#QMatrix4x4

        **QMatrix4x4::QMatrix4x4()**

        Constructs an identity matrix.
        """
        ...

    def __neg__(self) -> "QMatrix4x4":
        ...

    def isAffine(self) -> bool:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#isAffine

        **[since 5.5] bool QMatrix4x4::isAffine() const**

        Returns `true` if this matrix is affine matrix; false otherwise.

        An affine matrix is a 4x4 matrix with row 3 equal to (0, 0, 0, 1), e.g.
        no projective coefficients.

        This function was introduced in Qt 5.5.

        **See also** **isIdentity** ().
        """
        ...

    @typing.overload
    def viewport(
        self,
        left: float,
        bottom: float,
        width: float,
        height: float,
        nearPlane: float = ...,
        farPlane: float = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#viewport

        **void QMatrix4x4::viewport(float left , float bottom , float width ,
        float height , float nearPlane = 0.0f, float farPlane = 1.0f)**

        Multiplies this matrix by another that performs the scale and bias
        transformation used by OpenGL to transform from normalized device
        coordinates (NDC) to viewport (window) coordinates. That is it maps
        points from the cube ranging over [-1, 1] in each dimension to the
        viewport with it's near-lower-left corner at ( **left** , **bottom** ,
        **nearPlane** ) and with size ( **width** , **height** , **farPlane** \\-
        **nearPlane** ).

        This matches the transform used by the fixed function OpenGL viewport
        transform controlled by the functions glViewport() and glDepthRange().
        """
        ...

    @typing.overload
    def viewport(self, rect: QtCore.QRectF) -> None:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#viewport-1

        **void QMatrix4x4::viewport(const QRectF & rect )**

        This is an overloaded function.

        Sets up viewport transform for viewport bounded by **rect** and with
        near and far set to 0 and 1 respectively.
        """
        ...

    def mapVector(self, vector: "QVector3D") -> "QVector3D":
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#mapVector

        **QVector3D QMatrix4x4::mapVector(const QVector3D & vector ) const**

        Maps **vector** by multiplying the top 3x3 portion of this matrix by
        **vector**. The translation and projection components of this matrix are
        ignored. The matrix is applied pre-vector.

        **See also** **map** ().
        """
        ...

    @typing.overload
    def map(self, point: QtCore.QPoint) -> QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#map

        **QPoint QMatrix4x4::map(const QPoint & point ) const**

        Maps **point** by multiplying this matrix by **point**. The matrix is
        applied pre-point.

        **See also** **mapRect** ().
        """
        ...

    @typing.overload
    def map(self, point: QtCore.QPointF) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#map-1

        **QPointF QMatrix4x4::map(const QPointF & point ) const**

        Maps **point** by post-multiplying this matrix by **point**. The matrix
        is applied pre-point.

        **See also** **mapRect** ().
        """
        ...

    @typing.overload
    def map(self, point: "QVector3D") -> "QVector3D":
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#map-2

        **QVector3D QMatrix4x4::map(const QVector3D & point ) const**

        Maps **point** by multiplying this matrix by **point**. The matrix is
        applied pre-point.

        **See also** **mapRect** () and **mapVector** ().
        """
        ...

    @typing.overload
    def map(self, point: "QVector4D") -> "QVector4D":
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#map-3

        **QVector4D QMatrix4x4::map(const QVector4D & point ) const**

        Maps **point** by multiplying this matrix by **point**. The matrix is
        applied pre-point.

        **See also** **mapRect** ().
        """
        ...

    def fill(self, value: float) -> None:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#fill

        **void QMatrix4x4::fill(float value )**

        Fills all elements of this matrx with **value**.
        """
        ...

    def setToIdentity(self) -> None:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#setToIdentity

        **void QMatrix4x4::setToIdentity()**

        Sets this matrix to the identity.

        **See also** **isIdentity** ().
        """
        ...

    def isIdentity(self) -> bool:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#isIdentity

        **bool QMatrix4x4::isIdentity() const**

        Returns `true` if this matrix is the identity; false otherwise.

        **See also** **setToIdentity** ().
        """
        ...

    def setRow(self, index: int, value: "QVector4D") -> None:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#setRow

        **void QMatrix4x4::setRow(int index , const QVector4D & value )**

        Sets the elements of row **index** to the components of **value**.

        **See also** **row** () and **setColumn** ().
        """
        ...

    def row(self, index: int) -> "QVector4D":
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#row

        **QVector4D QMatrix4x4::row(int index ) const**

        Returns the elements of row **index** as a 4D vector.

        **See also** **setRow** () and **column** ().
        """
        ...

    def setColumn(self, index: int, value: "QVector4D") -> None:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#setColumn

        **void QMatrix4x4::setColumn(int index , const QVector4D & value )**

        Sets the elements of column **index** to the components of **value**.

        **See also** **column** () and **setRow** ().
        """
        ...

    def column(self, index: int) -> "QVector4D":
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#column

        **QVector4D QMatrix4x4::column(int index ) const**

        Returns the elements of column **index** as a 4D vector.

        **See also** **setColumn** () and **row** ().
        """
        ...

    def __setitem__(self, a0: typing.Any, a1: float) -> None:
        ...

    def __getitem__(self, a0: typing.Any) -> typing.Any:
        ...

    def optimize(self) -> None:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#optimize

        **void QMatrix4x4::optimize()**

        Optimize the usage of this matrix from its current elements.

        Some operations such as **translate** (), **scale** (), and **rotate**
        () can be performed more efficiently if the matrix being modified is
        already known to be the identity, a previous **translate** (), a
        previous **scale** (), etc.

        Normally the **QMatrix4x4**  class keeps track of this special type
        internally as operations are performed. However, if the matrix is
        modified directly with **operator** ()(int, int) or **data** (), then
        **QMatrix4x4**  will lose track of the special type and will revert to
        the safest but least efficient operations thereafter.

        By calling optimize() after directly modifying the matrix, the
        programmer can force **QMatrix4x4**  to recover the special type if the
        elements appear to conform to one of the known optimized types.

        **See also** **operator()** (int, int), **data** (), and **translate**
        ().
        """
        ...

    def data(self) -> typing.List[float]:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#data

        **float *QMatrix4x4::data()**

        Returns a pointer to the raw data of this matrix.

        **See also** **constData** () and **optimize** ().
        """
        ...

    @typing.overload
    def mapRect(self, rect: QtCore.QRect) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#mapRect

        **QRect QMatrix4x4::mapRect(const QRect & rect ) const**

        Maps **rect** by multiplying this matrix by the corners of **rect** and
        then forming a new rectangle from the results. The returned rectangle
        will be an ordinary 2D rectangle with sides parallel to the horizontal
        and vertical axes.

        **See also** **map** ().
        """
        ...

    @typing.overload
    def mapRect(self, rect: QtCore.QRectF) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#mapRect-1

        **QRectF QMatrix4x4::mapRect(const QRectF & rect ) const**

        Maps **rect** by multiplying this matrix by the corners of **rect** and
        then forming a new rectangle from the results. The returned rectangle
        will be an ordinary 2D rectangle with sides parallel to the horizontal
        and vertical axes.

        **See also** **map** ().
        """
        ...

    @typing.overload
    def toTransform(self) -> "QTransform":
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#toTransform

        **QTransform QMatrix4x4::toTransform() const**

        Returns the conventional Qt 2D transformation matrix that corresponds to
        this matrix.

        The returned **QTransform**  is formed by simply dropping the third row
        and third column of the **QMatrix4x4** . This is suitable for
        implementing orthographic projections where the z coordinate should be
        dropped rather than projected.
        """
        ...

    @typing.overload
    def toTransform(self, distanceToPlane: float) -> "QTransform":
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#toTransform-1

        **QTransform QMatrix4x4::toTransform(float distanceToPlane ) const**

        Returns the conventional Qt 2D transformation matrix that corresponds to
        this matrix.

        If **distanceToPlane** is non-zero, it indicates a projection factor to
        use to adjust for the z coordinate. The value of 1024 corresponds to the
        projection factor used by **QTransform::rotate** () for the x and y
        axes.

        If **distanceToPlane** is zero, then the returned **QTransform**  is
        formed by simply dropping the third row and third column of the
        **QMatrix4x4** . This is suitable for implementing orthographic
        projections where the z coordinate should be dropped rather than
        projected.
        """
        ...

    def copyDataTo(self) -> typing.List[float]:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#copyDataTo

        **void QMatrix4x4::copyDataTo(float * values ) const**

        Retrieves the 16 items in this matrix and copies them to **values** in
        row-major order.
        """
        ...

    def lookAt(self, eye: "QVector3D", center: "QVector3D", up: "QVector3D") -> None:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#lookAt

        **void QMatrix4x4::lookAt(const QVector3D & eye , const QVector3D &
        center , const QVector3D & up )**

        Multiplies this matrix by a viewing matrix derived from an eye point.
        The **center** value indicates the center of the view that the **eye**
        is looking at. The **up** value indicates which direction should be
        considered up with respect to the **eye**.

        **Note:** The **up** vector must not be parallel to the line of sight
        from **eye** to **center**.
        """
        ...

    def perspective(
        self, angle: float, aspect: float, nearPlane: float, farPlane: float
    ) -> None:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#perspective

        **void QMatrix4x4::perspective(float verticalAngle , float aspectRatio ,
        float nearPlane , float farPlane )**

        Multiplies this matrix by another that applies a perspective projection.
        The vertical field of view will be **verticalAngle** degrees within a
        window with a given **aspectRatio** that determines the horizontal field
        of view. The projection will have the specified **nearPlane** and
        **farPlane** clipping planes which are the distances from the viewer to
        the corresponding planes.

        **See also** **ortho** () and **frustum** ().
        """
        ...

    def frustum(
        self,
        left: float,
        right: float,
        bottom: float,
        top: float,
        nearPlane: float,
        farPlane: float,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#frustum

        **void QMatrix4x4::frustum(float left , float right , float bottom ,
        float top , float nearPlane , float farPlane )**

        Multiplies this matrix by another that applies a perspective frustum
        projection for a window with lower-left corner ( **left** , **bottom**
        ), upper-right corner ( **right** , **top** ), and the specified
        **nearPlane** and **farPlane** clipping planes.

        **See also** **ortho** () and **perspective** ().
        """
        ...

    @typing.overload
    def ortho(self, rect: QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#ortho

        **void QMatrix4x4::ortho(float left , float right , float bottom , float
        top , float nearPlane , float farPlane )**

        Multiplies this matrix by another that applies an orthographic
        projection for a window with lower-left corner ( **left** , **bottom**
        ), upper-right corner ( **right** , **top** ), and the specified
        **nearPlane** and **farPlane** clipping planes.

        **See also** **frustum** () and **perspective** ().
        """
        ...

    @typing.overload
    def ortho(self, rect: QtCore.QRectF) -> None:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#ortho-1

        **void QMatrix4x4::ortho(const QRect & rect )**

        This is an overloaded function.

        Multiplies this matrix by another that applies an orthographic
        projection for a window with boundaries specified by **rect**. The near
        and far clipping planes will be -1 and 1 respectively.

        **See also** **frustum** () and **perspective** ().
        """
        ...

    @typing.overload
    def ortho(
        self,
        left: float,
        right: float,
        bottom: float,
        top: float,
        nearPlane: float,
        farPlane: float,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#ortho-2

        **void QMatrix4x4::ortho(const QRectF & rect )**

        This is an overloaded function.

        Multiplies this matrix by another that applies an orthographic
        projection for a window with boundaries specified by **rect**. The near
        and far clipping planes will be -1 and 1 respectively.

        **See also** **frustum** () and **perspective** ().
        """
        ...

    @typing.overload
    def rotate(self, angle: float, vector: "QVector3D") -> None:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#rotate

        **void QMatrix4x4::rotate(float angle , const QVector3D & vector )**

        Multiples this matrix by another that rotates coordinates through
        **angle** degrees about **vector**.

        **See also** **scale** () and **translate** ().
        """
        ...

    @typing.overload
    def rotate(self, angle: float, x: float, y: float, z: float = ...) -> None:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#rotate-1

        **void QMatrix4x4::rotate(float angle , float x , float y , float z =
        0.0f)**

        This is an overloaded function.

        Multiplies this matrix by another that rotates coordinates through
        **angle** degrees about the vector ( **x** , **y** , **z** ).

        **See also** **scale** () and **translate** ().
        """
        ...

    @typing.overload
    def rotate(self, quaternion: "QQuaternion") -> None:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#rotate-2

        **void QMatrix4x4::rotate(const QQuaternion & quaternion )**

        Multiples this matrix by another that rotates coordinates according to a
        specified **quaternion**. The **quaternion** is assumed to have been
        normalized.

        **See also** **scale** (), **translate** (), and **QQuaternion** .
        """
        ...

    @typing.overload
    def translate(self, vector: "QVector3D") -> None:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#translate

        **void QMatrix4x4::translate(const QVector3D & vector )**

        Multiplies this matrix by another that translates coordinates by the
        components of **vector**.

        **See also** **scale** () and **rotate** ().
        """
        ...

    @typing.overload
    def translate(self, x: float, y: float) -> None:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#translate-1

        **void QMatrix4x4::translate(float x , float y )**

        This is an overloaded function.

        Multiplies this matrix by another that translates coordinates by the
        components **x** , and **y**.

        **See also** **scale** () and **rotate** ().
        """
        ...

    @typing.overload
    def translate(self, x: float, y: float, z: float) -> None:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#translate-2

        **void QMatrix4x4::translate(float x , float y , float z )**

        This is an overloaded function.

        Multiplies this matrix by another that translates coordinates by the
        components **x** , **y** , and **z**.

        **See also** **scale** () and **rotate** ().
        """
        ...

    @typing.overload
    def scale(self, vector: "QVector3D") -> None:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#scale

        **void QMatrix4x4::scale(const QVector3D & vector )**

        Multiplies this matrix by another that scales coordinates by the
        components of **vector**.

        **See also** **translate** () and **rotate** ().
        """
        ...

    @typing.overload
    def scale(self, x: float, y: float) -> None:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#scale-1

        **void QMatrix4x4::scale(float x , float y )**

        This is an overloaded function.

        Multiplies this matrix by another that scales coordinates by the
        components **x** , and **y**.

        **See also** **translate** () and **rotate** ().
        """
        ...

    @typing.overload
    def scale(self, x: float, y: float, z: float) -> None:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#scale-2

        **void QMatrix4x4::scale(float x , float y , float z )**

        This is an overloaded function.

        Multiplies this matrix by another that scales coordinates by the
        components **x** , **y** , and **z**.

        **See also** **translate** () and **rotate** ().
        """
        ...

    @typing.overload
    def scale(self, factor: float) -> None:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#scale-3

        **void QMatrix4x4::scale(float factor )**

        This is an overloaded function.

        Multiplies this matrix by another that scales coordinates by the given
        **factor**.

        **See also** **translate** () and **rotate** ().
        """
        ...

    def normalMatrix(self) -> QMatrix3x3:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#normalMatrix

        **QMatrix3x3 QMatrix4x4::normalMatrix() const**

        Returns the normal matrix corresponding to this 4x4 transformation. The
        normal matrix is the transpose of the inverse of the top-left 3x3 part
        of this 4x4 matrix. If the 3x3 sub-matrix is not invertible, this
        function returns the identity.

        **See also** **inverted** ().
        """
        ...

    def transposed(self) -> "QMatrix4x4":
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#transposed

        **QMatrix4x4 QMatrix4x4::transposed() const**

        Returns this matrix, transposed about its diagonal.
        """
        ...

    def inverted(self) -> typing.Tuple["QMatrix4x4", bool]:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#inverted

        **QMatrix4x4 QMatrix4x4::inverted(bool * invertible = nullptr) const**

        Returns the inverse of this matrix. Returns the identity if this matrix
        cannot be inverted; i.e. **determinant** () is zero. If **invertible**
        is not null, then true will be written to that location if the matrix
        can be inverted; false otherwise.

        If the matrix is recognized as the identity or an orthonormal matrix,
        then this function will quickly invert the matrix using optimized
        routines.

        **See also** **determinant** () and **normalMatrix** ().
        """
        ...

    def determinant(self) -> float:
        """
        https://doc.qt.io/qt-6/qmatrix4x4.html#determinant

        **double QMatrix4x4::determinant() const**

        Returns the determinant of this matrix.
        """
        ...

    def __repr__(self) -> str:
        ...
