"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip


class QPageRanges(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qpageranges.html

    **Detailed Description**

    Use **QPagedPaintDevice::pageRanges** () to access the collection of page
    ranges associated with a paged device.
    """

    class Range(PyQt6.sip.simplewrapper):
        from_: int = ...
        to: int = ...

        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QPageRanges.Range") -> None:
            ...

        def contains(self, pageNumber: int) -> bool:
            ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qpageranges.html#QPageRanges

        **QPageRanges::QPageRanges()**

        Constructs an empty QPageRanges object.
        """
        ...

    @typing.overload
    def __init__(self, other: "QPageRanges") -> None:
        """
        https://doc.qt.io/qt-6/qpageranges.html#QPageRanges-1

        **QPageRanges::QPageRanges(const QPageRanges & other )**

        Constructs a QPageRanges object by copying **other**.
        """
        ...

    def lastPage(self) -> int:
        """
        https://doc.qt.io/qt-6/qpageranges.html#lastPage

        **int QPageRanges::lastPage() const**

        Returns the index of the last page covered by the page ranges, or 0 if
        the page ranges are empty.
        """
        ...

    def firstPage(self) -> int:
        """
        https://doc.qt.io/qt-6/qpageranges.html#firstPage

        **int QPageRanges::firstPage() const**

        Returns the index of the first page covered by the page ranges, or 0 if
        the page ranges are empty.
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-6/qpageranges.html#isEmpty

        **bool QPageRanges::isEmpty() const**

        Returns `true` if the ranges are empty; otherwise returns `false`.
        """
        ...

    def contains(self, pageNumber: int) -> bool:
        """
        https://doc.qt.io/qt-6/qpageranges.html#contains

        **bool QPageRanges::contains(int pageNumber ) const**

        Returns `true` if the ranges include the page **pageNumber** ; otherwise
        returns `false`.
        """
        ...

    @staticmethod
    def fromString(ranges: str) -> "QPageRanges":
        """
        https://doc.qt.io/qt-6/qpageranges.html#fromString

        **[static] QPageRanges QPageRanges::fromString(const QString & ranges
        )**

        Constructs and returns a **QPageRanges**  object populated with the
        **ranges** from the string representation.

        **QPrinter**  printer;
            **QPageRanges**  ranges = **QPageRanges**
        ::fromString("1-3,6-7");
            printer.setPageRanges(ranges);

        In case of parsing error, returns an empty **QPageRanges**  object.

        **See also** **isEmpty** ().
        """
        ...

    def toString(self) -> str:
        """
        https://doc.qt.io/qt-6/qpageranges.html#toString

        **QString QPageRanges::toString() const**

        Returns the string representation of the page ranges.
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qpageranges.html#clear

        **void QPageRanges::clear()**

        Removes all page ranges.
        """
        ...

    def toRangeList(self) -> typing.List["QPageRanges.Range"]:
        """
        https://doc.qt.io/qt-6/qpageranges.html#toRangeList

        **QList<QPageRanges::Range> QPageRanges::toRangeList() const**

        Returns a list with the values of the ranges.
        """
        ...

    def addRange(self, from_: int, to: int) -> None:
        """
        https://doc.qt.io/qt-6/qpageranges.html#addRange

        **void QPageRanges::addRange(int from , int to )**

        Adds the range specified with **from** and **to** to the ranges.

        **Note:** Page numbers start with 1. Attempts to add page numbers
        smaller than 1 will be ignored with a warning.
        """
        ...

    def addPage(self, pageNumber: int) -> None:
        """
        https://doc.qt.io/qt-6/qpageranges.html#addPage

        **void QPageRanges::addPage(int pageNumber )**

        Adds the single page **pageNumber** to the ranges.

        **Note:** Page numbers start with 1. Attempts to add page numbers
        smaller than 1 will be ignored with a warning.
        """
        ...

    def swap(self, other: "QPageRanges") -> None:
        ...
