"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtGui import *
import enum


class QPageSize(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qpagesize.html

    **Detailed Description**

    This class implements support for the set of standard page sizes as defined
    in the Adobe Postscript PPD Standard v4.3. It defines the standard set of
    page sizes in points, millimeters and inches and ensures these sizes are
    consistently used. Other size units can be used but will be calculated
    results and so may not always be consistent. The defined point sizes are
    always a integer, all other sizes can be fractions of a unit.

    The defined size is always in width x height order with no implied page
    orientation. Note that it is possible for page sizes to be defined where the
    width is greater than the height, such as **QPageSize::Ledger** , so you
    cannot rely on comparing the width and height values to determine page
    orientation.

    For example, A4 is defined by the standard as 210mm x 297mm, 8.27in x
    11.69in, or 595pt x 842pt.

    You can also define custom page sizes with custom names in any units you
    want and this unit size will be preserved and used as the base for all other
    unit size calculations.

    When creating a QPageSize using a custom **QSize**  you can choose if you
    want QPageSize to try match the size to a standard page size. By default
    QPaperSize uses a **FuzzyMatch**  mode where it will match a given page size
    to a standard page size if it falls within 3 postscript points of a defined
    standard size. You can override this to request only an exact match but this
    is not recommended as conversions between units can easily lose 3 points and
    result in incorrect page sizes.

    A QPageSize instance may also be obtained by querying the supported page
    sizes for a print device. In this case the localized name returned is that
    defined by the printer itself. Note that the print device may not support
    the current default locale language.

    The class also provides convenience methods for converting page size IDs to
    and from various unit sizes.

    **See also** **QPagedPaintDevice**  and **QPdfWriter** .
    """

    class SizeMatchPolicy(enum.Enum):
        FuzzyMatch: QPageSize = ...
        FuzzyOrientationMatch: QPageSize = ...
        ExactMatch: QPageSize = ...

    class Unit(enum.Enum):
        Millimeter: QPageSize = ...
        Point: QPageSize = ...
        Inch: QPageSize = ...
        Pica: QPageSize = ...
        Didot: QPageSize = ...
        Cicero: QPageSize = ...

    class PageSizeId(enum.Enum):
        A4: QPageSize = ...
        B5: QPageSize = ...
        Letter: QPageSize = ...
        Legal: QPageSize = ...
        Executive: QPageSize = ...
        A0: QPageSize = ...
        A1: QPageSize = ...
        A2: QPageSize = ...
        A3: QPageSize = ...
        A5: QPageSize = ...
        A6: QPageSize = ...
        A7: QPageSize = ...
        A8: QPageSize = ...
        A9: QPageSize = ...
        B0: QPageSize = ...
        B1: QPageSize = ...
        B10: QPageSize = ...
        B2: QPageSize = ...
        B3: QPageSize = ...
        B4: QPageSize = ...
        B6: QPageSize = ...
        B7: QPageSize = ...
        B8: QPageSize = ...
        B9: QPageSize = ...
        C5E: QPageSize = ...
        Comm10E: QPageSize = ...
        DLE: QPageSize = ...
        Folio: QPageSize = ...
        Ledger: QPageSize = ...
        Tabloid: QPageSize = ...
        Custom: QPageSize = ...
        A10: QPageSize = ...
        A3Extra: QPageSize = ...
        A4Extra: QPageSize = ...
        A4Plus: QPageSize = ...
        A4Small: QPageSize = ...
        A5Extra: QPageSize = ...
        B5Extra: QPageSize = ...
        JisB0: QPageSize = ...
        JisB1: QPageSize = ...
        JisB2: QPageSize = ...
        JisB3: QPageSize = ...
        JisB4: QPageSize = ...
        JisB5: QPageSize = ...
        JisB6: QPageSize = ...
        JisB7: QPageSize = ...
        JisB8: QPageSize = ...
        JisB9: QPageSize = ...
        JisB10: QPageSize = ...
        AnsiC: QPageSize = ...
        AnsiD: QPageSize = ...
        AnsiE: QPageSize = ...
        LegalExtra: QPageSize = ...
        LetterExtra: QPageSize = ...
        LetterPlus: QPageSize = ...
        LetterSmall: QPageSize = ...
        TabloidExtra: QPageSize = ...
        ArchA: QPageSize = ...
        ArchB: QPageSize = ...
        ArchC: QPageSize = ...
        ArchD: QPageSize = ...
        ArchE: QPageSize = ...
        Imperial7x9: QPageSize = ...
        Imperial8x10: QPageSize = ...
        Imperial9x11: QPageSize = ...
        Imperial9x12: QPageSize = ...
        Imperial10x11: QPageSize = ...
        Imperial10x13: QPageSize = ...
        Imperial10x14: QPageSize = ...
        Imperial12x11: QPageSize = ...
        Imperial15x11: QPageSize = ...
        ExecutiveStandard: QPageSize = ...
        Note: QPageSize = ...
        Quarto: QPageSize = ...
        Statement: QPageSize = ...
        SuperA: QPageSize = ...
        SuperB: QPageSize = ...
        Postcard: QPageSize = ...
        DoublePostcard: QPageSize = ...
        Prc16K: QPageSize = ...
        Prc32K: QPageSize = ...
        Prc32KBig: QPageSize = ...
        FanFoldUS: QPageSize = ...
        FanFoldGerman: QPageSize = ...
        FanFoldGermanLegal: QPageSize = ...
        EnvelopeB4: QPageSize = ...
        EnvelopeB5: QPageSize = ...
        EnvelopeB6: QPageSize = ...
        EnvelopeC0: QPageSize = ...
        EnvelopeC1: QPageSize = ...
        EnvelopeC2: QPageSize = ...
        EnvelopeC3: QPageSize = ...
        EnvelopeC4: QPageSize = ...
        EnvelopeC6: QPageSize = ...
        EnvelopeC65: QPageSize = ...
        EnvelopeC7: QPageSize = ...
        Envelope9: QPageSize = ...
        Envelope11: QPageSize = ...
        Envelope12: QPageSize = ...
        Envelope14: QPageSize = ...
        EnvelopeMonarch: QPageSize = ...
        EnvelopePersonal: QPageSize = ...
        EnvelopeChou3: QPageSize = ...
        EnvelopeChou4: QPageSize = ...
        EnvelopeInvite: QPageSize = ...
        EnvelopeItalian: QPageSize = ...
        EnvelopeKaku2: QPageSize = ...
        EnvelopeKaku3: QPageSize = ...
        EnvelopePrc1: QPageSize = ...
        EnvelopePrc2: QPageSize = ...
        EnvelopePrc3: QPageSize = ...
        EnvelopePrc4: QPageSize = ...
        EnvelopePrc5: QPageSize = ...
        EnvelopePrc6: QPageSize = ...
        EnvelopePrc7: QPageSize = ...
        EnvelopePrc8: QPageSize = ...
        EnvelopePrc9: QPageSize = ...
        EnvelopePrc10: QPageSize = ...
        EnvelopeYou4: QPageSize = ...
        AnsiA: QPageSize = ...
        AnsiB: QPageSize = ...
        EnvelopeC5: QPageSize = ...
        EnvelopeDL: QPageSize = ...
        Envelope10: QPageSize = ...
        LastPageSize: QPageSize = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qpagesize.html#QPageSize

        **QPageSize::QPageSize()**

        Creates a null QPageSize.
        """
        ...

    @typing.overload
    def __init__(self, pageSizeId: "QPageSize.PageSizeId") -> None:
        """
        https://doc.qt.io/qt-6/qpagesize.html#QPageSize-1

        **QPageSize::QPageSize(QPageSize::PageSizeId pageSize )**

        Creates a QPageSize of the standard **pageSize**.

        If **pageSize** is **QPageSize::Custom**  then the resulting QPageSize
        will not be valid. Use the custom size constructor instead.
        """
        ...

    @typing.overload
    def __init__(
        self,
        pointSize: QtCore.QSize,
        name: str = ...,
        matchPolicy: "QPageSize.SizeMatchPolicy" = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpagesize.html#QPageSize-2

        **QPageSize::QPageSize(const QSize & pointSize , const QString & name =
        QString(), QPageSize::SizeMatchPolicy matchPolicy = FuzzyMatch)**

        Creates a QPageSize of the given **pointSize** in Points using the
        matching **matchPolicy**.

        If the given **pointSize** matches a standard **QPageSize::PageSizeId**
        , then that page size will be used. Note that if the **matchPolicy** is
        **FuzzyMatch**  this may result in the **pointSize** being adjusted to
        the standard size. To prevent this happening use a **matchPolicy** of
        **ExactMatch**  instead.

        If the given **pointSize** is not a standard **QPageSize::PageSizeId**
        then a **QPageSize::Custom**  size will be created.

        If **name** is null then the standard localized name will be used. If a
        custom page size then a custom name in the format "Custom (width x
        height)" will be created.

        The **matchPolicy** defaults to **FuzzyMatch** .
        """
        ...

    @typing.overload
    def __init__(
        self,
        size: QtCore.QSizeF,
        units: "QPageSize.Unit",
        name: str = ...,
        matchPolicy: "QPageSize.SizeMatchPolicy" = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpagesize.html#QPageSize-3

        **QPageSize::QPageSize(const QSizeF & size , QPageSize::Unit units ,
        const QString & name = QString(), QPageSize::SizeMatchPolicy matchPolicy
        = FuzzyMatch)**

        Creates a custom page of the given **size** in **units**.

        If the given **size** matches a standard **QPageSize::PageSizeId** ,
        then that page size will be used. Note that if the **matchPolicy** is
        **FuzzyMatch**  this may result in the **size** being adjusted to the
        standard size. To prevent this happening use a **matchPolicy** of
        **ExactMatch**  instead.

        If the given **size** is not a standard **QPageSize::PageSizeId**  then
        a **QPageSize::Custom**  size will be created. The original unit size
        will be preserved and used as the base for all other unit size
        calculations.

        If **name** is null then a custom name will be created in the form
        "Custom (width x height)" where the size is expressed in units provided.
        """
        ...

    @typing.overload
    def __init__(self, other: "QPageSize") -> None:
        """
        https://doc.qt.io/qt-6/qpagesize.html#QPageSize-4

        **QPageSize::QPageSize(const QPageSize & other )**

        Copy constructor, copies **other** to this.
        """
        ...

    def rectPixels(self, resolution: int) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qpagesize.html#rectPixels

        **QRect QPageSize::rectPixels(int resolution ) const**

        Returns the page rectangle in Device Pixels at the given **resolution**.

        If the **QPageSize**  is invalid then the **QRect**  will be invalid.
        """
        ...

    def rectPoints(self) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qpagesize.html#rectPoints

        **QRect QPageSize::rectPoints() const**

        Returns the page rectangle in Postscript Points (1/72 of an inch).

        If the **QPageSize**  is invalid then the **QRect**  will be invalid.
        """
        ...

    def rect(self, units: "QPageSize.Unit") -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qpagesize.html#rect

        **QRectF QPageSize::rect(QPageSize::Unit units ) const**

        Returns the page rectangle in the required **units**.

        If the **QPageSize**  is invalid then the **QRect**  will be invalid.
        """
        ...

    @typing.overload
    def sizePixels(self, resolution: int) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qpagesize.html#sizePixels

        **QSize QPageSize::sizePixels(int resolution ) const**

        Returns the size of the page in Device Pixels at the given
        **resolution**.

        If the **QPageSize**  is invalid then the **QSize**  will be invalid.
        """
        ...

    @typing.overload
    @staticmethod
    def sizePixels(pageSizeId: "QPageSize.PageSizeId", resolution: int) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qpagesize.html#sizePixels-1

        **[static] QSize QPageSize::sizePixels(QPageSize::PageSizeId pageSizeId
        , int resolution )**

        Returns the size of the standard **pageSizeId** in Device Pixels for the
        given **resolution**.
        """
        ...

    @typing.overload
    def sizePoints(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qpagesize.html#sizePoints

        **QSize QPageSize::sizePoints() const**

        Returns the size of the page in Postscript Points (1/72 of an inch).

        If the **QPageSize**  is invalid then the **QSize**  will be invalid.
        """
        ...

    @typing.overload
    @staticmethod
    def sizePoints(pageSizeId: "QPageSize.PageSizeId") -> QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qpagesize.html#sizePoints-1

        **[static] QSize QPageSize::sizePoints(QPageSize::PageSizeId pageSizeId
        )**

        Returns the size of the standard **pageSizeId** in Points.
        """
        ...

    @typing.overload
    def size(self, units: "QPageSize.Unit") -> QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qpagesize.html#size

        **QSizeF QPageSize::size(QPageSize::Unit units ) const**

        Returns the size of the page in the required **units**.

        If the **QPageSize**  is invalid then the **QSizeF**  will be invalid.
        """
        ...

    @typing.overload
    @staticmethod
    def size(
        pageSizeId: "QPageSize.PageSizeId", units: "QPageSize.Unit"
    ) -> QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qpagesize.html#size-1

        **[static] QSizeF QPageSize::size(QPageSize::PageSizeId pageSizeId ,
        QPageSize::Unit units )**

        Returns the size of the standard **pageSizeId** in the requested
        **units**.
        """
        ...

    @typing.overload
    def definitionUnits(self) -> "QPageSize.Unit":
        """
        https://doc.qt.io/qt-6/qpagesize.html#definitionUnits

        **QPageSize::Unit QPageSize::definitionUnits() const**

        Returns the definition units of the page size.

        For a standard page size this will be the units as defined in the
        relevant standard, i.e. ISO A4 will be defined in millimeters while ANSI
        Letter will be defined in inches.

        For a custom page size this will be the original units used to create
        the page size object.

        If the **QPageSize**  is invalid then the **QPageSize::Unit**  will be
        invalid.

        **See also** **definitionSize** ().
        """
        ...

    @typing.overload
    @staticmethod
    def definitionUnits(pageSizeId: "QPageSize.PageSizeId") -> "QPageSize.Unit":
        """
        https://doc.qt.io/qt-6/qpagesize.html#definitionUnits-1

        **[static] QPageSize::Unit
        QPageSize::definitionUnits(QPageSize::PageSizeId pageSizeId )**

        Returns the definition units of the standard **pageSizeId**.

        To obtain the definition size, call **QPageSize::definitionSize** ().
        """
        ...

    @typing.overload
    def definitionSize(self) -> QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qpagesize.html#definitionSize

        **QSizeF QPageSize::definitionSize() const**

        Returns the definition size of the page size.

        For a standard page size this will be the size as defined in the
        relevant standard, i.e. ISO A4 will be defined in millimeters while ANSI
        Letter will be defined in inches.

        For a custom page size this will be the original size used to create the
        page size object.

        If the **QPageSize**  is invalid then the **QSizeF**  will be invalid.

        **See also** **definitionUnits** ().
        """
        ...

    @typing.overload
    @staticmethod
    def definitionSize(pageSizeId: "QPageSize.PageSizeId") -> QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qpagesize.html#definitionSize-1

        **[static] QSizeF QPageSize::definitionSize(QPageSize::PageSizeId
        pageSizeId )**

        Returns the definition size of the standard **pageSizeId**.

        To obtain the definition units, call **QPageSize::definitionUnits** ().
        """
        ...

    @typing.overload
    def windowsId(self) -> int:
        """
        https://doc.qt.io/qt-6/qpagesize.html#windowsId

        **int QPageSize::windowsId() const**

        Returns the Windows DMPAPER enum value for the page size.

        Not all valid PPD page sizes have a Windows equivalent, in which case 0
        will be returned.

        If the **QPageSize**  is invalid then the Windows ID will be 0.

        **See also** **id** ().
        """
        ...

    @typing.overload
    @staticmethod
    def windowsId(pageSizeId: "QPageSize.PageSizeId") -> int:
        """
        https://doc.qt.io/qt-6/qpagesize.html#windowsId-1

        **[static] int QPageSize::windowsId(QPageSize::PageSizeId pageSizeId )**

        Returns the Windows DMPAPER enum value of the standard **pageSizeId**.

        Not all valid PPD page sizes have a Windows equivalent, in which case 0
        will be returned.
        """
        ...

    @typing.overload
    def id(self) -> "QPageSize.PageSizeId":
        """
        https://doc.qt.io/qt-6/qpagesize.html#id

        **QPageSize::PageSizeId QPageSize::id() const**

        Returns the standard **QPageSize::PageSizeId**  of the page, or
        **QPageSize::Custom** .

        If the **QPageSize**  is invalid then the ID will be
        **QPageSize::Custom** .
        """
        ...

    @typing.overload
    @staticmethod
    def id(
        pointSize: QtCore.QSize, matchPolicy: "QPageSize.SizeMatchPolicy" = ...
    ) -> "QPageSize.PageSizeId":
        """
        https://doc.qt.io/qt-6/qpagesize.html#id-1

        **[static] QPageSize::PageSizeId QPageSize::id(const QSize & pointSize ,
        QPageSize::SizeMatchPolicy matchPolicy = FuzzyMatch)**

        Returns the standard **QPageSize::PageSizeId**  of the given
        **pointSize** in points using the given **matchPolicy**.

        If using **FuzzyMatch**  then the point size of the **PageSizeId**
        returned may not exactly match the **pointSize** you passed in. You
        should call **QPageSize::sizePoints** () using the returned
        **PageSizeId**  to find out the actual point size of the **PageSizeId**
        before using it in any calculations.
        """
        ...

    @typing.overload
    @staticmethod
    def id(
        size: QtCore.QSizeF,
        units: "QPageSize.Unit",
        matchPolicy: "QPageSize.SizeMatchPolicy" = ...,
    ) -> "QPageSize.PageSizeId":
        """
        https://doc.qt.io/qt-6/qpagesize.html#id-2

        **[static] QPageSize::PageSizeId QPageSize::id(const QSizeF & size ,
        QPageSize::Unit units , QPageSize::SizeMatchPolicy matchPolicy =
        FuzzyMatch)**

        Returns the standard **QPageSize::PageSizeId**  of the given **size** in
        **units** using the given **matchPolicy**.

        If using **FuzzyMatch**  then the unit size of the **PageSizeId**
        returned may not exactly match the **size** you passed in. You should
        call **QPageSize::size** () using the returned **PageSizeId**  to find
        out the actual unit size of the **PageSizeId**  before using it in any
        calculations.
        """
        ...

    @typing.overload
    @staticmethod
    def id(windowsId: int) -> "QPageSize.PageSizeId":
        """
        https://doc.qt.io/qt-6/qpagesize.html#id-3

        **[static] QPageSize::PageSizeId QPageSize::id(int windowsId )**

        Returns the **PageSizeId**  for the given Windows DMPAPER enum value
        **windowsId**.

        If there is no matching **PageSizeId**  then **QPageSize::Custom**  is
        returned.
        """
        ...

    @typing.overload
    def name(self) -> str:
        """
        https://doc.qt.io/qt-6/qpagesize.html#name

        **QString QPageSize::name() const**

        Returns a localized human-readable name for the page size.

        If the **QPageSize**  instance was obtained from a print device then the
        name used is that provided by the print device. Note that a print device
        may not support the current default locale language.

        If the **QPageSize**  is invalid then the name will be an empty string.
        """
        ...

    @typing.overload
    @staticmethod
    def name(pageSizeId: "QPageSize.PageSizeId") -> str:
        """
        https://doc.qt.io/qt-6/qpagesize.html#name-1

        **[static] QString QPageSize::name(QPageSize::PageSizeId pageSizeId )**

        Returns the localized name of the standard **pageSizeId**.

        If the **QPageSize**  is invalid then the name will be empty.
        """
        ...

    @typing.overload
    def key(self) -> str:
        """
        https://doc.qt.io/qt-6/qpagesize.html#key

        **QString QPageSize::key() const**

        Returns the unique key of the page size.

        By default this is the PPD standard mediaOption keyword for the page
        size, or the PPD custom format key. If the **QPageSize**  instance was
        obtained from a print device then this will be the key provided by the
        print device and may differ from the standard key.

        If the **QPageSize**  is invalid then the key will be an empty string.

        This key should never be shown to end users, it is an internal key only.
        For a human-readable name use **name** ().

        **See also** **name** ().
        """
        ...

    @typing.overload
    @staticmethod
    def key(pageSizeId: "QPageSize.PageSizeId") -> str:
        """
        https://doc.qt.io/qt-6/qpagesize.html#key-1

        **[static] QString QPageSize::key(QPageSize::PageSizeId pageSizeId )**

        Returns the PPD mediaOption keyword of the standard **pageSizeId**.

        If the **QPageSize**  is invalid then the key will be empty.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qpagesize.html#isValid

        **bool QPageSize::isValid() const**

        Returns `true` if this page size is valid.

        The page size may be invalid if created with an invalid **PageSizeId** ,
        or a negative or invalid **QSize**  or **QSizeF** , or the null
        constructor.
        """
        ...

    def isEquivalentTo(self, other: "QPageSize") -> bool:
        """
        https://doc.qt.io/qt-6/qpagesize.html#isEquivalentTo

        **bool QPageSize::isEquivalentTo(const QPageSize & other ) const**

        Returns `true` if this page is equivalent to the **other** page, i.e. if
        the page has the same size regardless of other attributes like name.
        """
        ...

    def swap(self, other: "QPageSize") -> None:
        """
        https://doc.qt.io/qt-6/qpagesize.html#swap

        **void QPageSize::swap(QPageSize & other )**

        Swaps this **QPageSize**  with **other**. This function is very fast and
        never fails.
        """
        ...
