"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtGui import *
import enum


class QPainter(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qpainter.html

    **Detailed Description**

    QPainter provides highly optimized functions to do most of the drawing GUI
    programs require. It can draw everything from simple lines to complex shapes
    like pies and chords. It can also draw aligned text and pixmaps. Normally,
    it draws in a "natural" coordinate system, but it can also do view and world
    transformation. QPainter can operate on any object that inherits the
    **QPaintDevice**  class.

    The common use of QPainter is inside a widget's paint event: Construct and
    customize (e.g. set the pen or the brush) the painter. Then draw. Remember
    to destroy the QPainter object after drawing. For example:

    void SimpleExampleWidget::paintEvent(**QPaintEvent**  *)
        {
    **QPainter**  painter(this);
            painter.setPen(Qt::blue);
    painter.setFont(**QFont** ("Arial", 30));
            painter.drawText(rect(),
    Qt::AlignCenter, "Qt");
        }

    The core functionality of QPainter is drawing, but the class also provide
    several functions that allows you to customize QPainter's settings and its
    rendering quality, and others that enable clipping. In addition you can
    control how different shapes are merged together by specifying the painter's
    composition mode.

    The **isActive** () function indicates whether the painter is active. A
    painter is activated by the **begin** () function and the constructor that
    takes a **QPaintDevice**  argument. The **end** () function, and the
    destructor, deactivates it.

    Together with the **QPaintDevice**  and **QPaintEngine**  classes, QPainter
    form the basis for Qt's paint system. QPainter is the class used to perform
    drawing operations. **QPaintDevice**  represents a device that can be
    painted on using a QPainter. **QPaintEngine**  provides the interface that
    the painter uses to draw onto different types of devices. If the painter is
    active, **device** () returns the paint device on which the painter paints,
    and **paintEngine** () returns the paint engine that the painter is
    currently operating on. For more information, see the **Paint System** .

    Sometimes it is desirable to make someone else paint on an unusual
    **QPaintDevice** . QPainter supports a static function to do this,
    setRedirected().

    **Warning:** When the paintdevice is a widget, QPainter can only be used
    inside a paintEvent() function or in a function called by paintEvent().

    **Settings**

    There are several settings that you can customize to make QPainter draw
    according to your preferences:

    * **font** () is the font used for drawing text. If the painter **isActive**
    (), you can retrieve information about the currently set font, and its
    metrics, using the **fontInfo** () and **fontMetrics** () functions
    respectively.
      * **brush** () defines the color or pattern that is used for
    filling shapes.
      * **pen** () defines the color or stipple that is used for
    drawing lines or boundaries.
      * **backgroundMode** () defines whether there
    is a **background** () or not, i.e it is either **Qt::OpaqueMode**  or
    **Qt::TransparentMode** .
      * **background** () only applies when
    **backgroundMode** () is **Qt::OpaqueMode**  and **pen** () is a stipple. In
    that case, it describes the color of the background pixels in the stipple.
    * **brushOrigin** () defines the origin of the tiled brushes, normally the
    origin of widget's background.
      * **viewport** (), **window** (),
    **worldTransform** () make up the painter's coordinate transformation
    system. For more information, see the **Coordinate Transformations**
    section and the **Coordinate System**  documentation.
      * **hasClipping** ()
    tells whether the painter clips at all. (The paint device clips, too.) If
    the painter clips, it clips to **clipRegion** ().
      * **layoutDirection** ()
    defines the layout direction used by the painter when drawing text.
      *
    **worldMatrixEnabled** () tells whether world transformation is enabled.
      *
    **viewTransformEnabled** () tells whether view transformation is enabled.

    Note that some of these settings mirror settings in some paint devices, e.g.
    **QWidget::font** (). The **QPainter::begin** () function (or equivalently
    the QPainter constructor) copies these attributes from the paint device.

    You can at any time save the QPainter's state by calling the **save** ()
    function which saves all the available settings on an internal stack. The
    **restore** () function pops them back.

    **Drawing**

    QPainter provides functions to draw most primitives: **drawPoint** (),
    **drawPoints** (), **drawLine** (), **drawRect** (), **drawRoundedRect** (),
    **drawEllipse** (), **drawArc** (), **drawPie** (), **drawChord** (),
    **drawPolyline** (), **drawPolygon** (), **drawConvexPolygon** () and
    drawCubicBezier(). The two convenience functions, **drawRects** () and
    **drawLines** (), draw the given number of rectangles or lines in the given
    array of **QRects**  or **QLines**  using the current pen and brush.

    The QPainter class also provides the **fillRect** () function which fills
    the given **QRect** , with the given **QBrush** , and the **eraseRect** ()
    function that erases the area inside the given rectangle.

    All of these functions have both integer and floating point versions.

    ![](images/qpainter-basicdrawing.png)**Basic Drawing Example**

    The **Basic
    Drawing**  example shows how to display basic graphics primitives in a
    variety of styles using the QPainter class.

    If you need to draw a complex shape, especially if you need to do so
    repeatedly, consider creating a **QPainterPath**  and drawing it using
    **drawPath** ().

    **Painter Paths example**

    The **QPainterPath**  class provides a container
    for painting operations, enabling graphical shapes to be constructed and
    reused.

    The **Painter Paths**  example shows how painter paths can be used
    to build complex shapes for rendering.

    ![](images/qpainter-
    painterpaths.png)

    QPainter also provides the **fillPath** () function which fills the given
    **QPainterPath**  with the given **QBrush** , and the **strokePath** ()
    function that draws the outline of the given path (i.e. strokes the path).

    See also the **Vector Deformation**  example which shows how to use advanced
    vector techniques to draw text using a **QPainterPath** , the **Gradients**
    example which shows the different types of gradients that are available in
    Qt, and the **Path Stroking**  example which shows Qt's built-in dash
    patterns and shows how custom patterns can be used to extend the range of
    available patterns.

    **Vector Deformation** **Gradients** **Path Stroking**
    ![](images/qpainter-vectordeformation.png)![](images/qpainter-
    gradients.png)![](images/qpainter-pathstroking.png)

    Text drawing is done using **drawText** (). When you need fine-grained
    positioning, **boundingRect** () tells you where a given **drawText** ()
    command will draw.

    **Drawing Pixmaps and Images**

    There are functions to draw pixmaps/images, namely **drawPixmap** (),
    **drawImage** () and **drawTiledPixmap** (). Both **drawPixmap** () and
    **drawImage** () produce the same result, except that **drawPixmap** () is
    faster on-screen while **drawImage** () may be faster on a **QPrinter**  or
    other devices.

    There is a **drawPicture** () function that draws the contents of an entire
    **QPicture** . The **drawPicture** () function is the only function that
    disregards all the painter's settings as **QPicture**  has its own settings.

    **Drawing High Resolution Versions of Pixmaps and Images**

    High resolution versions of pixmaps have a **device pixel ratio** value
    larger than 1 (see **QImageReader** , **QPixmap::devicePixelRatio** ()).
    Should it match the value of the underlying **QPaintDevice** , it is drawn
    directly onto the device with no additional transformation applied.

    This is for example the case when drawing a **QPixmap**  of 64x64 pixels
    size with a device pixel ratio of 2 onto a high DPI screen which also has a
    device pixel ratio of 2. Note that the pixmap is then effectively 32x32
    pixels in **user space**. Code paths in Qt that calculate layout geometry
    based on the pixmap size will use this size. The net effect of this is that
    the pixmap is displayed as high DPI pixmap rather than a large pixmap.

    **Rendering Quality**

    To get the optimal rendering result using QPainter, you should use the
    platform independent **QImage**  as paint device; i.e. using **QImage**
    will ensure that the result has an identical pixel representation on any
    platform.

    The QPainter class also provides a means of controlling the rendering
    quality through its **RenderHint**  enum and the support for floating point
    precision: All the functions for drawing primitives has a floating point
    version. These are often used in combination with the
    **QPainter::Antialiasing**  render hint.

    ![](images/qpainter-concentriccircles.png)**Concentric Circles Example**
    The **Concentric Circles**  example shows the improved rendering quality
    that can be obtained using floating point precision and anti-aliasing when
    drawing custom widgets.

    The application's main window displays several
    widgets which are drawn using the various combinations of precision and
    anti-aliasing.

    The **RenderHint**  enum specifies flags to QPainter that may or may not be
    respected by any given engine. **QPainter::Antialiasing**  indicates that
    the engine should antialias edges of primitives if possible,
    **QPainter::TextAntialiasing**  indicates that the engine should antialias
    text if possible, and the **QPainter::SmoothPixmapTransform**  indicates
    that the engine should use a smooth pixmap transformation algorithm.

    The **renderHints** () function returns a flag that specifies the rendering
    hints that are set for this painter. Use the **setRenderHint** () function
    to set or clear the currently set **RenderHints** .

    **Coordinate Transformations**

    Normally, the QPainter operates on the device's own coordinate system
    (usually pixels), but QPainter has good support for coordinate
    transformations.

    nop**rotate** ()**scale** ()**translate** ()
    ![](images/qpainter-
    clock.png)![](images/qpainter-rotation.png)![](images/qpainter-
    scale.png)![](images/qpainter-translation.png)

    The most commonly used transformations are scaling, rotation, translation
    and shearing. Use the **scale** () function to scale the coordinate system
    by a given offset, the **rotate** () function to rotate it clockwise and
    **translate** () to translate it (i.e. adding a given offset to the points).
    You can also twist the coordinate system around the origin using the
    **shear** () function. See the **Affine Transformations**  example for a
    visualization of a sheared coordinate system.

    See also the **Transformations**  example which shows how transformations
    influence the way that QPainter renders graphics primitives. In particular
    it shows how the order of transformations affects the result.

    **Affine Transformations Example**

    The **Affine Transformations**  example
    shows Qt's ability to perform affine transformations on painting operations.
    The demo also allows the user to experiment with the transformation
    operations and see the results immediately.

    ![](images/qpainter-
    affinetransformations.png)

    All the transformation operations operate on the transformation
    **worldTransform** (). A matrix transforms a point in the plane to another
    point. For more information about the transformation matrix, see the
    **Coordinate System**  and **QTransform**  documentation.

    The **setWorldTransform** () function can replace or add to the currently
    set **worldTransform** (). The **resetTransform** () function resets any
    transformations that were made using **translate** (), **scale** (),
    **shear** (), **rotate** (), **setWorldTransform** (), **setViewport** ()
    and **setWindow** () functions. The **deviceTransform** () returns the
    matrix that transforms from logical coordinates to device coordinates of the
    platform dependent paint device. The latter function is only needed when
    using platform painting commands on the platform dependent handle, and the
    platform does not do transformations nativly.

    When drawing with QPainter, we specify points using logical coordinates
    which then are converted into the physical coordinates of the paint device.
    The mapping of the logical coordinates to the physical coordinates are
    handled by QPainter's **combinedTransform** (), a combination of
    **viewport** () and **window** () and **worldTransform** (). The
    **viewport** () represents the physical coordinates specifying an arbitrary
    rectangle, the **window** () describes the same rectangle in logical
    coordinates, and the **worldTransform** () is identical with the
    transformation matrix.

    See also **Coordinate System**

    **Clipping**

    QPainter can clip any drawing operation to a rectangle, a region, or a
    vector path. The current clip is available using the functions
    **clipRegion** () and **clipPath** (). Whether paths or regions are
    preferred (faster) depends on the underlying **paintEngine** (). For
    example, the **QImage**  paint engine prefers paths while the X11 paint
    engine prefers regions. Setting a clip is done in the painters logical
    coordinates.

    After QPainter's clipping, the paint device may also clip. For example, most
    widgets clip away the pixels used by child widgets, and most printers clip
    away an area near the edges of the paper. This additional clipping is not
    reflected by the return value of **clipRegion** () or **hasClipping** ().

    **Composition Modes**

    QPainter provides the **CompositionMode**  enum which defines the Porter-
    Duff rules for digital image compositing; it describes a model for combining
    the pixels in one image, the source, with the pixels in another image, the
    destination.

    The two most common forms of composition are **Source**  and **SourceOver**
    . **Source**  is used to draw opaque objects onto a paint device. In this
    mode, each pixel in the source replaces the corresponding pixel in the
    destination. In **SourceOver**  composition mode, the source object is
    transparent and is drawn on top of the destination.

    Note that composition transformation operates pixelwise. For that reason,
    there is a difference between using the graphic primitive itself and its
    bounding rectangle: The bounding rect contains pixels with alpha == 0 (i.e
    the pixels surrounding the primitive). These pixels will overwrite the other
    image's pixels, effectively clearing those, while the primitive only
    overwrites its own area.

    ![](images/qpainter-compositiondemo.png)**Composition Modes Example**

    The
    **Composition Modes**  example, available in Qt's examples directory, allows
    you to experiment with the various composition modes and see the results
    immediately.

    **Limitations**

    If you are using coordinates with Qt's raster-based paint engine, it is
    important to note that, while coordinates greater than +/- 215 can be used,
    any painting performed with coordinates outside this range is not guaranteed
    to be shown; the drawing may be clipped. This is due to the use of `short
    int` in the implementation.

    The outlines generated by Qt's stroker are only an approximation when
    dealing with curved shapes. It is in most cases impossible to represent the
    outline of a bezier curve segment using another bezier curve segment, and so
    Qt approximates the curve outlines by using several smaller curves. For
    performance reasons there is a limit to how many curves Qt uses for these
    outlines, and thus when using large pen widths or scales the outline error
    increases. To generate outlines with smaller errors it is possible to use
    the **QPainterPathStroker**  class, which has the setCurveThreshold member
    function which let's the user specify the error tolerance. Another
    workaround is to convert the paths to polygons first and then draw the
    polygons instead.

    **Performance**

    QPainter is a rich framework that allows developers to do a great variety of
    graphical operations, such as gradients, composition modes and vector
    graphics. And QPainter can do this across a variety of different hardware
    and software stacks. Naturally the underlying combination of hardware and
    software has some implications for performance, and ensuring that every
    single operation is fast in combination with all the various combinations of
    composition modes, brushes, clipping, transformation, etc, is close to an
    impossible task because of the number of permutations. As a compromise we
    have selected a subset of the QPainter API and backends, where performance
    is guaranteed to be as good as we can sensibly get it for the given
    combination of hardware and software.

    The backends we focus on as high-performance engines are:

    * Raster - This backend implements all rendering in pure software and is
    always used to render into QImages. For optimal performance only use the
    format types **QImage::Format_ARGB32_Premultiplied** ,
    **QImage::Format_RGB32**  or **QImage::Format_RGB16** . Any other format,
    including **QImage::Format_ARGB32** , has significantly worse performance.
    This engine is used by default for **QWidget**  and **QPixmap** .
      * OpenGL
    2.0 (ES) - This backend is the primary backend for hardware accelerated
    graphics. It can be run on desktop machines and embedded devices supporting
    the OpenGL 2.0 or OpenGL/ES 2.0 specification. This includes most graphics
    chips produced in the last couple of years. The engine can be enabled by
    using QPainter onto a **QOpenGLWidget** .

    These operations are:

    * Simple transformations, meaning translation and scaling, pluss 0, 90, 180,
    270 degree rotations.
      * `drawPixmap()` in combination with simple
    transformations and opacity with non-smooth transformation mode
    (`QPainter::SmoothPixmapTransform` not enabled as a render hint).
      *
    Rectangle fills with solid color, two-color linear gradients and simple
    transforms.
      * Rectangular clipping with simple transformations and
    intersect clip.
      * Composition Modes `QPainter::CompositionMode_Source` and
    **QPainter::CompositionMode_SourceOver** .
      * Rounded rectangle filling
    using solid color and two-color linear gradients fills.
      * 3x3 patched
    pixmaps, via qDrawBorderPixmap.

    This list gives an indication of which features to safely use in an
    application where performance is critical. For certain setups, other
    operations may be fast too, but before making extensive use of them, it is
    recommended to benchmark and verify them on the system where the software
    will run in the end. There are also cases where expensive operations are ok
    to use, for instance when the result is cached in a **QPixmap** .

    **See also** **QPaintDevice** , **QPaintEngine** , **Qt SVG** , **Basic
    Drawing Example** , and **Drawing Utility Functions** .
    """

    class PixmapFragmentHint(enum.Flag):
        OpaqueHint: QPainter = ...

    class CompositionMode(enum.Enum):
        CompositionMode_SourceOver: QPainter = ...
        CompositionMode_DestinationOver: QPainter = ...
        CompositionMode_Clear: QPainter = ...
        CompositionMode_Source: QPainter = ...
        CompositionMode_Destination: QPainter = ...
        CompositionMode_SourceIn: QPainter = ...
        CompositionMode_DestinationIn: QPainter = ...
        CompositionMode_SourceOut: QPainter = ...
        CompositionMode_DestinationOut: QPainter = ...
        CompositionMode_SourceAtop: QPainter = ...
        CompositionMode_DestinationAtop: QPainter = ...
        CompositionMode_Xor: QPainter = ...
        CompositionMode_Plus: QPainter = ...
        CompositionMode_Multiply: QPainter = ...
        CompositionMode_Screen: QPainter = ...
        CompositionMode_Overlay: QPainter = ...
        CompositionMode_Darken: QPainter = ...
        CompositionMode_Lighten: QPainter = ...
        CompositionMode_ColorDodge: QPainter = ...
        CompositionMode_ColorBurn: QPainter = ...
        CompositionMode_HardLight: QPainter = ...
        CompositionMode_SoftLight: QPainter = ...
        CompositionMode_Difference: QPainter = ...
        CompositionMode_Exclusion: QPainter = ...
        RasterOp_SourceOrDestination: QPainter = ...
        RasterOp_SourceAndDestination: QPainter = ...
        RasterOp_SourceXorDestination: QPainter = ...
        RasterOp_NotSourceAndNotDestination: QPainter = ...
        RasterOp_NotSourceOrNotDestination: QPainter = ...
        RasterOp_NotSourceXorDestination: QPainter = ...
        RasterOp_NotSource: QPainter = ...
        RasterOp_NotSourceAndDestination: QPainter = ...
        RasterOp_SourceAndNotDestination: QPainter = ...
        RasterOp_NotSourceOrDestination: QPainter = ...
        RasterOp_SourceOrNotDestination: QPainter = ...
        RasterOp_ClearDestination: QPainter = ...
        RasterOp_SetDestination: QPainter = ...
        RasterOp_NotDestination: QPainter = ...

    class RenderHint(enum.Flag):
        Antialiasing: QPainter = ...
        TextAntialiasing: QPainter = ...
        SmoothPixmapTransform: QPainter = ...
        LosslessImageRendering: QPainter = ...
        VerticalSubpixelPositioning: QPainter = ...

    class PixmapFragment(PyQt6.sip.simplewrapper):
        height: float = ...
        opacity: float = ...
        rotation: float = ...
        scaleX: float = ...
        scaleY: float = ...
        sourceLeft: float = ...
        sourceTop: float = ...
        width: float = ...
        x: float = ...
        y: float = ...

        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QPainter.PixmapFragment") -> None:
            ...

        @staticmethod
        def create(
            pos: QtCore.QPointF,
            sourceRect: QtCore.QRectF,
            scaleX: float = ...,
            scaleY: float = ...,
            rotation: float = ...,
            opacity: float = ...,
        ) -> "QPainter.PixmapFragment":
            ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#QPainter

        **QPainter::QPainter()**

        Constructs a painter.

        **See also** **begin** () and **end** ().
        """
        ...

    @typing.overload
    def __init__(self, a0: QPaintDevice) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#QPainter-1

        **QPainter::QPainter(QPaintDevice * device )**

        Constructs a painter that begins painting the paint **device**
        immediately.

        This constructor is convenient for short-lived painters, e.g. in a
        **QWidget::paintEvent** () and should be used only once. The constructor
        calls **begin** () for you and the QPainter destructor automatically
        calls **end** ().

        Here's an example using **begin** () and **end** ():

        void MyWidget::paintEvent(**QPaintEvent**  *)
            {
                **QPainter**
        p;
                p.begin(this);
                p.drawLine(drawingCode);        //
        drawing code
                p.end();
            }

        The same example using this constructor:

        void MyWidget::paintEvent(**QPaintEvent**  *)
            {
                **QPainter**
        p(this);
                p.drawLine(drawingCode);        // drawing code
            }

        Since the constructor cannot provide feedback when the initialization of
        the painter failed you should rather use **begin** () and **end** () to
        paint on external devices, e.g. printers.

        **See also** **begin** () and **end** ().
        """
        ...

    def drawGlyphRun(self, position: QtCore.QPointF, glyphRun: QGlyphRun) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawGlyphRun

        **void QPainter::drawGlyphRun(const QPointF & position , const QGlyphRun
        & glyphs )**

        Draws the glyphs represented by **glyphs** at **position**. The
        **position** gives the edge of the baseline for the string of glyphs.
        The glyphs will be retrieved from the font selected on **glyphs** and at
        offsets given by the positions in **glyphs**.

        **See also** **QGlyphRun::setRawFont** (), **QGlyphRun::setPositions**
        (), and **QGlyphRun::setGlyphIndexes** ().
        """
        ...

    def clipBoundingRect(self) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qpainter.html#clipBoundingRect

        **QRectF QPainter::clipBoundingRect() const**

        Returns the bounding rectangle of the current clip if there is a clip;
        otherwise returns an empty rectangle. Note that the clip region is given
        in logical coordinates.

        The bounding rectangle is not guaranteed to be tight.

        **See also** **setClipRect** (), **setClipPath** (), and
        **setClipRegion** ().
        """
        ...

    @typing.overload
    def drawStaticText(
        self, topLeftPosition: QtCore.QPointF, staticText: "QStaticText"
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawStaticText

        **void QPainter::drawStaticText(const QPointF & topLeftPosition , const
        QStaticText & staticText )**

        Draws the given **staticText** at the given **topLeftPosition**.

        The text will be drawn using the font and the transformation set on the
        painter. If the font and/or transformation set on the painter are
        different from the ones used to initialize the layout of the
        **QStaticText** , then the layout will have to be recalculated. Use
        **QStaticText::prepare** () to initialize **staticText** with the font
        and transformation with which it will later be drawn.

        If **topLeftPosition** is not the same as when **staticText** was
        initialized, or when it was last drawn, then there will be a slight
        overhead when translating the text to its new position.

        **Note:** If the painter's transformation is not affine, then
        **staticText** will be drawn using regular calls to **drawText** (),
        losing any potential for performance improvement.

        **Note:** The y-position is used as the top of the font.

        **See also** **QStaticText** .
        """
        ...

    @typing.overload
    def drawStaticText(self, p: QtCore.QPoint, staticText: "QStaticText") -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawStaticText-1

        **void QPainter::drawStaticText(const QPoint & topLeftPosition , const
        QStaticText & staticText )**

        This is an overloaded function.

        Draws the **staticText** at the **topLeftPosition**.

        **Note:** The y-position is used as the top of the font.
        """
        ...

    @typing.overload
    def drawStaticText(self, x: int, y: int, staticText: "QStaticText") -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawStaticText-2

        **void QPainter::drawStaticText(int left , int top , const QStaticText &
        staticText )**

        This is an overloaded function.

        Draws the **staticText** at coordinates **left** and **top**.

        **Note:** The y-position is used as the top of the font.
        """
        ...

    def drawPixmapFragments(
        self,
        fragments: typing.List["QPainter.PixmapFragment"],
        pixmap: QPixmap,
        hints: "QPainter.PixmapFragmentHint" = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPixmapFragments

        **void QPainter::drawPixmapFragments(const QPainter::PixmapFragment *
        fragments , int fragmentCount , const QPixmap & pixmap ,
        QPainter::PixmapFragmentHints hints = PixmapFragmentHints())**

        This function is used to draw **pixmap** , or a sub-rectangle of
        **pixmap** , at multiple positions with different scale, rotation and
        opacity. **fragments** is an array of **fragmentCount** elements
        specifying the parameters used to draw each pixmap fragment. The
        **hints** parameter can be used to pass in drawing hints.

        This function is potentially faster than multiple calls to
        **drawPixmap** (), since the backend can optimize state changes.

        **See also** **QPainter::PixmapFragment**  and
        **QPainter::PixmapFragmentHint** .
        """
        ...

    def endNativePainting(self) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#endNativePainting

        **void QPainter::endNativePainting()**

        Restores the painter after manually issuing native painting commands.
        Lets the painter restore any native state that it relies on before
        calling any other painter commands.

        **See also** **beginNativePainting** ().
        """
        ...

    def beginNativePainting(self) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#beginNativePainting

        **void QPainter::beginNativePainting()**

        Flushes the painting pipeline and prepares for the user issuing commands
        directly to the underlying graphics context. Must be followed by a call
        to **endNativePainting** ().

        Note that only the states the underlying paint engine changes will be
        reset to their respective default states. The states we reset may change
        from release to release. The following states are currently reset in the
        OpenGL 2 engine:

        * blending is disabled
          * the depth, stencil and scissor tests are
        disabled
          * the active texture unit is reset to 0
          * the depth mask,
        depth function and the clear depth are reset to their default values
          *
        the stencil mask, stencil operation and stencil function are reset to
        their default values
          * the current color is reset to solid white

        If, for example, the OpenGL polygon mode is changed by the user inside a
        beginNativePaint()/**endNativePainting** () block, it will not be reset
        to the default state by **endNativePainting** (). Here is an example
        that shows intermixing of painter commands and raw OpenGL commands:

        **QPainter**  painter(this);
            painter.fillRect(0, 0, 128, 128,
        Qt::green);
            painter.beginNativePainting();
        glEnable(GL_SCISSOR_TEST);
            glScissor(0, 0, 64, 64);
        glClearColor(1, 0, 0, 1);
            glClear(GL_COLOR_BUFFER_BIT);
        glDisable(GL_SCISSOR_TEST);

            painter.endNativePainting();

        **See also** **endNativePainting** ().
        """
        ...

    @typing.overload
    def drawRoundedRect(
        self,
        rect: QtCore.QRectF,
        xRadius: float,
        yRadius: float,
        mode: QtCore.Qt.SizeMode = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawRoundedRect

        **void QPainter::drawRoundedRect(const QRectF & rect , qreal xRadius ,
        qreal yRadius , Qt::SizeMode mode = Qt::AbsoluteSize)**

        Draws the given rectangle **rect** with rounded corners.

        The **xRadius** and **yRadius** arguments specify the radii of the
        ellipses defining the corners of the rounded rectangle. When **mode** is
        **Qt::RelativeSize** , **xRadius** and **yRadius** are specified in
        percentage of half the rectangle's width and height respectively, and
        should be in the range 0.0 to 100.0.

        A filled rectangle has a size of rect.size(). A stroked rectangle has a
        size of rect.size() plus the pen width.

        ![](images/qpainter-roundrect.png)



            **QRectF**
        rectangle(10.0, 20.0, 80.0, 60.0);

            **QPainter**  painter(this);
        painter.drawRoundedRect(rectangle, 20.0, 15.0);

        **See also** **drawRect** () and **QPen** .
        """
        ...

    @typing.overload
    def drawRoundedRect(
        self,
        x: int,
        y: int,
        w: int,
        h: int,
        xRadius: float,
        yRadius: float,
        mode: QtCore.Qt.SizeMode = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawRoundedRect-1

        **void QPainter::drawRoundedRect(int x , int y , int w , int h , qreal
        xRadius , qreal yRadius , Qt::SizeMode mode = Qt::AbsoluteSize)**

        This is an overloaded function.

        Draws the given rectangle **x** , **y** , **w** , **h** with rounded
        corners.
        """
        ...

    @typing.overload
    def drawRoundedRect(
        self,
        rect: QtCore.QRect,
        xRadius: float,
        yRadius: float,
        mode: QtCore.Qt.SizeMode = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawRoundedRect-2

        **void QPainter::drawRoundedRect(const QRect & rect , qreal xRadius ,
        qreal yRadius , Qt::SizeMode mode = Qt::AbsoluteSize)**

        This is an overloaded function.

        Draws the given rectangle **rect** with rounded corners.
        """
        ...

    def testRenderHint(self, hint: "QPainter.RenderHint") -> bool:
        """
        https://doc.qt.io/qt-6/qpainter.html#testRenderHint

        **bool QPainter::testRenderHint(QPainter::RenderHint hint ) const**

        Returns `true` if **hint** is set; otherwise returns `false`.

        **See also** **renderHints** () and **setRenderHint** ().
        """
        ...

    def combinedTransform(self) -> "QTransform":
        """
        https://doc.qt.io/qt-6/qpainter.html#combinedTransform

        **QTransform QPainter::combinedTransform() const**

        Returns the transformation matrix combining the current window/viewport
        and world transformation.

        **See also** **setWorldTransform** (), **setWindow** (), and
        **setViewport** ().
        """
        ...

    def worldTransform(self) -> "QTransform":
        """
        https://doc.qt.io/qt-6/qpainter.html#worldTransform

        **const QTransform &QPainter::worldTransform() const**

        Returns the world transformation matrix.

        **See also** **setWorldTransform** ().
        """
        ...

    def setWorldTransform(self, matrix: "QTransform", combine: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#setWorldTransform

        **void QPainter::setWorldTransform(const QTransform & matrix , bool
        combine = false)**

        Sets the world transformation matrix. If **combine** is true, the
        specified **matrix** is combined with the current matrix; otherwise it
        replaces the current matrix.

        **See also** **worldTransform** (), **transform** (), and
        **setTransform** ().
        """
        ...

    def resetTransform(self) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#resetTransform

        **void QPainter::resetTransform()**

        Resets any transformations that were made using **translate** (),
        **scale** (), **shear** (), **rotate** (), **setWorldTransform** (),
        **setViewport** () and **setWindow** ().

        **See also** **Coordinate Transformations** .
        """
        ...

    def deviceTransform(self) -> "QTransform":
        """
        https://doc.qt.io/qt-6/qpainter.html#deviceTransform

        **const QTransform &QPainter::deviceTransform() const**

        Returns the matrix that transforms from logical coordinates to device
        coordinates of the platform dependent paint device.

        This function is **only** needed when using platform painting commands
        on the platform dependent handle (**Qt::HANDLE** ), and the platform
        does not do transformations nativly.

        The **QPaintEngine::PaintEngineFeature**  enum can be queried to
        determine whether the platform performs the transformations or not.

        **See also** **worldTransform** () and **QPaintEngine::hasFeature** ().
        """
        ...

    def transform(self) -> "QTransform":
        """
        https://doc.qt.io/qt-6/qpainter.html#transform

        **const QTransform &QPainter::transform() const**

        Alias for **worldTransform** (). Returns the world transformation
        matrix.

        **See also** **setTransform** () and **worldTransform** ().
        """
        ...

    def setTransform(self, transform: "QTransform", combine: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#setTransform

        **void QPainter::setTransform(const QTransform & transform , bool
        combine = false)**

        Sets the world transformation matrix. If **combine** is true, the
        specified **transform** is combined with the current matrix; otherwise
        it replaces the current matrix.

        **See also** **transform** () and **setWorldTransform** ().
        """
        ...

    def setWorldMatrixEnabled(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#setWorldMatrixEnabled

        **void QPainter::setWorldMatrixEnabled(bool enable )**

        Enables transformations if **enable** is true, or disables
        transformations if **enable** is false. The world transformation matrix
        is not changed.

        **See also** **worldMatrixEnabled** (), **worldTransform** (), and
        **Coordinate Transformations** .
        """
        ...

    def worldMatrixEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-6/qpainter.html#worldMatrixEnabled

        **bool QPainter::worldMatrixEnabled() const**

        Returns `true` if world transformation is enabled; otherwise returns
        false.

        **See also** **setWorldMatrixEnabled** (), **worldTransform** (), and
        **Coordinate System** .
        """
        ...

    def setOpacity(self, opacity: float) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#setOpacity

        **void QPainter::setOpacity(qreal opacity )**

        Sets the opacity of the painter to **opacity**. The value should be in
        the range 0.0 to 1.0, where 0.0 is fully transparent and 1.0 is fully
        opaque.

        Opacity set on the painter will apply to all drawing operations
        individually.

        **See also** **opacity** ().
        """
        ...

    def opacity(self) -> float:
        """
        https://doc.qt.io/qt-6/qpainter.html#opacity

        **qreal QPainter::opacity() const**

        Returns the opacity of the painter. The default value is 1.

        **See also** **setOpacity** ().
        """
        ...

    @typing.overload
    def drawImage(self, r: QtCore.QRectF, image: QImage) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawImage

        **void QPainter::drawImage(const QRectF & target , const QImage & image
        , const QRectF & source , Qt::ImageConversionFlags flags =
        Qt::AutoColor)**

        Draws the rectangular portion **source** of the given **image** into the
        **target** rectangle in the paint device.

        **Note:** The image is scaled to fit the rectangle, if both the image
        and rectangle size disagree.

        **Note:** See **Drawing High Resolution Versions of Pixmaps and Images**
        on how this is affected by **QImage::devicePixelRatio** ().

        If the image needs to be modified to fit in a lower-resolution result
        (e.g. converting from 32-bit to 8-bit), use the **flags** to specify how
        you would prefer this to happen.

        **QRectF**  target(10.0, 20.0, 80.0, 60.0);
            **QRectF**  source(0.0,
        0.0, 70.0, 40.0);
            **QImage**  image(":/images/myImage.png");
        **QPainter**  painter(this);
            painter.drawImage(target, image,
        source);

        **See also** **drawPixmap** () and **QImage::devicePixelRatio** ().
        """
        ...

    @typing.overload
    def drawImage(
        self,
        targetRect: QtCore.QRectF,
        image: QImage,
        sourceRect: QtCore.QRectF,
        flags: QtCore.Qt.ImageConversionFlag = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawImage-1

        **void QPainter::drawImage(const QRect & target , const QImage & image ,
        const QRect & source , Qt::ImageConversionFlags flags = Qt::AutoColor)**

        This is an overloaded function.

        Draws the rectangular portion **source** of the given **image** into the
        **target** rectangle in the paint device.

        **Note:** The image is scaled to fit the rectangle, if both the image
        and rectangle size disagree.
        """
        ...

    @typing.overload
    def drawImage(self, r: QtCore.QRect, image: QImage) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawImage-2

        **void QPainter::drawImage(const QPointF & point , const QImage & image
        , const QRectF & source , Qt::ImageConversionFlags flags =
        Qt::AutoColor)**

        This is an overloaded function.

        Draws the rectangular portion **source** of the given **image** with its
        origin at the given **point**.
        """
        ...

    @typing.overload
    def drawImage(
        self,
        targetRect: QtCore.QRect,
        image: QImage,
        sourceRect: QtCore.QRect,
        flags: QtCore.Qt.ImageConversionFlag = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawImage-3

        **void QPainter::drawImage(const QPoint & point , const QImage & image ,
        const QRect & source , Qt::ImageConversionFlags flags = Qt::AutoColor)**

        This is an overloaded function.

        Draws the rectangular portion **source** of the given **image** with its
        origin at the given **point**.
        """
        ...

    @typing.overload
    def drawImage(self, p: QtCore.QPointF, image: QImage) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawImage-4

        **void QPainter::drawImage(const QRectF & rectangle , const QImage &
        image )**

        This is an overloaded function.

        Draws the given **image** into the given **rectangle**.

        **Note:** The image is scaled to fit the rectangle, if both the image
        and rectangle size disagree.
        """
        ...

    @typing.overload
    def drawImage(
        self,
        p: QtCore.QPointF,
        image: QImage,
        sr: QtCore.QRectF,
        flags: QtCore.Qt.ImageConversionFlag = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawImage-5

        **void QPainter::drawImage(const QRect & rectangle , const QImage &
        image )**

        This is an overloaded function.

        Draws the given **image** into the given **rectangle**.

        **Note:** The image is scaled to fit the rectangle, if both the image
        and rectangle size disagree.
        """
        ...

    @typing.overload
    def drawImage(self, p: QtCore.QPoint, image: QImage) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawImage-6

        **void QPainter::drawImage(const QPointF & point , const QImage & image
        )**

        This is an overloaded function.

        Draws the given **image** at the given **point**.
        """
        ...

    @typing.overload
    def drawImage(
        self,
        p: QtCore.QPoint,
        image: QImage,
        sr: QtCore.QRect,
        flags: QtCore.Qt.ImageConversionFlag = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawImage-7

        **void QPainter::drawImage(const QPoint & point , const QImage & image
        )**

        This is an overloaded function.

        Draws the given **image** at the given **point**.
        """
        ...

    @typing.overload
    def drawImage(
        self,
        x: int,
        y: int,
        image: QImage,
        sx: int = ...,
        sy: int = ...,
        sw: int = ...,
        sh: int = ...,
        flags: QtCore.Qt.ImageConversionFlag = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawImage-8

        **void QPainter::drawImage(int x , int y , const QImage & image , int sx
        = 0, int sy = 0, int sw = -1, int sh = -1, Qt::ImageConversionFlags
        flags = Qt::AutoColor)**

        This is an overloaded function.

        Draws an image at ( **x** , **y** ) by copying a part of **image** into
        the paint device.

        ( **x** , **y** ) specifies the top-left point in the paint device that
        is to be drawn onto. ( **sx** , **sy** ) specifies the top-left point in
        **image** that is to be drawn. The default is (0, 0).

        ( **sw** , **sh** ) specifies the size of the image that is to be drawn.
        The default, (0, 0) (and negative) means all the way to the bottom-right
        of the image.
        """
        ...

    @typing.overload
    def drawPoint(self, p: QtCore.QPointF) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPoint

        **void QPainter::drawPoint(const QPointF & position )**

        Draws a single point at the given **position** using the current pen's
        color.

        **See also** **Coordinate System** .
        """
        ...

    @typing.overload
    def drawPoint(self, x: int, y: int) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPoint-1

        **void QPainter::drawPoint(const QPoint & position )**

        This is an overloaded function.

        Draws a single point at the given **position** using the current pen's
        color.
        """
        ...

    @typing.overload
    def drawPoint(self, p: QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPoint-2

        **void QPainter::drawPoint(int x , int y )**

        This is an overloaded function.

        Draws a single point at position ( **x** , **y** ).
        """
        ...

    @typing.overload
    def drawRect(self, rect: QtCore.QRectF) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawRect

        **void QPainter::drawRect(const QRectF & rectangle )**

        Draws the current **rectangle** with the current pen and brush.

        A filled rectangle has a size of **rectangle**.size(). A stroked
        rectangle has a size of **rectangle**.size() plus the pen width.

        ![](images/qpainter-rectangle.png)



            **QRectF**
        rectangle(10.0, 20.0, 80.0, 60.0);

            **QPainter**  painter(this);
        painter.drawRect(rectangle);

        **See also** **drawRects** (), **drawPolygon** (), and **Coordinate
        System** .
        """
        ...

    @typing.overload
    def drawRect(self, x: int, y: int, w: int, h: int) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawRect-1

        **void QPainter::drawRect(int x , int y , int width , int height )**

        This is an overloaded function.

        Draws a rectangle with upper left corner at ( **x** , **y** ) and with
        the given **width** and **height**.
        """
        ...

    @typing.overload
    def drawRect(self, r: QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawRect-2

        **void QPainter::drawRect(const QRect & rectangle )**

        This is an overloaded function.

        Draws the current **rectangle** with the current pen and brush.
        """
        ...

    @typing.overload
    def drawLine(self, l: QtCore.QLineF) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawLine

        **void QPainter::drawLine(const QLineF & line )**

        Draws a line defined by **line**.

        ![](images/qpainter-line.png)



            **QLineF**  line(10.0,
        80.0, 90.0, 20.0);

            **QPainter** (this);
        painter.drawLine(line);

        **See also** **drawLines** (), **drawPolyline** (), and **Coordinate
        System** .
        """
        ...

    @typing.overload
    def drawLine(self, line: QtCore.QLine) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawLine-1

        **void QPainter::drawLine(const QLine & line )**

        This is an overloaded function.

        Draws a line defined by **line**.
        """
        ...

    @typing.overload
    def drawLine(self, x1: int, y1: int, x2: int, y2: int) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawLine-2

        **void QPainter::drawLine(int x1 , int y1 , int x2 , int y2 )**

        This is an overloaded function.

        Draws a line from ( **x1** , **y1** ) to ( **x2** , **y2** ).
        """
        ...

    @typing.overload
    def drawLine(self, p1: QtCore.QPoint, p2: QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawLine-3

        **void QPainter::drawLine(const QPoint & p1 , const QPoint & p2 )**

        This is an overloaded function.

        Draws a line from **p1** to **p2**.
        """
        ...

    @typing.overload
    def drawLine(self, p1: QtCore.QPointF, p2: QtCore.QPointF) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawLine-4

        **void QPainter::drawLine(const QPointF & p1 , const QPointF & p2 )**

        This is an overloaded function.

        Draws a line from **p1** to **p2**.
        """
        ...

    def paintEngine(self) -> QPaintEngine:
        """
        https://doc.qt.io/qt-6/qpainter.html#paintEngine

        **QPaintEngine *QPainter::paintEngine() const**

        Returns the paint engine that the painter is currently operating on if
        the painter is active; otherwise 0.

        **See also** **isActive** ().
        """
        ...

    def setRenderHints(self, hints: "QPainter.RenderHint", on: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#setRenderHints

        **void QPainter::setRenderHints(QPainter::RenderHints hints , bool on =
        true)**

        Sets the given render **hints** on the painter if **on** is true;
        otherwise clears the render hints.

        **See also** **setRenderHint** (), **renderHints** (), and **Rendering
        Quality** .
        """
        ...

    def renderHints(self) -> "QPainter.RenderHint":
        """
        https://doc.qt.io/qt-6/qpainter.html#renderHints

        **QPainter::RenderHints QPainter::renderHints() const**

        Returns a flag that specifies the rendering hints that are set for this
        painter.

        **See also** **setRenderHints** (), **testRenderHint** (), and
        **Rendering Quality** .
        """
        ...

    def setRenderHint(self, hint: "QPainter.RenderHint", on: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#setRenderHint

        **void QPainter::setRenderHint(QPainter::RenderHint hint , bool on =
        true)**

        Sets the given render **hint** on the painter if **on** is true;
        otherwise clears the render hint.

        **See also** **setRenderHints** (), **renderHints** (), and **Rendering
        Quality** .
        """
        ...

    @typing.overload
    def eraseRect(self, a0: QtCore.QRectF) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#eraseRect

        **void QPainter::eraseRect(const QRectF & rectangle )**

        Erases the area inside the given **rectangle**. Equivalent to calling

        fillRect(rectangle, background());

        **See also** **fillRect** ().
        """
        ...

    @typing.overload
    def eraseRect(self, rect: QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#eraseRect-1

        **void QPainter::eraseRect(int x , int y , int width , int height )**

        This is an overloaded function.

        Erases the area inside the rectangle beginning at ( **x** , **y** ) with
        the given **width** and **height**.
        """
        ...

    @typing.overload
    def eraseRect(self, x: int, y: int, w: int, h: int) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#eraseRect-2

        **void QPainter::eraseRect(const QRect & rectangle )**

        This is an overloaded function.

        Erases the area inside the given **rectangle**.
        """
        ...

    @typing.overload
    def fillRect(
        self,
        a0: QtCore.QRectF,
        a1: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, int, QGradient],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#fillRect

        **void QPainter::fillRect(const QRectF & rectangle , const QBrush &
        brush )**

        Fills the given **rectangle** with the **brush** specified.

        Alternatively, you can specify a **QColor**  instead of a **QBrush** ;
        the **QBrush**  constructor (taking a **QColor**  argument) will
        automatically create a solid pattern brush.

        **See also** **drawRect** ().
        """
        ...

    @typing.overload
    def fillRect(
        self,
        a0: QtCore.QRect,
        a1: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, int, QGradient],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#fillRect-1

        **void QPainter::fillRect(int x , int y , int width , int height , const
        QBrush & brush )**

        This is an overloaded function.

        Fills the rectangle beginning at ( **x** , **y** ) with the given
        **width** and **height** , using the given **brush**.
        """
        ...

    @typing.overload
    def fillRect(
        self,
        x: int,
        y: int,
        w: int,
        h: int,
        b: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, int, QGradient],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#fillRect-2

        **void QPainter::fillRect(const QRect & rectangle , const QBrush & brush
        )**

        This is an overloaded function.

        Fills the given **rectangle** with the specified **brush**.
        """
        ...

    @typing.overload
    def fillRect(
        self,
        a0: QtCore.QRectF,
        color: typing.Union[QColor, QtCore.Qt.GlobalColor, int, QGradient],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#fillRect-3

        **void QPainter::fillRect(const QRectF & rectangle , const QColor &
        color )**

        This is an overloaded function.

        Fills the given **rectangle** with the **color** specified.
        """
        ...

    @typing.overload
    def fillRect(
        self,
        a0: QtCore.QRect,
        color: typing.Union[QColor, QtCore.Qt.GlobalColor, int, QGradient],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#fillRect-4

        **void QPainter::fillRect(int x , int y , int width , int height , const
        QColor & color )**

        This is an overloaded function.

        Fills the rectangle beginning at ( **x** , **y** ) with the given
        **width** and **height** , using the given **color**.
        """
        ...

    @typing.overload
    def fillRect(
        self,
        x: int,
        y: int,
        w: int,
        h: int,
        b: typing.Union[QColor, QtCore.Qt.GlobalColor, int, QGradient],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#fillRect-5

        **void QPainter::fillRect(const QRect & rectangle , const QColor & color
        )**

        This is an overloaded function.

        Fills the given **rectangle** with the **color** specified.
        """
        ...

    @typing.overload
    def fillRect(
        self, x: int, y: int, w: int, h: int, c: QtCore.Qt.GlobalColor
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#fillRect-6

        **void QPainter::fillRect(int x , int y , int width , int height ,
        Qt::GlobalColor color )**

        This is an overloaded function.

        Fills the rectangle beginning at ( **x** , **y** ) with the given
        **width** and **height** , using the given **color**.
        """
        ...

    @typing.overload
    def fillRect(self, r: QtCore.QRect, c: QtCore.Qt.GlobalColor) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#fillRect-7

        **void QPainter::fillRect(const QRect & rectangle , Qt::GlobalColor
        color )**

        This is an overloaded function.

        Fills the given **rectangle** with the specified **color**.
        """
        ...

    @typing.overload
    def fillRect(self, r: QtCore.QRectF, c: QtCore.Qt.GlobalColor) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#fillRect-8

        **void QPainter::fillRect(const QRectF & rectangle , Qt::GlobalColor
        color )**

        This is an overloaded function.

        Fills the given **rectangle** with the specified **color**.
        """
        ...

    @typing.overload
    def fillRect(
        self, x: int, y: int, w: int, h: int, style: QtCore.Qt.BrushStyle
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#fillRect-9

        **void QPainter::fillRect(int x , int y , int width , int height ,
        Qt::BrushStyle style )**

        This is an overloaded function.

        Fills the rectangle beginning at ( **x** , **y** ) with the given
        **width** and **height** , using the brush **style** specified.
        """
        ...

    @typing.overload
    def fillRect(self, r: QtCore.QRect, style: QtCore.Qt.BrushStyle) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#fillRect-10

        **void QPainter::fillRect(const QRect & rectangle , Qt::BrushStyle style
        )**

        This is an overloaded function.

        Fills the given **rectangle** with the brush **style** specified.
        """
        ...

    @typing.overload
    def fillRect(self, r: QtCore.QRectF, style: QtCore.Qt.BrushStyle) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#fillRect

        **void QPainter::fillRect(const QRectF & rectangle , const QBrush &
        brush )**

        Fills the given **rectangle** with the **brush** specified.

        Alternatively, you can specify a **QColor**  instead of a **QBrush** ;
        the **QBrush**  constructor (taking a **QColor**  argument) will
        automatically create a solid pattern brush.

        **See also** **drawRect** ().
        """
        ...

    @typing.overload
    def fillRect(
        self, x: int, y: int, w: int, h: int, preset: QGradient.Preset
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#fillRect

        **void QPainter::fillRect(const QRectF & rectangle , const QBrush &
        brush )**

        Fills the given **rectangle** with the **brush** specified.

        Alternatively, you can specify a **QColor**  instead of a **QBrush** ;
        the **QBrush**  constructor (taking a **QColor**  argument) will
        automatically create a solid pattern brush.

        **See also** **drawRect** ().
        """
        ...

    @typing.overload
    def fillRect(self, r: QtCore.QRect, preset: QGradient.Preset) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#fillRect

        **void QPainter::fillRect(const QRectF & rectangle , const QBrush &
        brush )**

        Fills the given **rectangle** with the **brush** specified.

        Alternatively, you can specify a **QColor**  instead of a **QBrush** ;
        the **QBrush**  constructor (taking a **QColor**  argument) will
        automatically create a solid pattern brush.

        **See also** **drawRect** ().
        """
        ...

    @typing.overload
    def fillRect(self, r: QtCore.QRectF, preset: QGradient.Preset) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#fillRect

        **void QPainter::fillRect(const QRectF & rectangle , const QBrush &
        brush )**

        Fills the given **rectangle** with the **brush** specified.

        Alternatively, you can specify a **QColor**  instead of a **QBrush** ;
        the **QBrush**  constructor (taking a **QColor**  argument) will
        automatically create a solid pattern brush.

        **See also** **drawRect** ().
        """
        ...

    @typing.overload
    def boundingRect(self, rect: QtCore.QRectF, flags: int, text: str) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qpainter.html#boundingRect

        **QRectF QPainter::boundingRect(const QRectF & rectangle , int flags ,
        const QString & text )**

        Returns the bounding rectangle of the **text** as it will appear when
        drawn inside the given **rectangle** with the specified **flags** using
        the currently set **font** (); i.e the function tells you where the
        **drawText** () function will draw when given the same arguments.

        If the **text** does not fit within the given **rectangle** using the
        specified **flags** , the function returns the required rectangle.

        The **flags** argument is a bitwise OR of the following flags:

        * **Qt::AlignLeft**
          * **Qt::AlignRight**
          * **Qt::AlignHCenter**
        * **Qt::AlignTop**
          * **Qt::AlignBottom**
          * **Qt::AlignVCenter**
        * **Qt::AlignCenter**
          * **Qt::TextSingleLine**
          *
        **Qt::TextExpandTabs**
          * **Qt::TextShowMnemonic**
          *
        **Qt::TextWordWrap**
          * **Qt::TextIncludeTrailingSpaces**

        If several of the horizontal or several of the vertical alignment flags
        are set, the resulting alignment is undefined.

        **See also** **drawText** (), **Qt::Alignment** , and **Qt::TextFlag** .
        """
        ...

    @typing.overload
    def boundingRect(self, rect: QtCore.QRect, flags: int, text: str) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qpainter.html#boundingRect-1

        **QRect QPainter::boundingRect(const QRect & rectangle , int flags ,
        const QString & text )**

        This is an overloaded function.

        Returns the bounding rectangle of the **text** as it will appear when
        drawn inside the given **rectangle** with the specified **flags** using
        the currently set **font** ().
        """
        ...

    @typing.overload
    def boundingRect(
        self, rectangle: QtCore.QRectF, text: str, option: "QTextOption" = ...
    ) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qpainter.html#boundingRect-2

        **QRect QPainter::boundingRect(int x , int y , int w , int h , int flags
        , const QString & text )**

        This is an overloaded function.

        Returns the bounding rectangle of the given **text** as it will appear
        when drawn inside the rectangle beginning at the point ( **x** , **y** )
        with width **w** and height **h**.
        """
        ...

    @typing.overload
    def boundingRect(
        self, x: int, y: int, w: int, h: int, flags: int, text: str
    ) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qpainter.html#boundingRect-3

        **QRectF QPainter::boundingRect(const QRectF & rectangle , const QString
        & text , const QTextOption & option = QTextOption())**

        This is an overloaded function.

        Instead of specifying flags as a bitwise OR of the **Qt::AlignmentFlag**
        and **Qt::TextFlag** , this overloaded function takes an **option**
        argument. The **QTextOption**  class provides a description of general
        rich text properties.

        **See also** **QTextOption** .
        """
        ...

    @typing.overload
    def drawText(self, p: QtCore.QPointF, s: str) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawText

        **void QPainter::drawText(const QPointF & position , const QString &
        text )**

        Draws the given **text** with the currently defined text direction,
        beginning at the given **position**.

        This function does not handle the newline character (\\n), as it cannot
        break text into multiple lines, and it cannot display the newline
        character. Use the QPainter::drawText() overload that takes a rectangle
        instead if you want to draw multiple lines of text with the newline
        character, or if you want the text to be wrapped.

        By default, **QPainter**  draws text anti-aliased.

        **Note:** The y-position is used as the baseline of the font.

        **See also** **setFont** () and **setPen** ().
        """
        ...

    @typing.overload
    def drawText(
        self, rectangle: QtCore.QRectF, flags: int, text: str
    ) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawText-1

        **void QPainter::drawText(const QPoint & position , const QString & text
        )**

        This is an overloaded function.

        Draws the given **text** with the currently defined text direction,
        beginning at the given **position**.

        By default, **QPainter**  draws text anti-aliased.

        **Note:** The y-position is used as the baseline of the font.

        **See also** **setFont** () and **setPen** ().
        """
        ...

    @typing.overload
    def drawText(self, rectangle: QtCore.QRect, flags: int, text: str) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawText-2

        **void QPainter::drawText(int x , int y , const QString & text )**

        This is an overloaded function.

        Draws the given **text** at position ( **x** , **y** ), using the
        painter's currently defined text direction.

        By default, **QPainter**  draws text anti-aliased.

        **Note:** The y-position is used as the baseline of the font.

        **See also** **setFont** () and **setPen** ().
        """
        ...

    @typing.overload
    def drawText(
        self, rectangle: QtCore.QRectF, text: str, option: "QTextOption" = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawText-3

        **void QPainter::drawText(const QRect & rectangle , int flags , const
        QString & text , QRect * boundingRect = nullptr)**

        This is an overloaded function.

        Draws the given **text** within the provided **rectangle** according to
        the specified **flags**.

        The **boundingRect** (if not null) is set to the what the bounding
        rectangle should be in order to enclose the whole text. For example, in
        the following image, the dotted line represents **boundingRect** as
        calculated by the function, and the dashed line represents **rectangle**
        :

        ![](images/qpainter-text-bounds.png)



            **QPainter**
        painter(this);
            **QFont**  font = painter.font();
        font.setPixelSize(48);
            painter.setFont(font);

            const
        **QRect**  rectangle = **QRect** (0, 0, 100, 50);
            **QRect**
        boundingRect;
            painter.drawText(rectangle, 0, tr("Hello"),
        &boundingRect);

            **QPen**  pen = painter.pen();
        pen.setStyle(Qt::DotLine);
            painter.setPen(pen);
        painter.drawRect(boundingRect.adjusted(0, 0, -pen.width(),
        -pen.width()));

            pen.setStyle(Qt::DashLine);
        painter.setPen(pen);
            painter.drawRect(rectangle.adjusted(0, 0,
        -pen.width(), -pen.width()));

        By default, **QPainter**  draws text anti-aliased.

        **Note:** The y-coordinate of **rectangle** is used as the top of the
        font.

        **See also** **setFont** () and **setPen** ().
        """
        ...

    @typing.overload
    def drawText(self, p: QtCore.QPoint, s: str) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawText-4

        **void QPainter::drawText(int x , int y , int width , int height , int
        flags , const QString & text , QRect * boundingRect = nullptr)**

        This is an overloaded function.

        Draws the given **text** within the rectangle with origin ( **x** ,
        **y** ), **width** and **height**.

        The **boundingRect** (if not null) is set to the what the bounding
        rectangle should be in order to enclose the whole text. For example, in
        the following image, the dotted line represents **boundingRect** as
        calculated by the function, and the dashed line represents the rectangle
        defined by **x** , **y** , **width** and **height** :

        ![](images/qpainter-text-bounds.png)



            **QPainter**
        painter(this);
            **QFont**  font = painter.font();
        font.setPixelSize(48);
            painter.setFont(font);

            const
        **QRect**  rectangle = **QRect** (0, 0, 100, 50);
            **QRect**
        boundingRect;
            painter.drawText(rectangle, 0, tr("Hello"),
        &boundingRect);

            **QPen**  pen = painter.pen();
        pen.setStyle(Qt::DotLine);
            painter.setPen(pen);
        painter.drawRect(boundingRect.adjusted(0, 0, -pen.width(),
        -pen.width()));

            pen.setStyle(Qt::DashLine);
        painter.setPen(pen);
            painter.drawRect(rectangle.adjusted(0, 0,
        -pen.width(), -pen.width()));

        The **flags** argument is a bitwise OR of the following flags:

        * **Qt::AlignLeft**
          * **Qt::AlignRight**
          * **Qt::AlignHCenter**
        * **Qt::AlignJustify**
          * **Qt::AlignTop**
          * **Qt::AlignBottom**
        * **Qt::AlignVCenter**
          * **Qt::AlignCenter**
          *
        **Qt::TextSingleLine**
          * **Qt::TextExpandTabs**
          *
        **Qt::TextShowMnemonic**
          * **Qt::TextWordWrap**

        By default, **QPainter**  draws text anti-aliased.

        **Note:** The y-position is used as the top of the font.

        **See also** **Qt::AlignmentFlag** , **Qt::TextFlag** , **setFont** (),
        and **setPen** ().
        """
        ...

    @typing.overload
    def drawText(
        self, x: int, y: int, width: int, height: int, flags: int, text: str
    ) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawText-5

        **void QPainter::drawText(const QRectF & rectangle , const QString &
        text , const QTextOption & option = QTextOption())**

        This is an overloaded function.

        Draws the given **text** in the **rectangle** specified using the
        **option** to control its positioning, direction, and orientation. The
        options given in **option** override those set on the **QPainter**
        object itself.

        By default, **QPainter**  draws text anti-aliased.

        **Note:** The y-coordinate of **rectangle** is used as the top of the
        font.

        **See also** **setFont** () and **setPen** ().
        """
        ...

    @typing.overload
    def drawText(self, x: int, y: int, s: str) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawText

        **void QPainter::drawText(const QPointF & position , const QString &
        text )**

        Draws the given **text** with the currently defined text direction,
        beginning at the given **position**.

        This function does not handle the newline character (\\n), as it cannot
        break text into multiple lines, and it cannot display the newline
        character. Use the QPainter::drawText() overload that takes a rectangle
        instead if you want to draw multiple lines of text with the newline
        character, or if you want the text to be wrapped.

        By default, **QPainter**  draws text anti-aliased.

        **Note:** The y-position is used as the baseline of the font.

        **See also** **setFont** () and **setPen** ().
        """
        ...

    def layoutDirection(self) -> QtCore.Qt.LayoutDirection:
        """
        https://doc.qt.io/qt-6/qpainter.html#layoutDirection

        **Qt::LayoutDirection QPainter::layoutDirection() const**

        Returns the layout direction used by the painter when drawing text.

        **See also** **QTextOption::textDirection** (), **setLayoutDirection**
        (), **drawText** (), and **Settings** .
        """
        ...

    def setLayoutDirection(self, direction: QtCore.Qt.LayoutDirection) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#setLayoutDirection

        **void QPainter::setLayoutDirection(Qt::LayoutDirection direction )**

        Sets the layout direction used by the painter when drawing text, to the
        specified **direction**.

        The default is **Qt::LayoutDirectionAuto** , which will implicitly
        determine the direction from the text drawn.

        **See also** **QTextOption::setTextDirection** (), **layoutDirection**
        (), **drawText** (), and **Settings** .
        """
        ...

    @typing.overload
    def drawPixmap(
        self, targetRect: QtCore.QRectF, pixmap: QPixmap, sourceRect: QtCore.QRectF
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPixmap

        **void QPainter::drawPixmap(const QRectF & target , const QPixmap &
        pixmap , const QRectF & source )**

        Draws the rectangular portion **source** of the given **pixmap** into
        the given **target** in the paint device.

        **Note:** The pixmap is scaled to fit the rectangle, if both the pixmap
        and rectangle size disagree.

        **Note:** See **Drawing High Resolution Versions of Pixmaps and Images**
        on how this is affected by **QPixmap::devicePixelRatio** ().

        **QRectF**  target(10.0, 20.0, 80.0, 60.0);
            **QRectF**  source(0.0,
        0.0, 70.0, 40.0);
            **QPixmap**  pixmap(":myPixmap.png");
        **QPainter** (this);
            painter.drawPixmap(target, pixmap, source);

        If **pixmap** is a **QBitmap**  it is drawn with the bits that are "set"
        using the pens color. If **backgroundMode**  is **Qt::OpaqueMode** , the
        "unset" bits are drawn using the color of the background brush; if
        **backgroundMode**  is **Qt::TransparentMode** , the "unset" bits are
        transparent. Drawing bitmaps with gradient or texture colors is not
        supported.

        **See also** **drawImage** () and **QPixmap::devicePixelRatio** ().
        """
        ...

    @typing.overload
    def drawPixmap(
        self, targetRect: QtCore.QRect, pixmap: QPixmap, sourceRect: QtCore.QRect
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPixmap-1

        **void QPainter::drawPixmap(const QRect & target , const QPixmap &
        pixmap , const QRect & source )**

        This is an overloaded function.

        Draws the rectangular portion **source** of the given **pixmap** into
        the given **target** in the paint device.

        **Note:** The pixmap is scaled to fit the rectangle, if both the pixmap
        and rectangle size disagree.
        """
        ...

    @typing.overload
    def drawPixmap(self, p: QtCore.QPointF, pm: QPixmap) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPixmap-2

        **void QPainter::drawPixmap(int x , int y , int w , int h , const
        QPixmap & pixmap , int sx , int sy , int sw , int sh )**

        This is an overloaded function.

        Draws the rectangular portion with the origin ( **sx** , **sy** ), width
        **sw** and height **sh** , of the given **pixmap** , at the point (
        **x** , **y** ), with a width of **w** and a height of **h**. If sw or
        sh are equal to zero the width/height of the pixmap is used and adjusted
        by the offset sx/sy;
        """
        ...

    @typing.overload
    def drawPixmap(self, p: QtCore.QPoint, pm: QPixmap) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPixmap-3

        **void QPainter::drawPixmap(int x , int y , const QPixmap & pixmap , int
        sx , int sy , int sw , int sh )**

        This is an overloaded function.

        Draws a pixmap at ( **x** , **y** ) by copying a part of the given
        **pixmap** into the paint device.

        ( **x** , **y** ) specifies the top-left point in the paint device that
        is to be drawn onto. ( **sx** , **sy** ) specifies the top-left point in
        **pixmap** that is to be drawn. The default is (0, 0).

        ( **sw** , **sh** ) specifies the size of the pixmap that is to be
        drawn. The default, (0, 0) (and negative) means all the way to the
        bottom-right of the pixmap.
        """
        ...

    @typing.overload
    def drawPixmap(self, r: QtCore.QRect, pm: QPixmap) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPixmap-4

        **void QPainter::drawPixmap(const QPointF & point , const QPixmap &
        pixmap , const QRectF & source )**

        This is an overloaded function.

        Draws the rectangular portion **source** of the given **pixmap** with
        its origin at the given **point**.
        """
        ...

    @typing.overload
    def drawPixmap(self, x: int, y: int, pm: QPixmap) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPixmap-5

        **void QPainter::drawPixmap(const QPoint & point , const QPixmap &
        pixmap , const QRect & source )**

        This is an overloaded function.

        Draws the rectangular portion **source** of the given **pixmap** with
        its origin at the given **point**.
        """
        ...

    @typing.overload
    def drawPixmap(self, x: int, y: int, w: int, h: int, pm: QPixmap) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPixmap-6

        **void QPainter::drawPixmap(const QPointF & point , const QPixmap &
        pixmap )**

        This is an overloaded function.

        Draws the given **pixmap** with its origin at the given **point**.
        """
        ...

    @typing.overload
    def drawPixmap(
        self,
        x: int,
        y: int,
        w: int,
        h: int,
        pm: QPixmap,
        sx: int,
        sy: int,
        sw: int,
        sh: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPixmap-7

        **void QPainter::drawPixmap(const QPoint & point , const QPixmap &
        pixmap )**

        This is an overloaded function.

        Draws the given **pixmap** with its origin at the given **point**.
        """
        ...

    @typing.overload
    def drawPixmap(
        self, x: int, y: int, pm: QPixmap, sx: int, sy: int, sw: int, sh: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPixmap-8

        **void QPainter::drawPixmap(int x , int y , const QPixmap & pixmap )**

        This is an overloaded function.

        Draws the given **pixmap** at position ( **x** , **y** ).
        """
        ...

    @typing.overload
    def drawPixmap(self, p: QtCore.QPointF, pm: QPixmap, sr: QtCore.QRectF) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPixmap-9

        **void QPainter::drawPixmap(const QRect & rectangle , const QPixmap &
        pixmap )**

        This is an overloaded function.

        Draws the given **pixmap** into the given **rectangle**.

        **Note:** The pixmap is scaled to fit the rectangle, if both the pixmap
        and rectangle size disagree.
        """
        ...

    @typing.overload
    def drawPixmap(self, p: QtCore.QPoint, pm: QPixmap, sr: QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPixmap-10

        **void QPainter::drawPixmap(int x , int y , int width , int height ,
        const QPixmap & pixmap )**

        This is an overloaded function.

        Draws the **pixmap** into the rectangle at position ( **x** , **y** )
        with the given **width** and **height**.
        """
        ...

    @typing.overload
    def drawPicture(self, p: QtCore.QPointF, picture: "QPicture") -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPicture

        **void QPainter::drawPicture(const QPointF & point , const QPicture &
        picture )**

        Replays the given **picture** at the given **point**.

        The **QPicture**  class is a paint device that records and replays
        **QPainter**  commands. A picture serializes the painter commands to an
        IO device in a platform-independent format. Everything that can be
        painted on a widget or pixmap can also be stored in a picture.

        This function does exactly the same as **QPicture::play** () when called
        with **point** = **QPointF** (0, 0).

        **Note:** The state of the painter is preserved by this function.

        **QPicture**  picture;
            **QPointF**  point(10.0, 20.0);
        picture.load("drawing.pic");

            **QPainter**  painter(this);
        painter.drawPicture(0, 0, picture);

        **See also** **QPicture::play** ().
        """
        ...

    @typing.overload
    def drawPicture(self, x: int, y: int, p: "QPicture") -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPicture-1

        **void QPainter::drawPicture(int x , int y , const QPicture & picture
        )**

        This is an overloaded function.

        Draws the given **picture** at point ( **x** , **y** ).
        """
        ...

    @typing.overload
    def drawPicture(self, pt: QtCore.QPoint, p: "QPicture") -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPicture-2

        **void QPainter::drawPicture(const QPoint & point , const QPicture &
        picture )**

        This is an overloaded function.

        Replays the given **picture** at the given **point**.
        """
        ...

    @typing.overload
    def drawTiledPixmap(
        self, rectangle: QtCore.QRectF, pixmap: QPixmap, pos: QtCore.QPointF = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawTiledPixmap

        **void QPainter::drawTiledPixmap(const QRectF & rectangle , const
        QPixmap & pixmap , const QPointF & position = QPointF())**

        Draws a tiled **pixmap** , inside the given **rectangle** with its
        origin at the given **position**.

        Calling drawTiledPixmap() is similar to calling **drawPixmap** ()
        several times to fill (tile) an area with a pixmap, but is potentially
        much more efficient depending on the underlying window system.

        drawTiledPixmap() will produce the same visual tiling pattern on high-
        dpi displays (with devicePixelRatio > 1), compared to normal- dpi
        displays. Set the devicePixelRatio on the **pixmap** to control the tile
        size. For example, setting it to 2 halves the tile width and height (on
        both 1x and 2x displays), and produces high-resolution output on 2x
        displays.

        The **position** offset is always in the painter coordinate system,
        indepentent of display devicePixelRatio.

        **See also** **drawPixmap** ().
        """
        ...

    @typing.overload
    def drawTiledPixmap(
        self, rectangle: QtCore.QRect, pixmap: QPixmap, pos: QtCore.QPoint = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawTiledPixmap-1

        **void QPainter::drawTiledPixmap(int x , int y , int width , int height
        , const QPixmap & pixmap , int sx = 0, int sy = 0)**

        This is an overloaded function.

        Draws a tiled **pixmap** in the specified rectangle.

        ( **x** , **y** ) specifies the top-left point in the paint device that
        is to be drawn onto; with the given **width** and **height**. ( **sx** ,
        **sy** ) specifies the top-left point in the **pixmap** that is to be
        drawn; this defaults to (0, 0).
        """
        ...

    @typing.overload
    def drawTiledPixmap(
        self,
        x: int,
        y: int,
        width: int,
        height: int,
        pixmap: QPixmap,
        sx: int = ...,
        sy: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawTiledPixmap-2

        **void QPainter::drawTiledPixmap(const QRect & rectangle , const QPixmap
        & pixmap , const QPoint & position = QPoint())**

        This is an overloaded function.

        Draws a tiled **pixmap** , inside the given **rectangle** with its
        origin at the given **position**.
        """
        ...

    @typing.overload
    def drawChord(self, rect: QtCore.QRectF, a: int, alen: int) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawChord

        **void QPainter::drawChord(const QRectF & rectangle , int startAngle ,
        int spanAngle )**

        Draws the chord defined by the given **rectangle** , **startAngle** and
        **spanAngle**. The chord is filled with the current **brush** ().

        The startAngle and spanAngle must be specified in 1/16th of a degree,
        i.e. a full circle equals 5760 (16 * 360). Positive values for the
        angles mean counter-clockwise while negative values mean the clockwise
        direction. Zero degrees is at the 3 o'clock position.

        ![](images/qpainter-chord.png)



            **QRectF**
        rectangle(10.0, 20.0, 80.0, 60.0);
            int startAngle = 30 * 16;
            int
        spanAngle = 120 * 16;

            **QPainter**  painter(this);
        painter.drawChord(rect, startAngle, spanAngle);

        **See also** **drawArc** (), **drawPie** (), and **Coordinate System** .
        """
        ...

    @typing.overload
    def drawChord(self, rect: QtCore.QRect, a: int, alen: int) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawChord-1

        **void QPainter::drawChord(int x , int y , int width , int height , int
        startAngle , int spanAngle )**

        This is an overloaded function.

        Draws the chord defined by the rectangle beginning at ( **x** , **y** )
        with the specified **width** and **height** , and the given
        **startAngle** and **spanAngle**.
        """
        ...

    @typing.overload
    def drawChord(self, x: int, y: int, w: int, h: int, a: int, alen: int) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawChord-2

        **void QPainter::drawChord(const QRect & rectangle , int startAngle ,
        int spanAngle )**

        This is an overloaded function.

        Draws the chord defined by the given **rectangle** , **startAngle** and
        **spanAngle**.
        """
        ...

    @typing.overload
    def drawPie(self, rect: QtCore.QRectF, a: int, alen: int) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPie

        **void QPainter::drawPie(const QRectF & rectangle , int startAngle , int
        spanAngle )**

        Draws a pie defined by the given **rectangle** , **startAngle** and
        **spanAngle**.

        The pie is filled with the current **brush** ().

        The startAngle and spanAngle must be specified in 1/16th of a degree,
        i.e. a full circle equals 5760 (16 * 360). Positive values for the
        angles mean counter-clockwise while negative values mean the clockwise
        direction. Zero degrees is at the 3 o'clock position.

        ![](images/qpainter-pie.png)



            **QRectF**  rectangle(10.0,
        20.0, 80.0, 60.0);
            int startAngle = 30 * 16;
            int spanAngle = 120
        * 16;

            **QPainter**  painter(this);
        painter.drawPie(rectangle, startAngle, spanAngle);

        **See also** **drawEllipse** (), **drawChord** (), and **Coordinate
        System** .
        """
        ...

    @typing.overload
    def drawPie(self, rect: QtCore.QRect, a: int, alen: int) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPie-1

        **void QPainter::drawPie(int x , int y , int width , int height , int
        startAngle , int spanAngle )**

        This is an overloaded function.

        Draws the pie defined by the rectangle beginning at ( **x** , **y** )
        with the specified **width** and **height** , and the given
        **startAngle** and **spanAngle**.
        """
        ...

    @typing.overload
    def drawPie(self, x: int, y: int, w: int, h: int, a: int, alen: int) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPie-2

        **void QPainter::drawPie(const QRect & rectangle , int startAngle , int
        spanAngle )**

        This is an overloaded function.

        Draws a pie defined by the given **rectangle** , **startAngle** and and
        **spanAngle**.
        """
        ...

    @typing.overload
    def drawArc(self, rect: QtCore.QRectF, a: int, alen: int) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawArc

        **void QPainter::drawArc(const QRectF & rectangle , int startAngle , int
        spanAngle )**

        Draws the arc defined by the given **rectangle** , **startAngle** and
        **spanAngle**.

        The **startAngle** and **spanAngle** must be specified in 1/16th of a
        degree, i.e. a full circle equals 5760 (16 * 360). Positive values for
        the angles mean counter-clockwise while negative values mean the
        clockwise direction. Zero degrees is at the 3 o'clock position.

        ![](images/qpainter-arc.png)



            **QRectF**  rectangle(10.0,
        20.0, 80.0, 60.0);
            int startAngle = 30 * 16;
            int spanAngle = 120
        * 16;

            **QPainter**  painter(this);
        painter.drawArc(rectangle, startAngle, spanAngle);

        **See also** **drawPie** (), **drawChord** (), and **Coordinate System**
        .
        """
        ...

    @typing.overload
    def drawArc(self, r: QtCore.QRect, a: int, alen: int) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawArc-1

        **void QPainter::drawArc(const QRect & rectangle , int startAngle , int
        spanAngle )**

        This is an overloaded function.

        Draws the arc defined by the given **rectangle** , **startAngle** and
        **spanAngle**.
        """
        ...

    @typing.overload
    def drawArc(self, x: int, y: int, w: int, h: int, a: int, alen: int) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawArc-2

        **void QPainter::drawArc(int x , int y , int width , int height , int
        startAngle , int spanAngle )**

        This is an overloaded function.

        Draws the arc defined by the rectangle beginning at ( **x** , **y** )
        with the specified **width** and **height** , and the given
        **startAngle** and **spanAngle**.
        """
        ...

    @typing.overload
    def drawConvexPolygon(self, point: QtCore.QPointF, *a1) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawConvexPolygon

        **void QPainter::drawConvexPolygon(const QPointF * points , int
        pointCount )**

        Draws the convex polygon defined by the first **pointCount** points in
        the array **points** using the current pen.

        ![](images/qpainter-polygon.png)



            static const **QPointF**
        points[4] = {
                **QPointF** (10.0, 80.0),
                **QPointF**
        (20.0, 10.0),
                **QPointF** (80.0, 30.0),
                **QPointF**
        (90.0, 70.0)
            };

            **QPainter**  painter(this);
        painter.drawConvexPolygon(points, 4);

        The first point is implicitly connected to the last point, and the
        polygon is filled with the current **brush** (). If the supplied polygon
        is not convex, i.e. it contains at least one angle larger than 180
        degrees, the results are undefined.

        On some platforms (e.g. X11), the drawConvexPolygon() function can be
        faster than the **drawPolygon** () function.

        **See also** **drawPolygon** (), **drawPolyline** (), and **Coordinate
        System** .
        """
        ...

    @typing.overload
    def drawConvexPolygon(self, poly: "QPolygonF") -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawConvexPolygon-1

        **void QPainter::drawConvexPolygon(const QPolygonF & polygon )**

        This is an overloaded function.

        Draws the convex polygon defined by **polygon** using the current pen
        and brush.
        """
        ...

    @typing.overload
    def drawConvexPolygon(self, point: QtCore.QPoint, *a1) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawConvexPolygon-2

        **void QPainter::drawConvexPolygon(const QPoint * points , int
        pointCount )**

        This is an overloaded function.

        Draws the convex polygon defined by the first **pointCount** points in
        the array **points** using the current pen.
        """
        ...

    @typing.overload
    def drawConvexPolygon(self, poly: "QPolygon") -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawConvexPolygon-3

        **void QPainter::drawConvexPolygon(const QPolygon & polygon )**

        This is an overloaded function.

        Draws the convex polygon defined by **polygon** using the current pen
        and brush.
        """
        ...

    @typing.overload
    def drawPolygon(self, point: QtCore.QPointF, *a1) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPolygon

        **void QPainter::drawPolygon(const QPointF * points , int pointCount ,
        Qt::FillRule fillRule = Qt::OddEvenFill)**

        Draws the polygon defined by the first **pointCount** points in the
        array **points** using the current pen and brush.

        ![](images/qpainter-polygon.png)



            static const **QPointF**
        points[4] = {
                **QPointF** (10.0, 80.0),
                **QPointF**
        (20.0, 10.0),
                **QPointF** (80.0, 30.0),
                **QPointF**
        (90.0, 70.0)
            };

            **QPainter**  painter(this);
        painter.drawPolygon(points, 4);

        The first point is implicitly connected to the last point, and the
        polygon is filled with the current **brush** ().

        If **fillRule** is **Qt::WindingFill** , the polygon is filled using the
        winding fill algorithm. If **fillRule** is **Qt::OddEvenFill** , the
        polygon is filled using the odd-even fill algorithm. See
        **Qt::FillRule**  for a more detailed description of these fill rules.

        **See also** **drawConvexPolygon** (), **drawPolyline** (), and
        **Coordinate System** .
        """
        ...

    @typing.overload
    def drawPolygon(
        self, points: "QPolygonF", fillRule: QtCore.Qt.FillRule = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPolygon-1

        **void QPainter::drawPolygon(const QPolygonF & points , Qt::FillRule
        fillRule = Qt::OddEvenFill)**

        This is an overloaded function.

        Draws the polygon defined by the given **points** using the fill rule
        **fillRule**.
        """
        ...

    @typing.overload
    def drawPolygon(self, point: QtCore.QPoint, *a1) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPolygon-2

        **void QPainter::drawPolygon(const QPoint * points , int pointCount ,
        Qt::FillRule fillRule = Qt::OddEvenFill)**

        This is an overloaded function.

        Draws the polygon defined by the first **pointCount** points in the
        array **points**.
        """
        ...

    @typing.overload
    def drawPolygon(
        self, points: "QPolygon", fillRule: QtCore.Qt.FillRule = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPolygon-3

        **void QPainter::drawPolygon(const QPolygon & points , Qt::FillRule
        fillRule = Qt::OddEvenFill)**

        This is an overloaded function.

        Draws the polygon defined by the given **points** using the fill rule
        **fillRule**.
        """
        ...

    @typing.overload
    def drawPolyline(self, point: QtCore.QPointF, *a1) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPolyline

        **void QPainter::drawPolyline(const QPointF * points , int pointCount
        )**

        Draws the polyline defined by the first **pointCount** points in
        **points** using the current pen.

        Note that unlike the **drawPolygon** () function the last point is
        **not** connected to the first, neither is the polyline filled.

        static const **QPointF**  points[3] = {
                **QPointF** (10.0,
        80.0),
                **QPointF** (20.0, 10.0),
                **QPointF** (80.0,
        30.0),
            };

            **QPainter**  painter(this);
        painter.drawPolyline(points, 3);

        **See also** **drawLines** (), **drawPolygon** (), and **Coordinate
        System** .
        """
        ...

    @typing.overload
    def drawPolyline(self, polyline: "QPolygonF") -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPolyline-1

        **void QPainter::drawPolyline(const QPolygonF & points )**

        This is an overloaded function.

        Draws the polyline defined by the given **points** using the current
        pen.
        """
        ...

    @typing.overload
    def drawPolyline(self, point: QtCore.QPoint, *a1) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPolyline-2

        **void QPainter::drawPolyline(const QPoint * points , int pointCount )**

        This is an overloaded function.

        Draws the polyline defined by the first **pointCount** points in
        **points** using the current pen.
        """
        ...

    @typing.overload
    def drawPolyline(self, polyline: "QPolygon") -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPolyline-3

        **void QPainter::drawPolyline(const QPolygon & points )**

        This is an overloaded function.

        Draws the polyline defined by the given **points** using the current
        pen.
        """
        ...

    @typing.overload
    def drawEllipse(self, r: QtCore.QRectF) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawEllipse

        **void QPainter::drawEllipse(const QRectF & rectangle )**

        Draws the ellipse defined by the given **rectangle**.

        A filled ellipse has a size of **rectangle**.**size** (). A stroked
        ellipse has a size of **rectangle**.**size** () plus the pen width.

        ![](images/qpainter-ellipse.png)



            **QRectF**
        rectangle(10.0, 20.0, 80.0, 60.0);

            **QPainter**  painter(this);
        painter.drawEllipse(rectangle);

        **See also** **drawPie** () and **Coordinate System** .
        """
        ...

    @typing.overload
    def drawEllipse(self, r: QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawEllipse-1

        **void QPainter::drawEllipse(const QRect & rectangle )**

        This is an overloaded function.

        Draws the ellipse defined by the given **rectangle**.
        """
        ...

    @typing.overload
    def drawEllipse(self, x: int, y: int, w: int, h: int) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawEllipse-2

        **void QPainter::drawEllipse(int x , int y , int width , int height )**

        This is an overloaded function.

        Draws the ellipse defined by the rectangle beginning at ( **x** , **y**
        ) with the given **width** and **height**.
        """
        ...

    @typing.overload
    def drawEllipse(self, center: QtCore.QPointF, rx: float, ry: float) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawEllipse-3

        **void QPainter::drawEllipse(const QPointF & center , qreal rx , qreal
        ry )**

        This is an overloaded function.

        Draws the ellipse positioned at **center** with radii **rx** and **ry**.
        """
        ...

    @typing.overload
    def drawEllipse(self, center: QtCore.QPoint, rx: int, ry: int) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawEllipse-4

        **void QPainter::drawEllipse(const QPoint & center , int rx , int ry )**

        This is an overloaded function.

        Draws the ellipse positioned at **center** with radii **rx** and **ry**.
        """
        ...

    @typing.overload
    def drawRects(self, rect: QtCore.QRectF, *a1) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawRects

        **void QPainter::drawRects(const QRectF * rectangles , int rectCount )**

        Draws the first **rectCount** of the given **rectangles** using the
        current pen and brush.

        **See also** **drawRect** ().
        """
        ...

    @typing.overload
    def drawRects(self, rectangles: typing.Iterable[QtCore.QRectF]) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawRects-1

        **void QPainter::drawRects(const QList<QRectF> & rectangles )**

        This is an overloaded function.

        Draws the given **rectangles** using the current pen and brush.
        """
        ...

    @typing.overload
    def drawRects(self, rect: QtCore.QRect, *a1) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawRects-2

        **void QPainter::drawRects(const QRect * rectangles , int rectCount )**

        This is an overloaded function.

        Draws the first **rectCount** of the given **rectangles** using the
        current pen and brush.
        """
        ...

    @typing.overload
    def drawRects(self, rectangles: typing.Iterable[QtCore.QRect]) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawRects-3

        **void QPainter::drawRects(const QList<QRect> & rectangles )**

        This is an overloaded function.

        Draws the given **rectangles** using the current pen and brush.
        """
        ...

    @typing.overload
    def drawLines(self, line: QtCore.QLineF, *a1) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawLines

        **void QPainter::drawLines(const QLineF * lines , int lineCount )**

        Draws the first **lineCount** lines in the array **lines** using the
        current pen.

        **See also** **drawLine** () and **drawPolyline** ().
        """
        ...

    @typing.overload
    def drawLines(self, lines: typing.Iterable[QtCore.QLineF]) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawLines-1

        **void QPainter::drawLines(const QList<QLineF> & lines )**

        This is an overloaded function.

        Draws the set of lines defined by the list **lines** using the current
        pen and brush.
        """
        ...

    @typing.overload
    def drawLines(self, pointPair: QtCore.QPointF, *a1) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawLines-2

        **void QPainter::drawLines(const QPointF * pointPairs , int lineCount
        )**

        This is an overloaded function.

        Draws the first **lineCount** lines in the array **pointPairs** using
        the current pen. The lines are specified as pairs of points so the
        number of entries in **pointPairs** must be at least **lineCount** * 2.
        """
        ...

    @typing.overload
    def drawLines(self, pointPairs: typing.Iterable[QtCore.QPointF]) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawLines-3

        **void QPainter::drawLines(const QList<QPointF> & pointPairs )**

        This is an overloaded function.

        Draws a line for each pair of points in the vector **pointPairs** using
        the current pen. If there is an odd number of points in the array, the
        last point will be ignored.
        """
        ...

    @typing.overload
    def drawLines(self, line: QtCore.QLine, *a1) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawLines-4

        **void QPainter::drawLines(const QLine * lines , int lineCount )**

        This is an overloaded function.

        Draws the first **lineCount** lines in the array **lines** using the
        current pen.
        """
        ...

    @typing.overload
    def drawLines(self, lines: typing.Iterable[QtCore.QLine]) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawLines-5

        **void QPainter::drawLines(const QList<QLine> & lines )**

        This is an overloaded function.

        Draws the set of lines defined by the list **lines** using the current
        pen and brush.
        """
        ...

    @typing.overload
    def drawLines(self, pointPair: QtCore.QPoint, *a1) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawLines-6

        **void QPainter::drawLines(const QPoint * pointPairs , int lineCount )**

        This is an overloaded function.

        Draws the first **lineCount** lines in the array **pointPairs** using
        the current pen.
        """
        ...

    @typing.overload
    def drawLines(self, pointPairs: typing.Iterable[QtCore.QPoint]) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawLines-7

        **void QPainter::drawLines(const QList<QPoint> & pointPairs )**

        This is an overloaded function.

        Draws a line for each pair of points in the vector **pointPairs** using
        the current pen.
        """
        ...

    @typing.overload
    def drawPoints(self, point: QtCore.QPointF, *a1) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPoints

        **void QPainter::drawPoints(const QPointF * points , int pointCount )**

        Draws the first **pointCount** points in the array **points** using the
        current pen's color.

        **See also** **Coordinate System** .
        """
        ...

    @typing.overload
    def drawPoints(self, points: "QPolygonF") -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPoints-1

        **void QPainter::drawPoints(const QPolygonF & points )**

        This is an overloaded function.

        Draws the points in the vector **points**.
        """
        ...

    @typing.overload
    def drawPoints(self, point: QtCore.QPoint, *a1) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPoints-2

        **void QPainter::drawPoints(const QPoint * points , int pointCount )**

        This is an overloaded function.

        Draws the first **pointCount** points in the array **points** using the
        current pen's color.
        """
        ...

    @typing.overload
    def drawPoints(self, points: "QPolygon") -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPoints-3

        **void QPainter::drawPoints(const QPolygon & points )**

        This is an overloaded function.

        Draws the points in the vector **points**.
        """
        ...

    def drawPath(self, path: "QPainterPath") -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#drawPath

        **void QPainter::drawPath(const QPainterPath & path )**

        Draws the given painter **path** using the current pen for outline and
        the current brush for filling.

        ![](images/qpainter-path.png)



            **QPainterPath**  path;
        path.moveTo(20, 80);
            path.lineTo(20, 30);
            path.cubicTo(80, 0,
        50, 50, 80, 80);

            **QPainter**  painter(this);
        painter.drawPath(path);

        **See also** **the Painter Paths example**  and **the Vector Deformation
        example** .
        """
        ...

    def fillPath(
        self,
        path: "QPainterPath",
        brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, int, QGradient],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#fillPath

        **void QPainter::fillPath(const QPainterPath & path , const QBrush &
        brush )**

        Fills the given **path** using the given **brush**. The outline is not
        drawn.

        Alternatively, you can specify a **QColor**  instead of a **QBrush** ;
        the **QBrush**  constructor (taking a **QColor**  argument) will
        automatically create a solid pattern brush.

        **See also** **drawPath** ().
        """
        ...

    def strokePath(
        self,
        path: "QPainterPath",
        pen: typing.Union["QPen", QColor, QtCore.Qt.GlobalColor, int, QGradient],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#strokePath

        **void QPainter::strokePath(const QPainterPath & path , const QPen & pen
        )**

        Draws the outline (strokes) the path **path** with the pen specified by
        **pen**

        **See also** **fillPath** () and **Drawing** .
        """
        ...

    def viewTransformEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-6/qpainter.html#viewTransformEnabled

        **bool QPainter::viewTransformEnabled() const**

        Returns `true` if view transformation is enabled; otherwise returns
        false.

        **See also** **setViewTransformEnabled** () and **worldTransform** ().
        """
        ...

    def setViewTransformEnabled(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#setViewTransformEnabled

        **void QPainter::setViewTransformEnabled(bool enable )**

        Enables view transformations if **enable** is true, or disables view
        transformations if **enable** is false.

        **See also** **viewTransformEnabled** () and **Window-Viewport
        Conversion** .
        """
        ...

    @typing.overload
    def setViewport(self, viewport: QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#setViewport

        **void QPainter::setViewport(const QRect & rectangle )**

        Sets the painter's viewport rectangle to the given **rectangle** , and
        enables view transformations.

        The viewport rectangle is part of the view transformation. The viewport
        specifies the device coordinate system. Its sister, the **window** (),
        specifies the logical coordinate system.

        The default viewport rectangle is the same as the device's rectangle.

        **See also** **viewport** (), **viewTransformEnabled** (), and **Window-
        Viewport Conversion** .
        """
        ...

    @typing.overload
    def setViewport(self, x: int, y: int, w: int, h: int) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#setViewport-1

        **void QPainter::setViewport(int x , int y , int width , int height )**

        This is an overloaded function.

        Sets the painter's viewport rectangle to be the rectangle beginning at (
        **x** , **y** ) with the given **width** and **height**.
        """
        ...

    def viewport(self) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qpainter.html#viewport

        **QRect QPainter::viewport() const**

        Returns the viewport rectangle.

        **See also** **setViewport** () and **setViewTransformEnabled** ().
        """
        ...

    @typing.overload
    def setWindow(self, window: QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#setWindow

        **void QPainter::setWindow(const QRect & rectangle )**

        Sets the painter's window to the given **rectangle** , and enables view
        transformations.

        The window rectangle is part of the view transformation. The window
        specifies the logical coordinate system. Its sister, the **viewport**
        (), specifies the device coordinate system.

        The default window rectangle is the same as the device's rectangle.

        **See also** **window** (), **viewTransformEnabled** (), and **Window-
        Viewport Conversion** .
        """
        ...

    @typing.overload
    def setWindow(self, x: int, y: int, w: int, h: int) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#setWindow-1

        **void QPainter::setWindow(int x , int y , int width , int height )**

        This is an overloaded function.

        Sets the painter's window to the rectangle beginning at ( **x** , **y**
        ) and the given **width** and **height**.
        """
        ...

    def window(self) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qpainter.html#window

        **QRect QPainter::window() const**

        Returns the window rectangle.

        **See also** **setWindow** () and **setViewTransformEnabled** ().
        """
        ...

    @typing.overload
    def translate(self, offset: QtCore.QPointF) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#translate

        **void QPainter::translate(const QPointF & offset )**

        Translates the coordinate system by the given **offset** ; i.e. the
        given **offset** is added to points.

        **See also** **setWorldTransform** () and **Coordinate Transformations**
        .
        """
        ...

    @typing.overload
    def translate(self, dx: float, dy: float) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#translate-1

        **void QPainter::translate(const QPoint & offset )**

        This is an overloaded function.

        Translates the coordinate system by the given **offset**.
        """
        ...

    @typing.overload
    def translate(self, offset: QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#translate-2

        **void QPainter::translate(qreal dx , qreal dy )**

        This is an overloaded function.

        Translates the coordinate system by the vector ( **dx** , **dy** ).
        """
        ...

    def rotate(self, a: float) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#rotate

        **void QPainter::rotate(qreal angle )**

        Rotates the coordinate system clockwise. The given **angle** parameter
        is in degrees.

        **See also** **setWorldTransform** () and **Coordinate Transformations**
        .
        """
        ...

    def shear(self, sh: float, sv: float) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#shear

        **void QPainter::shear(qreal sh , qreal sv )**

        Shears the coordinate system by ( **sh** , **sv** ).

        **See also** **setWorldTransform** () and **Coordinate Transformations**
        .
        """
        ...

    def scale(self, sx: float, sy: float) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#scale

        **void QPainter::scale(qreal sx , qreal sy )**

        Scales the coordinate system by ( **sx** , **sy** ).

        **See also** **setWorldTransform** () and **Coordinate Transformations**
        .
        """
        ...

    def restore(self) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#restore

        **void QPainter::restore()**

        Restores the current painter state (pops a saved state off the stack).

        **See also** **save** ().
        """
        ...

    def save(self) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#save

        **void QPainter::save()**

        Saves the current painter state (pushes the state onto a stack). A
        save() must be followed by a corresponding **restore** (); the **end**
        () function unwinds the stack.

        **See also** **restore** ().
        """
        ...

    def hasClipping(self) -> bool:
        """
        https://doc.qt.io/qt-6/qpainter.html#hasClipping

        **bool QPainter::hasClipping() const**

        Returns `true` if clipping has been set; otherwise returns `false`.

        **See also** **setClipping** () and **Clipping** .
        """
        ...

    def setClipping(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#setClipping

        **void QPainter::setClipping(bool enable )**

        Enables clipping if **enable** is true, or disables clipping if
        **enable** is false.

        **See also** **hasClipping** () and **Clipping** .
        """
        ...

    def setClipPath(
        self, path: "QPainterPath", operation: QtCore.Qt.ClipOperation = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#setClipPath

        **void QPainter::setClipPath(const QPainterPath & path ,
        Qt::ClipOperation operation = Qt::ReplaceClip)**

        Enables clipping, and sets the clip path for the painter to the given
        **path** , with the clip **operation**.

        Note that the clip path is specified in logical (painter) coordinates.

        **See also** **clipPath** (), **clipRegion** (), and **Clipping** .
        """
        ...

    def setClipRegion(
        self, region: "QRegion", operation: QtCore.Qt.ClipOperation = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#setClipRegion

        **void QPainter::setClipRegion(const QRegion & region ,
        Qt::ClipOperation operation = Qt::ReplaceClip)**

        Sets the clip region to the given **region** using the specified clip
        **operation**. The default clip operation is to replace the current clip
        region.

        Note that the clip region is given in logical coordinates.

        **See also** **clipRegion** (), **setClipRect** (), and **Clipping** .
        """
        ...

    @typing.overload
    def setClipRect(
        self, rectangle: QtCore.QRectF, operation: QtCore.Qt.ClipOperation = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#setClipRect

        **void QPainter::setClipRect(const QRectF & rectangle ,
        Qt::ClipOperation operation = Qt::ReplaceClip)**

        Enables clipping, and sets the clip region to the given **rectangle**
        using the given clip **operation**. The default operation is to replace
        the current clip rectangle.

        Note that the clip rectangle is specified in logical (painter)
        coordinates.

        **See also** **clipRegion** (), **setClipping** (), and **Clipping** .
        """
        ...

    @typing.overload
    def setClipRect(
        self,
        x: int,
        y: int,
        width: int,
        height: int,
        operation: QtCore.Qt.ClipOperation = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#setClipRect-1

        **void QPainter::setClipRect(const QRect & rectangle , Qt::ClipOperation
        operation = Qt::ReplaceClip)**

        This is an overloaded function.

        Enables clipping, and sets the clip region to the given **rectangle**
        using the given clip **operation**.
        """
        ...

    @typing.overload
    def setClipRect(
        self, rectangle: QtCore.QRect, operation: QtCore.Qt.ClipOperation = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#setClipRect-2

        **void QPainter::setClipRect(int x , int y , int width , int height ,
        Qt::ClipOperation operation = Qt::ReplaceClip)**

        Enables clipping, and sets the clip region to the rectangle beginning at
        ( **x** , **y** ) with the given **width** and **height**.
        """
        ...

    def clipPath(self) -> "QPainterPath":
        """
        https://doc.qt.io/qt-6/qpainter.html#clipPath

        **QPainterPath QPainter::clipPath() const**

        Returns the current clip path in logical coordinates.

        **Warning:****QPainter**  does not store the combined clip explicitly as
        this is handled by the underlying **QPaintEngine** , so the path is
        recreated on demand and transformed to the current logical coordinate
        system. This is potentially an expensive operation.

        **See also** **setClipPath** (), **clipRegion** (), and **setClipping**
        ().
        """
        ...

    def clipRegion(self) -> "QRegion":
        """
        https://doc.qt.io/qt-6/qpainter.html#clipRegion

        **QRegion QPainter::clipRegion() const**

        Returns the currently set clip region. Note that the clip region is
        given in logical coordinates.

        **Warning:****QPainter**  does not store the combined clip explicitly as
        this is handled by the underlying **QPaintEngine** , so the path is
        recreated on demand and transformed to the current logical coordinate
        system. This is potentially an expensive operation.

        **See also** **setClipRegion** (), **clipPath** (), and **setClipping**
        ().
        """
        ...

    def background(self) -> QBrush:
        """
        https://doc.qt.io/qt-6/qpainter.html#background

        **const QBrush &QPainter::background() const**

        Returns the current background brush.

        **See also** **setBackground** () and **Settings** .
        """
        ...

    def setBackground(
        self, bg: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, int, QGradient]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#setBackground

        **void QPainter::setBackground(const QBrush & brush )**

        Sets the background brush of the painter to the given **brush**.

        The background brush is the brush that is filled in when drawing opaque
        text, stippled lines and bitmaps. The background brush has no effect in
        transparent background mode (which is the default).

        **See also** **background** (), **setBackgroundMode** (), and
        **Settings** .
        """
        ...

    @typing.overload
    def setBrushOrigin(self, a0: QtCore.QPointF) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#setBrushOrigin

        **void QPainter::setBrushOrigin(const QPointF & position )**

        Sets the brush origin to **position**.

        The brush origin specifies the (0, 0) coordinate of the painter's brush.

        Note that while the **brushOrigin** () was necessary to adopt the
        parent's background for a widget in Qt 3, this is no longer the case
        since the Qt 4 painter doesn't paint the background unless you
        explicitly tell it to do so by setting the widget's
        **autoFillBackground**  property to true.

        **See also** **brushOrigin** () and **Settings** .
        """
        ...

    @typing.overload
    def setBrushOrigin(self, x: int, y: int) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#setBrushOrigin-1

        **void QPainter::setBrushOrigin(int x , int y )**

        This is an overloaded function.

        Sets the brush's origin to point ( **x** , **y** ).
        """
        ...

    @typing.overload
    def setBrushOrigin(self, p: QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#setBrushOrigin-2

        **void QPainter::setBrushOrigin(const QPoint & position )**

        This is an overloaded function.

        Sets the brush's origin to the given **position**.
        """
        ...

    def brushOrigin(self) -> QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qpainter.html#brushOrigin

        **QPoint QPainter::brushOrigin() const**

        Returns the currently set brush origin.

        **See also** **setBrushOrigin** () and **Settings** .
        """
        ...

    def backgroundMode(self) -> QtCore.Qt.BGMode:
        """
        https://doc.qt.io/qt-6/qpainter.html#backgroundMode

        **Qt::BGMode QPainter::backgroundMode() const**

        Returns the current background mode.

        **See also** **setBackgroundMode** () and **Settings** .
        """
        ...

    def setBackgroundMode(self, mode: QtCore.Qt.BGMode) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#setBackgroundMode

        **void QPainter::setBackgroundMode(Qt::BGMode mode )**

        Sets the background mode of the painter to the given **mode**

        **Qt::TransparentMode**  (the default) draws stippled lines and text
        without setting the background pixels. **Qt::OpaqueMode**  fills these
        space with the current background color.

        Note that in order to draw a bitmap or pixmap transparently, you must
        use **QPixmap::setMask** ().

        **See also** **backgroundMode** (), **setBackground** (), and
        **Settings** .
        """
        ...

    def brush(self) -> QBrush:
        """
        https://doc.qt.io/qt-6/qpainter.html#brush

        **const QBrush &QPainter::brush() const**

        Returns the painter's current brush.

        **See also** **QPainter::setBrush** () and **Settings** .
        """
        ...

    @typing.overload
    def setBrush(
        self, brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, int, QGradient]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#setBrush

        **void QPainter::setBrush(const QBrush & brush )**

        Sets the painter's brush to the given **brush**.

        The painter's brush defines how shapes are filled.

        **See also** **brush** () and **Settings** .
        """
        ...

    @typing.overload
    def setBrush(self, style: QtCore.Qt.BrushStyle) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#setBrush-1

        **void QPainter::setBrush(Qt::BrushStyle style )**

        This is an overloaded function.

        Sets the painter's brush to black color and the specified **style**.
        """
        ...

    def pen(self) -> "QPen":
        """
        https://doc.qt.io/qt-6/qpainter.html#pen

        **const QPen &QPainter::pen() const**

        Returns the painter's current pen.

        **See also** **setPen** () and **Settings** .
        """
        ...

    @typing.overload
    def setPen(
        self, color: typing.Union[QColor, QtCore.Qt.GlobalColor, int, QGradient]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#setPen

        **void QPainter::setPen(const QPen & pen )**

        Sets the painter's pen to be the given **pen**.

        The **pen** defines how to draw lines and outlines, and it also defines
        the text color.

        **See also** **pen** () and **Settings** .
        """
        ...

    @typing.overload
    def setPen(
        self, pen: typing.Union["QPen", QColor, QtCore.Qt.GlobalColor, int, QGradient]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#setPen-1

        **void QPainter::setPen(const QColor & color )**

        This is an overloaded function.

        Sets the painter's pen to have style **Qt::SolidLine** , width 1 and the
        specified **color**.
        """
        ...

    @typing.overload
    def setPen(self, style: QtCore.Qt.PenStyle) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#setPen-2

        **void QPainter::setPen(Qt::PenStyle style )**

        This is an overloaded function.

        Sets the painter's pen to have the given **style** , width 1 and black
        color.
        """
        ...

    def fontInfo(self) -> QFontInfo:
        """
        https://doc.qt.io/qt-6/qpainter.html#fontInfo

        **QFontInfo QPainter::fontInfo() const**

        Returns the font info for the painter if the painter is active.
        Otherwise, the return value is undefined.

        **See also** **font** (), **isActive** (), and **Settings** .
        """
        ...

    def fontMetrics(self) -> QFontMetrics:
        """
        https://doc.qt.io/qt-6/qpainter.html#fontMetrics

        **QFontMetrics QPainter::fontMetrics() const**

        Returns the font metrics for the painter if the painter is active.
        Otherwise, the return value is undefined.

        **See also** **font** (), **isActive** (), and **Settings** .
        """
        ...

    def setFont(self, f: QFont) -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#setFont

        **void QPainter::setFont(const QFont & font )**

        Sets the painter's font to the given **font**.

        This font is used by subsequent **drawText** () functions. The text
        color is the same as the pen color.

        If you set a font that isn't available, Qt finds a close match. **font**
        () will return what you set using setFont() and **fontInfo** () returns
        the font actually being used (which may be the same).

        **See also** **font** (), **drawText** (), and **Settings** .
        """
        ...

    def font(self) -> QFont:
        """
        https://doc.qt.io/qt-6/qpainter.html#font

        **const QFont &QPainter::font() const**

        Returns the currently set font used for drawing text.

        **See also** **setFont** (), **drawText** (), and **Settings** .
        """
        ...

    def compositionMode(self) -> "QPainter.CompositionMode":
        """
        https://doc.qt.io/qt-6/qpainter.html#compositionMode

        **QPainter::CompositionMode QPainter::compositionMode() const**

        Returns the current composition mode.

        **See also** **CompositionMode**  and **setCompositionMode** ().
        """
        ...

    def setCompositionMode(self, mode: "QPainter.CompositionMode") -> None:
        """
        https://doc.qt.io/qt-6/qpainter.html#setCompositionMode

        **void QPainter::setCompositionMode(QPainter::CompositionMode mode )**

        Sets the composition mode to the given **mode**.

        **Warning:** Only a **QPainter**  operating on a **QImage**  fully
        supports all composition modes. The RasterOp modes are supported for X11
        as described in **compositionMode** ().

        **See also** **compositionMode** ().
        """
        ...

    def isActive(self) -> bool:
        """
        https://doc.qt.io/qt-6/qpainter.html#isActive

        **bool QPainter::isActive() const**

        Returns `true` if **begin** () has been called and **end** () has not
        yet been called; otherwise returns `false`.

        **See also** **begin** () and **QPaintDevice::paintingActive** ().
        """
        ...

    def end(self) -> bool:
        """
        https://doc.qt.io/qt-6/qpainter.html#end

        **bool QPainter::end()**

        Ends painting. Any resources used while painting are released. You don't
        normally need to call this since it is called by the destructor.

        Returns `true` if the painter is no longer active; otherwise returns
        `false`.

        **See also** **begin** () and **isActive** ().
        """
        ...

    def begin(self, a0: QPaintDevice) -> bool:
        """
        https://doc.qt.io/qt-6/qpainter.html#begin

        **bool QPainter::begin(QPaintDevice * device )**

        Begins painting the paint **device** and returns `true` if successful;
        otherwise returns `false`.

        Notice that all painter settings (**setPen** (), **setBrush** () etc.)
        are reset to default values when begin() is called.

        The errors that can occur are serious problems, such as these:

        painter->begin(0); // impossible - paint device cannot be 0
        **QPixmap**  image(0, 0);
            painter->begin(&image); // impossible -
        image.isNull() == true;

            painter->begin(myWidget);
        painter2->begin(myWidget); // impossible - only one painter at a time

        Note that most of the time, you can use one of the constructors instead
        of begin(), and that **end** () is automatically done at destruction.

        **Warning:** A paint device can only be painted by one painter at a
        time.

        **Warning:** Painting on a **QImage**  with the format
        **QImage::Format_Indexed8**  is not supported.

        **See also** **end** () and **QPainter** ().
        """
        ...

    def device(self) -> QPaintDevice:
        """
        https://doc.qt.io/qt-6/qpainter.html#device

        **QPaintDevice *QPainter::device() const**

        Returns the paint device on which this painter is currently painting, or
        `nullptr` if the painter is not active.

        **See also** **isActive** ().
        """
        ...

    def __exit__(
        self, type: typing.Any, value: typing.Any, traceback: typing.Any
    ) -> None:
        ...

    def __enter__(self) -> typing.Any:
        ...
