"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtGui import *


class QPen(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qpen.html

    **Detailed Description**

    A pen has a **style** (), **width** (), **brush** (), **capStyle** () and
    **joinStyle** ().

    The pen style defines the line type. The brush is used to fill strokes
    generated with the pen. Use the **QBrush**  class to specify fill styles.
    The cap style determines the line end caps that can be drawn using
    **QPainter** , while the join style describes how joins between two lines
    are drawn. The pen width can be specified in both integer (**width** ()) and
    floating point (**widthF** ()) precision. A line width of zero indicates a
    cosmetic pen. This means that the pen width is always drawn one pixel wide,
    independent of the **transformation**  set on the painter.

    The various settings can easily be modified using the corresponding
    **setStyle** (), **setWidth** (), **setBrush** (), **setCapStyle** () and
    **setJoinStyle** () functions (note that the painter's pen must be reset
    when altering the pen's properties).

    For example:

    **QPainter**  painter(this);
        **QPen**  pen(Qt::green, 3,
    Qt::DashDotLine, Qt::RoundCap, Qt::RoundJoin);
        painter.setPen(pen);

    which is equivalent to

    **QPainter**  painter(this);
        **QPen**  pen;  // creates a default pen
    pen.setStyle(Qt::DashDotLine);
        pen.setWidth(3);
    pen.setBrush(Qt::green);
        pen.setCapStyle(Qt::RoundCap);
    pen.setJoinStyle(Qt::RoundJoin);

        painter.setPen(pen);

    The default pen is a solid black brush with 1 width, square cap style
    (**Qt::SquareCap** ), and bevel join style (**Qt::BevelJoin** ).

    In addition QPen provides the **color** () and **setColor** () convenience
    functions to extract and set the color of the pen's brush, respectively.
    Pens may also be compared and streamed.

    For more information about painting in general, see the **Paint System**
    documentation.

    **Pen Style**

    Qt provides several built-in styles represented by the **Qt::PenStyle**
    enum:

    ![](images/qpen-solid.png)![](images/qpen-dash.png)![](images/qpen-dot.png)
    **Qt::SolidLine** **Qt::DashLine** **Qt::DotLine**
    ![](images/qpen-
    dashdot.png)![](images/qpen-dashdotdot.png)![](images/qpen-custom.png)
    **Qt::DashDotLine** **Qt::DashDotDotLine** **Qt::CustomDashLine**

    Simply use the **setStyle** () function to convert the pen style to either
    of the built-in styles, except the **Qt::CustomDashLine**  style which we
    will come back to shortly. Setting the style to **Qt::NoPen**  tells the
    painter to not draw lines or outlines. The default pen style is
    **Qt::SolidLine** .

    Since Qt 4.1 it is also possible to specify a custom dash pattern using the
    **setDashPattern** () function which implicitly converts the style of the
    pen to **Qt::CustomDashLine** . The pattern argument, a **QList** , must be
    specified as an even number of **qreal**  entries where the entries 1, 3,
    5... are the dashes and 2, 4, 6... are the spaces. For example, the custom
    pattern shown above is created using the following code:

    **QPen**  pen;
        **QList** <**qreal** > dashes;
        **qreal**  space = 4;
    dashes << 1 << space << 3 << space << 9 << space
                   << 27 <<
    space << 9 << space;

        pen.setDashPattern(dashes);

    Note that the dash pattern is specified in units of the pens width, e.g. a
    dash of length 5 in width 10 is 50 pixels long.

    The currently set dash pattern can be retrieved using the **dashPattern** ()
    function. Use the **isSolid** () function to determine whether the pen has a
    solid fill, or not.

    **Cap Style**

    The cap style defines how the end points of lines are drawn using
    **QPainter** . The cap style only apply to wide lines, i.e. when the width
    is 1 or greater. The **Qt::PenCapStyle**  enum provides the following
    styles:

    ![](images/qpen-square.png)![](images/qpen-flat.png)![](images/qpen-
    roundcap.png)
    **Qt::SquareCap** **Qt::FlatCap** **Qt::RoundCap**

    The **Qt::SquareCap**  style is a square line end that covers the end point
    and extends beyond it by half the line width. The **Qt::FlatCap**  style is
    a square line end that does not cover the end point of the line. And the
    **Qt::RoundCap**  style is a rounded line end covering the end point.

    The default is **Qt::SquareCap** .

    Whether or not end points are drawn when the pen width is 0 or 1 depends on
    the cap style. Using **Qt::SquareCap**  or **Qt::RoundCap**  they are drawn,
    using **Qt::FlatCap**  they are not drawn.

    **Join Style**

    The join style defines how joins between two connected lines can be drawn
    using **QPainter** . The join style only apply to wide lines, i.e. when the
    width is 1 or greater. The **Qt::PenJoinStyle**  enum provides the following
    styles:

    ![](images/qpen-bevel.png)![](images/qpen-miter.png)![](images/qpen-
    roundjoin.png)
    **Qt::BevelJoin** **Qt::MiterJoin** **Qt::RoundJoin**

    The **Qt::BevelJoin**  style fills the triangular notch between the two
    lines. The **Qt::MiterJoin**  style extends the lines to meet at an angle.
    And the **Qt::RoundJoin**  style fills a circular arc between the two lines.

    The default is **Qt::BevelJoin** .

    ![](images/qpen-miterlimit.png)

    When the **Qt::MiterJoin**  style is applied, it is possible to use the
    **setMiterLimit** () function to specify how far the miter join can extend
    from the join point. The **miterLimit** () is used to reduce artifacts
    between line joins where the lines are close to parallel.

    The **miterLimit** () must be specified in units of the pens width, e.g. a
    miter limit of 5 in width 10 is 50 pixels long. The default miter limit is
    2, i.e. twice the pen width in pixels.

    ![](images/qpen-demo.png)****The Path Stroking Example** **

    The Path
    Stroking example shows Qt's built-in dash patterns and shows how custom
    patterns can be used to extend the range of available patterns.

    **See also** **QPainter** , **QBrush** , **Path Stroking Example** , and
    **Scribble Example** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qpen.html#QPen

        **QPen::QPen()**

        Constructs a default black solid line pen with 1 width.
        """
        ...

    @typing.overload
    def __init__(self, a0: QtCore.Qt.PenStyle) -> None:
        """
        https://doc.qt.io/qt-6/qpen.html#QPen-1

        **QPen::QPen(Qt::PenStyle style )**

        Constructs a black pen with 1 width and the given **style**.

        **See also** **setStyle** ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, int, QGradient],
        width: float,
        style: QtCore.Qt.PenStyle = ...,
        cap: QtCore.Qt.PenCapStyle = ...,
        join: QtCore.Qt.PenJoinStyle = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpen.html#QPen-2

        **QPen::QPen(const QColor & color )**

        Constructs a solid line pen with 1 width and the given **color**.

        **See also** **setBrush** () and **setColor** ().
        """
        ...

    @typing.overload
    def __init__(
        self, pen: typing.Union["QPen", QColor, QtCore.Qt.GlobalColor, int, QGradient]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpen.html#QPen-3

        **QPen::QPen(const QBrush & brush , qreal width , Qt::PenStyle style =
        Qt::SolidLine, Qt::PenCapStyle cap = Qt::SquareCap, Qt::PenJoinStyle
        join = Qt::BevelJoin)**

        Constructs a pen with the specified **brush** , **width** , pen
        **style** , **cap** style and **join** style.

        **See also** **setBrush** (), **setWidth** (), **setStyle** (),
        **setCapStyle** (), and **setJoinStyle** ().
        """
        ...

    @typing.overload
    def __init__(self, variant: typing.Any) -> None:
        """
        https://doc.qt.io/qt-6/qpen.html#QPen-4

        **QPen::QPen(const QPen & pen )**

        Constructs a pen that is a copy of the given **pen**.
        """
        ...

    def swap(self, other: "QPen") -> None:
        """
        https://doc.qt.io/qt-6/qpen.html#swap

        **void QPen::swap(QPen & other )**

        Swaps pen **other** with this pen. This operation is very fast and never
        fails.
        """
        ...

    def setCosmetic(self, cosmetic: bool) -> None:
        """
        https://doc.qt.io/qt-6/qpen.html#setCosmetic

        **void QPen::setCosmetic(bool cosmetic )**

        Sets this pen to cosmetic or non-cosmetic, depending on the value of
        **cosmetic**.

        **See also** **isCosmetic** ().
        """
        ...

    def isCosmetic(self) -> bool:
        """
        https://doc.qt.io/qt-6/qpen.html#isCosmetic

        **bool QPen::isCosmetic() const**

        Returns `true` if the pen is cosmetic; otherwise returns `false`.

        Cosmetic pens are used to draw strokes that have a constant width
        regardless of any transformations applied to the **QPainter**  they are
        used with. Drawing a shape with a cosmetic pen ensures that its outline
        will have the same thickness at different scale factors.

        A zero width pen is cosmetic by default.

        **See also** **setCosmetic** () and **widthF** ().
        """
        ...

    def setDashOffset(self, doffset: float) -> None:
        """
        https://doc.qt.io/qt-6/qpen.html#setDashOffset

        **void QPen::setDashOffset(qreal offset )**

        Sets the dash offset (the starting point on the dash pattern) for this
        pen to the **offset** specified. The offset is measured in terms of the
        units used to specify the dash pattern.

        ![](images/qpen-dashpattern.png)For example, a pattern where each stroke
        is four units long, followed by a gap of two units, will begin with the
        stroke when drawn as a line.

        However, if the dash offset is set to 4.0,
        any line drawn will begin with the gap. Values of the offset up to 4.0
        will cause part of the stroke to be drawn first, and values of the
        offset between 4.0 and 6.0 will cause the line to begin with part of the
        gap.

        **Note:** This implicitly converts the style of the pen to
        **Qt::CustomDashLine** .

        **See also** **dashOffset** ().
        """
        ...

    def dashOffset(self) -> float:
        """
        https://doc.qt.io/qt-6/qpen.html#dashOffset

        **qreal QPen::dashOffset() const**

        Returns the dash offset for the pen.

        **See also** **setDashOffset** ().
        """
        ...

    def setMiterLimit(self, limit: float) -> None:
        """
        https://doc.qt.io/qt-6/qpen.html#setMiterLimit

        **void QPen::setMiterLimit(qreal limit )**

        Sets the miter limit of this pen to the given **limit**.

        ![](images/qpen-miterlimit.png)

        The miter limit describes how far a miter join can extend from the join
        point. This is used to reduce artifacts between line joins where the
        lines are close to parallel.

        This value does only have effect when the pen style is set to
        **Qt::MiterJoin** . The value is specified in units of the pen's width,
        e.g. a miter limit of 5 in width 10 is 50 pixels long. The default miter
        limit is 2, i.e. twice the pen width in pixels.

        **See also** **miterLimit** (), **setJoinStyle** (), and **Join Style**
        .
        """
        ...

    def miterLimit(self) -> float:
        """
        https://doc.qt.io/qt-6/qpen.html#miterLimit

        **qreal QPen::miterLimit() const**

        Returns the miter limit of the pen. The miter limit is only relevant
        when the join style is set to **Qt::MiterJoin** .

        **See also** **setMiterLimit** () and **Join Style** .
        """
        ...

    def setDashPattern(self, pattern: typing.Iterable[float]) -> None:
        """
        https://doc.qt.io/qt-6/qpen.html#setDashPattern

        **void QPen::setDashPattern(const QList<qreal> & pattern )**

        Sets the dash pattern for this pen to the given **pattern**. This
        implicitly converts the style of the pen to **Qt::CustomDashLine** .

        The pattern must be specified as an even number of positive entries
        where the entries 1, 3, 5... are the dashes and 2, 4, 6... are the
        spaces. For example:

        ![](images/qpen-custom.png)



            **QPen**  pen;
            **QList**
        <**qreal** > dashes;
            **qreal**  space = 4;
            dashes << 1 << space
        << 3 << space << 9 << space
                       << 27 << space << 9 << space;
        pen.setDashPattern(dashes);

        The dash pattern is specified in units of the pens width; e.g. a dash of
        length 5 in width 10 is 50 pixels long. Note that a pen with zero width
        is equivalent to a cosmetic pen with a width of 1 pixel.

        Each dash is also subject to cap styles so a dash of 1 with square cap
        set will extend 0.5 pixels out in each direction resulting in a total
        width of 2.

        Note that the default cap style is **Qt::SquareCap** , meaning that a
        square line end covers the end point and extends beyond it by half the
        line width.

        **See also** **setStyle** (), **dashPattern** (), **setCapStyle** (),
        and **setCosmetic** ().
        """
        ...

    def dashPattern(self) -> typing.List[float]:
        """
        https://doc.qt.io/qt-6/qpen.html#dashPattern

        **QList<qreal> QPen::dashPattern() const**

        Returns the dash pattern of this pen.

        **See also** **setDashPattern** (), **style** (), and **isSolid** ().
        """
        ...

    def setJoinStyle(self, pcs: QtCore.Qt.PenJoinStyle) -> None:
        """
        https://doc.qt.io/qt-6/qpen.html#setJoinStyle

        **void QPen::setJoinStyle(Qt::PenJoinStyle style )**

        Sets the pen's join style to the given **style**. The default value is
        **Qt::BevelJoin** .

        **See also** **joinStyle** () and **Join Style** .
        """
        ...

    def joinStyle(self) -> QtCore.Qt.PenJoinStyle:
        """
        https://doc.qt.io/qt-6/qpen.html#joinStyle

        **Qt::PenJoinStyle QPen::joinStyle() const**

        Returns the pen's join style.

        **See also** **setJoinStyle** () and **Join Style** .
        """
        ...

    def setCapStyle(self, pcs: QtCore.Qt.PenCapStyle) -> None:
        """
        https://doc.qt.io/qt-6/qpen.html#setCapStyle

        **void QPen::setCapStyle(Qt::PenCapStyle style )**

        Sets the pen's cap style to the given **style**. The default value is
        **Qt::SquareCap** .

        **See also** **capStyle** () and **Cap Style** .
        """
        ...

    def capStyle(self) -> QtCore.Qt.PenCapStyle:
        """
        https://doc.qt.io/qt-6/qpen.html#capStyle

        **Qt::PenCapStyle QPen::capStyle() const**

        Returns the pen's cap style.

        **See also** **setCapStyle** () and **Cap Style** .
        """
        ...

    def isSolid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qpen.html#isSolid

        **bool QPen::isSolid() const**

        Returns `true` if the pen has a solid fill, otherwise false.

        **See also** **style** () and **dashPattern** ().
        """
        ...

    def setBrush(
        self, brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, int, QGradient]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpen.html#setBrush

        **void QPen::setBrush(const QBrush & brush )**

        Sets the brush used to fill strokes generated with this pen to the given
        **brush**.

        **See also** **brush** () and **setColor** ().
        """
        ...

    def brush(self) -> QBrush:
        """
        https://doc.qt.io/qt-6/qpen.html#brush

        **QBrush QPen::brush() const**

        Returns the brush used to fill strokes generated with this pen.

        **See also** **setBrush** ().
        """
        ...

    def setColor(
        self, color: typing.Union[QColor, QtCore.Qt.GlobalColor, int, QGradient]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpen.html#setColor

        **void QPen::setColor(const QColor & color )**

        Sets the color of this pen's brush to the given **color**.

        **See also** **setBrush** () and **color** ().
        """
        ...

    def color(self) -> QColor:
        """
        https://doc.qt.io/qt-6/qpen.html#color

        **QColor QPen::color() const**

        Returns the color of this pen's brush.

        **See also** **brush** () and **setColor** ().
        """
        ...

    def setWidth(self, width: int) -> None:
        """
        https://doc.qt.io/qt-6/qpen.html#setWidth

        **void QPen::setWidth(int width )**

        Sets the pen width to the given **width** in pixels with integer
        precision.

        A line width of zero indicates a cosmetic pen. This means that the pen
        width is always drawn one pixel wide, independent of the
        **transformation**  set on the painter.

        Setting a pen width with a negative value is not supported.

        **See also** **setWidthF** () and **width** ().
        """
        ...

    def width(self) -> int:
        """
        https://doc.qt.io/qt-6/qpen.html#width

        **int QPen::width() const**

        Returns the pen width with integer precision.

        **See also** **setWidth** () and **widthF** ().
        """
        ...

    def setWidthF(self, width: float) -> None:
        """
        https://doc.qt.io/qt-6/qpen.html#setWidthF

        **void QPen::setWidthF(qreal width )**

        Sets the pen width to the given **width** in pixels with floating point
        precision.

        A line width of zero indicates a cosmetic pen. This means that the pen
        width is always drawn one pixel wide, independent of the
        **transformation**  on the painter.

        Setting a pen width with a negative value is not supported.

        **See also** **setWidth** () and **widthF** ().
        """
        ...

    def widthF(self) -> float:
        """
        https://doc.qt.io/qt-6/qpen.html#widthF

        **qreal QPen::widthF() const**

        Returns the pen width with floating point precision.

        **See also** **setWidthF** () and **width** ().
        """
        ...

    def setStyle(self, a0: QtCore.Qt.PenStyle) -> None:
        """
        https://doc.qt.io/qt-6/qpen.html#setStyle

        **void QPen::setStyle(Qt::PenStyle style )**

        Sets the pen style to the given **style**.

        See the **Qt::PenStyle**  documentation for a list of the available
        styles. Since Qt 4.1 it is also possible to specify a custom dash
        pattern using the **setDashPattern** () function which implicitly
        converts the style of the pen to **Qt::CustomDashLine** .

        **Note:** This function resets the dash offset to zero.

        **See also** **style** () and **Pen Style** .
        """
        ...

    def style(self) -> QtCore.Qt.PenStyle:
        """
        https://doc.qt.io/qt-6/qpen.html#style

        **Qt::PenStyle QPen::style() const**

        Returns the pen style.

        **See also** **setStyle** () and **Pen Style** .
        """
        ...
