"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6.QtGui import *


class QPixmapCache(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qpixmapcache.html

    **Detailed Description**

    This class is a tool for optimized drawing with **QPixmap** . You can use it
    to store temporary pixmaps that are expensive to generate without using more
    storage space than **cacheLimit** (). Use **insert** () to insert pixmaps,
    **find** () to find them, and **clear** () to empty the cache.

    QPixmapCache contains no member data, only static functions to access the
    global pixmap cache. It creates an internal **QCache**  object for caching
    the pixmaps.

    The cache associates a pixmap with a user-provided string as a key, or with
    a **QPixmapCache::Key**  that the cache generates. Using
    **QPixmapCache::Key**  for keys is faster than using strings. The string API
    is very convenient for complex keys but the **QPixmapCache::Key**  API will
    be very efficient and convenient for a one-to-one object-to-pixmap mapping -
    in this case, you can store the keys as members of an object.

    If two pixmaps are inserted into the cache using equal keys then the last
    pixmap will replace the first pixmap in the cache. This follows the behavior
    of the **QHash**  and **QCache**  classes.

    The cache becomes full when the total size of all pixmaps in the cache
    exceeds **cacheLimit** (). The initial cache limit is 10240 KB (10 MB); you
    can change this by calling **setCacheLimit** () with the required value. A
    pixmap takes roughly ( **width** * **height** * **depth** )/8 bytes of
    memory.

    The **Qt Quarterly** article **Optimizing with QPixmapCache**  explains how
    to use QPixmapCache to speed up applications by caching the results of
    painting.

    **Note:** QPixmapCache is only usable from the application's main thread.
    Access from other threads will be ignored and return failure.

    **See also** **QCache**  and **QPixmap** .
    """

    class Key(PyQt6.sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, other: "QPixmapCache.Key") -> None:
            ...

        def isValid(self) -> bool:
            ...

        def swap(self, other: "QPixmapCache.Key") -> None:
            ...

    @typing.overload
    def __init__(self) -> None:
        ...

    @typing.overload
    def __init__(self, a0: "QPixmapCache") -> None:
        ...

    @staticmethod
    def setCacheLimit(a0: int) -> None:
        """
        https://doc.qt.io/qt-6/qpixmapcache.html#setCacheLimit

        **[static] void QPixmapCache::setCacheLimit(int n )**

        Sets the cache limit to **n** kilobytes.

        The default setting is 10240 KB.

        **See also** **cacheLimit** ().
        """
        ...

    @staticmethod
    def replace(key: "QPixmapCache.Key", pixmap: QPixmap) -> bool:
        """
        https://doc.qt.io/qt-6/qpixmapcache.html#replace

        **[static] bool QPixmapCache::replace(const QPixmapCache::Key & key ,
        const QPixmap & pixmap )**

        Replaces the pixmap associated with the given **key** with the
        **pixmap** specified. Returns `true` if the **pixmap** has been
        correctly inserted into the cache; otherwise returns `false`.

        **See also** **setCacheLimit** () and **insert** ().
        """
        ...

    @typing.overload
    @staticmethod
    def remove(key: str) -> None:
        """
        https://doc.qt.io/qt-6/qpixmapcache.html#remove

        **[static] void QPixmapCache::remove(const QString & key )**

        Removes the pixmap associated with **key** from the cache.
        """
        ...

    @typing.overload
    @staticmethod
    def remove(key: "QPixmapCache.Key") -> None:
        """
        https://doc.qt.io/qt-6/qpixmapcache.html#remove-1

        **[static] void QPixmapCache::remove(const QPixmapCache::Key & key )**

        Removes the pixmap associated with **key** from the cache and releases
        the key for a future insertion.
        """
        ...

    @typing.overload
    @staticmethod
    def insert(key: str, a1: QPixmap) -> bool:
        """
        https://doc.qt.io/qt-6/qpixmapcache.html#insert

        **[static] bool QPixmapCache::insert(const QString & key , const QPixmap
        & pixmap )**

        Inserts a copy of the pixmap **pixmap** associated with the **key** into
        the cache.

        All pixmaps inserted by the Qt library have a key starting with "$qt",
        so your own pixmap keys should never begin "$qt".

        When a pixmap is inserted and the cache is about to exceed its limit, it
        removes pixmaps until there is enough room for the pixmap to be
        inserted.

        The oldest pixmaps (least recently accessed in the cache) are deleted
        when more space is needed.

        The function returns `true` if the object was inserted into the cache;
        otherwise it returns `false`.

        **See also** **setCacheLimit** ().
        """
        ...

    @typing.overload
    @staticmethod
    def insert(pixmap: QPixmap) -> "QPixmapCache.Key":
        """
        https://doc.qt.io/qt-6/qpixmapcache.html#insert-1

        **[static] QPixmapCache::Key QPixmapCache::insert(const QPixmap & pixmap
        )**

        Inserts a copy of the given **pixmap** into the cache and returns a key
        that can be used to retrieve it.

        When a pixmap is inserted and the cache is about to exceed its limit, it
        removes pixmaps until there is enough room for the pixmap to be
        inserted.

        The oldest pixmaps (least recently accessed in the cache) are deleted
        when more space is needed.

        **See also** **setCacheLimit** () and **replace** ().
        """
        ...

    @typing.overload
    @staticmethod
    def find(key: str) -> QPixmap:
        """
        https://doc.qt.io/qt-6/qpixmapcache.html#find

        **[static] bool QPixmapCache::find(const QString & key , QPixmap *
        pixmap )**

        Looks for a cached pixmap associated with the given **key** in the
        cache. If the pixmap is found, the function sets **pixmap** to that
        pixmap and returns `true`; otherwise it leaves **pixmap** alone and
        returns `false`.

        Example:

        **QPixmap**  pm;
            if (!**QPixmapCache** ::find("my_big_image", &pm))
        {
                pm.load("bigimage.png");
                **QPixmapCache**
        ::insert("my_big_image", pm);
            }
            painter->drawPixmap(0, 0, pm);
        """
        ...

    @typing.overload
    @staticmethod
    def find(key: "QPixmapCache.Key") -> QPixmap:
        """
        https://doc.qt.io/qt-6/qpixmapcache.html#find-1

        **[static] bool QPixmapCache::find(const QPixmapCache::Key & key ,
        QPixmap * pixmap )**

        Looks for a cached pixmap associated with the given **key** in the
        cache. If the pixmap is found, the function sets **pixmap** to that
        pixmap and returns `true`; otherwise it leaves **pixmap** alone and
        returns `false`. If the pixmap is not found, it means that the **key**
        is no longer valid, so it will be released for the next insertion.
        """
        ...

    @staticmethod
    def clear() -> None:
        """
        https://doc.qt.io/qt-6/qpixmapcache.html#clear

        **[static] void QPixmapCache::clear()**

        Removes all pixmaps from the cache.
        """
        ...

    @staticmethod
    def cacheLimit() -> int:
        """
        https://doc.qt.io/qt-6/qpixmapcache.html#cacheLimit

        **[static] int QPixmapCache::cacheLimit()**

        Returns the cache limit (in kilobytes).

        The default cache limit is 10240 KB.

        **See also** **setCacheLimit** ().
        """
        ...
