"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6 import QtCore


class QPolygon(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qpolygon.html

    **Detailed Description**

    A QPolygon object is a **QList** <**QPoint** >. The easiest way to add
    points to a QPolygon is to use **QList** 's streaming operator, as
    illustrated below:

    **QPolygon**  polygon;
        polygon << **QPoint** (10, 20) << **QPoint** (20,
    30);

    In addition to the functions provided by **QList** , QPolygon provides some
    point-specific functions.

    Each point in a polygon can be retrieved by passing its index to the
    **point** () function. To populate the polygon, QPolygon provides the
    **setPoint** () function to set the point at a given index, the
    **setPoints** () function to set all the points in the polygon (resizing it
    to the given number of points), and the **putPoints** () function which
    copies a number of given points into the polygon from a specified index
    (resizing the polygon if necessary).

    QPolygon provides the **boundingRect** () and **translate** () functions for
    geometry functions. Use the **QTransform::map** () function for more general
    transformations of QPolygons.

    The QPolygon class is **implicitly shared** .

    **See also** **QList** , **QPolygonF** , and **QLine** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qpolygon.html#QPolygon

        **QPolygon::QPolygon()**

        Constructs a polygon with no points.

        **See also** **QList::isEmpty** ().
        """
        ...

    @typing.overload
    def __init__(self, r: QtCore.QRect, closed: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qpolygon.html#QPolygon-1

        **QPolygon::QPolygon(const QList<QPoint> & points )**

        Constructs a polygon containing the specified **points**.

        **See also** **setPoints** ().
        """
        ...

    @typing.overload
    def __init__(self, v: typing.Iterable[QtCore.QPoint]) -> None:
        """
        https://doc.qt.io/qt-6/qpolygon.html#QPolygon-3

        **QPolygon::QPolygon(const QRect & rectangle , bool closed = false)**

        Constructs a polygon from the given **rectangle**. If **closed** is
        false, the polygon just contains the four points of the rectangle
        ordered clockwise, otherwise the polygon's fifth point is set to
        **rectangle**.topLeft().

        Note that the bottom-right corner of the rectangle is located at
        (rectangle.x() + rectangle.width(), rectangle.y() + rectangle.height()).

        **See also** **setPoints** ().
        """
        ...

    @typing.overload
    def __init__(self, variant: typing.Any) -> None:
        """
        https://doc.qt.io/qt-6/qpolygon.html#QPolygon

        **QPolygon::QPolygon()**

        Constructs a polygon with no points.

        **See also** **QList::isEmpty** ().
        """
        ...

    @typing.overload
    def __init__(self, a0: "QPolygon") -> None:
        """
        https://doc.qt.io/qt-6/qpolygon.html#QPolygon

        **QPolygon::QPolygon()**

        Constructs a polygon with no points.

        **See also** **QList::isEmpty** ().
        """
        ...

    def __contains__(self, value: QtCore.QPoint) -> int:
        ...

    @typing.overload
    def __delitem__(self, i: int) -> None:
        ...

    @typing.overload
    def __delitem__(self, slice: slice) -> None:
        ...

    @typing.overload
    def __setitem__(self, i: int, value: QtCore.QPoint) -> None:
        ...

    @typing.overload
    def __setitem__(self, slice: slice, list: "QPolygon") -> None:
        ...

    @typing.overload
    def __getitem__(self, i: int) -> QtCore.QPoint:
        ...

    @typing.overload
    def __getitem__(self, slice: slice) -> "QPolygon":
        ...

    @typing.overload
    def value(self, i: int) -> QtCore.QPoint:
        ...

    @typing.overload
    def value(self, i: int, defaultValue: QtCore.QPoint) -> QtCore.QPoint:
        ...

    def size(self) -> int:
        ...

    def replace(self, i: int, value: QtCore.QPoint) -> None:
        ...

    @typing.overload
    def remove(self, i: int) -> None:
        ...

    @typing.overload
    def remove(self, i: int, count: int) -> None:
        ...

    def prepend(self, value: QtCore.QPoint) -> None:
        ...

    def mid(self, pos: int, length: int = ...) -> "QPolygon":
        ...

    def lastIndexOf(self, value: QtCore.QPoint, from_: int = ...) -> int:
        ...

    def last(self) -> QtCore.QPoint:
        ...

    def isEmpty(self) -> bool:
        ...

    def insert(self, i: int, value: QtCore.QPoint) -> None:
        ...

    def indexOf(self, value: QtCore.QPoint, from_: int = ...) -> int:
        ...

    def first(self) -> QtCore.QPoint:
        ...

    def fill(self, value: QtCore.QPoint, size: int = ...) -> None:
        ...

    def data(self) -> PyQt6.sip.voidptr:
        ...

    def __len__(self) -> int:
        ...

    @typing.overload
    def count(self, value: QtCore.QPoint) -> int:
        ...

    @typing.overload
    def count(self) -> int:
        ...

    def contains(self, value: QtCore.QPoint) -> bool:
        ...

    def clear(self) -> None:
        ...

    def at(self, i: int) -> QtCore.QPoint:
        ...

    def append(self, value: QtCore.QPoint) -> None:
        ...

    def intersects(self, r: "QPolygon") -> bool:
        """
        https://doc.qt.io/qt-6/qpolygon.html#intersects

        **[since 5.10] bool QPolygon::intersects(const QPolygon & p ) const**

        Returns `true` if the current polygon intersects at any point the given
        polygon **p**. Also returns `true` if the current polygon contains or is
        contained by any part of **p**.

        Set operations on polygons will treat the polygons as areas. Non-closed
        polygons will be treated as implicitly closed.

        This function was introduced in Qt 5.10.

        **See also** **intersected** ().
        """
        ...

    def subtracted(self, r: "QPolygon") -> "QPolygon":
        """
        https://doc.qt.io/qt-6/qpolygon.html#subtracted

        **QPolygon QPolygon::subtracted(const QPolygon & r ) const**

        Returns a polygon which is **r** subtracted from this polygon.

        Set operations on polygons will treat the polygons as areas. Non-closed
        polygons will be treated as implicitly closed.
        """
        ...

    def intersected(self, r: "QPolygon") -> "QPolygon":
        """
        https://doc.qt.io/qt-6/qpolygon.html#intersected

        **QPolygon QPolygon::intersected(const QPolygon & r ) const**

        Returns a polygon which is the intersection of this polygon and **r**.

        Set operations on polygons will treat the polygons as areas. Non-closed
        polygons will be treated as implicitly closed.

        **See also** **intersects** ().
        """
        ...

    def united(self, r: "QPolygon") -> "QPolygon":
        """
        https://doc.qt.io/qt-6/qpolygon.html#united

        **QPolygon QPolygon::united(const QPolygon & r ) const**

        Returns a polygon which is the union of this polygon and **r**.

        Set operations on polygons, will treat the polygons as areas, and
        implicitly close the polygon.

        **See also** **intersected** () and **subtracted** ().
        """
        ...

    def containsPoint(self, pt: QtCore.QPoint, fillRule: QtCore.Qt.FillRule) -> bool:
        """
        https://doc.qt.io/qt-6/qpolygon.html#containsPoint

        **bool QPolygon::containsPoint(const QPoint & point , Qt::FillRule
        fillRule ) const**

        Returns `true` if the given **point** is inside the polygon according to
        the specified **fillRule** ; otherwise returns `false`.
        """
        ...

    @typing.overload
    def putPoints(self, index: int, firstx: int, firsty: int, *a3) -> None:
        """
        https://doc.qt.io/qt-6/qpolygon.html#putPoints

        **void QPolygon::putPoints(int index , int nPoints , int firstx , int
        firsty , ...)**

        Copies **nPoints** points from the variable argument list into this
        polygon from the given **index**.

        The points are given as a sequence of integers, starting with **firstx**
        then **firsty** , and so on. The polygon is resized if `index+nPoints`
        exceeds its current size.

        The example code creates a polygon with three points (4,5), (6,7) and
        (8,9), by expanding the polygon from 1 to 3 points:

        **QPolygon**  polygon(1);
            polygon[0] = **QPoint** (4, 5);
        polygon.putPoints(1, 2, 6,7, 8,9);

        The following code has the same result, but here the putPoints()
        function overwrites rather than extends:

        **QPolygon**  polygon(3);
            polygon.putPoints(0, 3, 4,5, 0,0, 8,9);
        polygon.putPoints(1, 1, 6,7);

        **See also** **setPoints** ().
        """
        ...

    @typing.overload
    def putPoints(
        self, index: int, nPoints: int, fromPolygon: "QPolygon", from_: int = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qpolygon.html#putPoints

        **void QPolygon::putPoints(int index , int nPoints , int firstx , int
        firsty , ...)**

        Copies **nPoints** points from the variable argument list into this
        polygon from the given **index**.

        The points are given as a sequence of integers, starting with **firstx**
        then **firsty** , and so on. The polygon is resized if `index+nPoints`
        exceeds its current size.

        The example code creates a polygon with three points (4,5), (6,7) and
        (8,9), by expanding the polygon from 1 to 3 points:

        **QPolygon**  polygon(1);
            polygon[0] = **QPoint** (4, 5);
        polygon.putPoints(1, 2, 6,7, 8,9);

        The following code has the same result, but here the putPoints()
        function overwrites rather than extends:

        **QPolygon**  polygon(3);
            polygon.putPoints(0, 3, 4,5, 0,0, 8,9);
        polygon.putPoints(1, 1, 6,7);

        **See also** **setPoints** ().
        """
        ...

    def setPoints(self, firstx: int, firsty: int, *a2) -> None:
        """
        https://doc.qt.io/qt-6/qpolygon.html#setPoints

        **void QPolygon::setPoints(int nPoints , const int * points )**

        Resizes the polygon to **nPoints** and populates it with the given
        **points**.

        The example code creates a polygon with two points (10, 20) and (30,
        40):

        static const int points[] = { 10, 20, 30, 40 };
            **QPolygon**
        polygon;
            polygon.setPoints(2, points);

        **See also** **setPoint** () and **putPoints** ().
        """
        ...

    @typing.overload
    def setPoint(self, index: int, x: int, y: int) -> None:
        """
        https://doc.qt.io/qt-6/qpolygon.html#setPoint

        **void QPolygon::setPoint(int index , int x , int y )**

        Sets the point at the given **index** to the point specified by ( **x**
        , **y** ).

        **See also** **point** (), **putPoints** (), and **setPoints** ().
        """
        ...

    @typing.overload
    def setPoint(self, index: int, p: QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qpolygon.html#setPoint-1

        **void QPolygon::setPoint(int index , const QPoint & point )**

        This is an overloaded function.

        Sets the point at the given **index** to the given **point**.
        """
        ...

    def point(self, i: int) -> QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qpolygon.html#point

        **void QPolygon::point(int index , int * x , int * y ) const**

        Extracts the coordinates of the point at the given **index** to * **x**
        and * **y** (if they are valid pointers).

        **See also** **setPoint** ().
        """
        ...

    def boundingRect(self) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qpolygon.html#boundingRect

        **QRect QPolygon::boundingRect() const**

        Returns the bounding rectangle of the polygon, or **QRect** (0, 0, 0, 0)
        if the polygon is empty.

        **See also** **QList::isEmpty** ().
        """
        ...

    @typing.overload
    def translated(self, dx: int, dy: int) -> "QPolygon":
        """
        https://doc.qt.io/qt-6/qpolygon.html#translated

        **QPolygon QPolygon::translated(int dx , int dy ) const**

        Returns a copy of the polygon that is translated by ( **dx** , **dy** ).

        **See also** **translate** ().
        """
        ...

    @typing.overload
    def translated(self, offset: QtCore.QPoint) -> "QPolygon":
        """
        https://doc.qt.io/qt-6/qpolygon.html#translated-1

        **QPolygon QPolygon::translated(const QPoint & offset ) const**

        This is an overloaded function.

        Returns a copy of the polygon that is translated by the given
        **offset**.

        **See also** **translate** ().
        """
        ...

    @typing.overload
    def translate(self, dx: int, dy: int) -> None:
        """
        https://doc.qt.io/qt-6/qpolygon.html#translate

        **void QPolygon::translate(int dx , int dy )**

        Translates all points in the polygon by ( **dx** , **dy** ).

        **See also** **translated** ().
        """
        ...

    @typing.overload
    def translate(self, offset: QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qpolygon.html#translate-1

        **void QPolygon::translate(const QPoint & offset )**

        This is an overloaded function.

        Translates all points in the polygon by the given **offset**.

        **See also** **translated** ().
        """
        ...

    def swap(self, other: "QPolygon") -> None:
        """
        https://doc.qt.io/qt-6/qpolygon.html#swap

        **void QPolygon::swap(QPolygon & other )**

        Swaps polygon **other** with this polygon. This operation is very fast
        and never fails.
        """
        ...
