"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtGui import *


class QPolygonF(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qpolygonf.html

    **Detailed Description**

    A QPolygonF is a **QList** <**QPointF** >. The easiest way to add points to
    a QPolygonF is to use its streaming operator, as illustrated below:

    **QPolygonF**  polygon;
        polygon << **QPointF** (10.4, 20.5) <<
    **QPointF** (20.2, 30.2);

    In addition to the functions provided by **QList** , QPolygonF provides the
    **boundingRect** () and **translate** () functions for geometry operations.
    Use the **QTransform::map** () function for more general transformations of
    QPolygonFs.

    QPolygonF also provides the **isClosed** () function to determine whether a
    polygon's start and end points are the same, and the **toPolygon** ()
    function returning an integer precision copy of this polygon.

    The QPolygonF class is **implicitly shared** .

    **See also** **QList** , **QPolygon** , and **QLineF** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#QPolygonF

        **QPolygonF::QPolygonF()**

        Constructs a polygon with no points.

        **See also** **QList::isEmpty** ().
        """
        ...

    @typing.overload
    def __init__(self, v: typing.Iterable[QtCore.QPointF]) -> None:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#QPolygonF-1

        **QPolygonF::QPolygonF(const QList<QPointF> & points )**

        Constructs a polygon containing the specified **points**.
        """
        ...

    @typing.overload
    def __init__(self, r: QtCore.QRectF) -> None:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#QPolygonF-3

        **QPolygonF::QPolygonF(const QRectF & rectangle )**

        Constructs a closed polygon from the specified **rectangle**.

        The polygon contains the four vertices of the rectangle in clockwise
        order starting and ending with the top-left vertex.

        **See also** **isClosed** ().
        """
        ...

    @typing.overload
    def __init__(self, a: QPolygon) -> None:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#QPolygonF-4

        **QPolygonF::QPolygonF(const QPolygon & polygon )**

        Constructs a float based polygon from the specified integer based
        **polygon**.

        **See also** **toPolygon** ().
        """
        ...

    @typing.overload
    def __init__(self, variant: typing.Any) -> None:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#QPolygonF

        **QPolygonF::QPolygonF()**

        Constructs a polygon with no points.

        **See also** **QList::isEmpty** ().
        """
        ...

    @typing.overload
    def __init__(self, a0: "QPolygonF") -> None:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#QPolygonF

        **QPolygonF::QPolygonF()**

        Constructs a polygon with no points.

        **See also** **QList::isEmpty** ().
        """
        ...

    def __contains__(self, value: QtCore.QPointF) -> int:
        ...

    @typing.overload
    def __delitem__(self, i: int) -> None:
        ...

    @typing.overload
    def __delitem__(self, slice: slice) -> None:
        ...

    @typing.overload
    def __setitem__(self, i: int, value: QtCore.QPointF) -> None:
        ...

    @typing.overload
    def __setitem__(self, slice: slice, list: "QPolygonF") -> None:
        ...

    @typing.overload
    def __getitem__(self, i: int) -> QtCore.QPointF:
        ...

    @typing.overload
    def __getitem__(self, slice: slice) -> "QPolygonF":
        ...

    @typing.overload
    def value(self, i: int) -> QtCore.QPointF:
        ...

    @typing.overload
    def value(self, i: int, defaultValue: QtCore.QPointF) -> QtCore.QPointF:
        ...

    def size(self) -> int:
        ...

    def replace(self, i: int, value: QtCore.QPointF) -> None:
        ...

    @typing.overload
    def remove(self, i: int) -> None:
        ...

    @typing.overload
    def remove(self, i: int, count: int) -> None:
        ...

    def prepend(self, value: QtCore.QPointF) -> None:
        ...

    def mid(self, pos: int, length: int = ...) -> "QPolygonF":
        ...

    def lastIndexOf(self, value: QtCore.QPointF, from_: int = ...) -> int:
        ...

    def last(self) -> QtCore.QPointF:
        ...

    def isEmpty(self) -> bool:
        ...

    def insert(self, i: int, value: QtCore.QPointF) -> None:
        ...

    def indexOf(self, value: QtCore.QPointF, from_: int = ...) -> int:
        ...

    def first(self) -> QtCore.QPointF:
        ...

    def fill(self, value: QtCore.QPointF, size: int = ...) -> None:
        ...

    def data(self) -> PyQt6.sip.voidptr:
        ...

    def __len__(self) -> int:
        ...

    @typing.overload
    def count(self, value: QtCore.QPointF) -> int:
        ...

    @typing.overload
    def count(self) -> int:
        ...

    def contains(self, value: QtCore.QPointF) -> bool:
        ...

    def clear(self) -> None:
        ...

    def at(self, i: int) -> QtCore.QPointF:
        ...

    def append(self, value: QtCore.QPointF) -> None:
        ...

    def intersects(self, r: "QPolygonF") -> bool:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#intersects

        **[since 5.10] bool QPolygonF::intersects(const QPolygonF & p ) const**

        Returns `true` if the current polygon intersects at any point the given
        polygon **p**. Also returns `true` if the current polygon contains or is
        contained by any part of **p**.

        Set operations on polygons will treat the polygons as areas. Non-closed
        polygons will be treated as implicitly closed.

        This function was introduced in Qt 5.10.

        **See also** **intersected** ().
        """
        ...

    def subtracted(self, r: "QPolygonF") -> "QPolygonF":
        """
        https://doc.qt.io/qt-6/qpolygonf.html#subtracted

        **QPolygonF QPolygonF::subtracted(const QPolygonF & r ) const**

        Returns a polygon which is **r** subtracted from this polygon.

        Set operations on polygons will treat the polygons as areas. Non-closed
        polygons will be treated as implicitly closed.
        """
        ...

    def intersected(self, r: "QPolygonF") -> "QPolygonF":
        """
        https://doc.qt.io/qt-6/qpolygonf.html#intersected

        **QPolygonF QPolygonF::intersected(const QPolygonF & r ) const**

        Returns a polygon which is the intersection of this polygon and **r**.

        Set operations on polygons will treat the polygons as areas. Non-closed
        polygons will be treated as implicitly closed.

        **See also** **intersects** ().
        """
        ...

    def united(self, r: "QPolygonF") -> "QPolygonF":
        """
        https://doc.qt.io/qt-6/qpolygonf.html#united

        **QPolygonF QPolygonF::united(const QPolygonF & r ) const**

        Returns a polygon which is the union of this polygon and **r**.

        Set operations on polygons will treat the polygons as areas. Non-closed
        polygons will be treated as implicitly closed.

        **See also** **intersected** () and **subtracted** ().
        """
        ...

    def containsPoint(self, pt: QtCore.QPointF, fillRule: QtCore.Qt.FillRule) -> bool:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#containsPoint

        **bool QPolygonF::containsPoint(const QPointF & point , Qt::FillRule
        fillRule ) const**

        Returns `true` if the given **point** is inside the polygon according to
        the specified **fillRule** ; otherwise returns `false`.
        """
        ...

    def boundingRect(self) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#boundingRect

        **QRectF QPolygonF::boundingRect() const**

        Returns the bounding rectangle of the polygon, or **QRectF** (0,0,0,0)
        if the polygon is empty.

        **See also** **QList::isEmpty** ().
        """
        ...

    def isClosed(self) -> bool:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#isClosed

        **bool QPolygonF::isClosed() const**

        Returns `true` if the polygon is closed; otherwise returns `false`.

        A polygon is said to be closed if its start point and end point are
        equal.

        **See also** **QList::first** () and **QList::last** ().
        """
        ...

    def toPolygon(self) -> QPolygon:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#toPolygon

        **QPolygon QPolygonF::toPolygon() const**

        Creates and returns a **QPolygon**  by converting each **QPointF**  to a
        **QPoint** .

        **See also** **QPointF::toPoint** ().
        """
        ...

    @typing.overload
    def translated(self, dx: float, dy: float) -> "QPolygonF":
        """
        https://doc.qt.io/qt-6/qpolygonf.html#translated

        **QPolygonF QPolygonF::translated(const QPointF & offset ) const**

        Returns a copy of the polygon that is translated by the given
        **offset**.

        **See also** **translate** ().
        """
        ...

    @typing.overload
    def translated(self, offset: QtCore.QPointF) -> "QPolygonF":
        """
        https://doc.qt.io/qt-6/qpolygonf.html#translated-1

        **QPolygonF QPolygonF::translated(qreal dx , qreal dy ) const**

        This is an overloaded function.

        Returns a copy of the polygon that is translated by ( **dx** , **dy** ).

        **See also** **translate** ().
        """
        ...

    @typing.overload
    def translate(self, dx: float, dy: float) -> None:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#translate

        **void QPolygonF::translate(const QPointF & offset )**

        Translate all points in the polygon by the given **offset**.

        **See also** **translated** ().
        """
        ...

    @typing.overload
    def translate(self, offset: QtCore.QPointF) -> None:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#translate-1

        **void QPolygonF::translate(qreal dx , qreal dy )**

        This is an overloaded function.

        Translates all points in the polygon by ( **dx** , **dy** ).

        **See also** **translated** ().
        """
        ...

    def swap(self, other: "QPolygonF") -> None:
        """
        https://doc.qt.io/qt-6/qpolygonf.html#swap

        **void QPolygonF::swap(QPolygonF & other )**

        Swaps polygon **other** with this polygon. This operation is very fast
        and never fails.
        """
        ...
