"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtGui import *


class QRegularExpressionValidator(QValidator):
    """
    https://doc.qt.io/qt-6/qregularexpressionvalidator.html

    **Detailed Description**

    QRegularExpressionValidator uses a regular expression (regexp) to determine
    whether an input string is **Acceptable** , **Intermediate** , or
    **Invalid** . The regexp can either be supplied when the
    QRegularExpressionValidator is constructed, or at a later time.

    If the regexp partially matches against the string, the result is considered
    **Intermediate** . For example, "" and "A" are **Intermediate**  for the
    regexp **[A-Z][0-9]** (whereas "**_** " would be **Invalid** ).

    QRegularExpressionValidator automatically wraps the regular expression in
    the `\\\\A` and `\\\\z` anchors; in other words, it always attempts to do an
    exact match.

    Example of use:

    // regexp: optional '-' followed by between 1 and 3 digits
    **QRegularExpression**  rx("-?\\\\d{1,3}");
        **QValidator**  *validator =
    new **QRegularExpressionValidator** (rx, this);

        **QLineEdit**
    *edit = new **QLineEdit** (this);
        edit->setValidator(validator);

    Below we present some examples of validators. In practice they would
    normally be associated with a widget as in the example above.

    // integers 1 to 9999
        **QRegularExpression**  re("[1-9]\\\\d{0,3}");
    // the validator treats the regexp as "^[1-9]\\\\d{0,3}$"
    **QRegularExpressionValidator**  v(re, 0);
        **QString**  s;
        int pos =
    0;

        s = "0";     v.validate(s, pos);    // returns Invalid
        s =
    "12345"; v.validate(s, pos);    // returns Invalid
        s = "1";
    v.validate(s, pos);    // returns Acceptable

        re.setPattern("\\\\S+");
    // one or more non-whitespace characters
        v.setRegularExpression(re);
    s = "myfile.txt";  v.validate(s, pos); // Returns Acceptable
        s = "my
    file.txt"; v.validate(s, pos); // Returns Invalid

        // A, B or C
    followed by exactly five digits followed by W, X, Y or Z
    re.setPattern("[A-C]\\\\d{5}[W-Z]");
        v.setRegularExpression(re);
        s =
    "a12345Z"; v.validate(s, pos);        // Returns Invalid
        s = "A12345Z";
    v.validate(s, pos);        // Returns Acceptable
        s = "B12";
    v.validate(s, pos);        // Returns Intermediate

        // match most
    'readme' files
        re.setPattern("read\\\\S?me(\\\\.(txt|asc|1st))?");
    re.setPatternOptions(**QRegularExpression** ::CaseInsensitiveOption);
    v.setRegularExpression(re);
        s = "readme";      v.validate(s, pos); //
    Returns Acceptable
        s = "README.1ST";  v.validate(s, pos); // Returns
    Acceptable
        s = "read me.txt"; v.validate(s, pos); // Returns Invalid
    s = "readm";       v.validate(s, pos); // Returns Intermediate

    **See also** **QRegularExpression** , **QIntValidator** , and
    **QDoubleValidator** .
    """

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qregularexpressionvalidator.html#QRegularExpressi
        onValidator

        **QRegularExpressionValidator::QRegularExpressionValidator(QObject *
        parent = nullptr)**

        Constructs a validator with a **parent** object that accepts any string
        (including an empty one) as valid.
        """
        ...

    @typing.overload
    def __init__(
        self,
        re: QtCore.QRegularExpression,
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qregularexpressionvalidator.html#QRegularExpressi
        onValidator-1

        **QRegularExpressionValidator::QRegularExpressionValidator(const
        QRegularExpression & re , QObject * parent = nullptr)**

        Constructs a validator with a **parent** object that accepts all strings
        that match the regular expression **re**.
        """
        ...

    def setRegularExpression(self, re: QtCore.QRegularExpression) -> None:
        """
        https://doc.qt.io/qt-6/qregularexpressionvalidator.html#regularExpressio
        n-prop

        **regularExpression : QRegularExpression**

        This property holds the regular expression used for validation

        By default, this property contains a regular expression with an empty
        pattern (which therefore matches any string).

        **Access functions:**

        QRegularExpression **regularExpression** () const
        void
        **setRegularExpression** (const QRegularExpression & **re** )

        **Notifier signal:**

        void **regularExpressionChanged** (const QRegularExpression & **re** )

        **Member Function Documentation**
        """
        ...

    def regularExpression(self) -> QtCore.QRegularExpression:
        """
        https://doc.qt.io/qt-6/qregularexpressionvalidator.html#regularExpressio
        n-prop

        **regularExpression : QRegularExpression**

        This property holds the regular expression used for validation

        By default, this property contains a regular expression with an empty
        pattern (which therefore matches any string).

        **Access functions:**

        QRegularExpression **regularExpression** () const
        void
        **setRegularExpression** (const QRegularExpression & **re** )

        **Notifier signal:**

        void **regularExpressionChanged** (const QRegularExpression & **re** )

        **Member Function Documentation**
        """
        ...

    def validate(
        self, input: str, pos: int
    ) -> typing.Tuple[QValidator.State, str, int]:
        """
        https://doc.qt.io/qt-6/qregularexpressionvalidator.html#validate

        **[override virtual] QValidator::State
        QRegularExpressionValidator::validate(QString & input , int & pos )
        const**

        Reimplements: **QValidator::validate(QString &input, int &pos) const** .

        Returns **Acceptable**  if **input** is matched by the regular
        expression for this validator, **Intermediate**  if it has matched
        partially (i.e. could be a valid match if additional valid characters
        are added), and **Invalid**  if **input** is not matched.

        In case the **input** is not matched, the **pos** parameter is set to
        the length of the **input** parameter; otherwise, it is not modified.

        For example, if the regular expression is **\\w\\d\\d** (word-character,
        digit, digit) then "A57" is **Acceptable** , "E5" is **Intermediate** ,
        and "+9" is **Invalid** .

        **See also** **QRegularExpression::match** ().
        """
        ...

    @property
    def regularExpressionChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        ...
