"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
from PyQt6 import QtCore


class QResizeEvent(QtCore.QEvent):
    """
    https://doc.qt.io/qt-6/qresizeevent.html

    **Detailed Description**

    Resize events are sent to widgets that have been resized.

    The event handler **QWidget::resizeEvent** () receives resize events.

    **See also** **QWidget::resize** () and **QWidget::setGeometry** ().
    """

    def __init__(self, size: QtCore.QSize, oldSize: QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-6/qresizeevent.html#QResizeEvent-2

        **QResizeEvent::QResizeEvent(const QSize & size , const QSize & oldSize
        )**

        Constructs a resize event with the new and old widget sizes, **size**
        and **oldSize** respectively.
        """
        ...

    def clone(self) -> "QResizeEvent":
        ...

    def oldSize(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qresizeevent.html#oldSize

        **const QSize &QResizeEvent::oldSize() const**

        Returns the old size of the widget.
        """
        ...

    def size(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qresizeevent.html#size

        **const QSize &QResizeEvent::size() const**

        Returns the new size of the widget. This is the same as
        **QWidget::size** ().
        """
        ...
