"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6.QtGui import *
import enum


class QSurfaceFormat(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qsurfaceformat.html

    **Detailed Description**

    The format includes the size of the color buffers, red, green, and blue; the
    size of the alpha buffer; the size of the depth and stencil buffers; and
    number of samples per pixel for multisampling. In addition, the format
    contains surface configuration parameters such as OpenGL profile and version
    for rendering, whether or not to enable stereo buffers, and swap behaviour.

    **Note:** When troubleshooting context or window format issues, it can be
    helpful to enable the logging category `qt.qpa.gl`. Depending on the
    platform, this may print useful debug information when it comes to OpenGL
    initialization and the native visual or framebuffer configurations which
    QSurfaceFormat gets mapped to.
    """

    class OpenGLContextProfile(enum.Enum):
        NoProfile: QSurfaceFormat = ...
        CoreProfile: QSurfaceFormat = ...
        CompatibilityProfile: QSurfaceFormat = ...

    class RenderableType(enum.Enum):
        DefaultRenderableType: QSurfaceFormat = ...
        OpenGL: QSurfaceFormat = ...
        OpenGLES: QSurfaceFormat = ...
        OpenVG: QSurfaceFormat = ...

    class SwapBehavior(enum.Enum):
        DefaultSwapBehavior: QSurfaceFormat = ...
        SingleBuffer: QSurfaceFormat = ...
        DoubleBuffer: QSurfaceFormat = ...
        TripleBuffer: QSurfaceFormat = ...

    class FormatOption(enum.Flag):
        StereoBuffers: QSurfaceFormat = ...
        DebugContext: QSurfaceFormat = ...
        DeprecatedFunctions: QSurfaceFormat = ...
        ResetNotification: QSurfaceFormat = ...
        ProtectedContent: QSurfaceFormat = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#QSurfaceFormat

        **QSurfaceFormat::QSurfaceFormat()**

        Constructs a default initialized QSurfaceFormat.

        **Note:** By default OpenGL 2.0 is requested since this provides the
        highest grade of portability between platforms and OpenGL
        implementations.
        """
        ...

    @typing.overload
    def __init__(self, options: "QSurfaceFormat.FormatOption") -> None:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#QSurfaceFormat-1

        **QSurfaceFormat::QSurfaceFormat(QSurfaceFormat::FormatOptions options
        )**

        Constructs a QSurfaceFormat with the given format **options**.
        """
        ...

    @typing.overload
    def __init__(self, other: "QSurfaceFormat") -> None:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#QSurfaceFormat-2

        **QSurfaceFormat::QSurfaceFormat(const QSurfaceFormat & other )**

        Constructs a copy of **other**.
        """
        ...

    def setColorSpace(self, colorSpace: QColorSpace) -> None:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#setColorSpace

        **[since 6.0] void QSurfaceFormat::setColorSpace(const QColorSpace &
        colorSpace )**

        Sets the preferred **colorSpace**.

        For example, this allows requesting windows with default framebuffers
        that are sRGB-capable on platforms that support it.

        **Note:** When the requested color space is not supported by the
        platform, the request is ignored. Query the **QSurfaceFormat**  after
        window creation to verify if the color space request could be honored or
        not.

        **Note:** This setting controls if the default framebuffer of the window
        is capable of updates and blending in a given color space. It does not
        change applications' output by itself. The applications' rendering code
        will still have to opt in via the appropriate OpenGL calls to enable
        updates and blending to be performed in the given color space instead of
        using the standard linear operations.

        This function was introduced in Qt 6.0.

        **See also** **colorSpace** ().
        """
        ...

    def colorSpace(self) -> QColorSpace:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#colorSpace

        **[since 5.10] const QColorSpace &QSurfaceFormat::colorSpace() const**

        Returns the color space.

        This function was introduced in Qt 5.10.

        **See also** **setColorSpace** ().
        """
        ...

    @staticmethod
    def defaultFormat() -> "QSurfaceFormat":
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#defaultFormat

        **[static, since 5.4] QSurfaceFormat QSurfaceFormat::defaultFormat()**

        Returns the global default surface format.

        When **setDefaultFormat** () is not called, this is a default-
        constructed **QSurfaceFormat** .

        This function was introduced in Qt 5.4.

        **See also** **setDefaultFormat** ().
        """
        ...

    @staticmethod
    def setDefaultFormat(format: "QSurfaceFormat") -> None:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#setDefaultFormat

        **[static, since 5.4] void QSurfaceFormat::setDefaultFormat(const
        QSurfaceFormat & format )**

        Sets the global default surface **format**.

        This format is used by default in **QOpenGLContext** , **QWindow** ,
        **QOpenGLWidget**  and similar classes.

        It can always be overridden on a per-instance basis by using the class
        in question's own setFormat() function. However, it is often more
        convenient to set the format for all windows once at the start of the
        application. It also guarantees proper behavior in cases where shared
        contexts are required, because settings the format via this function
        guarantees that all contexts and surfaces, even the ones created
        internally by Qt, will use the same format.

        **Note:** When setting **Qt::AA_ShareOpenGLContexts** , it is strongly
        recommended to place the call to this function before the construction
        of the **QGuiApplication**  or **QApplication** . Otherwise **format**
        will not be applied to the global share context and therefore issues may
        arise with context sharing afterwards.

        This function was introduced in Qt 5.4.

        **See also** **defaultFormat** ().
        """
        ...

    def setSwapInterval(self, interval: int) -> None:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#setSwapInterval

        **[since 5.3] void QSurfaceFormat::setSwapInterval(int interval )**

        Sets the preferred swap interval. The swap interval specifies the
        minimum number of video frames that are displayed before a buffer swap
        occurs. This can be used to sync the GL drawing into a window to the
        vertical refresh of the screen.

        Setting an **interval** value of 0 will turn the vertical refresh
        syncing off, any value higher than 0 will turn the vertical syncing on.
        Setting **interval** to a higher value, for example 10, results in
        having 10 vertical retraces between every buffer swap.

        The default interval is 1.

        Changing the swap interval may not be supported by the underlying
        platform. In this case, the request will be silently ignored.

        This function was introduced in Qt 5.3.

        **See also** **swapInterval** ().
        """
        ...

    def swapInterval(self) -> int:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#swapInterval

        **[since 5.3] int QSurfaceFormat::swapInterval() const**

        Returns the swap interval.

        This function was introduced in Qt 5.3.

        **See also** **setSwapInterval** ().
        """
        ...

    def options(self) -> "QSurfaceFormat.FormatOption":
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#options

        **[since 5.3] QSurfaceFormat::FormatOptions QSurfaceFormat::options()
        const**

        Returns the currently set format options.

        This function was introduced in Qt 5.3.

        **See also** **setOption** (), **setOptions** (), and **testOption** ().
        """
        ...

    def testOption(self, option: "QSurfaceFormat.FormatOption") -> bool:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#testOption

        **[since 5.3] bool
        QSurfaceFormat::testOption(QSurfaceFormat::FormatOption option ) const**

        Returns true if the format option **option** is set; otherwise returns
        false.

        This function was introduced in Qt 5.3.

        **See also** **options** ().
        """
        ...

    def setOption(self, option: "QSurfaceFormat.FormatOption", on: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#setOption

        **[since 5.3] void
        QSurfaceFormat::setOption(QSurfaceFormat::FormatOption option , bool on
        = true)**

        Sets the format option **option** if **on** is true; otherwise, clears
        the option.

        To verify that an option was respected, compare the actual format to the
        requested format after surface/context creation.

        This function was introduced in Qt 5.3.

        **See also** **setOptions** (), **options** (), and **testOption** ().
        """
        ...

    def setOptions(self, options: "QSurfaceFormat.FormatOption") -> None:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#setOptions

        **[since 5.3] void
        QSurfaceFormat::setOptions(QSurfaceFormat::FormatOptions options )**

        Sets the format options to **options**.

        To verify that an option was respected, compare the actual format to the
        requested format after surface/context creation.

        This function was introduced in Qt 5.3.

        **See also** **options** () and **testOption** ().
        """
        ...

    def setVersion(self, major: int, minor: int) -> None:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#setVersion

        **void QSurfaceFormat::setVersion(int major , int minor )**

        Sets the desired **major** and **minor** OpenGL versions.

        The default version is 2.0.

        **See also** **version** ().
        """
        ...

    def version(self) -> typing.Tuple[int, int]:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#version

        **QPair<int, int> QSurfaceFormat::version() const**

        Returns a QPair<int, int> representing the OpenGL version.

        Useful for version checks, for example format.version() >= qMakePair(3,
        2)

        **See also** **setVersion** ().
        """
        ...

    def stereo(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#stereo

        **bool QSurfaceFormat::stereo() const**

        Returns `true` if stereo buffering is enabled; otherwise returns false.
        Stereo buffering is disabled by default.

        **See also** **setStereo** ().
        """
        ...

    def setStereo(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#setStereo

        **void QSurfaceFormat::setStereo(bool enable )**

        If **enable** is true enables stereo buffering; otherwise disables
        stereo buffering.

        Stereo buffering is disabled by default.

        Stereo buffering provides extra color buffers to generate left-eye and
        right-eye images.

        **See also** **stereo** ().
        """
        ...

    def minorVersion(self) -> int:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#minorVersion

        **int QSurfaceFormat::minorVersion() const**

        Returns the minor OpenGL version.

        **See also** **setMinorVersion** ().
        """
        ...

    def setMinorVersion(self, minorVersion: int) -> None:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#setMinorVersion

        **void QSurfaceFormat::setMinorVersion(int minor )**

        Sets the desired **minor** OpenGL version.

        The default version is 2.0.

        **See also** **minorVersion** ().
        """
        ...

    def majorVersion(self) -> int:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#majorVersion

        **int QSurfaceFormat::majorVersion() const**

        Returns the major OpenGL version.

        The default version is 2.0.

        **See also** **setMajorVersion** ().
        """
        ...

    def setMajorVersion(self, majorVersion: int) -> None:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#setMajorVersion

        **void QSurfaceFormat::setMajorVersion(int major )**

        Sets the desired **major** OpenGL version.

        **See also** **majorVersion** ().
        """
        ...

    def renderableType(self) -> "QSurfaceFormat.RenderableType":
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#renderableType

        **QSurfaceFormat::RenderableType QSurfaceFormat::renderableType()
        const**

        Gets the renderable type.

        Chooses between desktop OpenGL, OpenGL ES, and **OpenVG** .

        **See also** **setRenderableType** ().
        """
        ...

    def setRenderableType(self, type: "QSurfaceFormat.RenderableType") -> None:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#setRenderableType

        **void QSurfaceFormat::setRenderableType(QSurfaceFormat::RenderableType
        type )**

        Sets the desired renderable **type**.

        Chooses between desktop OpenGL, OpenGL ES, and **OpenVG** .

        **See also** **renderableType** ().
        """
        ...

    def profile(self) -> "QSurfaceFormat.OpenGLContextProfile":
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#profile

        **QSurfaceFormat::OpenGLContextProfile QSurfaceFormat::profile() const**

        Get the configured OpenGL context profile.

        This setting is ignored if the requested OpenGL version is less than
        3.2.

        **See also** **setProfile** ().
        """
        ...

    def setProfile(self, profile: "QSurfaceFormat.OpenGLContextProfile") -> None:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#setProfile

        **void QSurfaceFormat::setProfile(QSurfaceFormat::OpenGLContextProfile
        profile )**

        Sets the desired OpenGL context **profile**.

        This setting is ignored if the requested OpenGL version is less than
        3.2.

        **See also** **profile** ().
        """
        ...

    def hasAlpha(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#hasAlpha

        **bool QSurfaceFormat::hasAlpha() const**

        Returns `true` if the alpha buffer size is greater than zero.

        This means that the surface might be used with per pixel translucency
        effects.
        """
        ...

    def swapBehavior(self) -> "QSurfaceFormat.SwapBehavior":
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#swapBehavior

        **QSurfaceFormat::SwapBehavior QSurfaceFormat::swapBehavior() const**

        Returns the configured swap behaviour.

        **See also** **setSwapBehavior** ().
        """
        ...

    def setSwapBehavior(self, behavior: "QSurfaceFormat.SwapBehavior") -> None:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#setSwapBehavior

        **void QSurfaceFormat::setSwapBehavior(QSurfaceFormat::SwapBehavior
        behavior )**

        Set the swap **behavior** of the surface.

        The swap behavior specifies whether single, double, or triple buffering
        is desired. The default, **DefaultSwapBehavior** , gives the default
        swap behavior of the platform.

        **See also** **swapBehavior** ().
        """
        ...

    def samples(self) -> int:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#samples

        **int QSurfaceFormat::samples() const**

        Returns the number of samples per pixel when multisampling is enabled,
        or `-1` when multisampling is disabled. The default return value is
        `-1`.

        **See also** **setSamples** ().
        """
        ...

    def setSamples(self, numSamples: int) -> None:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#setSamples

        **void QSurfaceFormat::setSamples(int numSamples )**

        Set the preferred number of samples per pixel when multisampling is
        enabled to **numSamples**. By default, multisampling is disabled.

        **See also** **samples** ().
        """
        ...

    def alphaBufferSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#alphaBufferSize

        **int QSurfaceFormat::alphaBufferSize() const**

        Get the size in bits of the alpha channel of the color buffer.

        **See also** **setAlphaBufferSize** ().
        """
        ...

    def setAlphaBufferSize(self, size: int) -> None:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#setAlphaBufferSize

        **void QSurfaceFormat::setAlphaBufferSize(int size )**

        Set the desired **size** in bits of the alpha channel of the color
        buffer.

        **See also** **alphaBufferSize** ().
        """
        ...

    def blueBufferSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#blueBufferSize

        **int QSurfaceFormat::blueBufferSize() const**

        Get the size in bits of the blue channel of the color buffer.

        **See also** **setBlueBufferSize** ().
        """
        ...

    def setBlueBufferSize(self, size: int) -> None:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#setBlueBufferSize

        **void QSurfaceFormat::setBlueBufferSize(int size )**

        Set the desired **size** in bits of the blue channel of the color
        buffer.

        **See also** **blueBufferSize** ().
        """
        ...

    def greenBufferSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#greenBufferSize

        **int QSurfaceFormat::greenBufferSize() const**

        Get the size in bits of the green channel of the color buffer.

        **See also** **setGreenBufferSize** ().
        """
        ...

    def setGreenBufferSize(self, size: int) -> None:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#setGreenBufferSize

        **void QSurfaceFormat::setGreenBufferSize(int size )**

        Set the desired **size** in bits of the green channel of the color
        buffer.

        **See also** **greenBufferSize** ().
        """
        ...

    def redBufferSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#redBufferSize

        **int QSurfaceFormat::redBufferSize() const**

        Get the size in bits of the red channel of the color buffer.

        **See also** **setRedBufferSize** ().
        """
        ...

    def setRedBufferSize(self, size: int) -> None:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#setRedBufferSize

        **void QSurfaceFormat::setRedBufferSize(int size )**

        Set the desired **size** in bits of the red channel of the color buffer.

        **See also** **redBufferSize** ().
        """
        ...

    def stencilBufferSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#stencilBufferSize

        **int QSurfaceFormat::stencilBufferSize() const**

        Returns the stencil buffer size in bits.

        **See also** **setStencilBufferSize** ().
        """
        ...

    def setStencilBufferSize(self, size: int) -> None:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#setStencilBufferSize

        **void QSurfaceFormat::setStencilBufferSize(int size )**

        Set the preferred stencil buffer size to **size** bits.

        **See also** **stencilBufferSize** ().
        """
        ...

    def depthBufferSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#depthBufferSize

        **int QSurfaceFormat::depthBufferSize() const**

        Returns the depth buffer size.

        **See also** **setDepthBufferSize** ().
        """
        ...

    def setDepthBufferSize(self, size: int) -> None:
        """
        https://doc.qt.io/qt-6/qsurfaceformat.html#setDepthBufferSize

        **void QSurfaceFormat::setDepthBufferSize(int size )**

        Set the minimum depth buffer size to **size**.

        **See also** **depthBufferSize** ().
        """
        ...
