"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6.QtGui import *


class QTextFrame(QTextObject):
    """
    https://doc.qt.io/qt-6/qtextframe.html

    **Detailed Description**

    Text frames provide structure for the text in a document. They are used as
    generic containers for other document elements. Frames are usually created
    by using **QTextCursor::insertFrame** ().

    Frames can be used to create hierarchical structures in rich text documents.
    Each document has a root frame (**QTextDocument::rootFrame** ()), and each
    frame beneath the root frame has a parent frame and a (possibly empty) list
    of child frames. The parent frame can be found with **parentFrame** (), and
    the **childFrames** () function provides a list of child frames.

    Each frame contains at least one text block to enable text cursors to insert
    new document elements within. As a result, the **QTextFrame::iterator**
    class is used to traverse both the blocks and child frames within a given
    frame. The first and last child elements in the frame can be found with
    **begin** () and **end** ().

    A frame also has a format (specified using **QTextFrameFormat** ) which can
    be set with **setFormat** () and read with **format** ().

    Text cursors can be obtained that point to the first and last valid cursor
    positions within a frame; use the **firstCursorPosition** () and
    **lastCursorPosition** () functions for this. The frame's extent in the
    document can be found with **firstPosition** () and **lastPosition** ().

    You can iterate over a frame's contents using the **QTextFrame::iterator**
    class: this provides read-only access to its internal list of text blocks
    and child frames.

    **See also** **QTextCursor**  and **QTextDocument** .
    """

    class iterator(PyQt6.sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QTextFrame.iterator") -> None:
            ...

        def atEnd(self) -> bool:
            ...

        def currentBlock(self) -> "QTextBlock":
            ...

        def currentFrame(self) -> "QTextFrame":
            ...

        def parentFrame(self) -> "QTextFrame":
            ...

    def __init__(self, doc: QTextDocument) -> None:
        """
        https://doc.qt.io/qt-6/qtextframe.html#QTextFrame

        **QTextFrame::QTextFrame(QTextDocument * document )**

        Creates a new empty frame for the text **document**.
        """
        ...

    def setFrameFormat(self, aformat: QTextFrameFormat) -> None:
        """
        https://doc.qt.io/qt-6/qtextframe.html#setFrameFormat

        **void QTextFrame::setFrameFormat(const QTextFrameFormat & format )**

        Sets the frame's **format**.

        **See also** **frameFormat** ().
        """
        ...

    def end(self) -> "QTextFrame.iterator":
        """
        https://doc.qt.io/qt-6/qtextframe.html#end

        **QTextFrame::iterator QTextFrame::end() const**

        Returns an iterator pointing to the position past the last document
        element inside the frame. Please see the document **STL-Style
        Iterators**  for more information.

        **See also** **begin** ().
        """
        ...

    def begin(self) -> "QTextFrame.iterator":
        """
        https://doc.qt.io/qt-6/qtextframe.html#begin

        **QTextFrame::iterator QTextFrame::begin() const**

        Returns an iterator pointing to the first document element inside the
        frame. Please see the document **STL-style-Iterators**  for more
        information.

        **See also** **end** ().
        """
        ...

    def parentFrame(self) -> "QTextFrame":
        """
        https://doc.qt.io/qt-6/qtextframe.html#parentFrame

        **QTextFrame *QTextFrame::parentFrame() const**

        Returns the frame's parent frame. If the frame is the root frame of a
        document, this will return 0.

        **See also** **childFrames** () and **QTextDocument::rootFrame** ().
        """
        ...

    def childFrames(self) -> typing.List["QTextFrame"]:
        """
        https://doc.qt.io/qt-6/qtextframe.html#childFrames

        **QList<QTextFrame *> QTextFrame::childFrames() const**

        Returns a (possibly empty) list of the frame's child frames.

        **See also** **parentFrame** ().
        """
        ...

    def lastPosition(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextframe.html#lastPosition

        **int QTextFrame::lastPosition() const**

        Returns the last document position inside the frame.

        **See also** **firstPosition** (), **firstCursorPosition** (), and
        **lastCursorPosition** ().
        """
        ...

    def firstPosition(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextframe.html#firstPosition

        **int QTextFrame::firstPosition() const**

        Returns the first document position inside the frame.

        **See also** **lastPosition** (), **firstCursorPosition** (), and
        **lastCursorPosition** ().
        """
        ...

    def lastCursorPosition(self) -> QTextCursor:
        """
        https://doc.qt.io/qt-6/qtextframe.html#lastCursorPosition

        **QTextCursor QTextFrame::lastCursorPosition() const**

        Returns the last cursor position inside the frame.

        **See also** **firstCursorPosition** (), **firstPosition** (), and
        **lastPosition** ().
        """
        ...

    def firstCursorPosition(self) -> QTextCursor:
        """
        https://doc.qt.io/qt-6/qtextframe.html#firstCursorPosition

        **QTextCursor QTextFrame::firstCursorPosition() const**

        Returns the first cursor position inside the frame.

        **See also** **lastCursorPosition** (), **firstPosition** (), and
        **lastPosition** ().
        """
        ...

    def frameFormat(self) -> QTextFrameFormat:
        """
        https://doc.qt.io/qt-6/qtextframe.html#frameFormat

        **QTextFrameFormat QTextFrame::frameFormat() const**

        Returns the frame's format.

        **See also** **setFrameFormat** ().
        """
        ...
