"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
from PyQt6 import QtCore
from PyQt6.QtGui import *
import enum


class QTextFrameFormat(QTextFormat):
    """
    https://doc.qt.io/qt-6/qtextframeformat.html

    **Detailed Description**

    A text frame groups together one or more blocks of text, providing a layer
    of structure larger than the paragraph. The format of a frame specifies how
    it is rendered and positioned on the screen. It does not directly specify
    the behavior of the text formatting within, but provides constraints on the
    layout of its children.

    The frame format defines the **width** () and **height** () of the frame on
    the screen. Each frame can have a **border** () that surrounds its contents
    with a rectangular box. The border is surrounded by a **margin** () around
    the frame, and the contents of the frame are kept separate from the border
    by the frame's **padding** (). This scheme is similar to the box model used
    by Cascading Style Sheets for HTML pages.

    ![](images/qtextframe-style.png)

    The **position** () of a frame is set using **setPosition** () and
    determines how it is located relative to the surrounding text.

    The validity of a QTextFrameFormat object can be determined with the
    **isValid** () function.

    **See also** **QTextFrame**  and **QTextBlockFormat** .
    """

    class BorderStyle(enum.Enum):
        BorderStyle_None: QTextFrameFormat = ...
        BorderStyle_Dotted: QTextFrameFormat = ...
        BorderStyle_Dashed: QTextFrameFormat = ...
        BorderStyle_Solid: QTextFrameFormat = ...
        BorderStyle_Double: QTextFrameFormat = ...
        BorderStyle_DotDash: QTextFrameFormat = ...
        BorderStyle_DotDotDash: QTextFrameFormat = ...
        BorderStyle_Groove: QTextFrameFormat = ...
        BorderStyle_Ridge: QTextFrameFormat = ...
        BorderStyle_Inset: QTextFrameFormat = ...
        BorderStyle_Outset: QTextFrameFormat = ...

    class Position(enum.Enum):
        InFlow: QTextFrameFormat = ...
        FloatLeft: QTextFrameFormat = ...
        FloatRight: QTextFrameFormat = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#QTextFrameFormat

        **QTextFrameFormat::QTextFrameFormat()**

        Constructs a text frame format object with the default properties.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QTextFrameFormat") -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#QTextFrameFormat

        **QTextFrameFormat::QTextFrameFormat()**

        Constructs a text frame format object with the default properties.
        """
        ...

    def setRightMargin(self, amargin: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#setRightMargin

        **void QTextFrameFormat::setRightMargin(qreal margin )**

        Sets the frame's right **margin** in pixels.

        **See also** **rightMargin** ().
        """
        ...

    def setLeftMargin(self, amargin: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#setLeftMargin

        **void QTextFrameFormat::setLeftMargin(qreal margin )**

        Sets the frame's left **margin** in pixels.

        **See also** **leftMargin** ().
        """
        ...

    def setBottomMargin(self, amargin: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#setBottomMargin

        **void QTextFrameFormat::setBottomMargin(qreal margin )**

        Sets the frame's bottom **margin** in pixels.

        **See also** **bottomMargin** ().
        """
        ...

    def setTopMargin(self, amargin: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#setTopMargin

        **void QTextFrameFormat::setTopMargin(qreal margin )**

        Sets the frame's top **margin** in pixels.

        **See also** **topMargin** ().
        """
        ...

    def rightMargin(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#rightMargin

        **qreal QTextFrameFormat::rightMargin() const**

        Returns the width of the frame's right margin in pixels.

        **See also** **setRightMargin** ().
        """
        ...

    def leftMargin(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#leftMargin

        **qreal QTextFrameFormat::leftMargin() const**

        Returns the width of the frame's left margin in pixels.

        **See also** **setLeftMargin** ().
        """
        ...

    def bottomMargin(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#bottomMargin

        **qreal QTextFrameFormat::bottomMargin() const**

        Returns the width of the frame's bottom margin in pixels.

        **See also** **setBottomMargin** ().
        """
        ...

    def topMargin(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#topMargin

        **qreal QTextFrameFormat::topMargin() const**

        Returns the width of the frame's top margin in pixels.

        **See also** **setTopMargin** ().
        """
        ...

    def borderStyle(self) -> "QTextFrameFormat.BorderStyle":
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#borderStyle

        **QTextFrameFormat::BorderStyle QTextFrameFormat::borderStyle() const**

        Returns the style of the frame's border.

        **See also** **setBorderStyle** ().
        """
        ...

    def setBorderStyle(self, style: "QTextFrameFormat.BorderStyle") -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#setBorderStyle

        **void QTextFrameFormat::setBorderStyle(QTextFrameFormat::BorderStyle
        style )**

        Sets the **style** of the frame's border.

        **See also** **borderStyle** ().
        """
        ...

    def borderBrush(self) -> QBrush:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#borderBrush

        **QBrush QTextFrameFormat::borderBrush() const**

        Returns the brush used for the frame's border.

        **See also** **setBorderBrush** ().
        """
        ...

    def setBorderBrush(
        self, brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, int, QGradient]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#setBorderBrush

        **void QTextFrameFormat::setBorderBrush(const QBrush & brush )**

        Sets the **brush** used for the frame's border.

        **See also** **borderBrush** ().
        """
        ...

    def pageBreakPolicy(self) -> QTextFormat.PageBreakFlag:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#pageBreakPolicy

        **QTextFormat::PageBreakFlags QTextFrameFormat::pageBreakPolicy()
        const**

        Returns the currently set page break policy for the frame/table. The
        default is **QTextFormat::PageBreak_Auto** .

        **See also** **setPageBreakPolicy** ().
        """
        ...

    def setPageBreakPolicy(self, flags: QTextFormat.PageBreakFlag) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#setPageBreakPolicy

        **void QTextFrameFormat::setPageBreakPolicy(QTextFormat::PageBreakFlags
        policy )**

        Sets the page break policy for the frame/table to **policy**.

        **See also** **pageBreakPolicy** ().
        """
        ...

    @typing.overload
    def setHeight(self, aheight: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#setHeight

        **void QTextFrameFormat::setHeight(const QTextLength & height )**

        Sets the frame's **height**.

        **See also** **height** ().
        """
        ...

    @typing.overload
    def setHeight(self, aheight: QTextLength) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#setHeight-1

        **void QTextFrameFormat::setHeight(qreal height )**

        This is an overloaded function.

        Sets the frame's **height**.
        """
        ...

    def setPadding(self, apadding: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#setPadding

        **void QTextFrameFormat::setPadding(qreal width )**

        Sets the **width** of the frame's internal padding in pixels.

        **See also** **padding** ().
        """
        ...

    def setMargin(self, amargin: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#setMargin

        **void QTextFrameFormat::setMargin(qreal margin )**

        Sets the frame's **margin** in pixels. This method also sets the left,
        right, top and bottom margins of the frame to the same value. The
        individual margins override the general margin.

        **See also** **margin** ().
        """
        ...

    def setBorder(self, aborder: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#setBorder

        **void QTextFrameFormat::setBorder(qreal width )**

        Sets the **width** (in pixels) of the frame's border.

        **See also** **border** ().
        """
        ...

    def height(self) -> QTextLength:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#height

        **QTextLength QTextFrameFormat::height() const**

        Returns the height of the frame's border rectangle.

        **See also** **setHeight** ().
        """
        ...

    def width(self) -> QTextLength:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#width

        **QTextLength QTextFrameFormat::width() const**

        Returns the width of the frame's border rectangle.

        **See also** **setWidth** () and **QTextLength** .
        """
        ...

    @typing.overload
    def setWidth(self, length: QTextLength) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#setWidth

        **void QTextFrameFormat::setWidth(const QTextLength & width )**

        Sets the frame's border rectangle's **width**.

        **See also** **width** () and **QTextLength** .
        """
        ...

    @typing.overload
    def setWidth(self, awidth: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#setWidth-1

        **void QTextFrameFormat::setWidth(qreal width )**

        This is an overloaded function.

        Convenience method that sets the width of the frame's border rectangle's
        width to the specified fixed **width**.
        """
        ...

    def padding(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#padding

        **qreal QTextFrameFormat::padding() const**

        Returns the width of the frame's internal padding in pixels.

        **See also** **setPadding** ().
        """
        ...

    def margin(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#margin

        **qreal QTextFrameFormat::margin() const**

        Returns the width of the frame's external margin in pixels.

        **See also** **setMargin** ().
        """
        ...

    def border(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#border

        **qreal QTextFrameFormat::border() const**

        Returns the width of the border in pixels.

        **See also** **setBorder** ().
        """
        ...

    def position(self) -> "QTextFrameFormat.Position":
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#position

        **QTextFrameFormat::Position QTextFrameFormat::position() const**

        Returns the positioning policy for frames with this frame format.

        **See also** **setPosition** ().
        """
        ...

    def setPosition(self, f: "QTextFrameFormat.Position") -> None:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#setPosition

        **void QTextFrameFormat::setPosition(QTextFrameFormat::Position policy
        )**

        Sets the **policy** for positioning frames with this frame format.

        **See also** **position** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextframeformat.html#isValid

        **bool QTextFrameFormat::isValid() const**

        Returns `true` if the format description is valid; otherwise returns
        `false`.
        """
        ...
