"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt6.QtGui import *


class QTextImageFormat(QTextCharFormat):
    """
    https://doc.qt.io/qt-6/qtextimageformat.html

    **Detailed Description**

    Inline images are represented by a Unicode value U+FFFC (OBJECT REPLACEMENT
    CHARACTER) which has an associated QTextImageFormat. The image format
    specifies a name with **setName** () that is used to locate the image. The
    size of the rectangle that the image will occupy is specified in pixels
    using **setWidth** () and **setHeight** (). The desired image quality may be
    set with **setQuality** ().

    Images can be supplied in any format for which Qt has an image reader, so
    SVG drawings can be included alongside PNG, TIFF and other bitmap formats.

    **See also** **QImage**  and **QImageReader** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextimageformat.html#QTextImageFormat

        **QTextImageFormat::QTextImageFormat()**

        Creates a new image format object.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QTextImageFormat") -> None:
        """
        https://doc.qt.io/qt-6/qtextimageformat.html#QTextImageFormat

        **QTextImageFormat::QTextImageFormat()**

        Creates a new image format object.
        """
        ...

    def setQuality(self, quality: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qtextimageformat.html#setQuality

        **[since 5.12] void QTextImageFormat::setQuality(int quality = 100)**

        Sets the quality that should be used by exporters when exporting the
        image. **QTextDocumentWriter**  will export jpg images with the
        **quality** set here when exporting to ODF files if **quality** is set
        to a value between 0 and 100. Or it will export png images if
        **quality** is set to 100 (default) or greater.

        This function was introduced in Qt 5.12.

        **See also** **quality** ().
        """
        ...

    def setHeight(self, aheight: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextimageformat.html#setHeight

        **void QTextImageFormat::setHeight(qreal height )**

        Sets the **height** of the rectangle occupied by the image.

        **See also** **height** () and **setWidth** ().
        """
        ...

    def setWidth(self, awidth: float) -> None:
        """
        https://doc.qt.io/qt-6/qtextimageformat.html#setWidth

        **void QTextImageFormat::setWidth(qreal width )**

        Sets the **width** of the rectangle occupied by the image.

        **See also** **width** () and **setHeight** ().
        """
        ...

    def setName(self, aname: str) -> None:
        """
        https://doc.qt.io/qt-6/qtextimageformat.html#setName

        **void QTextImageFormat::setName(const QString & name )**

        Sets the **name** of the image. The **name** is used to locate the image
        in the application's resources.

        **See also** **name** ().
        """
        ...

    def quality(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextimageformat.html#quality

        **[since 5.12] int QTextImageFormat::quality() const**

        Returns the value set by **setQuality** ().

        This function was introduced in Qt 5.12.

        **See also** **setQuality** ().
        """
        ...

    def height(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextimageformat.html#height

        **qreal QTextImageFormat::height() const**

        Returns the height of the rectangle occupied by the image.

        **See also** **width** () and **setHeight** ().
        """
        ...

    def width(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextimageformat.html#width

        **qreal QTextImageFormat::width() const**

        Returns the width of the rectangle occupied by the image.

        **See also** **height** () and **setWidth** ().
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-6/qtextimageformat.html#name

        **QString QTextImageFormat::name() const**

        Returns the name of the image. The name refers to an entry in the
        application's resources file.

        **See also** **setName** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextimageformat.html#isValid

        **bool QTextImageFormat::isValid() const**

        Returns `true` if this image format is valid; otherwise returns `false`.
        """
        ...
