"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtGui import *
import enum


class QTextLayout(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qtextlayout.html

    **Detailed Description**

    It offers many features expected from a modern text layout engine, including
    Unicode compliant rendering, line breaking and handling of cursor
    positioning. It can also produce and render device independent layout,
    something that is important for WYSIWYG applications.

    The class has a rather low level API and unless you intend to implement your
    own text rendering for some specialized widget, you probably won't need to
    use it directly.

    QTextLayout can be used with both plain and rich text.

    QTextLayout can be used to create a sequence of **QTextLine**  instances
    with given widths and can position them independently on the screen. Once
    the layout is done, these lines can be drawn on a paint device.

    The text to be laid out can be provided in the constructor or set with
    **setText** ().

    The layout can be seen as a sequence of **QTextLine**  objects; use
    **createLine** () to create a **QTextLine**  instance, and **lineAt** () or
    **lineForTextPosition** () to retrieve created lines.

    Here is a code snippet that demonstrates the layout phase:

    int leading = fontMetrics.leading();
        **qreal**  height = 0;
    textLayout.setCacheEnabled(true);
        textLayout.beginLayout();
        while
    (1) {
            **QTextLine**  line = textLayout.createLine();
            if
    (!line.isValid())
                break;
    line.setLineWidth(lineWidth);
            height += leading;
    line.setPosition(**QPointF** (0, height));
            height += line.height();
    }
        textLayout.endLayout();

    The text can then be rendered by calling the layout's **draw** () function:

    **QPainter**  painter(this);
        textLayout.draw(&painter, **QPoint** (0,
    0));

    For a given position in the text you can find a valid cursor position with
    **isValidCursorPosition** (), **nextCursorPosition** (), and
    **previousCursorPosition** ().

    The QTextLayout itself can be positioned with **setPosition** (); it has a
    **boundingRect** (), and a **minimumWidth** () and a **maximumWidth** ().

    **See also** **QStaticText** .
    """

    class CursorMode(enum.Enum):
        SkipCharacters: QTextLayout = ...
        SkipWords: QTextLayout = ...

    class FormatRange(PyQt6.sip.simplewrapper):
        format: QTextCharFormat = ...
        length: int = ...
        start: int = ...

        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QTextLayout.FormatRange") -> None:
            ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#QTextLayout

        **QTextLayout::QTextLayout()**

        Constructs an empty text layout.

        **See also** **setText** ().
        """
        ...

    @typing.overload
    def __init__(self, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#QTextLayout-1

        **QTextLayout::QTextLayout(const QString & text )**

        Constructs a text layout to lay out the given **text**.
        """
        ...

    @typing.overload
    def __init__(
        self, text: str, font: QFont, paintdevice: typing.Optional[QPaintDevice] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#QTextLayout-2

        **[since 5.13] QTextLayout::QTextLayout(const QString & text , const
        QFont & font , const QPaintDevice * paintdevice = nullptr)**

        Constructs a text layout to lay out the given **text** with the
        specified **font**.

        All the metric and layout calculations will be done in terms of the
        paint device, **paintdevice**. If **paintdevice** is `nullptr` the
        calculations will be done in screen metrics.

        This function was introduced in Qt 5.13.
        """
        ...

    @typing.overload
    def __init__(self, b: "QTextBlock") -> None:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#QTextLayout

        **QTextLayout::QTextLayout()**

        Constructs an empty text layout.

        **See also** **setText** ().
        """
        ...

    def clearFormats(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#clearFormats

        **[since 5.6] void QTextLayout::clearFormats()**

        Clears the list of additional formats supported by the text layout.

        This function was introduced in Qt 5.6.

        **See also** **formats** () and **setFormats** ().
        """
        ...

    def formats(self) -> typing.List["QTextLayout.FormatRange"]:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#formats

        **[since 5.6] QList<QTextLayout::FormatRange> QTextLayout::formats()
        const**

        Returns the list of additional formats supported by the text layout.

        This function was introduced in Qt 5.6.

        **See also** **setFormats** () and **clearFormats** ().
        """
        ...

    def setFormats(self, overrides: typing.Iterable["QTextLayout.FormatRange"]) -> None:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#setFormats

        **[since 5.6] void QTextLayout::setFormats(const
        QList<QTextLayout::FormatRange> & formats )**

        Sets the additional formats supported by the text layout to **formats**.
        The formats are applied with preedit area text in place.

        This function was introduced in Qt 5.6.

        **See also** **formats** () and **clearFormats** ().
        """
        ...

    def glyphRuns(self, from_: int = ..., length: int = ...) -> typing.List[QGlyphRun]:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#glyphRuns

        **QList<QGlyphRun> QTextLayout::glyphRuns(int from = -1, int length =
        -1) const**

        Returns the glyph indexes and positions for all glyphs corresponding to
        the **length** characters starting at the position **from** in this
        **QTextLayout** . This is an expensive function, and should not be
        called in a time sensitive context.

        If **from** is less than zero, then the glyph run will begin at the
        first character in the layout. If **length** is less than zero, it will
        span the entire string from the start position.

        **See also** **draw** () and **QPainter::drawGlyphRun** ().
        """
        ...

    def rightCursorPosition(self, oldPos: int) -> int:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#rightCursorPosition

        **int QTextLayout::rightCursorPosition(int oldPos ) const**

        Returns the cursor position to the right of **oldPos** , next to it.
        It's dependent on the visual position of characters, after bi-
        directional reordering.

        **See also** **leftCursorPosition** () and **nextCursorPosition** ().
        """
        ...

    def leftCursorPosition(self, oldPos: int) -> int:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#leftCursorPosition

        **int QTextLayout::leftCursorPosition(int oldPos ) const**

        Returns the cursor position to the left of **oldPos** , next to it. It's
        dependent on the visual position of characters, after bi-directional
        reordering.

        **See also** **rightCursorPosition** () and **previousCursorPosition**
        ().
        """
        ...

    def cursorMoveStyle(self) -> QtCore.Qt.CursorMoveStyle:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#cursorMoveStyle

        **Qt::CursorMoveStyle QTextLayout::cursorMoveStyle() const**

        The cursor movement style of this **QTextLayout** . The default is
        **Qt::LogicalMoveStyle** .

        **See also** **setCursorMoveStyle** ().
        """
        ...

    def setCursorMoveStyle(self, style: QtCore.Qt.CursorMoveStyle) -> None:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#setCursorMoveStyle

        **void QTextLayout::setCursorMoveStyle(Qt::CursorMoveStyle style )**

        Sets the visual cursor movement style to the given **style**. If the
        **QTextLayout**  is backed by a document, you can ignore this and use
        the option in **QTextDocument** , this option is for widgets like
        **QLineEdit**  or custom widgets without a **QTextDocument** . Default
        value is **Qt::LogicalMoveStyle** .

        **See also** **cursorMoveStyle** ().
        """
        ...

    def clearLayout(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#clearLayout

        **void QTextLayout::clearLayout()**

        Clears the line information in the layout. After having called this
        function, **lineCount** () returns 0.

        **Warning:** This will invalidate the layout, so all existing
        **QTextLine**  objects that refer to the previous contents should now be
        discarded.
        """
        ...

    def maximumWidth(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#maximumWidth

        **qreal QTextLayout::maximumWidth() const**

        The maximum width the layout could expand to; this is essentially the
        width of the entire text.

        **Warning:** This function only returns a valid value after the layout
        has been done.

        **See also** **minimumWidth** ().
        """
        ...

    def minimumWidth(self) -> float:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#minimumWidth

        **qreal QTextLayout::minimumWidth() const**

        The minimum width the layout needs. This is the width of the layout's
        smallest non-breakable substring.

        **Warning:** This function only returns a valid value after the layout
        has been done.

        **See also** **maximumWidth** ().
        """
        ...

    def boundingRect(self) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#boundingRect

        **QRectF QTextLayout::boundingRect() const**

        The smallest rectangle that contains all the lines in the layout.
        """
        ...

    def setPosition(self, p: QtCore.QPointF) -> None:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#setPosition

        **void QTextLayout::setPosition(const QPointF & p )**

        Moves the text layout to point **p**.

        **See also** **position** ().
        """
        ...

    def position(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#position

        **QPointF QTextLayout::position() const**

        The global position of the layout. This is independent of the bounding
        rectangle and of the layout process.

        **See also** **setPosition** ().
        """
        ...

    @typing.overload
    def drawCursor(self, p: QPainter, pos: QtCore.QPointF, cursorPosition: int) -> None:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#drawCursor

        **void QTextLayout::drawCursor(QPainter * painter , const QPointF &
        position , int cursorPosition , int width ) const**

        Draws a text cursor with the current pen and the specified **width** at
        the given **position** using the **painter** specified. The
        corresponding position within the text is specified by
        **cursorPosition**.
        """
        ...

    @typing.overload
    def drawCursor(
        self, p: QPainter, pos: QtCore.QPointF, cursorPosition: int, width: int
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#drawCursor-1

        **void QTextLayout::drawCursor(QPainter * painter , const QPointF &
        position , int cursorPosition ) const**

        This is an overloaded function.

        Draws a text cursor with the current pen at the given **position** using
        the **painter** specified. The corresponding position within the text is
        specified by **cursorPosition**.
        """
        ...

    def draw(
        self,
        p: QPainter,
        pos: QtCore.QPointF,
        selections: typing.Iterable["QTextLayout.FormatRange"] = ...,
        clip: QtCore.QRectF = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#draw

        **void QTextLayout::draw(QPainter * p , const QPointF & pos , const
        QList<QTextLayout::FormatRange> & selections = QList<FormatRange>(),
        const QRectF & clip = QRectF()) const**

        Draws the whole layout on the painter **p** at the position specified by
        **pos**. The rendered layout includes the given **selections** and is
        clipped within the rectangle specified by **clip**.
        """
        ...

    def previousCursorPosition(
        self, oldPos: int, mode: "QTextLayout.CursorMode" = ...
    ) -> int:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#previousCursorPosition

        **int QTextLayout::previousCursorPosition(int oldPos ,
        QTextLayout::CursorMode mode = SkipCharacters) const**

        Returns the first valid cursor position before **oldPos** that respects
        the given cursor **mode**. Returns value of **oldPos** , if **oldPos**
        is not a valid cursor position.

        **See also** **isValidCursorPosition** () and **nextCursorPosition** ().
        """
        ...

    def nextCursorPosition(
        self, oldPos: int, mode: "QTextLayout.CursorMode" = ...
    ) -> int:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#nextCursorPosition

        **int QTextLayout::nextCursorPosition(int oldPos ,
        QTextLayout::CursorMode mode = SkipCharacters) const**

        Returns the next valid cursor position after **oldPos** that respects
        the given cursor **mode**. Returns value of **oldPos** , if **oldPos**
        is not a valid cursor position.

        **See also** **isValidCursorPosition** () and **previousCursorPosition**
        ().
        """
        ...

    def isValidCursorPosition(self, pos: int) -> bool:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#isValidCursorPosition

        **bool QTextLayout::isValidCursorPosition(int pos ) const**

        / Returns `true` if position **pos** is a valid cursor position.

        In a Unicode context some positions in the text are not valid cursor
        positions, because the position is inside a Unicode surrogate or a
        grapheme cluster.

        A grapheme cluster is a sequence of two or more Unicode characters that
        form one indivisible entity on the screen. For example the latin
        character `Ä' can be represented in Unicode by two characters, `A'
        (0x41), and the combining diaeresis (0x308). A text cursor can only
        validly be positioned before or after these two characters, never
        between them since that wouldn't make sense. In indic languages every
        syllable forms a grapheme cluster.
        """
        ...

    def lineForTextPosition(self, pos: int) -> "QTextLine":
        """
        https://doc.qt.io/qt-6/qtextlayout.html#lineForTextPosition

        **QTextLine QTextLayout::lineForTextPosition(int pos ) const**

        Returns the line that contains the cursor position specified by **pos**.

        **See also** **isValidCursorPosition** () and **lineAt** ().
        """
        ...

    def lineAt(self, i: int) -> "QTextLine":
        """
        https://doc.qt.io/qt-6/qtextlayout.html#lineAt

        **QTextLine QTextLayout::lineAt(int i ) const**

        Returns the **i** -th line of text in this text layout.

        **See also** **lineCount** () and **lineForTextPosition** ().
        """
        ...

    def lineCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#lineCount

        **int QTextLayout::lineCount() const**

        Returns the number of lines in this text layout.

        **See also** **lineAt** ().
        """
        ...

    def createLine(self) -> "QTextLine":
        """
        https://doc.qt.io/qt-6/qtextlayout.html#createLine

        **QTextLine QTextLayout::createLine()**

        Returns a new text line to be laid out if there is text to be inserted
        into the layout; otherwise returns an invalid text line.

        The text layout creates a new line object that starts after the last
        line in the layout, or at the beginning if the layout is empty. The
        layout maintains an internal cursor, and each line is filled with text
        from the cursor position onwards when the **QTextLine::setLineWidth** ()
        function is called.

        Once **QTextLine::setLineWidth** () is called, a new line can be created
        and filled with text. Repeating this process will lay out the whole
        block of text contained in the **QTextLayout** . If there is no text
        left to be inserted into the layout, the **QTextLine**  returned will
        not be valid (isValid() will return false).
        """
        ...

    def endLayout(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#endLayout

        **void QTextLayout::endLayout()**

        Ends the layout process.

        **See also** **beginLayout** ().
        """
        ...

    def beginLayout(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#beginLayout

        **void QTextLayout::beginLayout()**

        Begins the layout process.

        **Warning:** This will invalidate the layout, so all existing
        **QTextLine**  objects that refer to the previous contents should now be
        discarded.

        **See also** **endLayout** ().
        """
        ...

    def cacheEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#cacheEnabled

        **bool QTextLayout::cacheEnabled() const**

        Returns `true` if the complete layout information is cached; otherwise
        returns `false`.

        **See also** **setCacheEnabled** ().
        """
        ...

    def setCacheEnabled(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#setCacheEnabled

        **void QTextLayout::setCacheEnabled(bool enable )**

        Enables caching of the complete layout information if **enable** is
        true; otherwise disables layout caching. Usually **QTextLayout**  throws
        most of the layouting information away after a call to **endLayout** ()
        to reduce memory consumption. If you however want to draw the laid out
        text directly afterwards enabling caching might speed up drawing
        significantly.

        **See also** **cacheEnabled** ().
        """
        ...

    def preeditAreaText(self) -> str:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#preeditAreaText

        **QString QTextLayout::preeditAreaText() const**

        Returns the text that is inserted in the layout before editing occurs.

        **See also** **preeditAreaPosition** ().
        """
        ...

    def preeditAreaPosition(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#preeditAreaPosition

        **int QTextLayout::preeditAreaPosition() const**

        Returns the position of the area in the text layout that will be
        processed before editing occurs.

        **See also** **preeditAreaText** ().
        """
        ...

    def setPreeditArea(self, position: int, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#setPreeditArea

        **void QTextLayout::setPreeditArea(int position , const QString & text
        )**

        Sets the **position** and **text** of the area in the layout that is
        processed before editing occurs. The layout is invalidated and must be
        laid out again.

        **See also** **preeditAreaPosition** () and **preeditAreaText** ().
        """
        ...

    def textOption(self) -> "QTextOption":
        """
        https://doc.qt.io/qt-6/qtextlayout.html#textOption

        **const QTextOption &QTextLayout::textOption() const**

        Returns the current text option used to control the layout process.

        **See also** **setTextOption** ().
        """
        ...

    def setTextOption(self, option: "QTextOption") -> None:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#setTextOption

        **void QTextLayout::setTextOption(const QTextOption & option )**

        Sets the text option structure that controls the layout process to the
        given **option**.

        **See also** **textOption** ().
        """
        ...

    def text(self) -> str:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#text

        **QString QTextLayout::text() const**

        Returns the layout's text.

        **See also** **setText** ().
        """
        ...

    def setText(self, string: str) -> None:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#setText

        **void QTextLayout::setText(const QString & string )**

        Sets the layout's text to the given **string**. The layout is
        invalidated and must be laid out again.

        Notice that when using this **QTextLayout**  as part of a
        **QTextDocument**  this method will have no effect.

        **See also** **text** ().
        """
        ...

    def font(self) -> QFont:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#font

        **QFont QTextLayout::font() const**

        Returns the current font that is used for the layout, or a default font
        if none is set.

        **See also** **setFont** ().
        """
        ...

    def setFont(self, f: QFont) -> None:
        """
        https://doc.qt.io/qt-6/qtextlayout.html#setFont

        **void QTextLayout::setFont(const QFont & font )**

        Sets the layout's font to the given **font**. The layout is invalidated
        and must be laid out again.

        **See also** **font** ().
        """
        ...
