"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtGui import *


class QTextObjectInterface(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qtextobjectinterface.html

    **Detailed Description**

    A text object describes the structure of one or more elements in a text
    document; for instance, images imported from HTML are implemented using text
    objects. A text object knows how to lay out and draw its elements when a
    document is being rendered.

    Qt allows custom text objects to be inserted into a document by registering
    a custom **object type**  with **QTextCharFormat** . A QTextObjectInterface
    must also be implemented for this type and be **registered**  with the
    **QAbstractTextDocumentLayout**  of the document. When the object type is
    encountered while rendering a **QTextDocument** , the **intrinsicSize** ()
    and **drawObject** () functions of the interface are called.

    The following list explains the required steps of inserting a custom text
    object into a document:

    * Choose an **objectType**. The **objectType** is an integer with a value
    greater or equal to **QTextFormat::UserObject** .
      * Create a
    **QTextCharFormat**  object and set the object type to the chosen type using
    the setObjectType() function.
      * Implement the QTextObjectInterface class.
    * Call **QAbstractTextDocumentLayout::registerHandler** () with an instance
    of your QTextObjectInterface subclass to register your object type.
      *
    Insert **QChar::ObjectReplacementCharacter**  with the aforementioned
    **QTextCharFormat**  of the chosen object type into the document. As
    mentioned, the functions of QTextObjectInterface **intrinsicSize** () and
    **drawObject** () will then be called with the **QTextFormat**  as parameter
    whenever the replacement character is encountered.

    A class implementing a text object needs to inherit both **QObject**  and
    QTextObjectInterface. **QObject**  must be the first class inherited. For
    instance:

    class SvgTextObject : public **QObject** , public **QTextObjectInterface**
    {
            Q_OBJECT
            Q_INTERFACES(**QTextObjectInterface** )

    The data of a text object is usually stored in the **QTextCharFormat**
    using **QTextCharFormat::setProperty** (), and then retrieved with
    **QTextCharFormat::property** ().

    **Warning:** Copy and Paste operations ignore custom text objects.

    **See also** **Text Object Example** , **QTextCharFormat** , and
    **QTextLayout** .
    """

    @typing.overload
    def __init__(self) -> None:
        ...

    @typing.overload
    def __init__(self, a0: "QTextObjectInterface") -> None:
        ...

    def drawObject(
        self,
        painter: "QPainter",
        rect: QtCore.QRectF,
        doc: "QTextDocument",
        posInDocument: int,
        format: "QTextFormat",
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtextobjectinterface.html#drawObject

        **[pure virtual] void QTextObjectInterface::drawObject(QPainter *
        painter , const QRectF & rect , QTextDocument * doc , int posInDocument
        , const QTextFormat & format )**

        Draws this text object using the specified **painter**.

        The size of the rectangle, **rect** , to draw in is the size previously
        calculated by **intrinsicSize** (). The rectangles position is relative
        to the **painter**.

        You also get the document ( **doc** ) and the position (
        **posInDocument** ) of the **format** in that document.

        **See also** **intrinsicSize** ().
        """
        ...

    def intrinsicSize(
        self, doc: "QTextDocument", posInDocument: int, format: "QTextFormat"
    ) -> QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qtextobjectinterface.html#intrinsicSize

        **[pure virtual] QSizeF
        QTextObjectInterface::intrinsicSize(QTextDocument * doc , int
        posInDocument , const QTextFormat & format )**

        The intrinsicSize() function returns the size of the text object
        represented by **format** in the given document ( **doc** ) at the given
        position ( **posInDocument** ).

        The size calculated will be used for subsequent calls to **drawObject**
        () for this **format**.

        **See also** **drawObject** ().
        """
        ...
