"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6.QtGui import *


class QTextTableCell(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qtexttablecell.html

    **Detailed Description**

    Table cells are pieces of document structure that belong to a table. The
    table orders cells into particular rows and columns; cells can also span
    multiple columns and rows.

    Cells are usually created when a table is inserted into a document with
    **QTextCursor::insertTable** (), but they are also created and destroyed
    when a table is resized.

    Cells contain information about their location in a table; you can obtain
    the **row** () and **column** () numbers of a cell, and its **rowSpan** ()
    and **columnSpan** ().

    The **format** () of a cell describes the default character format of its
    contents. The **firstCursorPosition** () and **lastCursorPosition** ()
    functions are used to obtain the extent of the cell in the document.

    **See also** **QTextTable**  and **QTextTableFormat** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecell.html#QTextTableCell

        **QTextTableCell::QTextTableCell()**

        Constructs an invalid table cell.

        **See also** **isValid** ().
        """
        ...

    @typing.overload
    def __init__(self, o: "QTextTableCell") -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecell.html#QTextTableCell-1

        **QTextTableCell::QTextTableCell(const QTextTableCell & other )**

        Copy constructor. Creates a new QTextTableCell object based on the
        **other** cell.
        """
        ...

    def tableCellFormatIndex(self) -> int:
        """
        https://doc.qt.io/qt-6/qtexttablecell.html#tableCellFormatIndex

        **int QTextTableCell::tableCellFormatIndex() const**

        Returns the index of the tableCell's format in the document's internal
        list of formats.

        **See also** **QTextDocument::allFormats** ().
        """
        ...

    def lastCursorPosition(self) -> QTextCursor:
        """
        https://doc.qt.io/qt-6/qtexttablecell.html#lastCursorPosition

        **QTextCursor QTextTableCell::lastCursorPosition() const**

        Returns the last valid cursor position in this cell.

        **See also** **firstCursorPosition** ().
        """
        ...

    def firstCursorPosition(self) -> QTextCursor:
        """
        https://doc.qt.io/qt-6/qtexttablecell.html#firstCursorPosition

        **QTextCursor QTextTableCell::firstCursorPosition() const**

        Returns the first valid cursor position in this cell.

        **See also** **lastCursorPosition** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtexttablecell.html#isValid

        **bool QTextTableCell::isValid() const**

        Returns `true` if this is a valid table cell; otherwise returns false.
        """
        ...

    def columnSpan(self) -> int:
        """
        https://doc.qt.io/qt-6/qtexttablecell.html#columnSpan

        **int QTextTableCell::columnSpan() const**

        Returns the number of columns this cell spans. The default is 1.

        **See also** **rowSpan** ().
        """
        ...

    def rowSpan(self) -> int:
        """
        https://doc.qt.io/qt-6/qtexttablecell.html#rowSpan

        **int QTextTableCell::rowSpan() const**

        Returns the number of rows this cell spans. The default is 1.

        **See also** **columnSpan** ().
        """
        ...

    def column(self) -> int:
        """
        https://doc.qt.io/qt-6/qtexttablecell.html#column

        **int QTextTableCell::column() const**

        Returns the number of the column in the table that contains this cell.

        **See also** **row** ().
        """
        ...

    def row(self) -> int:
        """
        https://doc.qt.io/qt-6/qtexttablecell.html#row

        **int QTextTableCell::row() const**

        Returns the number of the row in the table that contains this cell.

        **See also** **column** ().
        """
        ...

    def setFormat(self, format: QTextCharFormat) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecell.html#setFormat

        **void QTextTableCell::setFormat(const QTextCharFormat & format )**

        Sets the cell's character format to **format**. This can for example be
        used to change the background color of the entire cell:

        **QTextTableCell**  cell = table->cellAt(2, 3); **QTextCharFormat**
        format = cell.**format** (); format.setBackground(**Qt::blue** );
        cell.setFormat(format);

        Note that the cell's row or column span cannot be changed through this
        function. You have to use **QTextTable::mergeCells**  and
        **QTextTable::splitCell**  instead.

        **See also** **format** ().
        """
        ...

    def format(self) -> QTextCharFormat:
        """
        https://doc.qt.io/qt-6/qtexttablecell.html#format

        **QTextCharFormat QTextTableCell::format() const**

        Returns the cell's character format.

        **See also** **setFormat** ().
        """
        ...
