"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt6 import QtCore
from PyQt6.QtGui import *


class QTextTableCellFormat(QTextCharFormat):
    """
    https://doc.qt.io/qt-6/qtexttablecellformat.html

    **Detailed Description**

    The table cell format of a table cell in a document specifies the visual
    properties of the table cell.

    The padding properties of a table cell are controlled by **setLeftPadding**
    (), **setRightPadding** (), **setTopPadding** (), and **setBottomPadding**
    (). All the paddings can be set at once using **setPadding** ().

    **See also** **QTextFormat** , **QTextBlockFormat** , **QTextTableFormat** ,
    and **QTextCharFormat** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#QTextTableCellFormat

        **QTextTableCellFormat::QTextTableCellFormat()**

        Constructs a new table cell format object.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QTextTableCellFormat") -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#QTextTableCellFormat

        **QTextTableCellFormat::QTextTableCellFormat()**

        Constructs a new table cell format object.
        """
        ...

    def setBorderBrush(
        self, brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, int, QGradient]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setBorderBrush

        **[since 5.14] void QTextTableCellFormat::setBorderBrush(const QBrush &
        brush )**

        Sets the left, right, top, and bottom border **brush** of the table
        cell.

        This function was introduced in Qt 5.14.

        **See also** **setLeftBorderBrush** (), **setRightBorderBrush** (),
        **setTopBorderBrush** (), **setBottomBorderBrush** (), and
        **QTextTableFormat::setBorderCollapse** .
        """
        ...

    def rightBorderBrush(self) -> QBrush:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#rightBorderBrush

        **[since 5.14] QBrush QTextTableCellFormat::rightBorderBrush() const**

        Returns the right border brush of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **setRightBorderBrush** ().
        """
        ...

    def setRightBorderBrush(
        self, brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, int, QGradient]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setRightBorderBrush

        **[since 5.14] void QTextTableCellFormat::setRightBorderBrush(const
        QBrush & brush )**

        Sets the right border **brush** of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **rightBorderBrush** () and
        **QTextTableFormat::setBorderCollapse** .
        """
        ...

    def leftBorderBrush(self) -> QBrush:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#leftBorderBrush

        **[since 5.14] QBrush QTextTableCellFormat::leftBorderBrush() const**

        Returns the left border brush of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **setLeftBorderBrush** ().
        """
        ...

    def setLeftBorderBrush(
        self, brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, int, QGradient]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setLeftBorderBrush

        **[since 5.14] void QTextTableCellFormat::setLeftBorderBrush(const
        QBrush & brush )**

        Sets the left border **brush** of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **leftBorderBrush** () and
        **QTextTableFormat::setBorderCollapse** .
        """
        ...

    def bottomBorderBrush(self) -> QBrush:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#bottomBorderBrush

        **[since 5.14] QBrush QTextTableCellFormat::bottomBorderBrush() const**

        Returns the bottom border brush of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **setBottomBorderBrush** ().
        """
        ...

    def setBottomBorderBrush(
        self, brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, int, QGradient]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setBottomBorderBrush

        **[since 5.14] void QTextTableCellFormat::setBottomBorderBrush(const
        QBrush & brush )**

        Sets the bottom border **brush** of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **bottomBorderBrush** () and
        **QTextTableFormat::setBorderCollapse** .
        """
        ...

    def topBorderBrush(self) -> QBrush:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#topBorderBrush

        **[since 5.14] QBrush QTextTableCellFormat::topBorderBrush() const**

        Returns the top border brush of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **setTopBorderBrush** ().
        """
        ...

    def setTopBorderBrush(
        self, brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, int, QGradient]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setTopBorderBrush

        **[since 5.14] void QTextTableCellFormat::setTopBorderBrush(const QBrush
        & brush )**

        Sets the top border **brush** of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **topBorderBrush** () and
        **QTextTableFormat::setBorderCollapse** .
        """
        ...

    def setBorderStyle(self, style: QTextFrameFormat.BorderStyle) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setBorderStyle

        **[since 5.14] void
        QTextTableCellFormat::setBorderStyle(QTextFrameFormat::BorderStyle style
        )**

        Sets the left, right, top, and bottom border **style** of the table
        cell.

        This function was introduced in Qt 5.14.

        **See also** **setLeftBorderStyle** (), **setRightBorderStyle** (),
        **setTopBorderStyle** (), **setBottomBorderStyle** (), and
        **QTextTableFormat::setBorderCollapse** .
        """
        ...

    def rightBorderStyle(self) -> QTextFrameFormat.BorderStyle:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#rightBorderStyle

        **[since 5.14] QTextFrameFormat::BorderStyle
        QTextTableCellFormat::rightBorderStyle() const**

        Returns the right border style of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **setRightBorderStyle** ().
        """
        ...

    def setRightBorderStyle(self, style: QTextFrameFormat.BorderStyle) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setRightBorderStyle

        **[since 5.14] void
        QTextTableCellFormat::setRightBorderStyle(QTextFrameFormat::BorderStyle
        style )**

        Sets the right border **style** of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **rightBorderStyle** () and
        **QTextTableFormat::setBorderCollapse** .
        """
        ...

    def leftBorderStyle(self) -> QTextFrameFormat.BorderStyle:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#leftBorderStyle

        **[since 5.14] QTextFrameFormat::BorderStyle
        QTextTableCellFormat::leftBorderStyle() const**

        Returns the left border style of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **setLeftBorderStyle** ().
        """
        ...

    def setLeftBorderStyle(self, style: QTextFrameFormat.BorderStyle) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setLeftBorderStyle

        **[since 5.14] void
        QTextTableCellFormat::setLeftBorderStyle(QTextFrameFormat::BorderStyle
        style )**

        Sets the left border **style** of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **leftBorderStyle** () and
        **QTextTableFormat::setBorderCollapse** .
        """
        ...

    def bottomBorderStyle(self) -> QTextFrameFormat.BorderStyle:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#bottomBorderStyle

        **[since 5.14] QTextFrameFormat::BorderStyle
        QTextTableCellFormat::bottomBorderStyle() const**

        Returns the bottom border style of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **setBottomBorderStyle** ().
        """
        ...

    def setBottomBorderStyle(self, style: QTextFrameFormat.BorderStyle) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setBottomBorderStyle

        **[since 5.14] void
        QTextTableCellFormat::setBottomBorderStyle(QTextFrameFormat::BorderStyle
        style )**

        Sets the bottom border **style** of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **bottomBorderStyle** () and
        **QTextTableFormat::setBorderCollapse** .
        """
        ...

    def topBorderStyle(self) -> QTextFrameFormat.BorderStyle:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#topBorderStyle

        **[since 5.14] QTextFrameFormat::BorderStyle
        QTextTableCellFormat::topBorderStyle() const**

        Returns the top border style of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **setTopBorderStyle** ().
        """
        ...

    def setTopBorderStyle(self, style: QTextFrameFormat.BorderStyle) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setTopBorderStyle

        **[since 5.14] void
        QTextTableCellFormat::setTopBorderStyle(QTextFrameFormat::BorderStyle
        style )**

        Sets the top border **style** of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **topBorderStyle** () and
        **QTextTableFormat::setBorderCollapse** .
        """
        ...

    def setBorder(self, width: float) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setBorder

        **[since 5.14] void QTextTableCellFormat::setBorder(qreal width )**

        Sets the left, right, top, and bottom border **width** of the table
        cell.

        This function was introduced in Qt 5.14.

        **See also** **setLeftBorder** (), **setRightBorder** (),
        **setTopBorder** (), **setBottomBorder** (), and
        **QTextTableFormat::setBorderCollapse** .
        """
        ...

    def rightBorder(self) -> float:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#rightBorder

        **[since 5.14] qreal QTextTableCellFormat::rightBorder() const**

        Returns the right border width of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **setRightBorder** ().
        """
        ...

    def setRightBorder(self, width: float) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setRightBorder

        **[since 5.14] void QTextTableCellFormat::setRightBorder(qreal width )**

        Sets the right border **width** of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **rightBorder** () and
        **QTextTableFormat::setBorderCollapse** .
        """
        ...

    def leftBorder(self) -> float:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#leftBorder

        **[since 5.14] qreal QTextTableCellFormat::leftBorder() const**

        Returns the left border width of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **setLeftBorder** ().
        """
        ...

    def setLeftBorder(self, width: float) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setLeftBorder

        **[since 5.14] void QTextTableCellFormat::setLeftBorder(qreal width )**

        Sets the left border **width** of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **leftBorder** () and
        **QTextTableFormat::setBorderCollapse** .
        """
        ...

    def bottomBorder(self) -> float:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#bottomBorder

        **[since 5.14] qreal QTextTableCellFormat::bottomBorder() const**

        Returns the bottom border width of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **setBottomBorder** ().
        """
        ...

    def setBottomBorder(self, width: float) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setBottomBorder

        **[since 5.14] void QTextTableCellFormat::setBottomBorder(qreal width
        )**

        Sets the bottom border **width** of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **bottomBorder** () and
        **QTextTableFormat::setBorderCollapse** .
        """
        ...

    def topBorder(self) -> float:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#topBorder

        **[since 5.14] qreal QTextTableCellFormat::topBorder() const**

        Returns the top border width of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **setTopBorder** ().
        """
        ...

    def setTopBorder(self, width: float) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setTopBorder

        **[since 5.14] void QTextTableCellFormat::setTopBorder(qreal width )**

        Sets the top border **width** of the table cell.

        This function was introduced in Qt 5.14.

        **See also** **topBorder** () and
        **QTextTableFormat::setBorderCollapse** .
        """
        ...

    def setPadding(self, padding: float) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setPadding

        **void QTextTableCellFormat::setPadding(qreal padding )**

        Sets the left, right, top, and bottom **padding** of the table cell.

        **See also** **setLeftPadding** (), **setRightPadding** (),
        **setTopPadding** (), and **setBottomPadding** ().
        """
        ...

    def rightPadding(self) -> float:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#rightPadding

        **qreal QTextTableCellFormat::rightPadding() const**

        Gets the right padding of the table cell.

        **See also** **setRightPadding** (), **leftPadding** (), **topPadding**
        (), and **bottomPadding** ().
        """
        ...

    def setRightPadding(self, padding: float) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setRightPadding

        **void QTextTableCellFormat::setRightPadding(qreal padding )**

        Sets the right **padding** of the table cell.

        **See also** **rightPadding** (), **setLeftPadding** (),
        **setTopPadding** (), and **setBottomPadding** ().
        """
        ...

    def leftPadding(self) -> float:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#leftPadding

        **qreal QTextTableCellFormat::leftPadding() const**

        Gets the left padding of the table cell.

        **See also** **setLeftPadding** (), **rightPadding** (), **topPadding**
        (), and **bottomPadding** ().
        """
        ...

    def setLeftPadding(self, padding: float) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setLeftPadding

        **void QTextTableCellFormat::setLeftPadding(qreal padding )**

        Sets the left **padding** of the table cell.

        **See also** **leftPadding** (), **setRightPadding** (),
        **setTopPadding** (), and **setBottomPadding** ().
        """
        ...

    def bottomPadding(self) -> float:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#bottomPadding

        **qreal QTextTableCellFormat::bottomPadding() const**

        Gets the bottom padding of the table cell.

        **See also** **setBottomPadding** (), **leftPadding** (),
        **rightPadding** (), and **topPadding** ().
        """
        ...

    def setBottomPadding(self, padding: float) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setBottomPadding

        **void QTextTableCellFormat::setBottomPadding(qreal padding )**

        Sets the bottom **padding** of the table cell.

        **See also** **bottomPadding** (), **setLeftPadding** (),
        **setRightPadding** (), and **setTopPadding** ().
        """
        ...

    def topPadding(self) -> float:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#topPadding

        **qreal QTextTableCellFormat::topPadding() const**

        Gets the top padding of the table cell.

        **See also** **setTopPadding** (), **leftPadding** (), **rightPadding**
        (), and **bottomPadding** ().
        """
        ...

    def setTopPadding(self, padding: float) -> None:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#setTopPadding

        **void QTextTableCellFormat::setTopPadding(qreal padding )**

        Sets the top **padding** of the table cell.

        **See also** **topPadding** (), **setLeftPadding** (),
        **setRightPadding** (), and **setBottomPadding** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtexttablecellformat.html#isValid

        **bool QTextTableCellFormat::isValid() const**

        Returns `true` if this table cell format is valid; otherwise returns
        `false`.
        """
        ...
