"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6 import QtCore


class QHelpSearchResult(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qhelpsearchresult.html

    **Detailed Description**

    The QHelpSearchResult object is a data object that describes a single search
    result. The vector of search result objects is returned by
    **QHelpSearchEngine::searchResults** (). The description of the search
    result contains the document title and URL that the search input matched. It
    also contains the snippet from the document content containing the best
    match of the search input.

    **See also** **QHelpSearchEngine** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qhelpsearchresult.html#QHelpSearchResult

        **QHelpSearchResult::QHelpSearchResult()**

        Constructs a new empty QHelpSearchResult.
        """
        ...

    @typing.overload
    def __init__(self, other: "QHelpSearchResult") -> None:
        """
        https://doc.qt.io/qt-6/qhelpsearchresult.html#QHelpSearchResult-1

        **QHelpSearchResult::QHelpSearchResult(const QHelpSearchResult & other
        )**

        Constructs a copy of **other**.
        """
        ...

    @typing.overload
    def __init__(self, url: QtCore.QUrl, title: str, snippet: str) -> None:
        """
        https://doc.qt.io/qt-6/qhelpsearchresult.html#QHelpSearchResult-2

        **QHelpSearchResult::QHelpSearchResult(const QUrl & url , const QString
        & title , const QString & snippet )**

        Constructs the search result containing **url** , **title** and
        **snippet** as the description of the result.
        """
        ...

    def snippet(self) -> str:
        """
        https://doc.qt.io/qt-6/qhelpsearchresult.html#snippet

        **QString QHelpSearchResult::snippet() const**

        Returns the document snippet containing the search phrase of the search
        result.
        """
        ...

    def url(self) -> QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qhelpsearchresult.html#url

        **QUrl QHelpSearchResult::url() const**

        Returns the document URL of the search result.
        """
        ...

    def title(self) -> str:
        """
        https://doc.qt.io/qt-6/qhelpsearchresult.html#title

        **QString QHelpSearchResult::title() const**

        Returns the document title of the search result.
        """
        ...
