"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6.QtMultimedia import *
import enum


class QAudioFormat(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qaudioformat.html

    **Detailed Description**

    An audio format specifies how data in a raw audio stream is arranged. For
    example, how the stream is to be interpreted.

    QAudioFormat contains parameters that specify how the audio sample data is
    arranged. These are the frequency, the number of channels, and the sample
    format. The following table describes these in more detail.

    ParameterDescription
    Sample RateSamples per second of audio data in Hertz.
    Number of channelsThe number of audio channels (typically one for mono or
    two for stereo). These are the amount of consecutive samples that together
    form one frame in the stream
    Sample formatThe format of the audio samples
    in the stream

    This class is used in conjunction with **QAudioSource**  or **QAudioSink**
    to allow you to specify the parameters of the audio stream being read or
    written, or with **QAudioBuffer**  when dealing with samples in memory.

    You can obtain audio formats compatible with the audio device used through
    functions in **QAudioDevice** . This class also lets you query available
    parameter values for a device, so that you can set the parameters yourself.
    See the **QAudioDevice**  class description for details. You need to know
    the format of the audio streams you wish to play or record.

    Samples for all channels will be interleaved. One sample for each channel
    for the same instant in time is referred to as a frame in Qt Multimedia (and
    other places).
    """

    class SampleFormat(enum.Enum):
        Unknown: QAudioFormat = ...
        UInt8: QAudioFormat = ...
        Int16: QAudioFormat = ...
        Int32: QAudioFormat = ...
        Float: QAudioFormat = ...

    class ChannelConfig(enum.Enum):
        ChannelConfigUnknown: QAudioFormat = ...
        ChannelConfigMono: QAudioFormat = ...
        ChannelConfigStereo: QAudioFormat = ...
        ChannelConfig2Dot1: QAudioFormat = ...
        ChannelConfigSurround5Dot0: QAudioFormat = ...
        ChannelConfigSurround5Dot1: QAudioFormat = ...
        ChannelConfigSurround7Dot0: QAudioFormat = ...
        ChannelConfigSurround7Dot1: QAudioFormat = ...

    class AudioChannelPosition(enum.Enum):
        UnknownPosition: QAudioFormat = ...
        FrontLeft: QAudioFormat = ...
        FrontRight: QAudioFormat = ...
        FrontCenter: QAudioFormat = ...
        LFE: QAudioFormat = ...
        BackLeft: QAudioFormat = ...
        BackRight: QAudioFormat = ...
        FrontLeftOfCenter: QAudioFormat = ...
        FrontRightOfCenter: QAudioFormat = ...
        BackCenter: QAudioFormat = ...
        LFE2: QAudioFormat = ...
        SideLeft: QAudioFormat = ...
        SideRight: QAudioFormat = ...
        TopFrontLeft: QAudioFormat = ...
        TopFrontRight: QAudioFormat = ...
        TopFrontCenter: QAudioFormat = ...
        TopCenter: QAudioFormat = ...
        TopBackLeft: QAudioFormat = ...
        TopBackRight: QAudioFormat = ...
        TopSideLeft: QAudioFormat = ...
        TopSideRight: QAudioFormat = ...
        TopBackCenter: QAudioFormat = ...
        BottomFrontCenter: QAudioFormat = ...
        BottomFrontLeft: QAudioFormat = ...
        BottomFrontRight: QAudioFormat = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qaudioformat.html#QAudioFormat

        **[default] QAudioFormat::QAudioFormat()**

        Constructs a new audio format.

        Values are initialized as follows:

        * **sampleRate** () = 0
          * **channelCount** () = 0
          * **sampleFormat**
        () = **QAudioFormat::Unknown**
        """
        ...

    @typing.overload
    def __init__(self, a0: "QAudioFormat") -> None:
        """
        https://doc.qt.io/qt-6/qaudioformat.html#QAudioFormat-1

        **[default] QAudioFormat::QAudioFormat(const QAudioFormat & other )**

        Construct a new audio format using **other**.
        """
        ...

    def normalizedSampleValue(self, sample: PyQt6.sip.voidptr) -> float:
        """
        https://doc.qt.io/qt-6/qaudioformat.html#normalizedSampleValue

        **float QAudioFormat::normalizedSampleValue(const void * sample )
        const**

        Normalizes the **sample** value to a number between -1 and 1. The method
        depends on the QaudioFormat.
        """
        ...

    def bytesPerSample(self) -> int:
        """
        https://doc.qt.io/qt-6/qaudioformat.html#bytesPerSample

        **int QAudioFormat::bytesPerSample() const**

        Returns the number of bytes required to represent one sample in this
        format.

        Returns 0 if this format is invalid.
        """
        ...

    def sampleFormat(self) -> "QAudioFormat.SampleFormat":
        """
        https://doc.qt.io/qt-6/qaudioformat.html#sampleFormat

        **QAudioFormat::SampleFormat QAudioFormat::sampleFormat() const**

        Returns the current sample format.

        **See also** **setSampleFormat** ().
        """
        ...

    def setSampleFormat(self, f: "QAudioFormat.SampleFormat") -> None:
        """
        https://doc.qt.io/qt-6/qaudioformat.html#setSampleFormat

        **void QAudioFormat::setSampleFormat(QAudioFormat::SampleFormat format
        )**

        Sets the sample format to **format**.

        **See also** **sampleFormat** () and **QAudioFormat::SampleFormat** .
        """
        ...

    def channelOffset(self, channel: "QAudioFormat.AudioChannelPosition") -> int:
        """
        https://doc.qt.io/qt-6/qaudioformat.html#channelOffset

        **int QAudioFormat::channelOffset(QAudioFormat::AudioChannelPosition
        channel ) const**

        Returns the position of a certain audio **channel** inside an audio
        frame for the given format. Returns -1 if the channel does not exist for
        this format or the channel configuration is unknown.
        """
        ...

    def channelConfig(self) -> "QAudioFormat.ChannelConfig":
        """
        https://doc.qt.io/qt-6/qaudioformat.html#channelConfig-1

        **QAudioFormat::ChannelConfig QAudioFormat::channelConfig() const**

        Returns the current channel configuration.
        """
        ...

    def setChannelConfig(self, config: "QAudioFormat.ChannelConfig") -> None:
        """
        https://doc.qt.io/qt-6/qaudioformat.html#setChannelConfig

        **void QAudioFormat::setChannelConfig(QAudioFormat::ChannelConfig config
        )**

        Sets the channel configuration to **config**.

        Sets the channel configuration of the audio format to one of the
        standard audio channel configurations.

        **Note:** that this will also modify the channel count.

        **See also** **channelConfig** ().
        """
        ...

    def bytesPerFrame(self) -> int:
        """
        https://doc.qt.io/qt-6/qaudioformat.html#bytesPerFrame

        **int QAudioFormat::bytesPerFrame() const**

        Returns the number of bytes required to represent one frame (a sample in
        each channel) in this format.

        Returns 0 if this format is invalid.
        """
        ...

    def durationForFrames(self, frameCount: int) -> int:
        """
        https://doc.qt.io/qt-6/qaudioformat.html#durationForFrames

        **qint64 QAudioFormat::durationForFrames(qint32 frameCount ) const**

        Return the number of microseconds represented by **frameCount** frames
        in this format.
        """
        ...

    def framesForDuration(self, duration: int) -> int:
        """
        https://doc.qt.io/qt-6/qaudioformat.html#framesForDuration

        **qint32 QAudioFormat::framesForDuration(qint64 microseconds ) const**

        Returns the number of frames required to represent **microseconds** in
        this format.

        Note that some rounding may occur if **microseconds** is not an exact
        fraction of the **sampleRate** ().
        """
        ...

    def framesForBytes(self, byteCount: int) -> int:
        """
        https://doc.qt.io/qt-6/qaudioformat.html#framesForBytes

        **qint32 QAudioFormat::framesForBytes(qint32 byteCount ) const**

        Returns the number of frames represented by **byteCount** in this
        format.

        Note that some rounding may occur if **byteCount** is not an exact
        multiple of the number of bytes per frame.

        Each frame has one sample per channel.

        **See also** **framesForDuration** ().
        """
        ...

    def bytesForFrames(self, frameCount: int) -> int:
        """
        https://doc.qt.io/qt-6/qaudioformat.html#bytesForFrames

        **qint32 QAudioFormat::bytesForFrames(qint32 frameCount ) const**

        Returns the number of bytes required for **frameCount** frames of this
        format.

        Returns 0 if this format is not valid.

        **See also** **bytesForDuration** ().
        """
        ...

    def durationForBytes(self, byteCount: int) -> int:
        """
        https://doc.qt.io/qt-6/qaudioformat.html#durationForBytes

        **qint64 QAudioFormat::durationForBytes(qint32 bytes ) const**

        Returns the number of microseconds represented by **bytes** in this
        format.

        Returns 0 if this format is not valid.

        Note that some rounding may occur if **bytes** is not an exact multiple
        of the number of bytes per frame.

        **See also** **bytesForDuration** ().
        """
        ...

    def bytesForDuration(self, duration: int) -> int:
        """
        https://doc.qt.io/qt-6/qaudioformat.html#bytesForDuration

        **qint32 QAudioFormat::bytesForDuration(qint64 microseconds ) const**

        Returns the number of bytes required for this audio format for
        **microseconds**.

        Returns 0 if this format is not valid.

        Note that some rounding may occur if **microseconds** is not an exact
        fraction of the **sampleRate** ().

        **See also** **durationForBytes** ().
        """
        ...

    def channelCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qaudioformat.html#channelCount

        **int QAudioFormat::channelCount() const**

        Returns the current channel count value.

        **See also** **setChannelCount** ().
        """
        ...

    def setChannelCount(self, channelCount: int) -> None:
        """
        https://doc.qt.io/qt-6/qaudioformat.html#setChannelCount

        **void QAudioFormat::setChannelCount(int channels )**

        Sets the channel count to **channels**. Setting this also sets the
        channel config to **ChannelConfigUnknown** .

        **See also** **channelCount** ().
        """
        ...

    def sampleRate(self) -> int:
        """
        https://doc.qt.io/qt-6/qaudioformat.html#sampleRate

        **int QAudioFormat::sampleRate() const**

        Returns the current sample rate in Hertz.

        **See also** **setSampleRate** ().
        """
        ...

    def setSampleRate(self, sampleRate: int) -> None:
        """
        https://doc.qt.io/qt-6/qaudioformat.html#setSampleRate

        **void QAudioFormat::setSampleRate(int samplerate )**

        Sets the sample rate to **samplerate** in Hertz.

        **See also** **sampleRate** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qaudioformat.html#isValid

        **bool QAudioFormat::isValid() const**

        Returns `true` if all of the parameters are valid.
        """
        ...
