"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtMultimedia import *


class QAudioOutput(QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qaudiooutput.html

    **Detailed Description**

    This class represents an output channel that can be used together with
    **QMediaPlayer**  or **QMediaCaptureSession** . It enables the selection of
    the physical output device to be used, muting the channel, and changing the
    channel's volume.
    """

    @typing.overload
    def __init__(
        self, device: QAudioDevice, parent: typing.Optional[QtCore.QObject] = ...
    ) -> None:
        ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        ...

    def setMuted(self, muted: bool) -> None:
        """
        https://doc.qt.io/qt-6/qaudiooutput.html#muted-prop

        **muted : bool**

        This property holds the muted state of the current media.

        The value will be `true` if the output is muted; otherwise `false`.

        **Access functions:**

        bool **isMuted** () const
        void **setMuted** (bool **muted** )

        **Notifier signal:**

        void **mutedChanged** (bool **muted** )
        """
        ...

    def setVolume(self, volume: float) -> None:
        """
        https://doc.qt.io/qt-6/qaudiooutput.html#volume-prop

        **volume : float**

        This property holds the current volume.

        The volume is scaled linearly, ranging from `0` (silence) to `1` (full
        volume).

        **Note:** values outside this range will be clamped.

        By default the volume is `1`.

        UI volume controls should usually be scaled non-linearly. For example,
        using a logarithmic scale will produce linear changes in perceived
        loudness, which is what a user would normally expect from a volume
        control.

        **Access functions:**

        float **volume** () const
        void **setVolume** (float **volume** )

        **Notifier signal:**

        void **volumeChanged** (float **volume** )

        **See also** **QAudio::convertVolume** ().
        """
        ...

    def setDevice(self, device: QAudioDevice) -> None:
        """
        https://doc.qt.io/qt-6/qaudiooutput.html#device-prop

        **device : QAudioDevice**

        This property holds the audio device connected to this output.

        The device property represents the audio device this output is connected
        to. This property can be used to select an output device from the
        **QMediaDevices::audioOutputs** () list. You can select the system
        default audio output by setting this property to a default constructed
        **QAudioDevice**  object.

        **Access functions:**

        QAudioDevice **device** () const
        void **setDevice** (const
        QAudioDevice & **device** )

        **Notifier signal:**

        void **deviceChanged** ()
        """
        ...

    def isMuted(self) -> bool:
        ...

    def device(self) -> QAudioDevice:
        """
        https://doc.qt.io/qt-6/qaudiooutput.html#device-prop

        **device : QAudioDevice**

        This property holds the audio device connected to this output.

        The device property represents the audio device this output is connected
        to. This property can be used to select an output device from the
        **QMediaDevices::audioOutputs** () list. You can select the system
        default audio output by setting this property to a default constructed
        **QAudioDevice**  object.

        **Access functions:**

        QAudioDevice **device** () const
        void **setDevice** (const
        QAudioDevice & **device** )

        **Notifier signal:**

        void **deviceChanged** ()
        """
        ...

    def volume(self) -> float:
        """
        https://doc.qt.io/qt-6/qaudiooutput.html#volume-prop

        **volume : float**

        This property holds the current volume.

        The volume is scaled linearly, ranging from `0` (silence) to `1` (full
        volume).

        **Note:** values outside this range will be clamped.

        By default the volume is `1`.

        UI volume controls should usually be scaled non-linearly. For example,
        using a logarithmic scale will produce linear changes in perceived
        loudness, which is what a user would normally expect from a volume
        control.

        **Access functions:**

        float **volume** () const
        void **setVolume** (float **volume** )

        **Notifier signal:**

        void **volumeChanged** (float **volume** )

        **See also** **QAudio::convertVolume** ().
        """
        ...

    @property
    def deviceChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        ...

    @property
    def mutedChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        ...

    @property
    def volumeChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        ...
