"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtMultimedia import *


class QAudioSink(QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qaudiosink.html

    **Detailed Description**

    You can construct an audio output with the system's default audio output
    device. It is also possible to create QAudioSink with a specific
    **QAudioDevice** . When you create the audio output, you should also send in
    the **QAudioFormat**  to be used for the playback (see the **QAudioFormat**
    class description for details).

    To play a file:

    Starting to play an audio stream is simply a matter of calling **start** ()
    with a **QIODevice** . QAudioSink will then fetch the data it needs from the
    io device. So playing back an audio file is as simple as:

    **QFile**  sourceFile;   // class member.
        **QAudioSink** * audio; //
    class member.
        {
            sourceFile.setFileName("/tmp/test.raw");
    sourceFile.open(**QIODevice** ::ReadOnly);

            **QAudioFormat**
    format;
            // Set up the format, eg.
    format.setSampleRate(8000);
            format.setChannelCount(1);
    format.setSampleFormat(**QAudioFormat** ::UInt8);
    **QAudioDevice**  info(**QAudioDevice** ::defaultOutputDevice());
            if
    (!info.isFormatSupported(format)) {
                **qWarning** () << "Raw
    audio format not supported by backend, cannot play audio.";
    return;
            }

            audio = new **QAudioSink** (format, this);
    connect(audio, SIGNAL(stateChanged(QAudio::State)), this,
    SLOT(handleStateChanged(QAudio::State)));
            audio->start(&sourceFile);
    }

    The file will start playing assuming that the audio system and output device
    support it. If you run out of luck, check what's up with the **error** ()
    function.

    After the file has finished playing, we need to stop the device:

    void AudioOutputExample::handleStateChanged(QAudio::State newState)
        {
    switch (newState) {
                case QAudio::IdleState:
                    //
    Finished playing (no more data)
                    audio->stop();
    sourceFile.close();
                    delete audio;
                    break;
    case QAudio::StoppedState:
                    // Stopped for other reasons
    if (audio->error() != QAudio::NoError) {
                        // Error
    handling
                    }
                    break;

                default:
    // ... other cases as appropriate
                    break;
            }
        }

    At any given time, the QAudioSink will be in one of four states: active,
    suspended, stopped, or idle. These states are described by the
    **QAudio::State**  enum. State changes are reported through the
    **stateChanged** () signal. You can use this signal to, for instance, update
    the GUI of the application; the mundane example here being changing the
    state of a `play/pause` button. You request a state change directly with
    **suspend** (), **stop** (), **reset** (), **resume** (), and **start** ().

    If an error occurs, you can fetch the **error type**  with the **error** ()
    function. Please see the **QAudio::Error**  enum for a description of the
    possible errors that are reported. When an error is encountered, the state
    changes to **QAudio::StoppedState** . You can check for errors by connecting
    to the **stateChanged** () signal:

    void AudioOutputExample::handleStateChanged(QAudio::State newState)
        {
    switch (newState) {
                case QAudio::IdleState:
                    //
    Finished playing (no more data)
                    audio->stop();
    sourceFile.close();
                    delete audio;
                    break;
    case QAudio::StoppedState:
                    // Stopped for other reasons
    if (audio->error() != QAudio::NoError) {
                        // Error
    handling
                    }
                    break;

                default:
    // ... other cases as appropriate
                    break;
            }
        }

    **See also** **QAudioSource**  and **QAudioDevice** .
    """

    @typing.overload
    def __init__(
        self,
        audioDeviceInfo: QAudioDevice,
        format: QAudioFormat = ...,
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qaudiosink.html#QAudioSink

        **QAudioSink::QAudioSink(const QAudioFormat & format = QAudioFormat(),
        QObject * parent = nullptr)**

        Construct a new audio output and attach it to **parent**. The default
        audio output device is used with the output **format** parameters.
        """
        ...

    @typing.overload
    def __init__(
        self, format: QAudioFormat = ..., parent: typing.Optional[QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qaudiosink.html#QAudioSink-1

        **QAudioSink::QAudioSink(const QAudioDevice & audioDevice , const
        QAudioFormat & format = QAudioFormat(), QObject * parent = nullptr)**

        Construct a new audio output and attach it to **parent**. The device
        referenced by **audioDevice** is used with the output **format**
        parameters.
        """
        ...

    def volume(self) -> float:
        """
        https://doc.qt.io/qt-6/qaudiosink.html#volume

        **qreal QAudioSink::volume() const**

        Returns the volume between 0.0 and 1.0 inclusive.

        **See also** **setVolume** ().
        """
        ...

    def setVolume(self, a0: float) -> None:
        """
        https://doc.qt.io/qt-6/qaudiosink.html#setVolume

        **void QAudioSink::setVolume(qreal volume )**

        Sets the output volume to **volume**.

        The volume is scaled linearly from `0.0` (silence) to `1.0` (full
        volume). Values outside this range will be clamped.

        The default volume is `1.0`.

        **Note:** Adjustments to the volume will change the volume of this audio
        stream, not the global volume.

        UI volume controls should usually be scaled non-linearly. For example,
        using a logarithmic scale will produce linear changes in perceived
        loudness, which is what a user would normally expect from a volume
        control. See **QAudio::convertVolume** () for more details.

        **See also** **volume** ().
        """
        ...

    def state(self) -> QAudio.State:
        """
        https://doc.qt.io/qt-6/qaudiosink.html#state

        **QAudio::State QAudioSink::state() const**

        Returns the state of audio processing.
        """
        ...

    def error(self) -> QAudio.Error:
        """
        https://doc.qt.io/qt-6/qaudiosink.html#error

        **QAudio::Error QAudioSink::error() const**

        Returns the error state.
        """
        ...

    def elapsedUSecs(self) -> int:
        """
        https://doc.qt.io/qt-6/qaudiosink.html#elapsedUSecs

        **qint64 QAudioSink::elapsedUSecs() const**

        Returns the microseconds since **start** () was called, including time
        in Idle and Suspend states.
        """
        ...

    def processedUSecs(self) -> int:
        """
        https://doc.qt.io/qt-6/qaudiosink.html#processedUSecs

        **qint64 QAudioSink::processedUSecs() const**

        Returns the amount of audio data processed since **start** () was called
        (in microseconds).
        """
        ...

    def bytesFree(self) -> int:
        """
        https://doc.qt.io/qt-6/qaudiosink.html#bytesFree

        **qsizetype QAudioSink::bytesFree() const**

        Returns the number of free bytes available in the audio buffer.

        **Note:** The returned value is only valid while in
        **QAudio::ActiveState**  or **QAudio::IdleState**  state, otherwise
        returns zero.
        """
        ...

    def bufferSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qaudiosink.html#bufferSize

        **qsizetype QAudioSink::bufferSize() const**

        Returns the audio buffer size in bytes.

        If called before **start** (), returns platform default value. If called
        before **start** () but **setBufferSize** () was called prior, returns
        value set by **setBufferSize** (). If called after **start** (), returns
        the actual buffer size being used. This may not be what was set
        previously by **setBufferSize** ().

        **See also** **setBufferSize** ().
        """
        ...

    def setBufferSize(self, bytes: int) -> None:
        """
        https://doc.qt.io/qt-6/qaudiosink.html#setBufferSize

        **void QAudioSink::setBufferSize(qsizetype value )**

        Sets the audio buffer size to **value** in bytes.

        **Note:** This function can be called anytime before **start** (). Calls
        to this are ignored after **start** (). It should not be assumed that
        the buffer size set is the actual buffer size used - call **bufferSize**
        () anytime after **start** () to return the actual buffer size being
        used.

        **See also** **bufferSize** ().
        """
        ...

    def resume(self) -> None:
        """
        https://doc.qt.io/qt-6/qaudiosink.html#resume

        **void QAudioSink::resume()**

        Resumes processing audio data after a **suspend** ().

        Sets **error** () to **QAudio::NoError** . Sets **state** () to
        **QAudio::ActiveState**  if you previously called start(**QIODevice**
        *). Sets **state** () to **QAudio::IdleState**  if you previously called
        **start** (). emits **stateChanged** () signal.
        """
        ...

    def suspend(self) -> None:
        """
        https://doc.qt.io/qt-6/qaudiosink.html#suspend

        **void QAudioSink::suspend()**

        Stops processing audio data, preserving buffered audio data.

        Sets **error** () to **QAudio::NoError** , **state** () to
        **QAudio::SuspendedState**  and emits **stateChanged** () signal.
        """
        ...

    def reset(self) -> None:
        """
        https://doc.qt.io/qt-6/qaudiosink.html#reset

        **void QAudioSink::reset()**

        Drops all audio data in the buffers, resets buffers to zero.
        """
        ...

    def stop(self) -> None:
        """
        https://doc.qt.io/qt-6/qaudiosink.html#stop

        **void QAudioSink::stop()**

        Stops the audio output, detaching from the system resource.

        Sets **error** () to **QAudio::NoError** , **state** () to
        **QAudio::StoppedState**  and emit **stateChanged** () signal.
        """
        ...

    @typing.overload
    def start(self, device: QtCore.QIODevice) -> None:
        """
        https://doc.qt.io/qt-6/qaudiosink.html#start

        **void QAudioSink::start(QIODevice * device )**

        Starts transferring audio data from the **device** to the system's audio
        output. The **device** must have been opened in the **ReadOnly**  or
        **ReadWrite**  modes.

        If the **QAudioSink**  is able to successfully output audio data,
        **state** () returns **QAudio::ActiveState** , **error** () returns
        **QAudio::NoError**  and the **stateChanged** () signal is emitted.

        If a problem occurs during this process, **error** () returns
        **QAudio::OpenError** , **state** () returns **QAudio::StoppedState**
        and the **stateChanged** () signal is emitted.

        **See also** **QIODevice** .
        """
        ...

    @typing.overload
    def start(self) -> QtCore.QIODevice:
        """
        https://doc.qt.io/qt-6/qaudiosink.html#start-1

        **QIODevice *QAudioSink::start()**

        Returns a pointer to the internal **QIODevice**  being used to transfer
        data to the system's audio output. The device will already be open and
        **write** () can write data directly to it.

        **Note:** The pointer will become invalid after the stream is stopped or
        if you start another stream.

        If the **QAudioSink**  is able to access the system's audio device,
        **state** () returns **QAudio::IdleState** , **error** () returns
        **QAudio::NoError**  and the **stateChanged** () signal is emitted.

        If a problem occurs during this process, **error** () returns
        **QAudio::OpenError** , **state** () returns **QAudio::StoppedState**
        and the **stateChanged** () signal is emitted.

        **See also** **QIODevice** .
        """
        ...

    def format(self) -> QAudioFormat:
        """
        https://doc.qt.io/qt-6/qaudiosink.html#format

        **QAudioFormat QAudioSink::format() const**

        Returns the **QAudioFormat**  being used.
        """
        ...

    @property
    def stateChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qaudiosink.html#stateChanged

        **[signal] void QAudioSink::stateChanged(QAudio::State state )**

        This signal is emitted when the device **state** has changed. This is
        the current state of the audio output.
        """
        ...
