"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtMultimedia import *
import enum


class QCamera(QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qcamera.html

    **Detailed Description**

    QCamera can be used within a **QMediaCaptureSession**  for video recording
    and image taking.

    You can use **QCameraDevice**  to list available cameras and choose which
    one to use.

    const **QList** <**QCameraDevice** > cameras = **QMediaDevices**
    ::videoInputs();
        for (const **QCameraDevice**  &cameraDevice : cameras)
    {
            if (cameraDevice.description() == "mycamera")
                camera =
    new **QCamera** (cameraDevice);
        }

    On hardware that supports it, QCamera lets you adjust the focus and zoom.
    This also includes functionality such as a "Macro" mode for close up work
    (e.g. reading barcodes, or recognizing letters), or "touch to focus" -
    indicating an interesting area of the image for the hardware to attempt to
    focus on.

    camera->setFocusPointMode(**QCamera** ::FocusModeManual);
    camera->setCustomFocusPoint(**QPointF** (0.25f, 0.75f)); // A point near the
    bottom left, 25% away from the corner, near that shiny vase

    The **minimumZoomFactor** () and **maximumZoomFactor** () methods provide
    the range of supported zoom factors. The **zoomTo** () method allows
    changing the zoom factor.

    camera->setZoomFactor(3.0);

    After capturing the raw data for a camera frame, the camera hardware and
    software performs various image processing tasks to produce the final image.
    This includes compensating for ambient light color, reducing noise, as well
    as making some other adjustments to the image.

    You can control many of these processing steps through the Camera
    properties. For example, you can set the white balance (or color
    temperature) used for processing images:

    camera->setWhiteBalanceMode(**QCamera** ::WhiteBalanceFluorescent);

    For more information on image processing of camera frames, see **Camera
    Image Processing** .

    See the **camera overview**  for more information.
    """

    class Feature(enum.Enum):
        ColorTemperature: QCamera = ...
        ExposureCompensation: QCamera = ...
        IsoSensitivity: QCamera = ...
        ManualExposureTime: QCamera = ...
        CustomFocusPoint: QCamera = ...
        FocusDistance: QCamera = ...

    class WhiteBalanceMode(enum.Enum):
        WhiteBalanceAuto: QCamera = ...
        WhiteBalanceManual: QCamera = ...
        WhiteBalanceSunlight: QCamera = ...
        WhiteBalanceCloudy: QCamera = ...
        WhiteBalanceShade: QCamera = ...
        WhiteBalanceTungsten: QCamera = ...
        WhiteBalanceFluorescent: QCamera = ...
        WhiteBalanceFlash: QCamera = ...
        WhiteBalanceSunset: QCamera = ...

    class ExposureMode(enum.Enum):
        ExposureAuto: QCamera = ...
        ExposureManual: QCamera = ...
        ExposurePortrait: QCamera = ...
        ExposureNight: QCamera = ...
        ExposureSports: QCamera = ...
        ExposureSnow: QCamera = ...
        ExposureBeach: QCamera = ...
        ExposureAction: QCamera = ...
        ExposureLandscape: QCamera = ...
        ExposureNightPortrait: QCamera = ...
        ExposureTheatre: QCamera = ...
        ExposureSunset: QCamera = ...
        ExposureSteadyPhoto: QCamera = ...
        ExposureFireworks: QCamera = ...
        ExposureParty: QCamera = ...
        ExposureCandlelight: QCamera = ...
        ExposureBarcode: QCamera = ...

    class TorchMode(enum.Enum):
        TorchOff: QCamera = ...
        TorchOn: QCamera = ...
        TorchAuto: QCamera = ...

    class FlashMode(enum.Enum):
        FlashOff: QCamera = ...
        FlashOn: QCamera = ...
        FlashAuto: QCamera = ...

    class FocusMode(enum.Enum):
        FocusModeAuto: QCamera = ...
        FocusModeAutoNear: QCamera = ...
        FocusModeAutoFar: QCamera = ...
        FocusModeHyperfocal: QCamera = ...
        FocusModeInfinity: QCamera = ...
        FocusModeManual: QCamera = ...

    class Error(enum.Enum):
        NoError: QCamera = ...
        CameraError: QCamera = ...

    @typing.overload
    def __init__(
        self,
        cameraDevice: "QCameraDevice",
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcamera.html#QCamera

        **QCamera::QCamera(QObject * parent = nullptr)**

        Construct a QCamera with a **parent**.

        Selects the default camera on the system if more than one camera is
        available.
        """
        ...

    @typing.overload
    def __init__(
        self,
        position: "QCameraDevice.Position",
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qcamera.html#QCamera-1

        **QCamera::QCamera(const QCameraDevice & cameraDevice , QObject * parent
        = nullptr)**

        Construct a QCamera from a camera description **cameraDevice** and
        **parent**.
        """
        ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qcamera.html#QCamera-2

        **QCamera::QCamera(QCameraDevice::Position position , QObject * parent =
        nullptr)**

        Construct a QCamera which uses a hardware camera located a the specified
        **position**.

        For example on a mobile phone it can be used to easily choose between
        front-facing and back-facing cameras.

        If no camera is available at the specified **position** or if
        **position** is **QCameraDevice::UnspecifiedPosition** , the default
        camera is used.
        """
        ...

    def manualExposureTimeChanged(self, speed: float) -> None:
        ...

    def focusPointChanged(self) -> None:
        ...

    def colorTemperatureChanged(self) -> None:
        ...

    def whiteBalanceModeChanged(self) -> None:
        ...

    def maximumZoomFactorChanged(self, a0: float) -> None:
        ...

    def minimumZoomFactorChanged(self, a0: float) -> None:
        ...

    def focusModeChanged(self) -> None:
        ...

    def supportedFeaturesChanged(self) -> None:
        ...

    def cameraFormatChanged(self) -> None:
        ...

    def cameraDeviceChanged(self) -> None:
        ...

    def errorChanged(self) -> None:
        ...

    def setColorTemperature(self, colorTemperature: int) -> None:
        """
        https://doc.qt.io/qt-6/qcamera.html#setColorTemperature

        **[slot] void QCamera::setColorTemperature(int colorTemperature )**

        Sets manual white balance to **colorTemperature**. This is used when
        **whiteBalanceMode** () is set to `WhiteBalanceManual`. The units are
        Kelvin.

        Setting a color temperature will only have an effect if
        **WhiteBalanceManual**  is supported. In this case, setting a
        temperature greater 0 will automatically set the white balance mode to
        **WhiteBalanceManual** . Setting the temperature to 0 will reset the
        white balance mode to **WhiteBalanceAuto** .

        **Note:** Setter function for property **colorTemperature** .

        **See also** **colorTemperature** ().
        """
        ...

    def setWhiteBalanceMode(self, mode: "QCamera.WhiteBalanceMode") -> None:
        """
        https://doc.qt.io/qt-6/qcamera.html#setWhiteBalanceMode

        **[slot] void QCamera::setWhiteBalanceMode(QCamera::WhiteBalanceMode
        mode )**

        Sets the white balance to **mode**.

        **Note:** Setter function for property **whiteBalanceMode** .

        **See also** **whiteBalanceMode** ().
        """
        ...

    def setAutoExposureTime(self) -> None:
        """
        https://doc.qt.io/qt-6/qcamera.html#setAutoExposureTime

        **[slot] void QCamera::setAutoExposureTime()**

        Use automatically calculated exposure time
        """
        ...

    def setManualExposureTime(self, seconds: float) -> None:
        """
        https://doc.qt.io/qt-6/qcamera.html#setManualExposureTime

        **[slot] void QCamera::setManualExposureTime(float seconds )**

        Set the manual exposure time to **seconds**

        **Note:** Setter function for property **manualExposureTime** .

        **See also** **manualExposureTime** ().
        """
        ...

    def setAutoIsoSensitivity(self) -> None:
        """
        https://doc.qt.io/qt-6/qcamera.html#setAutoIsoSensitivity

        **[slot] void QCamera::setAutoIsoSensitivity()**

        Turn on auto sensitivity
        """
        ...

    def setManualIsoSensitivity(self, iso: int) -> None:
        """
        https://doc.qt.io/qt-6/qcamera.html#manualIsoSensitivity-prop

        **manualIsoSensitivity : int**

        Describes a manually set ISO sensitivity

        Setting this property to -1 (the default), implies that the camera
        automatically adjusts the ISO sensitivity.

        **Access functions:**

        int **manualIsoSensitivity** () const
        void **setManualIsoSensitivity**
        (int **iso** )

        **Notifier signal:**

        void **manualIsoSensitivityChanged** (int)
        """
        ...

    def setExposureCompensation(self, ev: float) -> None:
        """
        https://doc.qt.io/qt-6/qcamera.html#exposureCompensation-prop

        **exposureCompensation : float**

        Exposure compensation in EV units.

        Exposure compensation property allows to adjust the automatically
        calculated exposure.

        **Access functions:**

        float **exposureCompensation** () const
        void
        **setExposureCompensation** (float **ev** )

        **Notifier signal:**

        void ****exposureCompensationChanged** ** (float **value** )
        """
        ...

    def setExposureMode(self, mode: "QCamera.ExposureMode") -> None:
        """
        https://doc.qt.io/qt-6/qcamera.html#exposureMode-prop

        **exposureMode : QCamera::ExposureMode**

        This property holds the exposure mode being used.

        **Access functions:**

        QCamera::ExposureMode **exposureMode** () const
        void
        **setExposureMode** (QCamera::ExposureMode **mode** )

        **Notifier signal:**

        void **exposureModeChanged** ()

        **See also** **QCamera::isExposureModeSupported** .
        """
        ...

    def setTorchMode(self, mode: "QCamera.TorchMode") -> None:
        """
        https://doc.qt.io/qt-6/qcamera.html#torchMode-prop

        **torchMode : QCamera::TorchMode**

        This property holds the torch mode being used.

        A torch is a continuous source of light. It can be used during video
        recording in low light conditions. Enabling torch mode will usually
        override any currently set flash mode.

        **Access functions:**

        QCamera::TorchMode **torchMode** () const
        void **setTorchMode**
        (QCamera::TorchMode **mode** )

        **Notifier signal:**

        void **torchModeChanged** ()

        **See also** **QCamera::TorchMode** , **QCamera::isTorchModeSupported**
        , and **QCamera::flashMode** .
        """
        ...

    def setFlashMode(self, mode: "QCamera.FlashMode") -> None:
        """
        https://doc.qt.io/qt-6/qcamera.html#flashMode-prop

        **flashMode : QCamera::FlashMode**

        This property holds the flash mode being used.

        Enables a certain flash mode if the camera has a flash.

        **Access functions:**

        QCamera::FlashMode **flashMode** () const
        void **setFlashMode**
        (QCamera::FlashMode **mode** )

        **Notifier signal:**

        void **flashModeChanged** ()

        **See also** **QCamera::FlashMode** , **QCamera::isFlashModeSupported**
        , and **QCamera::isFlashReady** .
        """
        ...

    def zoomTo(self, zoom: float, rate: float) -> None:
        """
        https://doc.qt.io/qt-6/qcamera.html#zoomTo

        **[slot] void QCamera::zoomTo(float factor , float rate )**

        Zooms to a zoom factor **factor** using **rate**.

        The **rate** is specified in powers of two per second. At a rate of 1 it
        would take 2 seconds to go from a zoom factor of 1 to 4.

        **Note:** Using a specific rate is not supported on all cameras. If not
        supported, zooming will happen as fast as possible.
        """
        ...

    def stop(self) -> None:
        """
        https://doc.qt.io/qt-6/qcamera.html#stop

        **[slot] void QCamera::stop()**

        Stops the camera. Same as **setActive** (false).
        """
        ...

    def start(self) -> None:
        """
        https://doc.qt.io/qt-6/qcamera.html#start

        **[slot] void QCamera::start()**

        Starts the camera.

        Same as **setActive** (true).

        If the camera can't be started for some reason, the **errorOccurred** ()
        signal is emitted.
        """
        ...

    def setActive(self, active: bool) -> None:
        """
        https://doc.qt.io/qt-6/qcamera.html#setActive

        **[slot] void QCamera::setActive(bool active )**

        Turns the camera on if **active** is `true`, or off if it's `false`.

        **Note:** Setter function for property **active** .

        **See also** **isActive** ().
        """
        ...

    def colorTemperature(self) -> int:
        """
        https://doc.qt.io/qt-6/qcamera.html#colorTemperature

        **int QCamera::colorTemperature() const**

        Returns the current color temperature if the current white balance mode
        is `WhiteBalanceManual`. For other modes the return value is undefined.

        **Note:** Getter function for property colorTemperature.

        **See also** **setColorTemperature** ().
        """
        ...

    def isWhiteBalanceModeSupported(self, mode: "QCamera.WhiteBalanceMode") -> bool:
        """
        https://doc.qt.io/qt-6/qcamera.html#isWhiteBalanceModeSupported

        **[invokable] bool
        QCamera::isWhiteBalanceModeSupported(QCamera::WhiteBalanceMode mode )
        const**

        Returns true if the white balance **mode** is supported.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def whiteBalanceMode(self) -> "QCamera.WhiteBalanceMode":
        """
        https://doc.qt.io/qt-6/qcamera.html#whiteBalanceMode

        **QCamera::WhiteBalanceMode QCamera::whiteBalanceMode() const**

        Returns the white balance mode being used.

        **Note:** Getter function for property whiteBalanceMode.

        **See also** **setWhiteBalanceMode** ().
        """
        ...

    def maximumExposureTime(self) -> float:
        """
        https://doc.qt.io/qt-6/qcamera.html#maximumExposureTime

        **float QCamera::maximumExposureTime() const**

        The maximal exposure time in seconds.
        """
        ...

    def minimumExposureTime(self) -> float:
        """
        https://doc.qt.io/qt-6/qcamera.html#minimumExposureTime

        **float QCamera::minimumExposureTime() const**

        The minimal exposure time in seconds.
        """
        ...

    def maximumIsoSensitivity(self) -> int:
        """
        https://doc.qt.io/qt-6/qcamera.html#maximumIsoSensitivity

        **int QCamera::maximumIsoSensitivity() const**

        Returns the maximum ISO sensitivity supported by the camera.
        """
        ...

    def minimumIsoSensitivity(self) -> int:
        """
        https://doc.qt.io/qt-6/qcamera.html#minimumIsoSensitivity

        **int QCamera::minimumIsoSensitivity() const**

        Returns the minimum ISO sensitivity supported by the camera.
        """
        ...

    def manualExposureTime(self) -> float:
        """
        https://doc.qt.io/qt-6/qcamera.html#manualExposureTime

        **float QCamera::manualExposureTime() const**

        Returns the manual exposure time in seconds, or -1 if the camera is
        using automatic exposure times.

        **Note:** Getter function for property manualExposureTime.

        **See also** **setManualExposureTime** ().
        """
        ...

    def exposureTime(self) -> float:
        """
        https://doc.qt.io/qt-6/qcamera.html#exposureTime

        **float QCamera::exposureTime() const**

        Returns the current exposure time in seconds.

        **Note:** Getter function for property exposureTime.
        """
        ...

    def manualIsoSensitivity(self) -> int:
        """
        https://doc.qt.io/qt-6/qcamera.html#manualIsoSensitivity-prop

        **manualIsoSensitivity : int**

        Describes a manually set ISO sensitivity

        Setting this property to -1 (the default), implies that the camera
        automatically adjusts the ISO sensitivity.

        **Access functions:**

        int **manualIsoSensitivity** () const
        void **setManualIsoSensitivity**
        (int **iso** )

        **Notifier signal:**

        void **manualIsoSensitivityChanged** (int)
        """
        ...

    def isoSensitivity(self) -> int:
        """
        https://doc.qt.io/qt-6/qcamera.html#isoSensitivity-prop

        **[read-only] isoSensitivity : const int**

        This property holds the sensor ISO sensitivity.

        Describes the ISO sensitivity currently used by the camera.

        **Access functions:**

        int **isoSensitivity** () const

        **Notifier signal:**

        void ****isoSensitivityChanged** ** (int **value** )

        **See also** **setAutoIsoSensitivity** () and
        **setManualIsoSensitivity** ().
        """
        ...

    def exposureCompensation(self) -> float:
        """
        https://doc.qt.io/qt-6/qcamera.html#exposureCompensation-prop

        **exposureCompensation : float**

        Exposure compensation in EV units.

        Exposure compensation property allows to adjust the automatically
        calculated exposure.

        **Access functions:**

        float **exposureCompensation** () const
        void
        **setExposureCompensation** (float **ev** )

        **Notifier signal:**

        void ****exposureCompensationChanged** ** (float **value** )
        """
        ...

    def isExposureModeSupported(self, mode: "QCamera.ExposureMode") -> bool:
        """
        https://doc.qt.io/qt-6/qcamera.html#isExposureModeSupported

        **[invokable] bool
        QCamera::isExposureModeSupported(QCamera::ExposureMode mode ) const**

        Returns true if the exposure **mode** is supported.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def exposureMode(self) -> "QCamera.ExposureMode":
        """
        https://doc.qt.io/qt-6/qcamera.html#exposureMode-prop

        **exposureMode : QCamera::ExposureMode**

        This property holds the exposure mode being used.

        **Access functions:**

        QCamera::ExposureMode **exposureMode** () const
        void
        **setExposureMode** (QCamera::ExposureMode **mode** )

        **Notifier signal:**

        void **exposureModeChanged** ()

        **See also** **QCamera::isExposureModeSupported** .
        """
        ...

    def isTorchModeSupported(self, mode: "QCamera.TorchMode") -> bool:
        """
        https://doc.qt.io/qt-6/qcamera.html#isTorchModeSupported

        **[invokable] bool QCamera::isTorchModeSupported(QCamera::TorchMode mode
        ) const**

        Returns true if the torch **mode** is supported.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def torchMode(self) -> "QCamera.TorchMode":
        """
        https://doc.qt.io/qt-6/qcamera.html#torchMode-prop

        **torchMode : QCamera::TorchMode**

        This property holds the torch mode being used.

        A torch is a continuous source of light. It can be used during video
        recording in low light conditions. Enabling torch mode will usually
        override any currently set flash mode.

        **Access functions:**

        QCamera::TorchMode **torchMode** () const
        void **setTorchMode**
        (QCamera::TorchMode **mode** )

        **Notifier signal:**

        void **torchModeChanged** ()

        **See also** **QCamera::TorchMode** , **QCamera::isTorchModeSupported**
        , and **QCamera::flashMode** .
        """
        ...

    def isFlashReady(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcamera.html#isFlashReady

        **[invokable] bool QCamera::isFlashReady() const**

        Returns true if flash is charged.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        **Note:** Getter function for property **flashReady** .
        """
        ...

    def isFlashModeSupported(self, mode: "QCamera.FlashMode") -> bool:
        """
        https://doc.qt.io/qt-6/qcamera.html#isFlashModeSupported

        **[invokable] bool QCamera::isFlashModeSupported(QCamera::FlashMode mode
        ) const**

        Returns true if the flash **mode** is supported.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def flashMode(self) -> "QCamera.FlashMode":
        """
        https://doc.qt.io/qt-6/qcamera.html#flashMode-prop

        **flashMode : QCamera::FlashMode**

        This property holds the flash mode being used.

        Enables a certain flash mode if the camera has a flash.

        **Access functions:**

        QCamera::FlashMode **flashMode** () const
        void **setFlashMode**
        (QCamera::FlashMode **mode** )

        **Notifier signal:**

        void **flashModeChanged** ()

        **See also** **QCamera::FlashMode** , **QCamera::isFlashModeSupported**
        , and **QCamera::isFlashReady** .
        """
        ...

    def setZoomFactor(self, factor: float) -> None:
        """
        https://doc.qt.io/qt-6/qcamera.html#setZoomFactor

        **void QCamera::setZoomFactor(float factor )**

        Zooms to a zoom factor **factor** at a rate of 1 factor per second.

        **Note:** Setter function for property **zoomFactor** .

        **See also** **zoomFactor** ().
        """
        ...

    def zoomFactor(self) -> float:
        """
        https://doc.qt.io/qt-6/qcamera.html#zoomFactor-prop

        **zoomFactor : float**

        This property holds the current zoom factor.

        Gets or sets the current zoom factor. Values will be clamped between
        **minimumZoomFactor**  and **maximumZoomFactor** .

        **Access functions:**

        float **zoomFactor** () const
        void ****setZoomFactor** ** (float
        **factor** )

        **Notifier signal:**

        void **zoomFactorChanged** (float)

        **Member Function Documentation**
        """
        ...

    def maximumZoomFactor(self) -> float:
        """
        https://doc.qt.io/qt-6/qcamera.html#maximumZoomFactor

        **float QCamera::maximumZoomFactor() const**

        Returns the maximum zoom factor.

        This will be `1.0` on cameras that do not support zooming.

        **Note:** Getter function for property maximumZoomFactor.
        """
        ...

    def minimumZoomFactor(self) -> float:
        """
        https://doc.qt.io/qt-6/qcamera.html#minimumZoomFactor

        **float QCamera::minimumZoomFactor() const**

        Returns the minimum zoom factor.

        This will be `1.0` on cameras that do not support zooming.

        **Note:** Getter function for property minimumZoomFactor.
        """
        ...

    def focusDistance(self) -> float:
        """
        https://doc.qt.io/qt-6/qcamera.html#focusDistance-prop

        **focusDistance : float**

        This property return an approximate focus distance of the camera. The
        value reported is between 0 and 1, 0 being the closest possible focus
        distance, 1 being as far away as possible. Note that 1 is often, but not
        always infinity.

        Setting the focus distance will be ignored unless the focus mode is set
        to **FocusModeManual** .

        **Access functions:**

        float **focusDistance** () const
        void **setFocusDistance** (float
        **d** )

        **Notifier signal:**

        void **focusDistanceChanged** (float)
        """
        ...

    def setFocusDistance(self, d: float) -> None:
        """
        https://doc.qt.io/qt-6/qcamera.html#focusDistance-prop

        **focusDistance : float**

        This property return an approximate focus distance of the camera. The
        value reported is between 0 and 1, 0 being the closest possible focus
        distance, 1 being as far away as possible. Note that 1 is often, but not
        always infinity.

        Setting the focus distance will be ignored unless the focus mode is set
        to **FocusModeManual** .

        **Access functions:**

        float **focusDistance** () const
        void **setFocusDistance** (float
        **d** )

        **Notifier signal:**

        void **focusDistanceChanged** (float)
        """
        ...

    def setCustomFocusPoint(self, point: QtCore.QPointF) -> None:
        """
        https://doc.qt.io/qt-6/qcamera.html#customFocusPoint-prop

        **customFocusPoint : QPointF**

        This property represents the position of the custom focus point, in
        relative frame coordinates: **QPointF** (0,0) points to the left top
        frame point, **QPointF** (0.5,0.5) points to the frame center.

        The custom focus point property is used only in `FocusPointCustom` focus
        mode.

        You can check whether custom focus points are supported by querying
        **supportedFeatures** () with the Feature.**CustomFocusPoint**  flag.

        **Access functions:**

        QPointF **customFocusPoint** () const
        void **setCustomFocusPoint**
        (const QPointF & **point** )

        **Notifier signal:**

        void **customFocusPointChanged** ()
        """
        ...

    def customFocusPoint(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qcamera.html#customFocusPoint-prop

        **customFocusPoint : QPointF**

        This property represents the position of the custom focus point, in
        relative frame coordinates: **QPointF** (0,0) points to the left top
        frame point, **QPointF** (0.5,0.5) points to the frame center.

        The custom focus point property is used only in `FocusPointCustom` focus
        mode.

        You can check whether custom focus points are supported by querying
        **supportedFeatures** () with the Feature.**CustomFocusPoint**  flag.

        **Access functions:**

        QPointF **customFocusPoint** () const
        void **setCustomFocusPoint**
        (const QPointF & **point** )

        **Notifier signal:**

        void **customFocusPointChanged** ()
        """
        ...

    def focusPoint(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qcamera.html#focusPoint

        **QPointF QCamera::focusPoint() const**

        Returns the point currently used by the auto focus system to focus onto.

        **Note:** Getter function for property focusPoint.
        """
        ...

    def isFocusModeSupported(self, mode: "QCamera.FocusMode") -> bool:
        """
        https://doc.qt.io/qt-6/qcamera.html#isFocusModeSupported

        **[invokable] bool QCamera::isFocusModeSupported(QCamera::FocusMode mode
        ) const**

        Returns true if the focus **mode** is supported by the camera.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def setFocusMode(self, mode: "QCamera.FocusMode") -> None:
        """
        https://doc.qt.io/qt-6/qcamera.html#focusMode-prop

        **focusMode : FocusMode**

        This property holds the current camera focus mode.

        Sets up different focus modes for the camera. All auto focus modes will
        focus continuously. Locking the focus is possible by setting the focus
        mode to **FocusModeManual** . This will keep the current focus and stop
        any automatic focusing.

        **Access functions:**

        QCamera::FocusMode **focusMode** () const
        void **setFocusMode**
        (QCamera::FocusMode **mode** )

        **See also** **isFocusModeSupported** .
        """
        ...

    def focusMode(self) -> "QCamera.FocusMode":
        """
        https://doc.qt.io/qt-6/qcamera.html#focusMode-prop

        **focusMode : FocusMode**

        This property holds the current camera focus mode.

        Sets up different focus modes for the camera. All auto focus modes will
        focus continuously. Locking the focus is possible by setting the focus
        mode to **FocusModeManual** . This will keep the current focus and stop
        any automatic focusing.

        **Access functions:**

        QCamera::FocusMode **focusMode** () const
        void **setFocusMode**
        (QCamera::FocusMode **mode** )

        **See also** **isFocusModeSupported** .
        """
        ...

    def supportedFeatures(self) -> "QCamera.Feature":
        """
        https://doc.qt.io/qt-6/qcamera.html#supportedFeatures

        **QCamera::Features QCamera::supportedFeatures() const**

        Returns the features supported by this camera.

        **Note:** Getter function for property supportedFeatures.

        **See also** **QCamera::Feature** .
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-6/qcamera.html#errorString

        **QString QCamera::errorString() const**

        Returns a human readable string describing a camera's error state.

        **Note:** Getter function for property errorString.
        """
        ...

    def error(self) -> "QCamera.Error":
        """
        https://doc.qt.io/qt-6/qcamera.html#error

        **QCamera::Error QCamera::error() const**

        Returns the error state of the camera.

        **Note:** Getter function for property error.
        """
        ...

    def setCameraFormat(self, format: "QCameraFormat") -> None:
        """
        https://doc.qt.io/qt-6/qcamera.html#setCameraFormat

        **void QCamera::setCameraFormat(const QCameraFormat & format )**

        Tells the camera to use the format desribed by **format**. This can be
        used to define as specific resolution and frame rate to be used for
        recording and image capture.

        **Note:** Setter function for property **cameraFormat** .

        **See also** **cameraFormat** ().
        """
        ...

    def cameraFormat(self) -> "QCameraFormat":
        """
        https://doc.qt.io/qt-6/qcamera.html#cameraFormat

        **QCameraFormat QCamera::cameraFormat() const**

        Returns the camera format currently used by the camera.

        **Note:** Getter function for property cameraFormat.

        **See also** **setCameraFormat** () and **QCameraDevice::videoFormats**
        .
        """
        ...

    def setCameraDevice(self, cameraDevice: "QCameraDevice") -> None:
        """
        https://doc.qt.io/qt-6/qcamera.html#setCameraDevice

        **void QCamera::setCameraDevice(const QCameraDevice & cameraDevice )**

        Connects the camera object to the physical camera device described by
        **cameraDevice**. Using a default constructed **QCameraDevice**  object
        as **cameraDevice** will connect the camera to the system default camera
        device.

        **Note:** Setter function for property **cameraDevice** .

        **See also** **cameraDevice** ().
        """
        ...

    def cameraDevice(self) -> "QCameraDevice":
        """
        https://doc.qt.io/qt-6/qcamera.html#cameraDevice

        **QCameraDevice QCamera::cameraDevice() const**

        Returns the **QCameraDevice**  object associated with this camera.

        **Note:** Getter function for property cameraDevice.

        **See also** **setCameraDevice** ().
        """
        ...

    def captureSession(self) -> "QMediaCaptureSession":
        """
        https://doc.qt.io/qt-6/qcamera.html#captureSession

        **QMediaCaptureSession *QCamera::captureSession() const**

        Returns the capture session this camera is connected to, or a nullptr if
        the camera is not connected to a capture session.

        use **QMediaCaptureSession::setCamera** () to connect the camera to a
        session.
        """
        ...

    def isActive(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcamera.html#isActive

        **bool QCamera::isActive() const**

        Returns true if the camera is currently active.

        **Note:** Getter function for property **active** .
        """
        ...

    def isAvailable(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcamera.html#isAvailable

        **bool QCamera::isAvailable() const**

        Returns true if the camera can be used.
        """
        ...

    @property
    def activeChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        ...

    @property
    def customFocusPointChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        ...

    @property
    def errorOccurred(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qcamera.html#errorOccurred

        **[signal] void QCamera::errorOccurred(QCamera::Error error , const
        QString & errorString )**

        This signal is emitted when error state changes to **error**. A
        description of the error is provided as **errorString**.
        """
        ...

    @property
    def exposureCompensationChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qcamera.html#exposureCompensationChanged

        **[signal] void QCamera::exposureCompensationChanged(float value )**

        Signal emitted when the exposure compensation changes to **value**.

        **Note:** Notifier signal for property **exposureCompensation** .
        """
        ...

    @property
    def exposureModeChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        ...

    @property
    def exposureTimeChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qcamera.html#exposureTimeChanged

        **[signal] void QCamera::exposureTimeChanged(float speed )**

        Signals that a camera's exposure **speed** has changed.

        **Note:** Notifier signal for property **exposureTime** .
        """
        ...

    @property
    def flashModeChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        ...

    @property
    def flashReady(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qcamera.html#flashReady

        **[signal] void QCamera::flashReady(bool ready )**

        Signal the flash **ready** status has changed.

        **Note:** Notifier signal for property flashReady.
        """
        ...

    @property
    def focusDistanceChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        ...

    @property
    def isoSensitivityChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qcamera.html#isoSensitivityChanged

        **[signal] void QCamera::isoSensitivityChanged(int value )**

        Signal emitted when sensitivity changes to **value**.

        **Note:** Notifier signal for property **isoSensitivity** .
        """
        ...

    @property
    def manualIsoSensitivityChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        ...

    @property
    def torchModeChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        ...

    @property
    def zoomFactorChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        ...
