"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtMultimedia import *
import enum


class QCameraDevice(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qcameradevice.html

    **Detailed Description**

    QCameraDevice represents a physical camera device and its properties.

    You can discover what cameras are available on a system using the
    availableCameras() and defaultCamera() functions. These are contained within
    QtMultimedia::MediaDevices.

    This example prints the name of all available cameras:

    const **QList** <**QCameraDevice** > cameras = **QMediaDevices**
    ::videoInputs();
        for (const **QCameraDevice**  &cameraDevice : cameras)
    **qDebug** () << cameraDevice.description();

    A QCameraDevice can be used to construct a **QCamera** . The following
    example instantiates a **QCamera**  whose camera device is named `mycamera`:

    const **QList** <**QCameraDevice** > cameras = **QMediaDevices**
    ::videoInputs();
        for (const **QCameraDevice**  &cameraDevice : cameras)
    {
            if (cameraDevice.description() == "mycamera")
                camera =
    new **QCamera** (cameraDevice);
        }

    You can also use QCameraDevice to get general information about a camera
    device such as description, physical position on the system, or camera
    sensor orientation.

    **QCamera**  myCamera;
        **QCameraDevice**  cameraDevice =
    camera->cameraDevice();

        if (cameraDevice.position() ==
    **QCameraDevice** ::FrontFace)
            **qDebug** () << "The camera is on
    the front face of the hardware system.";
        else if
    (cameraDevice.position() == **QCameraDevice** ::BackFace)
            **qDebug**
    () << "The camera is on the back face of the hardware system.";
    **qDebug** () << "The camera sensor orientation is " <<
    cameraDevice.orientation() << " degrees.";

    **See also** **QCamera** .
    """

    class Position(enum.Enum):
        UnspecifiedPosition: QCameraDevice = ...
        BackFace: QCameraDevice = ...
        FrontFace: QCameraDevice = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qcameradevice.html#QCameraDevice

        **QCameraDevice::QCameraDevice()**

        Constructs a null camera device
        """
        ...

    @typing.overload
    def __init__(self, other: "QCameraDevice") -> None:
        """
        https://doc.qt.io/qt-6/qcameradevice.html#QCameraDevice-1

        **QCameraDevice::QCameraDevice(const QCameraDevice & other )**

        Constructs a copy of **other**.
        """
        ...

    def videoFormats(self) -> typing.List[QCameraFormat]:
        """
        https://doc.qt.io/qt-6/qcameradevice.html#videoFormats

        **QList<QCameraFormat> QCameraDevice::videoFormats() const**

        Returns the video formats supported by the camera.

        **Note:** Getter function for property videoFormats.
        """
        ...

    def photoResolutions(self) -> typing.List[QtCore.QSize]:
        """
        https://doc.qt.io/qt-6/qcameradevice.html#photoResolutions

        **QList<QSize> QCameraDevice::photoResolutions() const**

        Returns a list of resolutions that the camera can use to capture still
        images.

        **See also** **QImageCapture** .
        """
        ...

    def position(self) -> "QCameraDevice.Position":
        """
        https://doc.qt.io/qt-6/qcameradevice.html#position

        **QCameraDevice::Position QCameraDevice::position() const**

        Returns the physical position of the camera on the hardware system.

        **Note:** Getter function for property position.
        """
        ...

    def isDefault(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcameradevice.html#isDefault

        **bool QCameraDevice::isDefault() const**

        Returns true if this is the default camera device.

        **Note:** Getter function for property isDefault.
        """
        ...

    def description(self) -> str:
        """
        https://doc.qt.io/qt-6/qcameradevice.html#description

        **QString QCameraDevice::description() const**

        Returns the human-readable description of the camera.

        Use this string to present the device to the user.

        **Note:** Getter function for property description.
        """
        ...

    def id(self) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qcameradevice.html#id

        **QByteArray QCameraDevice::id() const**

        Returns the device id of the camera

        This is a unique ID to identify the camera and may not be human-
        readable.

        **Note:** Getter function for property id.
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcameradevice.html#isNull

        **bool QCameraDevice::isNull() const**

        Returns true if this **QCameraDevice**  is null or invalid.
        """
        ...
