"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtMultimedia import *


class QCameraFormat(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qcameraformat.html

    **Detailed Description**

    QCameraFormat represents a certain video format supported by a camera
    device.

    The format is a combination of a **pixel format** , resolution and a range
    of frame rates.

    QCameraFormat objects can be queried from **QCameraDevice**  to inspect the
    set of supported video formats.

    **See also** **QCameraDevice**  and **QCamera** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qcameraformat.html#QCameraFormat

        **QCameraFormat::QCameraFormat()**

        Constructs a null camera format.

        **See also** **isNull** ().
        """
        ...

    @typing.overload
    def __init__(self, other: "QCameraFormat") -> None:
        """
        https://doc.qt.io/qt-6/qcameraformat.html#QCameraFormat-1

        **QCameraFormat::QCameraFormat(const QCameraFormat & other )**

        Copy constructs a camera format from the **other** format.
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcameraformat.html#isNull

        **bool QCameraFormat::isNull() const**

        Returns true if this is a default constructed **QCameraFormat** .
        """
        ...

    def maxFrameRate(self) -> float:
        """
        https://doc.qt.io/qt-6/qcameraformat.html#maxFrameRate

        **float QCameraFormat::maxFrameRate() const**

        Returns the highest frame rate defined by this format.

        In 6.2, the camera will always try to use the highest frame rate
        supported by a certain video format.

        **Note:** Getter function for property maxFrameRate.
        """
        ...

    def minFrameRate(self) -> float:
        """
        https://doc.qt.io/qt-6/qcameraformat.html#minFrameRate

        **float QCameraFormat::minFrameRate() const**

        Returns the lowest frame rate defined by this format.

        **Note:** Getter function for property minFrameRate.
        """
        ...

    def resolution(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qcameraformat.html#resolution

        **QSize QCameraFormat::resolution() const**

        Returns the resolution.

        **Note:** Getter function for property resolution.
        """
        ...

    def pixelFormat(self) -> "QVideoFrameFormat.PixelFormat":
        """
        https://doc.qt.io/qt-6/qcameraformat.html#pixelFormat

        **QVideoFrameFormat::PixelFormat QCameraFormat::pixelFormat() const**

        Returns the pixel format.

        Most commonly this is either **QVideoFrameFormat::Format_Jpeg**  or
        QVideoFrameFormat::Format_YUVY but other formats could also be supported
        by the camera.

        **Note:** Getter function for property pixelFormat.

        **See also** **QVideoFrameFormat::PixelFormat** .
        """
        ...
