"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtMultimedia import *


class QMediaCaptureSession(QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qmediacapturesession.html

    **Detailed Description**

    The QMediaCaptureSession is the central class that manages capturing of
    media on the local device.

    You can connect a camera and a microphone to QMediaCaptureSession using
    **setCamera** () and **setAudioInput** (). A preview of the captured media
    can be seen by setting a **QVideoSink**  of **QVideoWidget**  using
    **setVideoOutput** () and heard by routing the audio to an output device
    using **setAudioOutput** ().

    You can capture still images from a camera by setting a **QImageCapture**
    object on the capture session, and record audio/video using a
    **QMediaRecorder** .

    **See also** **QCamera** , **QAudioDevice** , **QMediaRecorder** ,
    **QImageCapture** , and **QMediaRecorder** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qmediacapturesession.html#QMediaCaptureSession

        **QMediaCaptureSession::QMediaCaptureSession(QObject * parent =
        nullptr)**

        Creates a session for media capture from the **parent** object.
        """
        ...

    def audioInputChanged(self) -> None:
        ...

    def audioOutput(self) -> QAudioOutput:
        ...

    def setAudioOutput(self, output: QAudioOutput) -> None:
        """
        https://doc.qt.io/qt-6/qmediacapturesession.html#setAudioOutput

        **void QMediaCaptureSession::setAudioOutput(QAudioOutput * output )**

        Sets the audio output device to **output**.

        **Note:** Setter function for property **audioOutput** .

        **See also** **audioOutput** ().
        """
        ...

    def videoSink(self) -> "QVideoSink":
        ...

    def setVideoSink(self, sink: "QVideoSink") -> None:
        """
        https://doc.qt.io/qt-6/qmediacapturesession.html#setVideoSink

        **void QMediaCaptureSession::setVideoSink(QVideoSink * sink )**

        Sets a **QVideoSink** , ( **sink** ), to a video preview for the capture
        session.

        A **QObject**  based preview is expected to have an invokable
        videoSink() method that returns a **QVideoSink** .

        The previously set preview is detached.
        """
        ...

    def videoOutput(self) -> QtCore.QObject:
        ...

    def setVideoOutput(self, output: QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-6/qmediacapturesession.html#setVideoOutput

        **void QMediaCaptureSession::setVideoOutput(QObject * output )**

        Sets a **QObject** , ( **output** ), to a video preview for the capture
        session.

        A **QObject**  based preview is expected to have an invokable
        videoSink() method that returns a **QVideoSink** .

        The previously set preview is detached.

        **Note:** Setter function for property **videoOutput** .

        **See also** **videoOutput** ().
        """
        ...

    def setRecorder(self, recorder: "QMediaRecorder") -> None:
        """
        https://doc.qt.io/qt-6/qmediacapturesession.html#recorder-prop

        **recorder : QMediaRecorder***

        This property holds the recorder object used to capture audio/video.

        Add a **QMediaRecorder**  object to the capture session to enable
        recording of audio and/or video from the capture session.

        **Access functions:**

        QMediaRecorder * **recorder** ()
        void **setRecorder** (QMediaRecorder
        * **recorder** )

        **Notifier signal:**

        void **recorderChanged** ()

        **Member Function Documentation**
        """
        ...

    def recorder(self) -> "QMediaRecorder":
        """
        https://doc.qt.io/qt-6/qmediacapturesession.html#recorder-prop

        **recorder : QMediaRecorder***

        This property holds the recorder object used to capture audio/video.

        Add a **QMediaRecorder**  object to the capture session to enable
        recording of audio and/or video from the capture session.

        **Access functions:**

        QMediaRecorder * **recorder** ()
        void **setRecorder** (QMediaRecorder
        * **recorder** )

        **Notifier signal:**

        void **recorderChanged** ()

        **Member Function Documentation**
        """
        ...

    def setImageCapture(self, imageCapture: QImageCapture) -> None:
        """
        https://doc.qt.io/qt-6/qmediacapturesession.html#imageCapture-prop

        **imageCapture : QImageCapture***

        This property holds the object used to capture still images.

        Add a **QImageCapture**  object to the capture session to enable
        capturing of still images from the camera.

        **Access functions:**

        QImageCapture * **imageCapture** ()
        void **setImageCapture**
        (QImageCapture * **imageCapture** )

        **Notifier signal:**

        void **imageCaptureChanged** ()
        """
        ...

    def imageCapture(self) -> QImageCapture:
        """
        https://doc.qt.io/qt-6/qmediacapturesession.html#imageCapture-prop

        **imageCapture : QImageCapture***

        This property holds the object used to capture still images.

        Add a **QImageCapture**  object to the capture session to enable
        capturing of still images from the camera.

        **Access functions:**

        QImageCapture * **imageCapture** ()
        void **setImageCapture**
        (QImageCapture * **imageCapture** )

        **Notifier signal:**

        void **imageCaptureChanged** ()
        """
        ...

    def setCamera(self, camera: QCamera) -> None:
        """
        https://doc.qt.io/qt-6/qmediacapturesession.html#camera-prop

        **camera : QCamera***

        This property holds the camera used to capture video.

        Record video or take images by adding a camera to the capture session
        using this property,

        **Access functions:**

        QCamera * **camera** () const
        void **setCamera** (QCamera * **camera**
        )

        **Notifier signal:**

        void **cameraChanged** ()
        """
        ...

    def camera(self) -> QCamera:
        """
        https://doc.qt.io/qt-6/qmediacapturesession.html#camera-prop

        **camera : QCamera***

        This property holds the camera used to capture video.

        Record video or take images by adding a camera to the capture session
        using this property,

        **Access functions:**

        QCamera * **camera** () const
        void **setCamera** (QCamera * **camera**
        )

        **Notifier signal:**

        void **cameraChanged** ()
        """
        ...

    def setAudioInput(self, device: QAudioInput) -> None:
        """
        https://doc.qt.io/qt-6/qmediacapturesession.html#setAudioInput

        **void QMediaCaptureSession::setAudioInput(QAudioInput * input )**

        Sets the audio input device to **input**. If setting it to an empty
        **QAudioDevice**  the capture session will use the default input as
        defined by the operating system.

        **Note:** Setter function for property **audioInput** .

        **See also** **audioInput** ().
        """
        ...

    def audioInput(self) -> QAudioInput:
        """
        https://doc.qt.io/qt-6/qmediacapturesession.html#audioInput

        **QAudioInput *QMediaCaptureSession::audioInput() const**

        Returns the device that is being used to capture audio.

        **Note:** Getter function for property audioInput.

        **See also** **setAudioInput** ().
        """
        ...

    @property
    def audioOutputChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        ...

    @property
    def cameraChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        ...

    @property
    def imageCaptureChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        ...

    @property
    def recorderChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        ...

    @property
    def videoOutputChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        ...
