"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtMultimedia import *
import enum


class QMediaFormat(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qmediaformat.html

    **Detailed Description**

    QMediaFormat describes an encoding format for a multimedia file or stream.

    You can check whether a certain media format can be used for encoding or
    decoding using QMediaFormat.
    """

    class ResolveFlags(enum.Enum):
        NoFlags: QMediaFormat = ...
        RequiresVideo: QMediaFormat = ...

    class ConversionMode(enum.Enum):
        Encode: QMediaFormat = ...
        Decode: QMediaFormat = ...

    class VideoCodec(enum.Enum):
        Unspecified: QMediaFormat = ...
        MPEG1: QMediaFormat = ...
        MPEG2: QMediaFormat = ...
        MPEG4: QMediaFormat = ...
        H264: QMediaFormat = ...
        H265: QMediaFormat = ...
        VP8: QMediaFormat = ...
        VP9: QMediaFormat = ...
        AV1: QMediaFormat = ...
        Theora: QMediaFormat = ...
        WMV: QMediaFormat = ...
        MotionJPEG: QMediaFormat = ...

    class AudioCodec(enum.Enum):
        Unspecified: QMediaFormat = ...
        MP3: QMediaFormat = ...
        AAC: QMediaFormat = ...
        AC3: QMediaFormat = ...
        EAC3: QMediaFormat = ...
        FLAC: QMediaFormat = ...
        DolbyTrueHD: QMediaFormat = ...
        Opus: QMediaFormat = ...
        Vorbis: QMediaFormat = ...
        Wave: QMediaFormat = ...
        WMA: QMediaFormat = ...
        ALAC: QMediaFormat = ...

    class FileFormat(enum.Enum):
        UnspecifiedFormat: QMediaFormat = ...
        WMV: QMediaFormat = ...
        AVI: QMediaFormat = ...
        Matroska: QMediaFormat = ...
        MPEG4: QMediaFormat = ...
        Ogg: QMediaFormat = ...
        QuickTime: QMediaFormat = ...
        WebM: QMediaFormat = ...
        Mpeg4Audio: QMediaFormat = ...
        AAC: QMediaFormat = ...
        WMA: QMediaFormat = ...
        MP3: QMediaFormat = ...
        FLAC: QMediaFormat = ...
        Wave: QMediaFormat = ...

    @typing.overload
    def __init__(self, format: "QMediaFormat.FileFormat" = ...) -> None:
        """
        https://doc.qt.io/qt-6/qmediaformat.html#QMediaFormat

        **QMediaFormat::QMediaFormat(QMediaFormat::FileFormat format =
        UnspecifiedFormat)**

        Constructs a QMediaFormat object for **format**.
        """
        ...

    @typing.overload
    def __init__(self, other: "QMediaFormat") -> None:
        """
        https://doc.qt.io/qt-6/qmediaformat.html#QMediaFormat-1

        **QMediaFormat::QMediaFormat(const QMediaFormat & other )**

        Constructs a QMediaFormat object by copying from **other**.
        """
        ...

    def resolveForEncoding(self, flags: "QMediaFormat.ResolveFlags") -> None:
        """
        https://doc.qt.io/qt-6/qmediaformat.html#resolveForEncoding

        **void QMediaFormat::resolveForEncoding(QMediaFormat::ResolveFlags flags
        )**

        Resolves the format, based on **flags** , to a format that is supported
        by **QMediaRecorder** .

        This method tries to find the best possible match for unspecified
        settings. Settings that are not supported by the recorder will be
        modified to the closest match that is supported.

        When resolving, priority is given in the following order:

        1. File format
          2. Video codec
          3. Audio codec
        """
        ...

    @staticmethod
    def videoCodecDescription(c: "QMediaFormat.VideoCodec") -> str:
        """
        https://doc.qt.io/qt-6/qmediaformat.html#videoCodecDescription

        **[static invokable] QString
        QMediaFormat::videoCodecDescription(QMediaFormat::VideoCodec codec )**

        Returns a description for **codec**.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    @staticmethod
    def audioCodecDescription(c: "QMediaFormat.AudioCodec") -> str:
        """
        https://doc.qt.io/qt-6/qmediaformat.html#audioCodecDescription

        **[static invokable] QString
        QMediaFormat::audioCodecDescription(QMediaFormat::AudioCodec codec )**

        Returns a description for **codec**.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    @staticmethod
    def fileFormatDescription(c: "QMediaFormat.FileFormat") -> str:
        """
        https://doc.qt.io/qt-6/qmediaformat.html#fileFormatDescription

        **[static invokable] QString
        QMediaFormat::fileFormatDescription(QMediaFormat::FileFormat fileFormat
        )**

        Returns a description for **fileFormat**.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    @staticmethod
    def videoCodecName(c: "QMediaFormat.VideoCodec") -> str:
        """
        https://doc.qt.io/qt-6/qmediaformat.html#videoCodecName

        **[static invokable] QString
        QMediaFormat::videoCodecName(QMediaFormat::VideoCodec codec )**

        Returns a string based name for **codec**.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    @staticmethod
    def audioCodecName(c: "QMediaFormat.AudioCodec") -> str:
        """
        https://doc.qt.io/qt-6/qmediaformat.html#audioCodecName

        **[static invokable] QString
        QMediaFormat::audioCodecName(QMediaFormat::AudioCodec codec )**

        Returns a string based name for **codec**.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    @staticmethod
    def fileFormatName(c: "QMediaFormat.FileFormat") -> str:
        """
        https://doc.qt.io/qt-6/qmediaformat.html#fileFormatName

        **[static invokable] QString
        QMediaFormat::fileFormatName(QMediaFormat::FileFormat fileFormat )**

        Returns a string based name for **fileFormat**.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def supportedAudioCodecs(
        self, m: "QMediaFormat.ConversionMode"
    ) -> typing.List["QMediaFormat.AudioCodec"]:
        """
        https://doc.qt.io/qt-6/qmediaformat.html#supportedAudioCodecs

        **[invokable] QList<QMediaFormat::AudioCodec>
        QMediaFormat::supportedAudioCodecs(QMediaFormat::ConversionMode m )**

        Returns a list of audio codecs for the chosen file format and video
        codec ( **m** ).

        To get all supported audio codecs, run this query on a default
        constructed **QMediaFormat** .

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        **See also** **QMediaFormat::ConversionMode** .
        """
        ...

    def supportedVideoCodecs(
        self, m: "QMediaFormat.ConversionMode"
    ) -> typing.List["QMediaFormat.VideoCodec"]:
        """
        https://doc.qt.io/qt-6/qmediaformat.html#supportedVideoCodecs

        **[invokable] QList<QMediaFormat::VideoCodec>
        QMediaFormat::supportedVideoCodecs(QMediaFormat::ConversionMode m )**

        Returns a list of video codecs for the chosen file format and audio
        codec ( **m** ).

        To get all supported video codecs, run this query on a default
        constructed MediaFormat.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        **See also** **QMediaFormat::ConversionMode** .
        """
        ...

    def supportedFileFormats(
        self, m: "QMediaFormat.ConversionMode"
    ) -> typing.List["QMediaFormat.FileFormat"]:
        """
        https://doc.qt.io/qt-6/qmediaformat.html#supportedFileFormats

        **[invokable] QList<QMediaFormat::FileFormat>
        QMediaFormat::supportedFileFormats(QMediaFormat::ConversionMode m )**

        Returns a list of file formats for the audio and video codec indicated
        by **m**.

        To get all supported file formats, run this query on a default
        constructed **QMediaFormat** .

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        **See also** **QMediaFormat::ConversionMode** .
        """
        ...

    def mimeType(self) -> QtCore.QMimeType:
        """
        https://doc.qt.io/qt-6/qmediaformat.html#mimeType

        **QMimeType QMediaFormat::mimeType() const**

        Returns the **MIME type**  for the file format used in this media
        format.
        """
        ...

    def isSupported(self, mode: "QMediaFormat.ConversionMode") -> bool:
        """
        https://doc.qt.io/qt-6/qmediaformat.html#isSupported

        **[invokable] bool
        QMediaFormat::isSupported(QMediaFormat::ConversionMode mode ) const**

        Returns `true` if Qt Multimedia can encode or decode this format,
        depending on **mode**.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def audioCodec(self) -> "QMediaFormat.AudioCodec":
        """
        https://doc.qt.io/qt-6/qmediaformat.html#audioCodec

        **QMediaFormat::AudioCodec QMediaFormat::audioCodec() const**

        Returns the audio codec used in this format.

        **Note:** Getter function for property audioCodec.

        **See also** **setAudioCodec** () and **QMediaFormat::AudioCodec** .
        """
        ...

    def setAudioCodec(self, codec: "QMediaFormat.AudioCodec") -> None:
        """
        https://doc.qt.io/qt-6/qmediaformat.html#setAudioCodec

        **void QMediaFormat::setAudioCodec(QMediaFormat::AudioCodec codec )**

        Sets the audio codec to **codec**.

        **Note:** Setter function for property **audioCodec** .

        **See also** **audioCodec** () and **QMediaFormat::AudioCodec** .
        """
        ...

    def videoCodec(self) -> "QMediaFormat.VideoCodec":
        """
        https://doc.qt.io/qt-6/qmediaformat.html#videoCodec

        **QMediaFormat::VideoCodec QMediaFormat::videoCodec() const**

        Returns the video codec used in this format.

        **Note:** Getter function for property videoCodec.

        **See also** **setVideoCodec** () and **QMediaFormat::VideoCodec** .
        """
        ...

    def setVideoCodec(self, codec: "QMediaFormat.VideoCodec") -> None:
        """
        https://doc.qt.io/qt-6/qmediaformat.html#setVideoCodec

        **void QMediaFormat::setVideoCodec(QMediaFormat::VideoCodec codec )**

        Sets the video codec to **codec**.

        **Note:** Setter function for property **videoCodec** .

        **See also** **videoCodec** () and **QMediaFormat::VideoCodec** .
        """
        ...

    def setFileFormat(self, f: "QMediaFormat.FileFormat") -> None:
        """
        https://doc.qt.io/qt-6/qmediaformat.html#fileFormat-prop

        **fileFormat : FileFormat**

        This property holds the file (container) format of the media.

        **Access functions:**

        QMediaFormat::FileFormat **fileFormat** () const
        void
        **setFileFormat** (QMediaFormat::FileFormat **f** )

        **See also** **QMediaFormat::FileFormat** .
        """
        ...

    def fileFormat(self) -> "QMediaFormat.FileFormat":
        """
        https://doc.qt.io/qt-6/qmediaformat.html#fileFormat-prop

        **fileFormat : FileFormat**

        This property holds the file (container) format of the media.

        **Access functions:**

        QMediaFormat::FileFormat **fileFormat** () const
        void
        **setFileFormat** (QMediaFormat::FileFormat **f** )

        **See also** **QMediaFormat::FileFormat** .
        """
        ...

    def swap(self, other: "QMediaFormat") -> None:
        ...
