"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6.QtMultimedia import *
import enum


class QMediaMetaData(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qmediametadata.html

    **Detailed Description**

    **Note:** Not all identifiers are supported on all platforms.

    Common attributes
    ValueDescriptionType
    TitleThe title of the
    media.**QString**
    AuthorThe authors of the media.**QStringList**
    CommentA user comment about the media.**QString**
    DescriptionA description
    of the media.**QString**
    GenreThe genre of the media.**QStringList**
    DateThe date of the media.**QDate** .
    LanguageThe language of
    media.**QLocale::Language**
    PublisherThe publisher of the
    media.**QString**
    CopyrightThe media's copyright notice.**QString**
    UrlA
    Url pointing to the origin of the media.**QUrl**
    Media attributes
    MediaTypeThe type of the media (audio, video, etc).**QString**
    FileFormatThe file format of the media.**QMediaFormat::FileFormat**
    DurationThe duration in millseconds of the media.qint64
    Audio attributes
    AudioBitRateThe bit rate of the media's audio stream in bits per second.int
    AudioCodecThe codec of the media's audio stream.QMediaForma::AudioCodec
    Video attributes
    VideoFrameRateThe frame rate of the media's video
    stream.qreal
    VideoBitRateThe bit rate of the media's video stream in bits
    per second.int
    VideoCodecThe codec of the media's video
    stream.**QMediaFormat::VideoCodec**
    Music attributes
    AlbumTitleThe title
    of the album the media belongs to.**QString**
    AlbumArtistThe principal
    artist of the album the media belongs to.**QString**
    ContributingArtistThe
    artists contributing to the media.**QStringList**
    TrackNumberThe track
    number of the media.int
    ComposerThe composer of the media.**QStringList**
    LeadPerformerThe lead performer in the media.**QStringList**
    ThumbnailImageAn embedded thumbnail image.**QImage**
    CoverArtImageAn
    embedded cover art image.**QImage**
    Image and video attributes
    ResolutionThe dimensions of an image or video.**QSize**
    """

    class Key(enum.Enum):
        Title: QMediaMetaData = ...
        Author: QMediaMetaData = ...
        Comment: QMediaMetaData = ...
        Description: QMediaMetaData = ...
        Genre: QMediaMetaData = ...
        Date: QMediaMetaData = ...
        Language: QMediaMetaData = ...
        Publisher: QMediaMetaData = ...
        Copyright: QMediaMetaData = ...
        Url: QMediaMetaData = ...
        Duration: QMediaMetaData = ...
        MediaType: QMediaMetaData = ...
        FileFormat: QMediaMetaData = ...
        AudioBitRate: QMediaMetaData = ...
        AudioCodec: QMediaMetaData = ...
        VideoBitRate: QMediaMetaData = ...
        VideoCodec: QMediaMetaData = ...
        VideoFrameRate: QMediaMetaData = ...
        AlbumTitle: QMediaMetaData = ...
        AlbumArtist: QMediaMetaData = ...
        ContributingArtist: QMediaMetaData = ...
        TrackNumber: QMediaMetaData = ...
        Composer: QMediaMetaData = ...
        LeadPerformer: QMediaMetaData = ...
        ThumbnailImage: QMediaMetaData = ...
        CoverArtImage: QMediaMetaData = ...
        Orientation: QMediaMetaData = ...
        Resolution: QMediaMetaData = ...

    @typing.overload
    def __init__(self) -> None:
        ...

    @typing.overload
    def __init__(self, a0: "QMediaMetaData") -> None:
        ...

    @staticmethod
    def metaDataKeyToString(k: "QMediaMetaData.Key") -> str:
        """
        https://doc.qt.io/qt-6/qmediametadata.html#metaDataKeyToString

        **[static invokable] QString
        QMediaMetaData::metaDataKeyToString(QMediaMetaData::Key key )**

        returns a string representation of **key** that can be used when
        presenting meta data to users.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def stringValue(self, k: "QMediaMetaData.Key") -> str:
        """
        https://doc.qt.io/qt-6/qmediametadata.html#stringValue

        **[invokable] QString QMediaMetaData::stringValue(QMediaMetaData::Key
        key ) const**

        Returns the meta data for key **key** as a **QString** .

        This is mainly meant to simplify presenting the meta data to a user.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def keys(self) -> typing.List["QMediaMetaData.Key"]:
        """
        https://doc.qt.io/qt-6/qmediametadata.html#keys

        **[invokable] QList<QMediaMetaData::Key> QMediaMetaData::keys() const**

        Returns a **QList**  of QMediaMetaData::Keys.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def insert(self, k: "QMediaMetaData.Key", value: typing.Any) -> None:
        """
        https://doc.qt.io/qt-6/qmediametadata.html#insert

        **[invokable] void QMediaMetaData::insert(QMediaMetaData::Key k , const
        QVariant & value )**

        Inserts a **value** into a Key: **k**.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def value(self, k: "QMediaMetaData.Key") -> typing.Any:
        """
        https://doc.qt.io/qt-6/qmediametadata.html#value

        **[invokable] QVariant QMediaMetaData::value(QMediaMetaData::Key key )
        const**

        Returns the meta data value for Key **key** , or a null **QVariant**  if
        no meta data for the key is available.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...
