"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtGui
from PyQt6 import QtCore
from PyQt6.QtMultimedia import *
import enum


class QVideoFrame(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qvideoframe.html

    **Detailed Description**

    A QVideoFrame encapsulates the pixel data of a video frame, and information
    about the frame.

    Video frames can come from several places - decoded **media** , a **camera**
    , or generated programmatically. The way pixels are described in these
    frames can vary greatly, and some pixel formats offer greater compression
    opportunities at the expense of ease of use.

    The pixel contents of a video frame can be mapped to memory using the
    **map** () function. After a successful call to **map** (), the video data
    can be accessed through various functions. Some of the YUV pixel formats
    provide the data in several planes. The **planeCount** () method will return
    the amount of planes that being used.

    While mapped, the video data of each plane can accessed using the **bits**
    () function, which returns a pointer to a buffer. The size of this buffer is
    given by the **mappedBytes** () function, and the size of each line is given
    by **bytesPerLine** (). The return value of the handle() function may also
    be used to access frame data using the internal buffer's native APIs (for
    example - an OpenGL texture handle).

    A video frame can also have timestamp information associated with it. These
    timestamps can be used to determine when to start and stop displaying the
    frame.

    QVideoFrame objects can consume a significant amount of memory or system
    resources and should not be held for longer than required by the
    application.

    **Note:** Since video frames can be expensive to copy, QVideoFrame is
    explicitly shared, so any change made to a video frame will also apply to
    any copies.
    """

    class MapMode(enum.Enum):
        NotMapped: QVideoFrame = ...
        ReadOnly: QVideoFrame = ...
        WriteOnly: QVideoFrame = ...
        ReadWrite: QVideoFrame = ...

    class HandleType(enum.Enum):
        NoHandle: QVideoFrame = ...
        RhiTextureHandle: QVideoFrame = ...

    class PaintOptions(PyQt6.sip.simplewrapper):
        class PaintFlag(enum.Flag):
            DontDrawSubtitles: QVideoFrame = ...

        aspectRatioMode: QtCore = ...
        backgroundColor: typing = ...
        paintFlags = ...

        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QVideoFrame.PaintOptions") -> None:
            ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qvideoframe.html#QVideoFrame

        **QVideoFrame::QVideoFrame()**

        Constructs a null video frame.
        """
        ...

    @typing.overload
    def __init__(self, format: "QVideoFrameFormat") -> None:
        """
        https://doc.qt.io/qt-6/qvideoframe.html#QVideoFrame-1

        **QVideoFrame::QVideoFrame(const QVideoFrameFormat & format )**

        Constructs a video frame of the given pixel **format**.
        """
        ...

    @typing.overload
    def __init__(self, other: "QVideoFrame") -> None:
        """
        https://doc.qt.io/qt-6/qvideoframe.html#QVideoFrame-2

        **QVideoFrame::QVideoFrame(const QVideoFrame & other )**

        Constructs a shallow copy of **other**. Since QVideoFrame is explicitly
        shared, these two instances will reflect the same frame.
        """
        ...

    def paint(
        self,
        painter: QtGui.QPainter,
        rect: QtCore.QRectF,
        options: "QVideoFrame.PaintOptions",
    ) -> None:
        """
        https://doc.qt.io/qt-6/qvideoframe.html#paint

        **void QVideoFrame::paint(QPainter * painter , const QRectF & rect ,
        const QVideoFrame::PaintOptions & options )**

        Uses a **QPainter** , **painter** , to render this **QVideoFrame**  to
        **rect**. The PaintOptions **options** can be used to specify a
        background color and how **rect** should be filled with the video.

        **Note:** that rendering will usually happen without hardware
        acceleration when using this method.
        """
        ...

    def setSubtitleText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qvideoframe.html#setSubtitleText

        **void QVideoFrame::setSubtitleText(const QString & text )**

        Sets the subtitle text that should be rendered together with this video
        frame to **text**.

        **See also** **subtitleText** ().
        """
        ...

    def subtitleText(self) -> str:
        """
        https://doc.qt.io/qt-6/qvideoframe.html#subtitleText

        **QString QVideoFrame::subtitleText() const**

        Returns the subtitle text that should be rendered together with this
        video frame.

        **See also** **setSubtitleText** ().
        """
        ...

    def toImage(self) -> QtGui.QImage:
        """
        https://doc.qt.io/qt-6/qvideoframe.html#toImage

        **QImage QVideoFrame::toImage() const**

        Based on the pixel format converts current video frame to image.
        """
        ...

    def surfaceFormat(self) -> "QVideoFrameFormat":
        """
        https://doc.qt.io/qt-6/qvideoframe.html#surfaceFormat

        **QVideoFrameFormat QVideoFrame::surfaceFormat() const**

        Returns the surface format of this video frame.
        """
        ...

    def planeCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qvideoframe.html#planeCount

        **int QVideoFrame::planeCount() const**

        Returns the number of planes in the video frame.

        **See also** **map** ().
        """
        ...

    def setEndTime(self, time: int) -> None:
        """
        https://doc.qt.io/qt-6/qvideoframe.html#setEndTime

        **void QVideoFrame::setEndTime(qint64 time )**

        Sets the presentation **time** (in microseconds) when a frame should
        stop being displayed.

        An invalid time is represented as -1.

        **See also** **endTime** ().
        """
        ...

    def endTime(self) -> int:
        """
        https://doc.qt.io/qt-6/qvideoframe.html#endTime

        **qint64 QVideoFrame::endTime() const**

        Returns the presentation time (in microseconds) when a frame should stop
        being displayed.

        An invalid time is represented as -1.

        **See also** **setEndTime** ().
        """
        ...

    def setStartTime(self, time: int) -> None:
        """
        https://doc.qt.io/qt-6/qvideoframe.html#setStartTime

        **void QVideoFrame::setStartTime(qint64 time )**

        Sets the presentation **time** (in microseconds) when the frame should
        initially be displayed.

        An invalid time is represented as -1.

        **See also** **startTime** ().
        """
        ...

    def startTime(self) -> int:
        """
        https://doc.qt.io/qt-6/qvideoframe.html#startTime

        **qint64 QVideoFrame::startTime() const**

        Returns the presentation time (in microseconds) when the frame should be
        displayed.

        An invalid time is represented as -1.

        **See also** **setStartTime** ().
        """
        ...

    def mappedBytes(self, plane: int) -> int:
        """
        https://doc.qt.io/qt-6/qvideoframe.html#mappedBytes

        **int QVideoFrame::mappedBytes(int plane ) const**

        Returns the number of bytes occupied by plane **plane** of the mapped
        frame data.

        This value is only valid while the frame data is **mapped** .

        **See also** **map** ().
        """
        ...

    def bits(self, plane: int) -> PyQt6.sip.voidptr:
        """
        https://doc.qt.io/qt-6/qvideoframe.html#bits

        **uchar *QVideoFrame::bits(int plane )**

        Returns a pointer to the start of the frame data buffer for a **plane**.

        This value is only valid while the frame data is **mapped** .

        Changes made to data accessed via this pointer (when mapped with write
        access) are only guaranteed to have been persisted when **unmap** () is
        called and when the buffer has been mapped for writing.

        **See also** **map** (), **mappedBytes** (), **bytesPerLine** (), and
        **planeCount** ().
        """
        ...

    def bytesPerLine(self, plane: int) -> int:
        """
        https://doc.qt.io/qt-6/qvideoframe.html#bytesPerLine

        **int QVideoFrame::bytesPerLine(int plane ) const**

        Returns the number of bytes in a scan line of a **plane**.

        This value is only valid while the frame data is **mapped** .

        **See also** **bits** (), **map** (), **mappedBytes** (), and
        **planeCount** ().
        """
        ...

    def unmap(self) -> None:
        """
        https://doc.qt.io/qt-6/qvideoframe.html#unmap

        **void QVideoFrame::unmap()**

        Releases the memory mapped by the **map** () function.

        If the **MapMode**  included the **QVideoFrame::WriteOnly**  flag this
        will persist the current content of the mapped memory to the video
        frame.

        unmap() should not be called if **map** () function failed.

        **See also** **map** ().
        """
        ...

    def map(self, mode: "QVideoFrame.MapMode") -> bool:
        """
        https://doc.qt.io/qt-6/qvideoframe.html#map

        **bool QVideoFrame::map(QVideoFrame::MapMode mode )**

        Maps the contents of a video frame to system (CPU addressable) memory.

        In some cases the video frame data might be stored in video memory or
        otherwise inaccessible memory, so it is necessary to map a frame before
        accessing the pixel data. This may involve copying the contents around,
        so avoid mapping and unmapping unless required.

        The map **mode** indicates whether the contents of the mapped memory
        should be read from and/or written to the frame. If the map mode
        includes the `QVideoFrame::ReadOnly` flag the mapped memory will be
        populated with the content of the video frame when initially mapped. If
        the map mode includes the `QVideoFrame::WriteOnly` flag the content of
        the possibly modified mapped memory will be written back to the frame
        when unmapped.

        While mapped the contents of a video frame can be accessed directly
        through the pointer returned by the **bits** () function.

        When access to the data is no longer needed, be sure to call the
        **unmap** () function to release the mapped memory and possibly update
        the video frame contents.

        If the video frame has been mapped in read only mode, it is permissible
        to map it multiple times in read only mode (and unmap it a corresponding
        number of times). In all other cases it is necessary to unmap the frame
        first before mapping a second time.

        **Note:** Writing to memory that is mapped as read-only is undefined,
        and may result in changes to shared data or crashes.

        Returns true if the frame was mapped to memory in the given **mode** and
        false otherwise.

        **See also** **unmap** (), **mapMode** (), and **bits** ().
        """
        ...

    def mapMode(self) -> "QVideoFrame.MapMode":
        """
        https://doc.qt.io/qt-6/qvideoframe.html#mapMode

        **QVideoFrame::MapMode QVideoFrame::mapMode() const**

        Returns the mode a video frame was mapped to system memory in.

        **See also** **map** () and **QVideoFrame::MapMode** .
        """
        ...

    def isWritable(self) -> bool:
        """
        https://doc.qt.io/qt-6/qvideoframe.html#isWritable

        **bool QVideoFrame::isWritable() const**

        Identifies if the mapped contents of a video frame will be persisted
        when the frame is unmapped.

        This is a convenience function which checks if the **MapMode**  contains
        the **QVideoFrame::WriteOnly**  flag.

        Returns true if the video frame will be updated when unmapped, and false
        otherwise.

        **Note:** The result of altering the data of a frame that is mapped in
        read-only mode is undefined. Depending on the buffer implementation the
        changes may be persisted, or worse alter a shared buffer.

        **See also** **mapMode** () and **QVideoFrame::MapMode** .
        """
        ...

    def isReadable(self) -> bool:
        """
        https://doc.qt.io/qt-6/qvideoframe.html#isReadable

        **bool QVideoFrame::isReadable() const**

        Identifies if the mapped contents of a video frame were read from the
        frame when it was mapped.

        This is a convenience function which checks if the **MapMode**  contains
        the **QVideoFrame::WriteOnly**  flag.

        Returns true if the contents of the mapped memory were read from the
        video frame, and false otherwise.

        **See also** **mapMode** () and **QVideoFrame::MapMode** .
        """
        ...

    def isMapped(self) -> bool:
        """
        https://doc.qt.io/qt-6/qvideoframe.html#isMapped

        **bool QVideoFrame::isMapped() const**

        Identifies if a video frame's contents are currently mapped to system
        memory.

        This is a convenience function which checks that the **MapMode**  of the
        frame is not equal to **QVideoFrame::NotMapped** .

        Returns true if the contents of the video frame are mapped to system
        memory, and false otherwise.

        **See also** **mapMode** () and **QVideoFrame::MapMode** .
        """
        ...

    def height(self) -> int:
        """
        https://doc.qt.io/qt-6/qvideoframe.html#height

        **int QVideoFrame::height() const**

        Returns the height of a video frame.
        """
        ...

    def width(self) -> int:
        """
        https://doc.qt.io/qt-6/qvideoframe.html#width

        **int QVideoFrame::width() const**

        Returns the width of a video frame.
        """
        ...

    def size(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qvideoframe.html#size

        **QSize QVideoFrame::size() const**

        Returns the dimensions of a video frame.
        """
        ...

    def handleType(self) -> "QVideoFrame.HandleType":
        """
        https://doc.qt.io/qt-6/qvideoframe.html#handleType

        **QVideoFrame::HandleType QVideoFrame::handleType() const**

        Returns the type of a video frame's handle.

        The handle type could either be **NoHandle** , meaning that the frame is
        memory based, or a RHI texture.
        """
        ...

    def pixelFormat(self) -> "QVideoFrameFormat.PixelFormat":
        """
        https://doc.qt.io/qt-6/qvideoframe.html#pixelFormat

        **QVideoFrameFormat::PixelFormat QVideoFrame::pixelFormat() const**

        Returns the pixel format of this video frame.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qvideoframe.html#isValid

        **bool QVideoFrame::isValid() const**

        Identifies whether a video frame is valid.

        An invalid frame has no video buffer associated with it.

        Returns true if the frame is valid, and false if it is not.
        """
        ...
