"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtGui
from PyQt6 import QtCore
from PyQt6.QtMultimedia import *
import enum


class QVideoFrameFormat(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qvideoframeformat.html

    **Detailed Description**

    A video sink presents a stream of video frames. QVideoFrameFormat describes
    the type of the frames and determines how they should be presented.

    The core properties of a video stream required to setup a video sink are the
    pixel format given by **pixelFormat** (), and the frame dimensions given by
    **frameSize** ().

    The region of a frame that is actually displayed on a video surface is given
    by the **viewport** (). A stream may have a viewport less than the entire
    region of a frame to allow for videos smaller than the nearest optimal size
    of a video frame. For example the width of a frame may be extended so that
    the start of each scan line is eight byte aligned.

    Other common properties are the **scanLineDirection** (), **frameRate** ()
    and the yCrCbColorSpace().
    """

    class YCbCrColorSpace(enum.Enum):
        YCbCr_Undefined: QVideoFrameFormat = ...
        YCbCr_BT601: QVideoFrameFormat = ...
        YCbCr_BT709: QVideoFrameFormat = ...
        YCbCr_xvYCC601: QVideoFrameFormat = ...
        YCbCr_xvYCC709: QVideoFrameFormat = ...
        YCbCr_JPEG: QVideoFrameFormat = ...

    class Direction(enum.Enum):
        TopToBottom: QVideoFrameFormat = ...
        BottomToTop: QVideoFrameFormat = ...

    class PixelFormat(enum.Enum):
        Format_Invalid: QVideoFrameFormat = ...
        Format_YUV420P: QVideoFrameFormat = ...
        Format_YUV422P: QVideoFrameFormat = ...
        Format_YV12: QVideoFrameFormat = ...
        Format_UYVY: QVideoFrameFormat = ...
        Format_YUYV: QVideoFrameFormat = ...
        Format_NV12: QVideoFrameFormat = ...
        Format_NV21: QVideoFrameFormat = ...
        Format_IMC1: QVideoFrameFormat = ...
        Format_IMC2: QVideoFrameFormat = ...
        Format_IMC3: QVideoFrameFormat = ...
        Format_IMC4: QVideoFrameFormat = ...
        Format_Y8: QVideoFrameFormat = ...
        Format_Y16: QVideoFrameFormat = ...
        Format_P010: QVideoFrameFormat = ...
        Format_P016: QVideoFrameFormat = ...
        Format_Jpeg: QVideoFrameFormat = ...
        Format_SamplerExternalOES: QVideoFrameFormat = ...
        Format_ARGB8888: QVideoFrameFormat = ...
        Format_ARGB8888_Premultiplied: QVideoFrameFormat = ...
        Format_XRGB8888: QVideoFrameFormat = ...
        Format_BGRA8888: QVideoFrameFormat = ...
        Format_BGRA8888_Premultiplied: QVideoFrameFormat = ...
        Format_BGRX8888: QVideoFrameFormat = ...
        Format_ABGR8888: QVideoFrameFormat = ...
        Format_XBGR8888: QVideoFrameFormat = ...
        Format_RGBA8888: QVideoFrameFormat = ...
        Format_RGBX8888: QVideoFrameFormat = ...
        Format_AYUV: QVideoFrameFormat = ...
        Format_AYUV_Premultiplied: QVideoFrameFormat = ...
        Format_SamplerRect: QVideoFrameFormat = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#QVideoFrameFormat

        **QVideoFrameFormat::QVideoFrameFormat()**

        Constructs a null video stream format.
        """
        ...

    @typing.overload
    def __init__(
        self, size: QtCore.QSize, pixelFormat: "QVideoFrameFormat.PixelFormat"
    ) -> None:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#QVideoFrameFormat-1

        **QVideoFrameFormat::QVideoFrameFormat(const QSize & size ,
        QVideoFrameFormat::PixelFormat format )**

        Constructs a video stream with the given frame **size** and pixel
        **format**.
        """
        ...

    @typing.overload
    def __init__(self, format: "QVideoFrameFormat") -> None:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#QVideoFrameFormat-2

        **QVideoFrameFormat::QVideoFrameFormat(const QVideoFrameFormat & other
        )**

        Constructs a copy of **other**.
        """
        ...

    @staticmethod
    def imageFormatFromPixelFormat(
        format: "QVideoFrameFormat.PixelFormat",
    ) -> QtGui.QImage.Format:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#imageFormatFromPixelFormat

        **[static] QImage::Format QVideoFrameFormat::imageFormatFromPixelFormat(
        QVideoFrameFormat::PixelFormat format )**

        Returns an image format equivalent to a video frame pixel **format**. If
        there is no equivalent format **QImage::Format_Invalid**  is returned
        instead.

        **Note:** In general **QImage**  does not handle YUV formats.
        """
        ...

    @staticmethod
    def pixelFormatFromImageFormat(
        format: QtGui.QImage.Format,
    ) -> "QVideoFrameFormat.PixelFormat":
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#pixelFormatFromImageFormat

        **[static] QVideoFrameFormat::PixelFormat
        QVideoFrameFormat::pixelFormatFromImageFormat(QImage::Format format )**

        Returns a video pixel format equivalent to an image **format**. If there
        is no equivalent format **QVideoFrameFormat::Format_Invalid**  is
        returned instead.

        **Note:** In general **QImage**  does not handle YUV formats.
        """
        ...

    def setMirrored(self, mirrored: bool) -> None:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#setMirrored

        **void QVideoFrameFormat::setMirrored(bool mirrored )**

        Sets if the surface is **mirrored** around its vertical axis. This is
        typically needed for video frames coming from a front camera of a mobile
        device. Default value is false.

        **Note:** The mirroring here differs from **QImage::mirrored** , as a
        vertically mirrored **QImage**  will be mirrored around its x-axis.

        **See also** **isMirrored** ().
        """
        ...

    def isMirrored(self) -> bool:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#isMirrored

        **bool QVideoFrameFormat::isMirrored() const**

        Returns `true` if the surface is mirrored around its vertical axis. This
        is typically needed for video frames coming from a front camera of a
        mobile device.

        **Note:** The mirroring here differs from **QImage::mirrored** , as a
        vertically mirrored **QImage**  will be mirrored around its x-axis.
        """
        ...

    def setYCbCrColorSpace(
        self, colorSpace: "QVideoFrameFormat.YCbCrColorSpace"
    ) -> None:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#setYCbCrColorSpace

        **void
        QVideoFrameFormat::setYCbCrColorSpace(QVideoFrameFormat::YCbCrColorSpace
        space )**

        Sets the Y'CbCr color **space** of a video stream. It is only used with
        raw YUV frame types.

        **See also** **yCbCrColorSpace** ().
        """
        ...

    def yCbCrColorSpace(self) -> "QVideoFrameFormat.YCbCrColorSpace":
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#yCbCrColorSpace

        **QVideoFrameFormat::YCbCrColorSpace
        QVideoFrameFormat::yCbCrColorSpace() const**

        Returns the Y'CbCr color space of a video stream.

        **See also** **setYCbCrColorSpace** ().
        """
        ...

    def setFrameRate(self, rate: float) -> None:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#setFrameRate

        **void QVideoFrameFormat::setFrameRate(qreal rate )**

        Sets the frame **rate** of a video stream in frames per second.

        **See also** **frameRate** ().
        """
        ...

    def frameRate(self) -> float:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#frameRate

        **qreal QVideoFrameFormat::frameRate() const**

        Returns the frame rate of a video stream in frames per second.

        **See also** **setFrameRate** ().
        """
        ...

    def setScanLineDirection(self, direction: "QVideoFrameFormat.Direction") -> None:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#setScanLineDirection

        **void
        QVideoFrameFormat::setScanLineDirection(QVideoFrameFormat::Direction
        direction )**

        Sets the **direction** of scan lines.

        **See also** **scanLineDirection** ().
        """
        ...

    def scanLineDirection(self) -> "QVideoFrameFormat.Direction":
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#scanLineDirection

        **QVideoFrameFormat::Direction QVideoFrameFormat::scanLineDirection()
        const**

        Returns the direction of scan lines.

        **See also** **setScanLineDirection** ().
        """
        ...

    def setViewport(self, viewport: QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#setViewport

        **void QVideoFrameFormat::setViewport(const QRect & viewport )**

        Sets the viewport of a video stream to **viewport**.

        **See also** **viewport** ().
        """
        ...

    def viewport(self) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#viewport

        **QRect QVideoFrameFormat::viewport() const**

        Returns the viewport of a video stream.

        The viewport is the region of a video frame that is actually displayed.

        By default the viewport covers an entire frame.

        **See also** **setViewport** ().
        """
        ...

    def planeCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#planeCount

        **int QVideoFrameFormat::planeCount() const**

        Returns the number of planes used. This number is depending on the pixel
        format and is 1 for RGB based formats, and a number between 1 and 3 for
        YUV based formats.
        """
        ...

    def frameHeight(self) -> int:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#frameHeight

        **int QVideoFrameFormat::frameHeight() const**

        Returns the height of frame in a video stream.
        """
        ...

    def frameWidth(self) -> int:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#frameWidth

        **int QVideoFrameFormat::frameWidth() const**

        Returns the width of frames in a video stream.

        **See also** **frameSize** () and **frameHeight** ().
        """
        ...

    @typing.overload
    def setFrameSize(self, size: QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#setFrameSize

        **void QVideoFrameFormat::setFrameSize(const QSize & size )**

        Sets the size of frames in a video stream to **size**.

        This will reset the **viewport** () to fill the entire frame.

        **See also** **frameSize** ().
        """
        ...

    @typing.overload
    def setFrameSize(self, width: int, height: int) -> None:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#setFrameSize-1

        **void QVideoFrameFormat::setFrameSize(int width , int height )**

        This is an overloaded function.

        Sets the **width** and **height** of frames in a video stream.

        This will reset the **viewport** () to fill the entire frame.
        """
        ...

    def frameSize(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#frameSize

        **QSize QVideoFrameFormat::frameSize() const**

        Returns the dimensions of frames in a video stream.

        **See also** **setFrameSize** (), **frameWidth** (), and **frameHeight**
        ().
        """
        ...

    def pixelFormat(self) -> "QVideoFrameFormat.PixelFormat":
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#pixelFormat

        **QVideoFrameFormat::PixelFormat QVideoFrameFormat::pixelFormat()
        const**

        Returns the pixel format of frames in a video stream.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qvideoframeformat.html#isValid

        **bool QVideoFrameFormat::isValid() const**

        Identifies if a video surface format has a valid pixel format and frame
        size.

        Returns true if the format is valid, and false otherwise.
        """
        ...
