"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt6 import QtCore
from PyQt6.QtMultimedia import *


class QVideoSink(QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qvideosink.html

    **Detailed Description**

    The QVideoSink class can be used to retrieve video data on a frame by frame
    basis from Qt Multimedia.

    QVideoSink can operate in two modes. In the first mode, it can render the
    video stream to a native window of the underlying windowing system. In the
    other mode, it will provide individual video frames to the application
    developer through the videoFrameChanged() signal.

    The video frame can then be used to read out the data of those frames and
    handle them further. When using **QPainter** , the **QVideoFrame**  can be
    drawing using the paint() method in QVideoSink.

    **QVideoFrame**  objects can consume a significant amount of memory or
    system resources and should thus not be held for longer than required by the
    application.

    **See also** **QMediaPlayer**  and **QMediaCaptureSession** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qvideosink.html#QVideoSink

        **QVideoSink::QVideoSink(QObject * parent = nullptr)**

        Constructs a new QVideoSink object with **parent**.
        """
        ...

    def videoFrame(self) -> QVideoFrame:
        """
        https://doc.qt.io/qt-6/qvideosink.html#videoFrame

        **QVideoFrame QVideoSink::videoFrame() const**

        Returns the current video frame.

        **See also** **setVideoFrame** ().
        """
        ...

    def setVideoFrame(self, frame: QVideoFrame) -> None:
        """
        https://doc.qt.io/qt-6/qvideosink.html#setVideoFrame

        **void QVideoSink::setVideoFrame(const QVideoFrame & frame )**

        Sets the current video **frame**.

        **See also** **videoFrame** ().
        """
        ...

    def setSubtitleText(self, subtitle: str) -> None:
        """
        https://doc.qt.io/qt-6/qvideosink.html#setSubtitleText

        **void QVideoSink::setSubtitleText(const QString & subtitle )**

        Sets the current **subtitle** text.

        **See also** **subtitleText** ().
        """
        ...

    def subtitleText(self) -> str:
        """
        https://doc.qt.io/qt-6/qvideosink.html#subtitleText

        **QString QVideoSink::subtitleText() const**

        Returns the current subtitle text.

        **See also** **setSubtitleText** ().
        """
        ...

    def videoSize(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qvideosink.html#videoSize

        **QSize QVideoSink::videoSize() const**

        Returns the size of the video currently being played back. If no video
        is being played, this method returns an invalid size.
        """
        ...
