"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6 import QtWidgets
from PyQt6 import QtMultimedia
from PyQt6 import QtCore
from PyQt6.QtMultimediaWidgets import *


class QGraphicsVideoItem(QtWidgets.QGraphicsObject):
    """
    https://doc.qt.io/qt-6/qgraphicsvideoitem.html

    **Detailed Description**

    Attaching a QGraphicsVideoItem to a **QMediaPlayer**  or **QCamera**  allows
    it to display the video or image output of that media object.

    player = new **QMediaPlayer** (this);

        **QGraphicsVideoItem**  *item
    = new **QGraphicsVideoItem** ;
        player->setVideoOutput(item);
    graphicsView->scene()->addItem(item);
        graphicsView->show();
    player->setSource(**QUrl** ("http://example.com/myclip4.ogv"));
    player->play();

    **Note** : Only a single display output can be attached to a media object at
    one time.

    **See also** **QMediaPlayer** , **QVideoWidget** , and **QCamera** .
    """

    def __init__(self, parent: typing.Optional[QtWidgets.QGraphicsItem] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsvideoitem.html#QGraphicsVideoItem

        **QGraphicsVideoItem::QGraphicsVideoItem(QGraphicsItem * parent =
        nullptr)**

        Constructs a graphics item that displays video.

        The **parent** is passed to **QGraphicsItem** .
        """
        ...

    def itemChange(
        self, change: QtWidgets.QGraphicsItem.GraphicsItemChange, value: typing.Any
    ) -> typing.Any:
        ...

    def timerEvent(self, event: QtCore.QTimerEvent) -> None:
        ...

    def type(self) -> int:
        ...

    def paint(
        self,
        painter: QtGui.QPainter,
        option: QtWidgets.QStyleOptionGraphicsItem,
        widget: typing.Optional[QtWidgets.QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsvideoitem.html#paint

        **[override virtual] void QGraphicsVideoItem::paint(QPainter * painter ,
        const QStyleOptionGraphicsItem * option , QWidget * widget = nullptr)**

        Reimplements: **QGraphicsItem::paint** (QPainter *painter, const
        QStyleOptionGraphicsItem *option, QWidget *widget).
        """
        ...

    def boundingRect(self) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qgraphicsvideoitem.html#boundingRect

        **[override virtual] QRectF QGraphicsVideoItem::boundingRect() const**

        Reimplements: **QGraphicsItem::boundingRect() const** .
        """
        ...

    def nativeSize(self) -> QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qgraphicsvideoitem.html#nativeSize-prop

        **[read-only] nativeSize : const QSizeF**

        This property holds the native size of the video.

        **Access functions:**

        QSizeF **nativeSize** () const

        **Notifier signal:**

        void ****nativeSizeChanged** ** (const QSizeF & **size** )
        """
        ...

    def setSize(self, size: QtCore.QSizeF) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsvideoitem.html#size-prop

        **size : QSizeF**

        This property holds the video item's size.

        **QGraphicsVideoItem**  will draw video scaled to fit size according to
        its fillMode.

        **Access functions:**

        QSizeF **size** () const
        void **setSize** (const QSizeF & **size** )
        """
        ...

    def size(self) -> QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qgraphicsvideoitem.html#size-prop

        **size : QSizeF**

        This property holds the video item's size.

        **QGraphicsVideoItem**  will draw video scaled to fit size according to
        its fillMode.

        **Access functions:**

        QSizeF **size** () const
        void **setSize** (const QSizeF & **size** )
        """
        ...

    def setOffset(self, offset: QtCore.QPointF) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsvideoitem.html#offset-prop

        **offset : QPointF**

        This property holds the video item's offset.

        **QGraphicsVideoItem**  will draw video using the offset for its top
        left corner.

        **Access functions:**

        QPointF **offset** () const
        void **setOffset** (const QPointF &
        **offset** )
        """
        ...

    def offset(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qgraphicsvideoitem.html#offset-prop

        **offset : QPointF**

        This property holds the video item's offset.

        **QGraphicsVideoItem**  will draw video using the offset for its top
        left corner.

        **Access functions:**

        QPointF **offset** () const
        void **setOffset** (const QPointF &
        **offset** )
        """
        ...

    def setAspectRatioMode(self, mode: QtCore.Qt.AspectRatioMode) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsvideoitem.html#aspectRatioMode-prop

        **aspectRatioMode : Qt::AspectRatioMode**

        how a video is scaled to fit the graphics item's size.

        **Access functions:**

        Qt::AspectRatioMode **aspectRatioMode** () const
        void
        **setAspectRatioMode** (Qt::AspectRatioMode **mode** )
        """
        ...

    def aspectRatioMode(self) -> QtCore.Qt.AspectRatioMode:
        """
        https://doc.qt.io/qt-6/qgraphicsvideoitem.html#aspectRatioMode-prop

        **aspectRatioMode : Qt::AspectRatioMode**

        how a video is scaled to fit the graphics item's size.

        **Access functions:**

        Qt::AspectRatioMode **aspectRatioMode** () const
        void
        **setAspectRatioMode** (Qt::AspectRatioMode **mode** )
        """
        ...

    def videoSink(self) -> QtMultimedia.QVideoSink:
        """
        https://doc.qt.io/qt-6/qgraphicsvideoitem.html#videoSink-prop

        **[read-only] videoSink : QVideoSink* const**

        Returns the underlying video sink that can render video frames to the
        current item. This property is never `nullptr`. Example of how to render
        video frames to **QGraphicsVideoItem** :

        **QGraphicsVideoItem**  *item = new **QGraphicsVideoItem** ;
        graphicsView->scene()->addItem(item);
            graphicsView->show();
        **QImage**  img = **QImage** ("images/qt-
        logo.png").convertToFormat(**QImage** ::Format_ARGB32);
        item->videoSink()->setVideoFrame(**QVideoFrame** (img));

        **Access functions:**

        QVideoSink * **videoSink** () const[see note below]

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        **See also** **QMediaPlayer::setVideoOutput** .

        **Member Function Documentation**
        """
        ...

    @property
    def nativeSizeChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qgraphicsvideoitem.html#nativeSizeChanged

        **[signal] void QGraphicsVideoItem::nativeSizeChanged(const QSizeF &
        size )**

        Signals that the native **size** of the video has changed.

        **Note:** Notifier signal for property **nativeSize** .
        """
        ...
