"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6 import QtWidgets
from PyQt6 import QtMultimedia
from PyQt6 import QtCore
from PyQt6.QtMultimediaWidgets import *


class QVideoWidget(QtWidgets.QWidget):
    """
    https://doc.qt.io/qt-6/qvideowidget.html

    **Detailed Description**

    Attaching a QVideoWidget to a **QMediaPlayer**  or **QCamera**  allows it to
    display the video or image output of that object.

    player = new **QMediaPlayer** ;
        player->setSource(**QUrl**
    ("http://example.com/myclip1.mp4"));

        videoWidget = new
    **QVideoWidget** ;
        player->setVideoOutput(videoWidget);
    videoWidget->show();
        player->play();

    **Note** : Only a single display output can be attached to a media object at
    one time.

    **See also** **QCamera** , **QMediaPlayer** , and **QGraphicsVideoItem** .
    """

    def __init__(self, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qvideowidget.html#QVideoWidget

        **QVideoWidget::QVideoWidget(QWidget * parent = nullptr)**

        Constructs a new video widget.

        The **parent** is passed to **QWidget** .
        """
        ...

    def moveEvent(self, event: QtGui.QMoveEvent) -> None:
        """
        https://doc.qt.io/qt-6/qvideowidget.html#moveEvent

        **[override virtual protected] void QVideoWidget::moveEvent(QMoveEvent *
        event )**

        Reimplements: **QWidget::moveEvent** (QMoveEvent *event).

        Handles the move **event**.
        """
        ...

    def resizeEvent(self, event: QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-6/qvideowidget.html#resizeEvent

        **[override virtual protected] void
        QVideoWidget::resizeEvent(QResizeEvent * event )**

        Reimplements: **QWidget::resizeEvent** (QResizeEvent *event).

        Handles the resize **event**.
        """
        ...

    def hideEvent(self, event: QtGui.QHideEvent) -> None:
        """
        https://doc.qt.io/qt-6/qvideowidget.html#hideEvent

        **[override virtual protected] void QVideoWidget::hideEvent(QHideEvent *
        event )**

        Reimplements: **QWidget::hideEvent** (QHideEvent *event).

        Handles the hide **event**.
        """
        ...

    def showEvent(self, event: QtGui.QShowEvent) -> None:
        """
        https://doc.qt.io/qt-6/qvideowidget.html#showEvent

        **[override virtual protected] void QVideoWidget::showEvent(QShowEvent *
        event )**

        Reimplements: **QWidget::showEvent** (QShowEvent *event).

        Handles the show **event**.
        """
        ...

    def event(self, event: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qvideowidget.html#event

        **[override virtual protected] bool QVideoWidget::event(QEvent * event
        )**

        Reimplements: **QWidget::event** (QEvent *event).

        Current event **event**. Returns the value of the base class
        **QWidget::event** (**QEvent**  *event) function.
        """
        ...

    def setAspectRatioMode(self, mode: QtCore.Qt.AspectRatioMode) -> None:
        """
        https://doc.qt.io/qt-6/qvideowidget.html#aspectRatioMode-prop

        **aspectRatioMode : Qt::AspectRatioMode**

        how video is scaled with respect to its aspect ratio.

        **Access functions:**

        Qt::AspectRatioMode **aspectRatioMode** () const
        void
        **setAspectRatioMode** (Qt::AspectRatioMode **mode** )

        **Notifier signal:**

        void **aspectRatioModeChanged** (Qt::AspectRatioMode **mode** )
        """
        ...

    def setFullScreen(self, fullScreen: bool) -> None:
        """
        https://doc.qt.io/qt-6/qvideowidget.html#fullScreen-prop

        **fullScreen : bool**

        This property holds whether video display is confined to a window or is
        fullScreen.

        **Access functions:**

        bool **isFullScreen** () const
        void **setFullScreen** (bool
        **fullScreen** )

        **Notifier signal:**

        void ****fullScreenChanged** ** (bool **fullScreen** )

        **Member Function Documentation**
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qvideowidget.html#sizeHint

        **[override virtual] QSize QVideoWidget::sizeHint() const**

        Reimplements an access function for property: **QWidget::sizeHint** .

        Returns the size hint for the current back end, if there is one, or else
        the size hint from **QWidget** .
        """
        ...

    def isFullScreen(self) -> bool:
        ...

    def aspectRatioMode(self) -> QtCore.Qt.AspectRatioMode:
        """
        https://doc.qt.io/qt-6/qvideowidget.html#aspectRatioMode-prop

        **aspectRatioMode : Qt::AspectRatioMode**

        how video is scaled with respect to its aspect ratio.

        **Access functions:**

        Qt::AspectRatioMode **aspectRatioMode** () const
        void
        **setAspectRatioMode** (Qt::AspectRatioMode **mode** )

        **Notifier signal:**

        void **aspectRatioModeChanged** (Qt::AspectRatioMode **mode** )
        """
        ...

    def videoSink(self) -> QtMultimedia.QVideoSink:
        ...

    @property
    def aspectRatioModeChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        ...

    @property
    def fullScreenChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qvideowidget.html#fullScreenChanged

        **[signal] void QVideoWidget::fullScreenChanged(bool fullScreen )**

        Signals that the **fullScreen** mode of a video widget has changed.

        **Note:** Notifier signal for property **fullScreen** .

        **See also** **isFullScreen** ().
        """
        ...
