"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip


class QDnsMailExchangeRecord(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qdnsmailexchangerecord.html

    **Detailed Description**

    When performing a lookup on a service, zero or more records will be
    returned. Each record is represented by a QDnsMailExchangeRecord instance.

    The meaning of the fields is defined in **RFC 1035** .

    **See also** **QDnsLookup** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qdnsmailexchangerecord.html#QDnsMailExchangeRecor
        d

        **QDnsMailExchangeRecord::QDnsMailExchangeRecord()**

        Constructs an empty mail exchange record object.
        """
        ...

    @typing.overload
    def __init__(self, other: "QDnsMailExchangeRecord") -> None:
        """
        https://doc.qt.io/qt-6/qdnsmailexchangerecord.html#QDnsMailExchangeRecor
        d-1

        **QDnsMailExchangeRecord::QDnsMailExchangeRecord(const
        QDnsMailExchangeRecord & other )**

        Constructs a copy of **other**.
        """
        ...

    def timeToLive(self) -> int:
        """
        https://doc.qt.io/qt-6/qdnsmailexchangerecord.html#timeToLive

        **quint32 QDnsMailExchangeRecord::timeToLive() const**

        Returns the duration in seconds for which this record is valid.
        """
        ...

    def preference(self) -> int:
        """
        https://doc.qt.io/qt-6/qdnsmailexchangerecord.html#preference

        **quint16 QDnsMailExchangeRecord::preference() const**

        Returns the preference for this record.
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-6/qdnsmailexchangerecord.html#name

        **QString QDnsMailExchangeRecord::name() const**

        Returns the name for this record.
        """
        ...

    def exchange(self) -> str:
        """
        https://doc.qt.io/qt-6/qdnsmailexchangerecord.html#exchange

        **QString QDnsMailExchangeRecord::exchange() const**

        Returns the domain name of the mail exchange for this record.
        """
        ...

    def swap(self, other: "QDnsMailExchangeRecord") -> None:
        """
        https://doc.qt.io/qt-6/qdnsmailexchangerecord.html#swap

        **void QDnsMailExchangeRecord::swap(QDnsMailExchangeRecord & other )**

        Swaps this mail exchange record with **other**. This function is very
        fast and never fails.
        """
        ...
