"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtNetwork import *
import enum


class QNetworkAddressEntry(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qnetworkaddressentry.html

    **Detailed Description**

    Each network interface can contain zero or more IP addresses, which in turn
    can be associated with a netmask and/or a broadcast address (depending on
    support from the operating system).

    This class represents one such group.
    """

    class DnsEligibilityStatus(enum.Enum):
        DnsEligibilityUnknown: QNetworkAddressEntry = ...
        DnsIneligible: QNetworkAddressEntry = ...
        DnsEligible: QNetworkAddressEntry = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkaddressentry.html#QNetworkAddressEntry

        **QNetworkAddressEntry::QNetworkAddressEntry()**

        Constructs an empty QNetworkAddressEntry object.
        """
        ...

    @typing.overload
    def __init__(self, other: "QNetworkAddressEntry") -> None:
        """
        https://doc.qt.io/qt-6/qnetworkaddressentry.html#QNetworkAddressEntry-1

        **QNetworkAddressEntry::QNetworkAddressEntry(const QNetworkAddressEntry
        & other )**

        Constructs a QNetworkAddressEntry object that is a copy of the object
        **other**.
        """
        ...

    def isTemporary(self) -> bool:
        """
        https://doc.qt.io/qt-6/qnetworkaddressentry.html#isTemporary

        **[since 5.11] bool QNetworkAddressEntry::isTemporary() const**

        Returns `true` if this address is temporary on this interface, `false`
        if it's permanent.

        This function was introduced in Qt 5.11.

        **See also** **isLifetimeKnown** (), **validityLifetime** (), and
        **isPermanent** ().
        """
        ...

    def isPermanent(self) -> bool:
        """
        https://doc.qt.io/qt-6/qnetworkaddressentry.html#isPermanent

        **[since 5.11] bool QNetworkAddressEntry::isPermanent() const**

        Returns `true` if this address is permanent on this interface, `false`
        if it's temporary. A permanent address is one which has no expiration
        time and is often static (manually configured).

        If this information could not be determined, this function returns
        `true`.

        **Note:** Depending on the operating system and the networking
        configuration tool, it is possible for a temporary address to be
        interpreted as permanent, if the tool did not inform the details
        correctly to the operating system.

        This function was introduced in Qt 5.11.

        **See also** **isLifetimeKnown** (), **validityLifetime** (), and
        **isTemporary** ().
        """
        ...

    def clearAddressLifetime(self) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkaddressentry.html#clearAddressLifetime

        **[since 5.11] void QNetworkAddressEntry::clearAddressLifetime()**

        Resets both the preferred and valid lifetimes for this address. After
        this call, **isLifetimeKnown** () will return `false`.

        This function was introduced in Qt 5.11.

        **See also** **preferredLifetime** (), **validityLifetime** (),
        **isLifetimeKnown** (), and **setAddressLifetime** ().
        """
        ...

    def setAddressLifetime(
        self, preferred: QtCore.QDeadlineTimer, validity: QtCore.QDeadlineTimer
    ) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkaddressentry.html#setAddressLifetime

        **[since 5.11] void
        QNetworkAddressEntry::setAddressLifetime(QDeadlineTimer preferred ,
        QDeadlineTimer validity )**

        Sets both the preferred and valid lifetimes for this address to the
        **preferred** and **validity** deadlines, respectively. After this call,
        **isLifetimeKnown** () will return `true`, even if both parameters are
        **QDeadlineTimer::Forever** .

        This function was introduced in Qt 5.11.

        **See also** **preferredLifetime** (), **validityLifetime** (),
        **isLifetimeKnown** (), and **clearAddressLifetime** ().
        """
        ...

    def validityLifetime(self) -> QtCore.QDeadlineTimer:
        """
        https://doc.qt.io/qt-6/qnetworkaddressentry.html#validityLifetime

        **[since 5.11] QDeadlineTimer QNetworkAddressEntry::validityLifetime()
        const**

        Returns the deadline when this address becomes invalid and will be
        removed from the networking stack, if known. If the address lifetime is
        not known (see **isLifetimeKnown** ()), this function always returns
        **QDeadlineTimer::Forever** .

        While an address is valid, it will be accepted by the operating system
        as a valid destination address for this machine. Whether it is used as a
        source address for new, outgoing packets is controlled by, among other
        rules, the preferred lifetime (see **preferredLifetime** ()).

        This function was introduced in Qt 5.11.

        **See also** **preferredLifetime** (), **isLifetimeKnown** (),
        **setAddressLifetime** (), and **clearAddressLifetime** ().
        """
        ...

    def preferredLifetime(self) -> QtCore.QDeadlineTimer:
        """
        https://doc.qt.io/qt-6/qnetworkaddressentry.html#preferredLifetime

        **[since 5.11] QDeadlineTimer QNetworkAddressEntry::preferredLifetime()
        const**

        Returns the deadline when this address becomes deprecated (no longer
        preferred), if known. If the address lifetime is not known (see
        **isLifetimeKnown** ()), this function always returns
        **QDeadlineTimer::Forever** .

        While an address is preferred, it may be used by the operating system as
        the source address for new, outgoing packets. After it becomes
        deprecated, it will remain valid for incoming packets for a while longer
        until finally removed (see **validityLifetime** ()).

        This function was introduced in Qt 5.11.

        **See also** **validityLifetime** (), **isLifetimeKnown** (),
        **setAddressLifetime** (), and **clearAddressLifetime** ().
        """
        ...

    def isLifetimeKnown(self) -> bool:
        """
        https://doc.qt.io/qt-6/qnetworkaddressentry.html#isLifetimeKnown

        **[since 5.11] bool QNetworkAddressEntry::isLifetimeKnown() const**

        Returns `true` if the address lifetime is known, `false` if not. If the
        lifetime is not known, both **preferredLifetime** () and
        **validityLifetime** () will return **QDeadlineTimer::Forever** .

        This function was introduced in Qt 5.11.

        **See also** **preferredLifetime** (), **validityLifetime** (),
        **setAddressLifetime** (), and **clearAddressLifetime** ().
        """
        ...

    def setDnsEligibility(
        self, status: "QNetworkAddressEntry.DnsEligibilityStatus"
    ) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkaddressentry.html#setDnsEligibility

        **[since 5.11] void QNetworkAddressEntry::setDnsEligibility(QNetworkAddr
        essEntry::DnsEligibilityStatus status )**

        Sets the DNS eligibility flag for this address to **status**.

        This function was introduced in Qt 5.11.

        **See also** **dnsEligibility** ().
        """
        ...

    def dnsEligibility(self) -> "QNetworkAddressEntry.DnsEligibilityStatus":
        """
        https://doc.qt.io/qt-6/qnetworkaddressentry.html#dnsEligibility

        **[since 5.11] QNetworkAddressEntry::DnsEligibilityStatus
        QNetworkAddressEntry::dnsEligibility() const**

        Returns whether this address is eligible for publication in the Domain
        Name System (DNS) or similar name resolution mechanisms.

        In general, an address is suitable for publication if it is an address
        this machine will be reached at for an indeterminate amount of time,
        though it need not be permanent. For example, addresses obtained via
        DHCP are often eligible, but cryptographically-generated temporary IPv6
        addresses are not.

        On some systems, **QNetworkInterface**  will need to heuristically
        determine which addresses are eligible.

        This function was introduced in Qt 5.11.

        **See also** **isLifetimeKnown** (), **isPermanent** (), and
        **setDnsEligibility** ().
        """
        ...

    def swap(self, other: "QNetworkAddressEntry") -> None:
        """
        https://doc.qt.io/qt-6/qnetworkaddressentry.html#swap

        **[since 5.0] void QNetworkAddressEntry::swap(QNetworkAddressEntry &
        other )**

        Swaps this network address entry instance with **other**. This function
        is very fast and never fails.

        This function was introduced in Qt 5.0.
        """
        ...

    def setPrefixLength(self, length: int) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkaddressentry.html#setPrefixLength

        **void QNetworkAddressEntry::setPrefixLength(int length )**

        Sets the prefix length of this IP address to **length**. The value of
        **length** must be valid for this type of IP address: between 0 and 32
        for IPv4 addresses, between 0 and 128 for IPv6 addresses. Setting to any
        invalid value is equivalent to setting to -1, which means "no prefix
        length".

        Setting the prefix length also sets the netmask (see **netmask** ()).

        **See also** **prefixLength** () and **setNetmask** ().
        """
        ...

    def prefixLength(self) -> int:
        """
        https://doc.qt.io/qt-6/qnetworkaddressentry.html#prefixLength

        **int QNetworkAddressEntry::prefixLength() const**

        Returns the prefix length of this IP address. The prefix length matches
        the number of bits set to 1 in the netmask (see **netmask** ()). For
        IPv4 addresses, the value is between 0 and 32. For IPv6 addresses, it's
        contained between 0 and 128 and is the preferred form of representing
        addresses.

        This function returns -1 if the prefix length could not be determined
        (i.e., **netmask** () returns a null QHostAddress()).

        **See also** **setPrefixLength** () and **netmask** ().
        """
        ...

    def setBroadcast(
        self, newBroadcast: typing.Union[QHostAddress, QHostAddress.SpecialAddress]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkaddressentry.html#setBroadcast

        **void QNetworkAddressEntry::setBroadcast(const QHostAddress &
        newBroadcast )**

        Sets the broadcast IP address of this **QNetworkAddressEntry**  object
        to **newBroadcast**.

        **See also** **broadcast** ().
        """
        ...

    def broadcast(self) -> QHostAddress:
        """
        https://doc.qt.io/qt-6/qnetworkaddressentry.html#broadcast

        **QHostAddress QNetworkAddressEntry::broadcast() const**

        Returns the broadcast address associated with the IPv4 address and
        netmask. It can usually be derived from those two by setting to 1 the
        bits of the IP address where the netmask contains a 0. (In other words,
        by bitwise-OR'ing the IP address with the inverse of the netmask)

        This member is always empty for IPv6 addresses, since the concept of
        broadcast has been abandoned in that system in favor of multicast. In
        particular, the group of hosts corresponding to all the nodes in the
        local network can be reached by the "all-nodes" special multicast group
        (address FF02::1).

        **See also** **setBroadcast** ().
        """
        ...

    def setNetmask(
        self, newNetmask: typing.Union[QHostAddress, QHostAddress.SpecialAddress]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkaddressentry.html#setNetmask

        **void QNetworkAddressEntry::setNetmask(const QHostAddress & newNetmask
        )**

        Sets the netmask that this **QNetworkAddressEntry**  object contains to
        **newNetmask**. Setting the netmask also sets the prefix length to match
        the new netmask.

        **See also** **netmask** () and **setPrefixLength** ().
        """
        ...

    def netmask(self) -> QHostAddress:
        """
        https://doc.qt.io/qt-6/qnetworkaddressentry.html#netmask

        **QHostAddress QNetworkAddressEntry::netmask() const**

        Returns the netmask associated with the IP address. The netmask is
        expressed in the form of an IP address, such as 255.255.0.0.

        For IPv6 addresses, the prefix length is converted to an address where
        the number of bits set to 1 is equal to the prefix length. For a prefix
        length of 64 bits (the most common value), the netmask will be expressed
        as a **QHostAddress**  holding the address FFFF:FFFF:FFFF:FFFF::

        **See also** **setNetmask** () and **prefixLength** ().
        """
        ...

    def setIp(
        self, newIp: typing.Union[QHostAddress, QHostAddress.SpecialAddress]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkaddressentry.html#setIp

        **void QNetworkAddressEntry::setIp(const QHostAddress & newIp )**

        Sets the IP address the **QNetworkAddressEntry**  object contains to
        **newIp**.

        **See also** **ip** ().
        """
        ...

    def ip(self) -> QHostAddress:
        """
        https://doc.qt.io/qt-6/qnetworkaddressentry.html#ip

        **QHostAddress QNetworkAddressEntry::ip() const**

        This function returns one IPv4 or IPv6 address found, that was found in
        a network interface.

        **See also** **setIp** ().
        """
        ...
