"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt6 import QtCore
from PyQt6.QtNetwork import *


class QNetworkDiskCache(QAbstractNetworkCache):
    """
    https://doc.qt.io/qt-6/qnetworkdiskcache.html

    **Detailed Description**

    QNetworkDiskCache stores each url in its own file inside of the
    **cacheDirectory**  using **QDataStream** . Files with a text MimeType are
    compressed using **qCompress** . Data is written to disk only in **insert**
    () and **updateMetaData** ().

    Currently you cannot share the same cache files with more than one disk
    cache.

    QNetworkDiskCache by default limits the amount of space that the cache will
    use on the system to 50MB.

    Note you have to set the cache directory before it will work.

    A network disk cache can be enabled by:

    **QNetworkAccessManager**  *manager = new **QNetworkAccessManager** (this);
    **QNetworkDiskCache**  *diskCache = new **QNetworkDiskCache** (this);
    diskCache->setCacheDirectory("cacheDir");
        manager->setCache(diskCache);

    When sending requests, to control the preference of when to use the cache
    and when to use the network, consider the following:

    // do a normal request (preferred from network, as this is the default)
    **QNetworkRequest**  request(**QUrl** (**QString** ("http://qt-
    project.org")));
        manager->get(request);

        // do a request
    preferred from cache
        **QNetworkRequest**  request2(**QUrl** (**QString**
    ("http://qt-project.org")));
        request2.setAttribute(**QNetworkRequest**
    ::CacheLoadControlAttribute, **QNetworkRequest** ::PreferCache);
    manager->get(request2);

    To check whether the response came from the cache or from the network, the
    following can be applied:

    void replyFinished(**QNetworkReply**  *reply) {
            **QVariant**
    fromCache = reply->attribute(**QNetworkRequest**
    ::SourceIsFromCacheAttribute);
            **qDebug** () << "page from cache?"
    << fromCache.toBool();
        }
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkdiskcache.html#QNetworkDiskCache

        **QNetworkDiskCache::QNetworkDiskCache(QObject * parent = nullptr)**

        Creates a new disk cache. The **parent** argument is passed to
        **QAbstractNetworkCache** 's constructor.
        """
        ...

    def expire(self) -> int:
        """
        https://doc.qt.io/qt-6/qnetworkdiskcache.html#expire

        **[virtual protected] qint64 QNetworkDiskCache::expire()**

        Cleans the cache so that its size is under the maximum cache size.
        Returns the current size of the cache.

        When the current size of the cache is greater than the
        **maximumCacheSize** () older cache files are removed until the total
        size is less then 90% of **maximumCacheSize** () starting with the
        oldest ones first using the file creation date to determine how old a
        cache file is.

        Subclasses can reimplement this function to change the order that cache
        files are removed taking into account information in the application
        knows about that **QNetworkDiskCache**  does not, for example the number
        of times a cache is accessed.

        **Note:****cacheSize** () calls expire if the current cache size is
        unknown.

        **See also** **maximumCacheSize** () and **fileMetaData** ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkdiskcache.html#clear

        **[override virtual slot] void QNetworkDiskCache::clear()**

        Reimplements: **QAbstractNetworkCache::clear** ().
        """
        ...

    def fileMetaData(self, fileName: str) -> QNetworkCacheMetaData:
        """
        https://doc.qt.io/qt-6/qnetworkdiskcache.html#fileMetaData

        **QNetworkCacheMetaData QNetworkDiskCache::fileMetaData(const QString &
        fileName ) const**

        Returns the **QNetworkCacheMetaData**  for the cache file **fileName**.

        If **fileName** is not a cache file **QNetworkCacheMetaData**  will be
        invalid.
        """
        ...

    def insert(self, device: QtCore.QIODevice) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkdiskcache.html#insert

        **[override virtual] void QNetworkDiskCache::insert(QIODevice * device
        )**

        Reimplements: **QAbstractNetworkCache::insert** (QIODevice *device).
        """
        ...

    def prepare(self, metaData: QNetworkCacheMetaData) -> QtCore.QIODevice:
        """
        https://doc.qt.io/qt-6/qnetworkdiskcache.html#prepare

        **[override virtual] QIODevice *QNetworkDiskCache::prepare(const
        QNetworkCacheMetaData & metaData )**

        Reimplements: **QAbstractNetworkCache::prepare** (const
        QNetworkCacheMetaData &metaData).
        """
        ...

    def remove(self, url: QtCore.QUrl) -> bool:
        """
        https://doc.qt.io/qt-6/qnetworkdiskcache.html#remove

        **[override virtual] bool QNetworkDiskCache::remove(const QUrl & url )**

        Reimplements: **QAbstractNetworkCache::remove** (const QUrl &url).
        """
        ...

    def data(self, url: QtCore.QUrl) -> QtCore.QIODevice:
        """
        https://doc.qt.io/qt-6/qnetworkdiskcache.html#data

        **[override virtual] QIODevice *QNetworkDiskCache::data(const QUrl & url
        )**

        Reimplements: **QAbstractNetworkCache::data** (const QUrl &url).
        """
        ...

    def updateMetaData(self, metaData: QNetworkCacheMetaData) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkdiskcache.html#updateMetaData

        **[override virtual] void QNetworkDiskCache::updateMetaData(const
        QNetworkCacheMetaData & metaData )**

        Reimplements: **QAbstractNetworkCache::updateMetaData** (const
        QNetworkCacheMetaData &metaData).
        """
        ...

    def metaData(self, url: QtCore.QUrl) -> QNetworkCacheMetaData:
        """
        https://doc.qt.io/qt-6/qnetworkdiskcache.html#metaData

        **[override virtual] QNetworkCacheMetaData
        QNetworkDiskCache::metaData(const QUrl & url )**

        Reimplements: **QAbstractNetworkCache::metaData** (const QUrl &url).
        """
        ...

    def cacheSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qnetworkdiskcache.html#cacheSize

        **[override virtual] qint64 QNetworkDiskCache::cacheSize() const**

        Reimplements: **QAbstractNetworkCache::cacheSize() const** .
        """
        ...

    def setMaximumCacheSize(self, size: int) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkdiskcache.html#setMaximumCacheSize

        **void QNetworkDiskCache::setMaximumCacheSize(qint64 size )**

        Sets the maximum size of the disk cache to be **size**.

        If the new size is smaller then the current cache size then the cache
        will call **expire** ().

        **See also** **maximumCacheSize** ().
        """
        ...

    def maximumCacheSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qnetworkdiskcache.html#maximumCacheSize

        **qint64 QNetworkDiskCache::maximumCacheSize() const**

        Returns the current maximum size for the disk cache.

        **See also** **setMaximumCacheSize** ().
        """
        ...

    def setCacheDirectory(self, cacheDir: str) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkdiskcache.html#setCacheDirectory

        **void QNetworkDiskCache::setCacheDirectory(const QString & cacheDir )**

        Sets the directory where cached files will be stored to **cacheDir**

        **QNetworkDiskCache**  will create this directory if it does not exists.

        Prepared cache items will be stored in the new cache directory when they
        are inserted.

        **See also** **cacheDirectory** () and **QStandardPaths::CacheLocation**
        .
        """
        ...

    def cacheDirectory(self) -> str:
        """
        https://doc.qt.io/qt-6/qnetworkdiskcache.html#cacheDirectory

        **QString QNetworkDiskCache::cacheDirectory() const**

        Returns the location where cached files will be stored.

        **See also** **setCacheDirectory** ().
        """
        ...
