"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtNetwork import *
import enum


class QNetworkRequest(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qnetworkrequest.html

    **Detailed Description**

    QNetworkRequest is part of the Network Access API and is the class holding
    the information necessary to send a request over the network. It contains a
    URL and some ancillary information that can be used to modify the request.

    **See also** **QNetworkReply**  and **QNetworkAccessManager** .
    """

    class TransferTimeoutConstant(enum.Enum):
        DefaultTransferTimeoutConstant: QNetworkRequest = ...

    class RedirectPolicy(enum.Enum):
        ManualRedirectPolicy: QNetworkRequest = ...
        NoLessSafeRedirectPolicy: QNetworkRequest = ...
        SameOriginRedirectPolicy: QNetworkRequest = ...
        UserVerifiedRedirectPolicy: QNetworkRequest = ...

    class Priority(enum.Enum):
        HighPriority: QNetworkRequest = ...
        NormalPriority: QNetworkRequest = ...
        LowPriority: QNetworkRequest = ...

    class LoadControl(enum.Enum):
        Automatic: QNetworkRequest = ...
        Manual: QNetworkRequest = ...

    class CacheLoadControl(enum.Enum):
        AlwaysNetwork: QNetworkRequest = ...
        PreferNetwork: QNetworkRequest = ...
        PreferCache: QNetworkRequest = ...
        AlwaysCache: QNetworkRequest = ...

    class Attribute(enum.Enum):
        HttpStatusCodeAttribute: QNetworkRequest = ...
        HttpReasonPhraseAttribute: QNetworkRequest = ...
        RedirectionTargetAttribute: QNetworkRequest = ...
        ConnectionEncryptedAttribute: QNetworkRequest = ...
        CacheLoadControlAttribute: QNetworkRequest = ...
        CacheSaveControlAttribute: QNetworkRequest = ...
        SourceIsFromCacheAttribute: QNetworkRequest = ...
        DoNotBufferUploadDataAttribute: QNetworkRequest = ...
        HttpPipeliningAllowedAttribute: QNetworkRequest = ...
        HttpPipeliningWasUsedAttribute: QNetworkRequest = ...
        CustomVerbAttribute: QNetworkRequest = ...
        CookieLoadControlAttribute: QNetworkRequest = ...
        AuthenticationReuseAttribute: QNetworkRequest = ...
        CookieSaveControlAttribute: QNetworkRequest = ...
        BackgroundRequestAttribute: QNetworkRequest = ...
        EmitAllUploadProgressSignalsAttribute: QNetworkRequest = ...
        Http2AllowedAttribute: QNetworkRequest = ...
        Http2WasUsedAttribute: QNetworkRequest = ...
        OriginalContentLengthAttribute: QNetworkRequest = ...
        RedirectPolicyAttribute: QNetworkRequest = ...
        Http2DirectAttribute: QNetworkRequest = ...
        AutoDeleteReplyOnFinishAttribute: QNetworkRequest = ...
        User: QNetworkRequest = ...
        UserMax: QNetworkRequest = ...

    class KnownHeaders(enum.Enum):
        ContentTypeHeader: QNetworkRequest = ...
        ContentLengthHeader: QNetworkRequest = ...
        LocationHeader: QNetworkRequest = ...
        LastModifiedHeader: QNetworkRequest = ...
        CookieHeader: QNetworkRequest = ...
        SetCookieHeader: QNetworkRequest = ...
        ContentDispositionHeader: QNetworkRequest = ...
        UserAgentHeader: QNetworkRequest = ...
        ServerHeader: QNetworkRequest = ...
        IfModifiedSinceHeader: QNetworkRequest = ...
        ETagHeader: QNetworkRequest = ...
        IfMatchHeader: QNetworkRequest = ...
        IfNoneMatchHeader: QNetworkRequest = ...

    @typing.overload
    def __init__(self, url: QtCore.QUrl) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkrequest.html#QNetworkRequest

        **QNetworkRequest::QNetworkRequest()**

        Constructs a QNetworkRequest object with no URL to be requested. Use
        **setUrl** () to set one.

        **See also** **url** () and **setUrl** ().
        """
        ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkrequest.html#QNetworkRequest-1

        **QNetworkRequest::QNetworkRequest(const QUrl & url )**

        Constructs a QNetworkRequest object with **url** as the URL to be
        requested.

        **See also** **url** () and **setUrl** ().
        """
        ...

    @typing.overload
    def __init__(self, other: "QNetworkRequest") -> None:
        """
        https://doc.qt.io/qt-6/qnetworkrequest.html#QNetworkRequest-2

        **QNetworkRequest::QNetworkRequest(const QNetworkRequest & other )**

        Creates a copy of **other**.
        """
        ...

    def setDecompressedSafetyCheckThreshold(self, threshold: int) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkrequest.html#setDecompressedSafetyCheckTh
        reshold

        **[since 6.2] void
        QNetworkRequest::setDecompressedSafetyCheckThreshold(qint64 threshold
        )**

        Sets the **threshold** for archive bomb checks.

        Some supported compression algorithms can, in a tiny compressed file,
        encode a spectacularly huge decompressed file. This is only possible if
        the decompressed content is extremely monotonous, which is seldom the
        case for real files being transmitted in good faith: files exercising
        such insanely high compression ratios are typically payloads of buffer-
        overrun attacks, or denial-of-service (by using up too much memory)
        attacks. Consequently, files that decompress to huge sizes, particularly
        from tiny compressed forms, are best rejected as suspected malware.

        If a reply's decompressed size is bigger than this threshold (by
        default, 10 MiB, i.e. 10 * 1024 * 1024), Qt will check the compression
        ratio: if that is unreasonably large (40:1 for GZip and Deflate, or
        100:1 for Brotli and ZStandard), the reply will be treated as an error.
        Setting the threshold to `-1` disables this check.

        This function was introduced in Qt 6.2.

        **See also** **decompressedSafetyCheckThreshold** ().
        """
        ...

    def decompressedSafetyCheckThreshold(self) -> int:
        """
        https://doc.qt.io/qt-6/qnetworkrequest.html#decompressedSafetyCheckThres
        hold

        **[since 6.2] qint64 QNetworkRequest::decompressedSafetyCheckThreshold()
        const**

        Returns the threshold for archive bomb checks.

        If the decompressed size of a reply is smaller than this, Qt will simply
        decompress it, without further checking.

        This function was introduced in Qt 6.2.

        **See also** **setDecompressedSafetyCheckThreshold** ().
        """
        ...

    def setTransferTimeout(self, timeout: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkrequest.html#setTransferTimeout

        **[since 5.15] void QNetworkRequest::setTransferTimeout(int timeout =
        DefaultTransferTimeoutConstant)**

        Sets **timeout** as the transfer timeout in milliseconds.

        Transfers are aborted if no bytes are transferred before the timeout
        expires. Zero means no timer is set. If no argument is provided, the
        timeout is **QNetworkRequest::DefaultTransferTimeoutConstant** . If this
        function is not called, the timeout is disabled and has the value zero.

        This function was introduced in Qt 5.15.

        **See also** **transferTimeout** .
        """
        ...

    def transferTimeout(self) -> int:
        """
        https://doc.qt.io/qt-6/qnetworkrequest.html#transferTimeout

        **[since 5.15] int QNetworkRequest::transferTimeout() const**

        Returns the timeout used for transfers, in milliseconds.

        This timeout is zero if **setTransferTimeout**  hasn't been called,
        which means that the timeout is not used.

        This function was introduced in Qt 5.15.

        **See also** **setTransferTimeout** .
        """
        ...

    def setHttp2Configuration(self, configuration: QHttp2Configuration) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkrequest.html#setHttp2Configuration

        **[since 5.14] void QNetworkRequest::setHttp2Configuration(const
        QHttp2Configuration & configuration )**

        Sets request's HTTP/2 parameters from **configuration**.

        **Note:** The configuration must be set prior to making a request.

        **Note:** HTTP/2 multiplexes several streams in a single HTTP/2
        connection. This implies that **QNetworkAccessManager**  will use the
        configuration found in the first request from a series of requests sent
        to the same host.

        This function was introduced in Qt 5.14.

        **See also** **http2Configuration** , **QNetworkAccessManager** , and
        **QHttp2Configuration** .
        """
        ...

    def http2Configuration(self) -> QHttp2Configuration:
        """
        https://doc.qt.io/qt-6/qnetworkrequest.html#http2Configuration

        **[since 5.14] QHttp2Configuration QNetworkRequest::http2Configuration()
        const**

        Returns the current parameters that **QNetworkAccessManager**  is using
        for this request and its underlying HTTP/2 connection. This is either a
        configuration previously set by an application or a default
        configuration.

        The default values that **QNetworkAccessManager**  is using are:

        * Window size for connection-level flowcontrol is 2147483647 octets
          *
        Window size for stream-level flowcontrol is 21474836 octets
          * Max
        frame size is 16384

        By default, server push is disabled, Huffman compression and string
        indexing are enabled.

        This function was introduced in Qt 5.14.

        **See also** **setHttp2Configuration** .
        """
        ...

    def setPeerVerifyName(self, peerName: str) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkrequest.html#setPeerVerifyName

        **[since 5.13] void QNetworkRequest::setPeerVerifyName(const QString &
        peerName )**

        Sets **peerName** as host name for the certificate validation, instead
        of the one used for the TCP connection.

        This function was introduced in Qt 5.13.

        **See also** **peerVerifyName** .
        """
        ...

    def peerVerifyName(self) -> str:
        """
        https://doc.qt.io/qt-6/qnetworkrequest.html#peerVerifyName

        **[since 5.13] QString QNetworkRequest::peerVerifyName() const**

        Returns the host name set for the certificate validation, as set by
        **setPeerVerifyName** . By default this returns a null string.

        This function was introduced in Qt 5.13.

        **See also** **setPeerVerifyName** .
        """
        ...

    def setMaximumRedirectsAllowed(self, maximumRedirectsAllowed: int) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkrequest.html#setMaximumRedirectsAllowed

        **[since 5.6] void QNetworkRequest::setMaximumRedirectsAllowed(int
        maxRedirectsAllowed )**

        Sets the maximum number of redirects allowed to be followed for this
        request to **maxRedirectsAllowed**.

        This function was introduced in Qt 5.6.

        **See also** **maximumRedirectsAllowed** ().
        """
        ...

    def maximumRedirectsAllowed(self) -> int:
        """
        https://doc.qt.io/qt-6/qnetworkrequest.html#maximumRedirectsAllowed

        **[since 5.6] int QNetworkRequest::maximumRedirectsAllowed() const**

        Returns the maximum number of redirects allowed to be followed for this
        request.

        This function was introduced in Qt 5.6.

        **See also** **setMaximumRedirectsAllowed** ().
        """
        ...

    def swap(self, other: "QNetworkRequest") -> None:
        """
        https://doc.qt.io/qt-6/qnetworkrequest.html#swap

        **[since 5.0] void QNetworkRequest::swap(QNetworkRequest & other )**

        Swaps this network request with **other**. This function is very fast
        and never fails.

        This function was introduced in Qt 5.0.
        """
        ...

    def setPriority(self, priority: "QNetworkRequest.Priority") -> None:
        """
        https://doc.qt.io/qt-6/qnetworkrequest.html#setPriority

        **void QNetworkRequest::setPriority(QNetworkRequest::Priority priority
        )**

        Set the priority of this request to **priority**.

        **Note:** The **priority** is only a hint to the network access manager.
        It can use it or not. Currently it is used for HTTP to decide which
        request should be sent first to a server.

        **See also** **priority** ().
        """
        ...

    def priority(self) -> "QNetworkRequest.Priority":
        """
        https://doc.qt.io/qt-6/qnetworkrequest.html#priority

        **QNetworkRequest::Priority QNetworkRequest::priority() const**

        Return the priority of this request.

        **See also** **setPriority** ().
        """
        ...

    def originatingObject(self) -> QtCore.QObject:
        """
        https://doc.qt.io/qt-6/qnetworkrequest.html#originatingObject

        **QObject *QNetworkRequest::originatingObject() const**

        Returns a reference to the object that initiated this network request;
        returns `nullptr` if not set or the object has been destroyed.

        **See also** **setOriginatingObject** ().
        """
        ...

    def setOriginatingObject(self, object: QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkrequest.html#setOriginatingObject

        **void QNetworkRequest::setOriginatingObject(QObject * object )**

        Allows setting a reference to the **object** initiating the request.

        For example Qt WebKit sets the originating object to the QWebFrame that
        initiated the request.

        **See also** **originatingObject** ().
        """
        ...

    def setSslConfiguration(self, configuration: "QSslConfiguration") -> None:
        """
        https://doc.qt.io/qt-6/qnetworkrequest.html#setSslConfiguration

        **void QNetworkRequest::setSslConfiguration(const QSslConfiguration &
        config )**

        Sets this network request's SSL configuration to be **config**. The
        settings that apply are the private key, the local certificate, the SSL
        protocol (SSLv2, SSLv3, TLSv1.0 where applicable), the CA certificates
        and the ciphers that the SSL backend is allowed to use.

        **See also** **sslConfiguration** () and
        **QSslConfiguration::defaultConfiguration** ().
        """
        ...

    def sslConfiguration(self) -> "QSslConfiguration":
        """
        https://doc.qt.io/qt-6/qnetworkrequest.html#sslConfiguration

        **QSslConfiguration QNetworkRequest::sslConfiguration() const**

        Returns this network request's SSL configuration. By default this is the
        same as **QSslConfiguration::defaultConfiguration** ().

        **See also** **setSslConfiguration** () and
        **QSslConfiguration::defaultConfiguration** ().
        """
        ...

    def setAttribute(
        self, code: "QNetworkRequest.Attribute", value: typing.Any
    ) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkrequest.html#setAttribute

        **void QNetworkRequest::setAttribute(QNetworkRequest::Attribute code ,
        const QVariant & value )**

        Sets the attribute associated with code **code** to be value **value**.
        If the attribute is already set, the previous value is discarded. In
        special, if **value** is an invalid **QVariant** , the attribute is
        unset.

        **See also** **attribute** () and **QNetworkRequest::Attribute** .
        """
        ...

    def attribute(
        self, code: "QNetworkRequest.Attribute", defaultValue: typing.Any = ...
    ) -> typing.Any:
        """
        https://doc.qt.io/qt-6/qnetworkrequest.html#attribute

        **QVariant QNetworkRequest::attribute(QNetworkRequest::Attribute code ,
        const QVariant & defaultValue = QVariant()) const**

        Returns the attribute associated with the code **code**. If the
        attribute has not been set, it returns **defaultValue**.

        **Note:** This function does not apply the defaults listed in
        **QNetworkRequest::Attribute** .

        **See also** **setAttribute** () and **QNetworkRequest::Attribute** .
        """
        ...

    def setRawHeader(
        self, headerName: QtCore.QByteArray, value: QtCore.QByteArray
    ) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkrequest.html#setRawHeader

        **void QNetworkRequest::setRawHeader(const QByteArray & headerName ,
        const QByteArray & headerValue )**

        Sets the header **headerName** to be of value **headerValue**. If
        **headerName** corresponds to a known header (see
        **QNetworkRequest::KnownHeaders** ), the raw format will be parsed and
        the corresponding "cooked" header will be set as well.

        For example:

        request.setRawHeader(**QByteArray** ("Last-Modified"), **QByteArray**
        ("Sun, 06 Nov 1994 08:49:37 GMT"));

        will also set the known header **LastModifiedHeader**  to be the
        **QDateTime**  object of the parsed date.

        **Note:** Setting the same header twice overrides the previous setting.
        To accomplish the behaviour of multiple HTTP headers of the same name,
        you should concatenate the two values, separating them with a comma
        (",") and set one single raw header.

        **See also** **KnownHeaders** , **setHeader** (), **hasRawHeader** (),
        and **rawHeader** ().
        """
        ...

    def rawHeader(self, headerName: QtCore.QByteArray) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qnetworkrequest.html#rawHeader

        **QByteArray QNetworkRequest::rawHeader(const QByteArray & headerName )
        const**

        Returns the raw form of header **headerName**. If no such header is
        present, an empty **QByteArray**  is returned, which may be
        indistinguishable from a header that is present but has no content (use
        **hasRawHeader** () to find out if the header exists or not).

        Raw headers can be set with **setRawHeader** () or with **setHeader**
        ().

        **See also** **header** () and **setRawHeader** ().
        """
        ...

    def rawHeaderList(self) -> typing.List[QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qnetworkrequest.html#rawHeaderList

        **QList<QByteArray> QNetworkRequest::rawHeaderList() const**

        Returns a list of all raw headers that are set in this network request.
        The list is in the order that the headers were set.

        **See also** **hasRawHeader** () and **rawHeader** ().
        """
        ...

    def hasRawHeader(self, headerName: QtCore.QByteArray) -> bool:
        """
        https://doc.qt.io/qt-6/qnetworkrequest.html#hasRawHeader

        **bool QNetworkRequest::hasRawHeader(const QByteArray & headerName )
        const**

        Returns `true` if the raw header **headerName** is present in this
        network request.

        **See also** **rawHeader** () and **setRawHeader** ().
        """
        ...

    def setHeader(
        self, header: "QNetworkRequest.KnownHeaders", value: typing.Any
    ) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkrequest.html#setHeader

        **void QNetworkRequest::setHeader(QNetworkRequest::KnownHeaders header ,
        const QVariant & value )**

        Sets the value of the known header **header** to be **value** ,
        overriding any previously set headers. This operation also sets the
        equivalent raw HTTP header.

        **See also** **KnownHeaders** , **setRawHeader** (), and **header** ().
        """
        ...

    def header(self, header: "QNetworkRequest.KnownHeaders") -> typing.Any:
        """
        https://doc.qt.io/qt-6/qnetworkrequest.html#header

        **QVariant QNetworkRequest::header(QNetworkRequest::KnownHeaders header
        ) const**

        Returns the value of the known network header **header** if it is
        present in this request. If it is not present, returns QVariant() (i.e.,
        an invalid variant).

        **See also** **KnownHeaders** , **rawHeader** (), and **setHeader** ().
        """
        ...

    def setUrl(self, url: QtCore.QUrl) -> None:
        """
        https://doc.qt.io/qt-6/qnetworkrequest.html#setUrl

        **void QNetworkRequest::setUrl(const QUrl & url )**

        Sets the URL this network request is referring to be **url**.

        **See also** **url** ().
        """
        ...

    def url(self) -> QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qnetworkrequest.html#url

        **QUrl QNetworkRequest::url() const**

        Returns the URL this network request is referring to.

        **See also** **setUrl** ().
        """
        ...
