"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6.QtNetwork import *
import enum


class QSslError(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qsslerror.html

    **Detailed Description**

    QSslError provides a simple API for managing errors during **QSslSocket** 's
    SSL handshake.

    **See also** **QSslSocket** , **QSslCertificate** , and **QSslCipher** .
    """

    class SslError(enum.Enum):
        UnspecifiedError: QSslError = ...
        NoError: QSslError = ...
        UnableToGetIssuerCertificate: QSslError = ...
        UnableToDecryptCertificateSignature: QSslError = ...
        UnableToDecodeIssuerPublicKey: QSslError = ...
        CertificateSignatureFailed: QSslError = ...
        CertificateNotYetValid: QSslError = ...
        CertificateExpired: QSslError = ...
        InvalidNotBeforeField: QSslError = ...
        InvalidNotAfterField: QSslError = ...
        SelfSignedCertificate: QSslError = ...
        SelfSignedCertificateInChain: QSslError = ...
        UnableToGetLocalIssuerCertificate: QSslError = ...
        UnableToVerifyFirstCertificate: QSslError = ...
        CertificateRevoked: QSslError = ...
        InvalidCaCertificate: QSslError = ...
        PathLengthExceeded: QSslError = ...
        InvalidPurpose: QSslError = ...
        CertificateUntrusted: QSslError = ...
        CertificateRejected: QSslError = ...
        SubjectIssuerMismatch: QSslError = ...
        AuthorityIssuerSerialNumberMismatch: QSslError = ...
        NoPeerCertificate: QSslError = ...
        HostNameMismatch: QSslError = ...
        NoSslSupport: QSslError = ...
        CertificateBlacklisted: QSslError = ...
        CertificateStatusUnknown: QSslError = ...
        OcspNoResponseFound: QSslError = ...
        OcspMalformedRequest: QSslError = ...
        OcspMalformedResponse: QSslError = ...
        OcspInternalError: QSslError = ...
        OcspTryLater: QSslError = ...
        OcspSigRequred: QSslError = ...
        OcspUnauthorized: QSslError = ...
        OcspResponseCannotBeTrusted: QSslError = ...
        OcspResponseCertIdUnknown: QSslError = ...
        OcspResponseExpired: QSslError = ...
        OcspStatusUnknown: QSslError = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qsslerror.html#QSslError

        **QSslError::QSslError()**

        Constructs a QSslError object with no error and default certificate.
        """
        ...

    @typing.overload
    def __init__(self, error: "QSslError.SslError") -> None:
        """
        https://doc.qt.io/qt-6/qsslerror.html#QSslError-1

        **QSslError::QSslError(QSslError::SslError error )**

        Constructs a QSslError object. The argument specifies the **error** that
        occurred.
        """
        ...

    @typing.overload
    def __init__(
        self, error: "QSslError.SslError", certificate: QSslCertificate
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsslerror.html#QSslError-2

        **QSslError::QSslError(QSslError::SslError error , const QSslCertificate
        & certificate )**

        Constructs a QSslError object. The two arguments specify the **error**
        that occurred, and which **certificate** the error relates to.

        **See also** **QSslCertificate** .
        """
        ...

    @typing.overload
    def __init__(self, other: "QSslError") -> None:
        """
        https://doc.qt.io/qt-6/qsslerror.html#QSslError-3

        **QSslError::QSslError(const QSslError & other )**

        Constructs an identical copy of **other**.
        """
        ...

    def __hash__(self) -> int:
        ...

    def swap(self, other: "QSslError") -> None:
        """
        https://doc.qt.io/qt-6/qsslerror.html#swap

        **[since 5.0] void QSslError::swap(QSslError & other )**

        Swaps this error instance with **other**. This function is very fast and
        never fails.

        This function was introduced in Qt 5.0.
        """
        ...

    def certificate(self) -> QSslCertificate:
        """
        https://doc.qt.io/qt-6/qsslerror.html#certificate

        **QSslCertificate QSslError::certificate() const**

        Returns the certificate associated with this error, or a null
        certificate if the error does not relate to any certificate.

        **See also** **error** () and **errorString** ().
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-6/qsslerror.html#errorString

        **QString QSslError::errorString() const**

        Returns a short localized human-readable description of the error.

        **See also** **error** () and **certificate** ().
        """
        ...

    def error(self) -> "QSslError.SslError":
        """
        https://doc.qt.io/qt-6/qsslerror.html#error

        **QSslError::SslError QSslError::error() const**

        Returns the type of the error.

        **See also** **errorString** () and **certificate** ().
        """
        ...
