"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtNfc import *


class QNdefFilter(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qndeffilter.html

    **Detailed Description**

    The QNdefFilter encapsulates the structure of an NDEF message and is used
    for matching messages that have a particular structure.

    The following filter matches NDEF messages that contain a single smart
    poster record:

    **QNdefFilter**  filter;
        filter.append(**QNdefRecord** ::NfcRtd, "Sp");

    The following filter matches NDEF messages that contain a URI, a localized
    piece of text and an optional JPEG image. The order of the records must be
    in the order specified:

    **QNdefFilter**  filter;
        filter.setOrderMatch(true);
    filter.appendRecord(**QNdefRecord** ::NfcRtd, "U");
    filter.appendRecord<**QNdefNfcTextRecord** >();
    filter.appendRecord(**QNdefRecord** ::Mime, "image/jpeg", 0, 1);

    The **match** () method can be used to check if a message matches the
    filter.

    **Matching Algorithms**

    The filter behavior depends on the value of **orderMatch** () parameter.

    **Note:** In the discussion below we will consider the filter records to be
    equal if their `typeNameFormat` and `type` parameters match. Joining two
    records means adding their `minimum` and `maximum` values, respectively.

    **Unordered Matching**

    If the record order is not taken into account, all the equal records in the
    filter can be joined. The resulting filter will contain only unique records,
    each with the updated `minimum` and `maximum` value.

    Consider the following example:

    **QNdefFilter**  filter;
        filter.appendRecord<**QNdefNfcTextRecord** >(0,
    1);
        filter.appendRecord<**QNdefNfcTextRecord** >(0, 1);
    filter.appendRecord(**QNdefRecord** ::Mime, "", 1, 1);
    filter.appendRecord<**QNdefNfcTextRecord** >(1, 1);
    filter.setOrderMatch(false);

    With the unordered matching, the filter will be simplified to the following:

    **QNdefFilter**  filter;
        filter.appendRecord<**QNdefNfcTextRecord** >(1,
    3);
        filter.appendRecord(**QNdefRecord** ::Mime, "", 1, 1);
    filter.setOrderMatch(false);

    Once the filter contains only the unique records, the matching algorithm
    iterates through the message and calculates the actual amount of records of
    each type. If all the actual amounts fit in the corresponding [minimum,
    maximum] ranges, the matching algorithm returns `true`.

    **Ordered Matching**

    If the record order is important, a different approach is applied. In this
    case the equal records can't be simply joined together. However, the
    consecutive equal records can still be joined. Then, the matching algorithm
    iterates through the message, this time also taking the positions of the
    records into account.

    **Handling Empty Type in Filter Record**

    It's possible to add a filter record with an empty `type`. In this case the
    empty type will act as a wildcard for any type.

    For example, the filter can be defined as follows:

    **QNdefFilter**  filter;
        filter.addRecord(**QNdefRecord** ::Mime, "", 1,
    1);

    This filter specifies that the message must contain exactly one NDEF record
    with **Mime**  **typeNameFormat** (), and any **type** ().

    **Handling Extra Records in the Message**

    If the message contains some records that do not match **any** record in the
    filter, the matching algorithm will return `false`.

    **Filter Examples**

    In the table below, each filter record is specified by the following
    parameters (in the given order):

    * `typeNameFormat` \\- contains the **typeNameFormat** () of the record.
      *
    `type` \\- contains the **type** () of the record.
      * `minimum` \\- contains
    the minimum amount of occurrences of the record in the message.
      *
    `maximum` \\- contains the maximum amount of occurrences of the record in the
    message.

    The filter contains multiple records.

    The message consists of multiple **QNdefRecord** s. In the table below, only
    the **typeNameFormat** () and **type** () of each record will be shown,
    because the other parameters do not matter for filtering.

    FilterMessageMatch ResultComment
    Empty filterEmpty messageMatch
    Empty
    filterNon-empty messageNo match
    Non-empty filterEmpty messageNo match
    [(**QNdefRecord::NfcRtd** , "T", 1, 2), (**QNdefRecord::Mime** , "", 1, 1),
    (**QNdefRecord::Empty** , "", 0, 100)][(**QNdefRecord::Mime** ,
    "image/jpeg"), (**QNdefRecord::Empty** , ""), (**QNdefRecord::NfcRtd** ,
    "T"), (**QNdefRecord::Empty** , ""), (**QNdefRecord::NfcRtd** ,
    "T")]Unordered: matchOrdered filter does not match because the message must
    start with a **QNdefRecord::NfcRtd**  record, but it starts with
    **QNdefRecord::Mime** .
    Ordered: no match
    [(**QNdefRecord::NfcRtd** ,
    "T", 0, 2), (**QNdefRecord::Mime** , "", 1, 1), (**QNdefRecord::NfcRtd** ,
    "T", 1, 1)][(**QNdefRecord::NfcRtd** , "T"), (**QNdefRecord::NfcRtd** ,
    "T"), (**QNdefRecord::Mime** , "image/jpeg")]Unordered: matchOrdered filter
    does not match because an **QNdefRecord::NfcRtd**  record is expected after
    **QNdefRecord::Mime** , but the message does not have it.
    Ordered: no
    match
    [(**QNdefRecord::NfcRtd** , "T", 0, 2), (**QNdefRecord::NfcRtd** ,
    "T", 1, 1), (**QNdefRecord::Mime** , "", 1, 1)][(**QNdefRecord::NfcRtd** ,
    "T"), (**QNdefRecord::Mime** , "image/jpeg")]Unordered: matchBoth cases
    match because the message contains the required minimum of records in the
    correct order.
    Ordered: match
    """

    class Record(PyQt6.sip.simplewrapper):
        maximum: int = ...
        minimum: int = ...
        type: QtCore = ...
        typeNameFormat = ...

        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QNdefFilter.Record") -> None:
            ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qndeffilter.html#QNdefFilter

        **QNdefFilter::QNdefFilter()**

        Constructs a new NDEF filter.
        """
        ...

    @typing.overload
    def __init__(self, other: "QNdefFilter") -> None:
        """
        https://doc.qt.io/qt-6/qndeffilter.html#QNdefFilter-1

        **QNdefFilter::QNdefFilter(const QNdefFilter & other )**

        Constructs a new NDEF filter that is a copy of **other**.
        """
        ...

    def match(self, message: "QNdefMessage") -> bool:
        """
        https://doc.qt.io/qt-6/qndeffilter.html#match

        **[since 6.2] bool QNdefFilter::match(const QNdefMessage & message )
        const**

        Returns `true` if the **message** matches the given filter. Otherwise
        returns `false`.

        See **Matching Algorithms**  for more detailed explanation of matching.

        This function was introduced in Qt 6.2.
        """
        ...

    def recordAt(self, i: int) -> "QNdefFilter.Record":
        """
        https://doc.qt.io/qt-6/qndeffilter.html#recordAt

        **QNdefFilter::Record QNdefFilter::recordAt(qsizetype i ) const**

        Returns the NDEF record at index **i**.

        **i** must be a valid index (i.e. 0 <= i < **recordCount** ()).

        **See also** **recordCount** ().
        """
        ...

    def __len__(self) -> int:
        ...

    def recordCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qndeffilter.html#recordCount

        **qsizetype QNdefFilter::recordCount() const**

        Returns the number of NDEF records in the filter.
        """
        ...

    @typing.overload
    def appendRecord(self, record: "QNdefFilter.Record") -> bool:
        """
        https://doc.qt.io/qt-6/qndeffilter.html#appendRecord

        **template <typename T> bool QNdefFilter::appendRecord(unsigned int min
        = 1, unsigned int max = 1)**

        Appends a record matching the template parameter to the NDEF filter. The
        record must occur between **min** and **max** times in the NDEF message.

        Returns `true` if the record was appended successfully. Otherwise
        returns `false`.
        """
        ...

    @typing.overload
    def appendRecord(
        self,
        typeNameFormat: "QNdefRecord.TypeNameFormat",
        type: QtCore.QByteArray,
        min: int = ...,
        max: int = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qndeffilter.html#appendRecord-1

        **bool QNdefFilter::appendRecord(QNdefRecord::TypeNameFormat
        typeNameFormat , const QByteArray & type , unsigned int min = 1,
        unsigned int max = 1)**

        Appends a record with type name format **typeNameFormat** and type
        **type** to the NDEF filter. The record must occur between **min** and
        **max** times in the NDEF message.

        Returns `true` if the record was appended successfully. Otherwise
        returns `false`.
        """
        ...

    def orderMatch(self) -> bool:
        """
        https://doc.qt.io/qt-6/qndeffilter.html#orderMatch

        **bool QNdefFilter::orderMatch() const**

        Returns `true` if the filter takes NDEF record order into account when
        matching. Otherwise returns `false`.

        **See also** **setOrderMatch** ().
        """
        ...

    def setOrderMatch(self, on: bool) -> None:
        """
        https://doc.qt.io/qt-6/qndeffilter.html#setOrderMatch

        **void QNdefFilter::setOrderMatch(bool on )**

        Sets the ordering requirements of the filter. If **on** is `true`, the
        filter will only match if the order of records in the filter matches the
        order of the records in the NDEF message. If **on** is `false`, the
        order of the records is not taken into account when matching.

        By default record order is not taken into account.

        **See also** **orderMatch** ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qndeffilter.html#clear

        **void QNdefFilter::clear()**

        Clears the filter.
        """
        ...
