"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtNfc import *


class QNdefMessage(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qndefmessage.html

    **Detailed Description**

    A QNdefMessage is a collection of 0 or more QNdefRecords. QNdefMessage
    inherits from **QList** <**QNdefRecord** > and therefore the standard
    **QList**  functions can be used to manipulate the NDEF records in the
    message.

    NDEF messages can be parsed from a byte array conforming to the NFC Data
    Exchange Format technical specification by using the **fromByteArray** ()
    static function. Conversely QNdefMessages can be converted into a byte array
    with the **toByteArray** () function.
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qndefmessage.html#QNdefMessage

        **QNdefMessage::QNdefMessage()**

        Constructs a new empty NDEF message.
        """
        ...

    @typing.overload
    def __init__(self, record: "QNdefRecord") -> None:
        """
        https://doc.qt.io/qt-6/qndefmessage.html#QNdefMessage-1

        **QNdefMessage::QNdefMessage(const QNdefRecord & record )**

        Constructs a new NDEF message containing a single record **record**.
        """
        ...

    @typing.overload
    def __init__(self, message: "QNdefMessage") -> None:
        """
        https://doc.qt.io/qt-6/qndefmessage.html#QNdefMessage-2

        **QNdefMessage::QNdefMessage(const QNdefMessage & message )**

        Constructs a new NDEF message that is a copy of **message**.
        """
        ...

    @typing.overload
    def __init__(self, records: typing.Iterable["QNdefRecord"]) -> None:
        """
        https://doc.qt.io/qt-6/qndefmessage.html#QNdefMessage-3

        **QNdefMessage::QNdefMessage(const QList<QNdefRecord> & records )**

        Constructs a new NDEF message that contains all of the records in
        **records**.
        """
        ...

    @staticmethod
    def fromByteArray(message: QtCore.QByteArray) -> "QNdefMessage":
        """
        https://doc.qt.io/qt-6/qndefmessage.html#fromByteArray

        **[static] QNdefMessage QNdefMessage::fromByteArray(const QByteArray &
        message )**

        Returns an NDEF message parsed from the contents of **message**.

        The **message** parameter is interpreted as the raw message format
        defined in the NFC Data Exchange Format technical specification.

        If a parse error occurs an empty NDEF message is returned.
        """
        ...

    def __delitem__(self, i: int) -> None:
        ...

    def __setitem__(self, i: int, value: "QNdefRecord") -> None:
        ...

    def __getitem__(self, i: int) -> "QNdefRecord":
        ...

    def __len__(self) -> int:
        ...

    def toByteArray(self) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qndefmessage.html#toByteArray

        **QByteArray QNdefMessage::toByteArray() const**

        Returns the NDEF message as a byte array.

        The return value of this function conforms to the format defined in the
        NFC Data Exchange Format technical specification.
        """
        ...
