"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt6 import QtCore
from PyQt6.QtNfc import *


class QNdefNfcIconRecord(QNdefRecord):
    """
    https://doc.qt.io/qt-6/qndefnfciconrecord.html

    **Detailed Description**

    This class wraps the image data into an NDEF message. It provides an NDEF
    record of type **QNdefRecord::Mime** . The **payload** () contains the raw
    image data.
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qndefnfciconrecord.html#QNdefNfcIconRecord

        **QNdefNfcIconRecord::QNdefNfcIconRecord()**

        Constructs an empty NDEF record of type **QNdefRecord::Mime** .
        """
        ...

    @typing.overload
    def __init__(self, other: QNdefRecord) -> None:
        """
        https://doc.qt.io/qt-6/qndefnfciconrecord.html#QNdefNfcIconRecord-1

        **QNdefNfcIconRecord::QNdefNfcIconRecord(const QNdefRecord & other )**

        Constructs an NDEF icon record that is a copy of **other**.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QNdefNfcIconRecord") -> None:
        """
        https://doc.qt.io/qt-6/qndefnfciconrecord.html#QNdefNfcIconRecord

        **QNdefNfcIconRecord::QNdefNfcIconRecord()**

        Constructs an empty NDEF record of type **QNdefRecord::Mime** .
        """
        ...

    def data(self) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qndefnfciconrecord.html#data

        **QByteArray QNdefNfcIconRecord::data() const**

        Returns the icon data as **QByteArray** .

        **See also** **setData** ().
        """
        ...

    def setData(self, data: QtCore.QByteArray) -> None:
        """
        https://doc.qt.io/qt-6/qndefnfciconrecord.html#setData

        **void QNdefNfcIconRecord::setData(const QByteArray & data )**

        Sets the contents of the icon record to **data**.

        **See also** **data** ().
        """
        ...
