"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtNfc import *
import enum


class QNearFieldManager(QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qnearfieldmanager.html

    **Detailed Description**

    NFC Forum devices support two modes of communications. The first mode, peer-
    to-peer communications, is used to communicate between two NFC Forum
    devices. The second mode, master/slave communications, is used to
    communicate between an NFC Forum device and an NFC Forum Tag or Contactless
    Card. The **targetDetected** () signal is emitted when a target device
    enters communications range. Communications can be initiated from the slot
    connected to this signal.

    NFC Forum devices generally operate as the master in master/slave
    communications. Some devices are also capable of operating as the slave, so
    called Card Emulation mode. In this mode the local NFC device emulates a NFC
    Forum Tag or Contactless Card.

    Applications can connect to the **targetDetected** () and **targetLost** ()
    signals to get notified when an NFC Forum Tag enters or leaves proximity.
    Before these signals are emitted target detection must be started with the
    **startTargetDetection** () function. Target detection can be stopped with
    the **stopTargetDetection** () function. When the target is no longer
    required the target should be deleted as other applications may be blocked
    from accessing the target.
    """

    class AdapterState(enum.Enum):
        Offline: QNearFieldManager = ...
        TurningOn: QNearFieldManager = ...
        Online: QNearFieldManager = ...
        TurningOff: QNearFieldManager = ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qnearfieldmanager.html#QNearFieldManager

        **QNearFieldManager::QNearFieldManager(QObject * parent = nullptr)**

        Constructs a new near field manager with **parent**.
        """
        ...

    def setUserInformation(self, message: str) -> None:
        """
        https://doc.qt.io/qt-6/qnearfieldmanager.html#setUserInformation

        **[since 6.2] void QNearFieldManager::setUserInformation(const QString &
        message )**

        Sets the message shown to the user by the system. If the target
        detection is running the **message** will be updated immediately and can
        be used as a progress message. The last message set before a call to
        **startTargetDetection** () without an error message is used as a
        success message. If the target detection is not running the **message**
        will be used as the initial message when the next detection is started.
        By default no message is shown to the user.

        **Note:** Currently, this function only has an effect on iOS because a
        popup is shown by the system during the scan. On iOS, this **message**
        is mapped to the alert message which is shown upon successful completion
        of the scan. Other platforms will ignore **message**.

        This function was introduced in Qt 6.2.

        **See also** **startTargetDetection** () and **stopTargetDetection** ().
        """
        ...

    def isEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-6/qnearfieldmanager.html#isEnabled

        **[since 6.2] bool QNearFieldManager::isEnabled() const**

        Returns `true` if the device has a NFC adapter and it is turned on;
        otherwise returns `false`.

        This function was introduced in Qt 6.2.

        **See also** **isSupported** ().
        """
        ...

    def isSupported(self, accessMethod: "QNearFieldTarget.AccessMethod" = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qnearfieldmanager.html#isSupported

        **[since 5.12] bool
        QNearFieldManager::isSupported(QNearFieldTarget::AccessMethod
        accessMethod = QNearFieldTarget::AnyAccess) const**

        Returns `true` if the underlying device has a NFC adapter; otherwise
        returns `false`. If an **accessMethod** is given, the function returns
        `true` only if the NFC adapter supports the given **accessMethod**.

        This function was introduced in Qt 5.12.

        **See also** **isEnabled** ().
        """
        ...

    def stopTargetDetection(self, errorMessage: str = ...) -> None:
        """
        https://doc.qt.io/qt-6/qnearfieldmanager.html#stopTargetDetection

        **void QNearFieldManager::stopTargetDetection(const QString &
        errorMessage = QString())**

        Stops detecting targets. The **targetDetected** () signal will no longer
        be emitted until another call to **startTargetDetection** () is made.
        Targets detected before are still valid.

        If an **errorMessage** is provided, this is a hint to the system that
        the goal, the application had, was not reached. The **errorMessage** and
        a matching error icon are shown to the user. Calling this function with
        an empty **errorMessage** , implies a successful operation end;
        otherwise an **errorMessage** should be passed to this function.

        **Note:** Currently, **errorMessage** only has an effect on iOS because
        a popup is shown by the system during the scan where the
        **errorMessage** is visible. Other platforms will ignore this parameter.

        **See also** **setUserInformation** ().
        """
        ...

    def startTargetDetection(
        self, accessMethod: "QNearFieldTarget.AccessMethod"
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qnearfieldmanager.html#startTargetDetection

        **bool
        QNearFieldManager::startTargetDetection(QNearFieldTarget::AccessMethod
        accessMethod )**

        Starts detecting targets and returns `true` if target detection is
        successfully started; otherwise returns `false`. Causes the
        **targetDetected** () signal to be emitted when a target is within
        proximity. Only tags with the given **accessMethod** will be delivered.
        Active detection continues until **stopTargetDetection** () has been
        called.

        To detect targets with a different **accessMethod** ,
        **stopTargetDetection** () must be called first.

        **See also** **stopTargetDetection** ().
        """
        ...

    @property
    def adapterStateChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qnearfieldmanager.html#adapterStateChanged

        **[signal, since 5.12] void
        QNearFieldManager::adapterStateChanged(QNearFieldManager::AdapterState
        state )**

        This signal is emitted whenever the **state** of the NFC adapter
        changed.

        **Note:** Currently, this signal is only emitted on Android.

        This function was introduced in Qt 5.12.
        """
        ...

    @property
    def targetDetected(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qnearfieldmanager.html#targetDetected

        **[signal] void QNearFieldManager::targetDetected(QNearFieldTarget *
        target )**

        This signal is emitted whenever a target is detected. The **target**
        parameter represents the detected target.

        This signal will be emitted for all detected targets.

        **QNearFieldManager**  maintains ownership of **target** , however, it
        will not be destroyed until the **QNearFieldManager**  destructor is
        called. Ownership may be transferred by calling **setParent** ().

        Do not delete **target** from the slot connected to this signal, instead
        call **deleteLater** ().

        **Note:** that if **target** is deleted before it moves out of proximity
        the **targetLost** () signal will not be emitted.

        **See also** **targetLost** ().
        """
        ...

    @property
    def targetDetectionStopped(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qnearfieldmanager.html#targetDetectionStopped

        **[signal, since 6.2] void QNearFieldManager::targetDetectionStopped()**

        This signal is emitted whenever the target detection is stopped.

        **Note:** Mostly this signal is emitted when **stopTargetDetection** ()
        has been called. Additionally the user is able to stop the detection on
        iOS within a popup shown by the system during the scan, which also leads
        to emitting this signal.

        This function was introduced in Qt 6.2.
        """
        ...

    @property
    def targetLost(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qnearfieldmanager.html#targetLost

        **[signal] void QNearFieldManager::targetLost(QNearFieldTarget * target
        )**

        This signal is emitted whenever a target moves out of proximity. The
        **target** parameter represents the lost target.

        Do not delete **target** from the slot connected to this signal, instead
        use **deleteLater** ().

        **See also** **QNearFieldTarget::disconnected** ().
        """
        ...
