"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtNfc import *
import enum


class QNearFieldTarget(QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qnearfieldtarget.html

    **Detailed Description**

    QNearFieldTarget provides a generic interface for communicating with an NFC
    target device. Both NFC Forum devices and NFC Forum Tag targets are
    supported by this class. All target specific classes subclass this class.

    The **type** () function can be used to get the type of the target device.
    The **uid** () function returns the unique identifier of the target. The
    **AccessMethods**  flags returns from the **accessMethods** () function can
    be tested to determine which access methods are supported by the target.

    If the target supports **NdefAccess** , **hasNdefMessage** () can be called
    to test if the target has a stored NDEF message, **readNdefMessages** () and
    **writeNdefMessages** () functions can be used to get and set the NDEF
    message.

    If the target supports **TagTypeSpecificAccess** , **sendCommand** () can be
    used to send a single proprietary command to the target and retrieve the
    response.
    """

    class Error(enum.Enum):
        NoError: QNearFieldTarget = ...
        UnknownError: QNearFieldTarget = ...
        UnsupportedError: QNearFieldTarget = ...
        TargetOutOfRangeError: QNearFieldTarget = ...
        NoResponseError: QNearFieldTarget = ...
        ChecksumMismatchError: QNearFieldTarget = ...
        InvalidParametersError: QNearFieldTarget = ...
        NdefReadError: QNearFieldTarget = ...
        NdefWriteError: QNearFieldTarget = ...
        CommandError: QNearFieldTarget = ...
        ConnectionError: QNearFieldTarget = ...
        TimeoutError: QNearFieldTarget = ...

    class AccessMethod(enum.Flag):
        UnknownAccess: QNearFieldTarget = ...
        NdefAccess: QNearFieldTarget = ...
        TagTypeSpecificAccess: QNearFieldTarget = ...
        AnyAccess: QNearFieldTarget = ...

    class Type(enum.Enum):
        ProprietaryTag: QNearFieldTarget = ...
        NfcTagType1: QNearFieldTarget = ...
        NfcTagType2: QNearFieldTarget = ...
        NfcTagType3: QNearFieldTarget = ...
        NfcTagType4: QNearFieldTarget = ...
        NfcTagType4A: QNearFieldTarget = ...
        NfcTagType4B: QNearFieldTarget = ...
        MifareTag: QNearFieldTarget = ...

    class RequestId(PyQt6.sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, other: "QNearFieldTarget.RequestId") -> None:
            ...

        def refCount(self) -> int:
            ...

        def isValid(self) -> bool:
            ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qnearfieldtarget.html#QNearFieldTarget

        **QNearFieldTarget::QNearFieldTarget(QObject * parent = nullptr)**

        Constructs a new near field target with **parent**.
        """
        ...

    def maxCommandLength(self) -> int:
        """
        https://doc.qt.io/qt-6/qnearfieldtarget.html#maxCommandLength

        **[since 5.9] int QNearFieldTarget::maxCommandLength() const**

        Returns the maximum number of bytes that can be sent with
        **sendCommand** . 0 will be returned if the target does not support
        sending tag type specific commands.

        This function was introduced in Qt 5.9.

        **See also** **sendCommand** ().
        """
        ...

    def disconnect(self) -> bool:
        """
        https://doc.qt.io/qt-6/qnearfieldtarget.html#disconnect

        **[since 5.9] bool QNearFieldTarget::disconnect()**

        Closes the connection to the target to enable communication with the
        target from a different instance. The connection will also be closed,
        when the **QNearFieldTarget**  is destroyed. A connection to the target
        device is (re)created to process a command or read/write a NDEF
        messages.

        Returns `true` only if an existing connection was successfully closed;
        otherwise returns `false`.

        This function was introduced in Qt 5.9.
        """
        ...

    def requestResponse(self, id: "QNearFieldTarget.RequestId") -> typing.Any:
        """
        https://doc.qt.io/qt-6/qnearfieldtarget.html#requestResponse

        **QVariant QNearFieldTarget::requestResponse(const
        QNearFieldTarget::RequestId & id ) const**

        Returns the decoded response for request **id**. If the request is
        unknown or has not yet been completed an invalid **QVariant**  is
        returned.
        """
        ...

    def waitForRequestCompleted(
        self, id: "QNearFieldTarget.RequestId", msecs: int = ...
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qnearfieldtarget.html#waitForRequestCompleted

        **bool QNearFieldTarget::waitForRequestCompleted(const
        QNearFieldTarget::RequestId & id , int msecs = 5000)**

        Waits up to **msecs** milliseconds for the request **id** to complete.
        Returns `true` if the request completes successfully and the
        requestCompeted() signal is emitted; otherwise returns `false`.
        """
        ...

    def sendCommand(self, command: QtCore.QByteArray) -> "QNearFieldTarget.RequestId":
        """
        https://doc.qt.io/qt-6/qnearfieldtarget.html#sendCommand

        **QNearFieldTarget::RequestId QNearFieldTarget::sendCommand(const
        QByteArray & command )**

        Sends **command** to the near field target. Returns a request id which
        can be used to track the completion status of the request. An invalid
        request id will be returned if the target does not support sending tag
        type specific commands.

        The **requestCompleted** () signal will be emitted on successful
        completion of the request; otherwise the **error** () signal will be
        emitted.

        Once the request completes successfully the response can be retrieved
        from the **requestResponse** () function. The response of this request
        will be a **QByteArray** .

        **See also** **requestCompleted** () and **waitForRequestCompleted** ().
        """
        ...

    def writeNdefMessages(
        self, messages: typing.Iterable[QNdefMessage]
    ) -> "QNearFieldTarget.RequestId":
        """
        https://doc.qt.io/qt-6/qnearfieldtarget.html#writeNdefMessages

        **QNearFieldTarget::RequestId QNearFieldTarget::writeNdefMessages(const
        QList<QNdefMessage> & messages )**

        Writes the NDEF messages in **messages** to the target. Returns a
        request id which can be used to track the completion status of the
        request. An invalid request id will be returned if the target does not
        support reading NDEF messages.

        The **requestCompleted** () signal will be emitted when the write
        operation completes successfully; otherwise the **error** () signal is
        emitted.
        """
        ...

    def readNdefMessages(self) -> "QNearFieldTarget.RequestId":
        """
        https://doc.qt.io/qt-6/qnearfieldtarget.html#readNdefMessages

        **QNearFieldTarget::RequestId QNearFieldTarget::readNdefMessages()**

        Starts reading NDEF messages stored on the near field target. Returns a
        request id which can be used to track the completion status of the
        request. An invalid request id will be returned if the target does not
        support reading NDEF messages.

        An **ndefMessageRead** () signal will be emitted for each NDEF message.
        The **requestCompleted** () signal will be emitted was all NDEF messages
        have been read. The **error** () signal is emitted if an error occurs.

        **Note:** An attempt to read an NDEF message from a tag, that is in
        INITIALIZED state as defined by NFC Forum, will fail with the
        **NdefReadError** , as the tag is formatted to support NDEF but does not
        contain a message yet.
        """
        ...

    def hasNdefMessage(self) -> bool:
        """
        https://doc.qt.io/qt-6/qnearfieldtarget.html#hasNdefMessage

        **bool QNearFieldTarget::hasNdefMessage()**

        Returns `true` if at least one NDEF message is stored on the near field
        target; otherwise returns `false`.
        """
        ...

    def accessMethods(self) -> "QNearFieldTarget.AccessMethod":
        """
        https://doc.qt.io/qt-6/qnearfieldtarget.html#accessMethods

        **QNearFieldTarget::AccessMethods QNearFieldTarget::accessMethods()
        const**

        Returns the access methods support by this near field target.
        """
        ...

    def type(self) -> "QNearFieldTarget.Type":
        """
        https://doc.qt.io/qt-6/qnearfieldtarget.html#type

        **QNearFieldTarget::Type QNearFieldTarget::type() const**

        Returns the type of tag type of this near field target.
        """
        ...

    def uid(self) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qnearfieldtarget.html#uid

        **QByteArray QNearFieldTarget::uid() const**

        Returns the UID of the near field target.
        """
        ...

    @property
    def disconnected(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qnearfieldtarget.html#disconnected

        **[signal] void QNearFieldTarget::disconnected()**

        This signal is emitted when the near field target moves out of
        proximity.
        """
        ...

    @property
    def error(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qnearfieldtarget.html#error

        **[signal] void QNearFieldTarget::error(QNearFieldTarget::Error error ,
        const QNearFieldTarget::RequestId & id )**

        This signal is emitted when an error occurs while processing request
        **id**. The **error** parameter describes the error.
        """
        ...

    @property
    def ndefMessageRead(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qnearfieldtarget.html#ndefMessageRead

        **[signal] void QNearFieldTarget::ndefMessageRead(const QNdefMessage &
        message )**

        This signal is emitted when a complete NDEF **message** has been read
        from the target.

        **See also** **readNdefMessages** ().
        """
        ...

    @property
    def requestCompleted(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qnearfieldtarget.html#requestCompleted

        **[signal] void QNearFieldTarget::requestCompleted(const
        QNearFieldTarget::RequestId & id )**

        This signal is emitted when a request **id** completes.

        **See also** **sendCommand** ().
        """
        ...
