"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtOpenGL import *
import enum


class QOpenGLDebugLogger(QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qopengldebuglogger.html

    **Detailed Description**

    **Introduction**

    OpenGL programming can be very error prone. Most of the time, a single
    failing call to OpenGL can cause an entire portion of an application to stop
    working, with nothing being drawn on the screen.

    The only way to be sure that no errors are being returned from the OpenGL
    implementation is checking with `glGetError` after each and every API call.
    Moreover, OpenGL errors stack up, therefore glGetError should always be used
    in a loop like this:

    GLenum error = GL_NO_ERROR;
        do {
            error = glGetError();
    if (error != GL_NO_ERROR) {
                // handle the error
            }
        }
    while (error != GL_NO_ERROR);

    If you try to clear the error stack, make sure not just keep going until
    GL_NO_ERROR is returned but also break on GL_CONTEXT_LOST as that error
    value will keep repeating.

    There are also many other information we are interested in (as application
    developers), for instance performance issues, or warnings about using
    deprecated APIs. Those kind of messages are not reported through the
    ordinary OpenGL error reporting mechanisms.

    QOpenGLDebugLogger aims at addressing these issues by providing access to
    the **OpenGL debug log**. If your OpenGL implementation supports it (by
    exposing the `GL_KHR_debug` extension), messages from the OpenGL server will
    be either logged in an internal OpenGL log, or passed in "real-time" to
    listeners as they're generated from OpenGL.

    QOpenGLDebugLogger supports both these modes of operation. Refer to the
    following sections to find out the differences between them.

    **Creating an OpenGL Debug Context**

    For efficiency reasons, OpenGL implementations are allowed not to create any
    debug output at all, unless the OpenGL context is a debug context. In order
    to create a debug context from Qt, you must set the
    **QSurfaceFormat::DebugContext**  format option on the **QSurfaceFormat**
    used to create the **QOpenGLContext**  object:

    **QSurfaceFormat**  format;
        // asks for a OpenGL 3.2 debug context using
    the Core profile
        format.setMajorVersion(3);
    format.setMinorVersion(2);
        format.setProfile(**QSurfaceFormat**
    ::CoreProfile);
        format.setOption(**QSurfaceFormat** ::DebugContext);
    **QOpenGLContext**  *context = new **QOpenGLContext** ;
    context->setFormat(format);
        context->create();

    Note that requesting a 3.2 OpenGL Core Profile is just for the example's
    purposes; this class is not tied to any specific OpenGL or OpenGL ES
    version, as it relies on the availability of the `GL_KHR_debug` extension
    (see below).

    **Creating and Initializing a QOpenGLDebugLogger**

    QOpenGLDebugLogger is a simple **QObject** -derived class. Just like all
    **QObject**  subclasses, you create an instance (and optionally specify a
    parent object), and like the other OpenGL functions in Qt you **must**
    initialize it before usage by calling **initialize** () whilst there is a
    current OpenGL context:

    **QOpenGLContext**  *ctx = **QOpenGLContext** ::currentContext();
    **QOpenGLDebugLogger**  *logger = new **QOpenGLDebugLogger** (this);
    logger->initialize(); // initializes in the current context, i.e. ctx

    Note that the `GL_KHR_debug` extension **must** be available in the context
    in order to access the messages logged by OpenGL. You can check the presence
    of this extension by calling:

    ctx->hasExtension(**QByteArrayLiteral** ("GL_KHR_debug"));

    where `ctx` is a valid **QOpenGLContext** . If the extension is not
    available, **initialize** () will return false.

    **Reading the Internal OpenGL Debug Log**

    OpenGL implementations keep an internal log of debug messages. Messages
    stored in this log can be retrieved by using the **loggedMessages** ()
    function:

    const **QList** <**QOpenGLDebugMessage** > messages =
    logger->loggedMessages();
        for (const **QOpenGLDebugMessage**  &message :
    messages)
            **qDebug** () << message;

    The internal log has a limited size; when it fills up, older messages will
    get discarded to make room for the new incoming messages. When you call
    **loggedMessages** (), the internal log will be emptied as well.

    If you want to be sure not to lose any debug message, you must use real-time
    logging instead of calling this function. However, debug messages might
    still be generated in the timespan between context creation and activation
    of real-time logging (or, in general, when the real-time logging is
    disabled).

    **Real-time logging of messages**

    It is also possible to receive a stream of debug messages from the OpenGL
    server **as they are generated** by the implementation. In order to do so,
    you need to connect a suitable slot to the **messageLogged** () signal, and
    start logging by calling **startLogging** ():

    connect(logger, &**QOpenGLDebugLogger** ::messageLogged, receiver,
    &LogHandler::handleLoggedMessage);
        logger->startLogging();

    Similarly, logging can be disabled at any time by calling the
    **stopLogging** () function.

    Real-time logging can be either asynchronous or synchronous, depending on
    the parameter passed to **startLogging** (). When logging in asynchronous
    mode (the default, as it has a very small overhead), the OpenGL
    implementation can generate messages at any time, and/or in an order which
    is different from the order of the OpenGL commands which caused those
    messages to be logged. The messages could also be generated from a thread
    that it's different from the thread the context is currently bound to. This
    is because OpenGL implementations are usually highly threaded and
    asynchronous, and therefore no warranties are made about the relative order
    and the timings of the debug messages.

    On the other hand, logging in synchronous mode has a high overhead, but the
    OpenGL implementation guarantees that all the messages caused by a certain
    command are received in order, before the command returns, and from the same
    thread the OpenGL context is bound to.

    This means that when logging in synchronous mode you will be able to run
    your OpenGL application in a debugger, put a breakpoint on a slot connected
    to the **messageLogged** () signal, and see in the backtrace the exact call
    that caused the logged message. This can be extremely useful to debug an
    OpenGL problem. Note that if OpenGL rendering is happening in another
    thread, you must force the signal/slot connection type to
    **Qt::DirectConnection**  in order to be able to see the actual backtrace.

    Refer to the **LoggingMode**  enum documentation for more information about
    logging modes.

    **Note:** When real-time logging is enabled, debug messages will **not** be
    inserted in the internal OpenGL debug log any more; messages already present
    in the internal log will not be deleted, nor they will be emitted through
    the **messageLogged** () signal. Since some messages might be generated
    before real-time logging is started (and therefore be kept in the internal
    OpenGL log), it is important to always check if it contains any message
    after calling **startLogging** ().

    **Inserting Messages in the Debug Log**

    It is possible for applications and libraries to insert custom messages in
    the debug log, for instance for marking a group of related OpenGL commands
    and therefore being then able to identify eventual messages coming from
    them.

    In order to do so, you can create a **QOpenGLDebugMessage**  object by
    calling **createApplicationMessage** () or **createThirdPartyMessage** (),
    and then inserting it into the log by calling **logMessage** ():

    **QOpenGLDebugMessage**  message =
            **QOpenGLDebugMessage**
    ::createApplicationMessage(**QStringLiteral** ("Custom message"));
    logger->logMessage(message);

    Note that OpenGL implementations have a vendor-specific limit to the length
    of the messages that can be inserted in the debug log. You can retrieve this
    length by calling the **maximumMessageLength** () method; messages longer
    than the limit will automatically get truncated.

    **Controlling the Debug Output**

    **QOpenGLDebugMessage**  is also able to apply filters to the debug
    messages, and therefore limit the amount of messages logged. You can enable
    or disable logging of messages by calling **enableMessages** () and
    **disableMessages** () respectively. By default, all messages are logged.

    It is possible to enable or disable messages by selecting them by:

    * source, type and severity (and including all ids in the selection);
      *
    id, source and type (and including all severities in the selection).

    Note that the "enabled" status for a given message is a property of the (id,
    source, type, severity) tuple; the message attributes **do not** form a
    hierarchy of any kind. You should be careful about the order of the calls to
    **enableMessages** () and **disableMessages** (), as it will change which
    messages will are enabled / disabled.

    It's not possible to filter by the message text itself; applications have to
    do that on their own (in slots connected to the **messageLogged** () signal,
    or after fetching the messages in the internal debug log through
    **loggedMessages** ()).

    In order to simplify the management of the enabled / disabled statuses,
    **QOpenGLDebugMessage**  also supports the concept of `debug groups`. A
    debug group contains the group of enabled / disabled configurations of debug
    messages. Moreover, debug groups are organized in a stack: it is possible to
    push and pop groups by calling **pushGroup** () and **popGroup** ()
    respectively. (When an OpenGL context is created, there is already a group
    in the stack).

    The **enableMessages** () and **disableMessages** () functions will modify
    the configuration in the current debug group, that is, the one at the top of
    the debug groups stack.

    When a new group is pushed onto the debug groups stack, it will inherit the
    configuration of the group that was previously on the top of the stack. Vice
    versa, popping a debug group will restore the configuration of the debug
    group that becomes the new top.

    Pushing (respectively popping) debug groups will also automatically generate
    a debug message of type **QOpenGLDebugMessage::GroupPushType**
    (respectively **GroupPopType** ).

    **See also** **QOpenGLDebugMessage** .
    """

    class LoggingMode(enum.Enum):
        AsynchronousLogging: QOpenGLDebugLogger = ...
        SynchronousLogging: QOpenGLDebugLogger = ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qopengldebuglogger.html#QOpenGLDebugLogger

        **QOpenGLDebugLogger::QOpenGLDebugLogger(QObject * parent = nullptr)**

        Constructs a new logger object with the given **parent**.

        **Note:** The object must be initialized before logging can happen.

        **See also** **initialize** ().
        """
        ...

    def stopLogging(self) -> None:
        """
        https://doc.qt.io/qt-6/qopengldebuglogger.html#stopLogging

        **[slot] void QOpenGLDebugLogger::stopLogging()**

        Stops logging messages from the OpenGL server.

        **See also** **startLogging** ().
        """
        ...

    def startLogging(self, loggingMode: "QOpenGLDebugLogger.LoggingMode" = ...) -> None:
        """
        https://doc.qt.io/qt-6/qopengldebuglogger.html#startLogging

        **[slot] void
        QOpenGLDebugLogger::startLogging(QOpenGLDebugLogger::LoggingMode
        loggingMode = AsynchronousLogging)**

        Starts logging messages coming from the OpenGL server. When a new
        message is received, the signal **messageLogged** () is emitted,
        carrying the logged message as argument.

        **loggingMode** specifies whether the logging must be asynchronous (the
        default) or synchronous.

        **QOpenGLDebugLogger**  will record the values of `GL_DEBUG_OUTPUT` and
        `GL_DEBUG_OUTPUT_SYNCHRONOUS` when logging is started, and set them back
        when logging is stopped. Moreover, any user-defined OpenGL debug
        callback installed when this function is invoked will be restored when
        logging is stopped; **QOpenGLDebugLogger**  will ensure that the pre-
        existing callback will still be invoked when logging.

        **Note:** It's not possible to change the logging mode without stopping
        and starting logging again. This might change in a future version of Qt.

        **Note:** The object must be initialized before logging can happen.

        **See also** **stopLogging** () and **initialize** ().
        """
        ...

    def logMessage(self, debugMessage: QOpenGLDebugMessage) -> None:
        """
        https://doc.qt.io/qt-6/qopengldebuglogger.html#logMessage

        **[slot] void QOpenGLDebugLogger::logMessage(const QOpenGLDebugMessage &
        debugMessage )**

        Inserts the message **debugMessage** into the OpenGL debug log. This
        provides a way for applications or libraries to insert custom messages
        that can ease the debugging of OpenGL applications.

        **Note:** **debugMessage** must have
        **QOpenGLDebugMessage::ApplicationSource**  or
        **QOpenGLDebugMessage::ThirdPartySource**  as its source, and a valid
        type and severity, otherwise it will not be inserted into the log.

        **Note:** The object must be initialized before logging can happen.

        **See also** **initialize** ().
        """
        ...

    def loggedMessages(self) -> typing.List[QOpenGLDebugMessage]:
        """
        https://doc.qt.io/qt-6/qopengldebuglogger.html#loggedMessages

        **QList<QOpenGLDebugMessage> QOpenGLDebugLogger::loggedMessages()
        const**

        Reads all the available messages in the OpenGL internal debug log and
        returns them. Moreover, this function will clear the internal debug log,
        so that subsequent invocations will not return messages that were
        already returned.

        **See also** **startLogging** ().
        """
        ...

    @typing.overload
    def disableMessages(
        self,
        sources: QOpenGLDebugMessage.Source = ...,
        types: QOpenGLDebugMessage.Type = ...,
        severities: QOpenGLDebugMessage.Severity = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengldebuglogger.html#disableMessages

        **void QOpenGLDebugLogger::disableMessages(QOpenGLDebugMessage::Sources
        sources = QOpenGLDebugMessage::AnySource, QOpenGLDebugMessage::Types
        types = QOpenGLDebugMessage::AnyType, QOpenGLDebugMessage::Severities
        severities = QOpenGLDebugMessage::AnySeverity)**

        Disables the logging of messages with the given **sources** , of the
        given **types** and with the given **severities** and any message id.

        The logging will be disabled in the current control group.

        **See also** **enableMessages** (), **pushGroup** (), and **popGroup**
        ().
        """
        ...

    @typing.overload
    def disableMessages(
        self,
        ids: typing.Iterable[int],
        sources: QOpenGLDebugMessage.Source = ...,
        types: QOpenGLDebugMessage.Type = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengldebuglogger.html#disableMessages-1

        **void QOpenGLDebugLogger::disableMessages(const QList<GLuint> & ids ,
        QOpenGLDebugMessage::Sources sources = QOpenGLDebugMessage::AnySource,
        QOpenGLDebugMessage::Types types = QOpenGLDebugMessage::AnyType)**

        Disables the logging of messages with the given **ids** , from the given
        **sources** and of the given **types** and any severity.

        The logging will be disabled in the current control group.

        **See also** **enableMessages** (), **pushGroup** (), and **popGroup**
        ().
        """
        ...

    @typing.overload
    def enableMessages(
        self,
        sources: QOpenGLDebugMessage.Source = ...,
        types: QOpenGLDebugMessage.Type = ...,
        severities: QOpenGLDebugMessage.Severity = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengldebuglogger.html#enableMessages

        **void QOpenGLDebugLogger::enableMessages(QOpenGLDebugMessage::Sources
        sources = QOpenGLDebugMessage::AnySource, QOpenGLDebugMessage::Types
        types = QOpenGLDebugMessage::AnyType, QOpenGLDebugMessage::Severities
        severities = QOpenGLDebugMessage::AnySeverity)**

        Enables the logging of messages from the given **sources** , of the
        given **types** and with the given **severities** and any message id.

        The logging will be enabled in the current control group.

        **See also** **disableMessages** (), **pushGroup** (), and **popGroup**
        ().
        """
        ...

    @typing.overload
    def enableMessages(
        self,
        ids: typing.Iterable[int],
        sources: QOpenGLDebugMessage.Source = ...,
        types: QOpenGLDebugMessage.Type = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengldebuglogger.html#enableMessages-1

        **void QOpenGLDebugLogger::enableMessages(const QList<GLuint> & ids ,
        QOpenGLDebugMessage::Sources sources = QOpenGLDebugMessage::AnySource,
        QOpenGLDebugMessage::Types types = QOpenGLDebugMessage::AnyType)**

        Enables the logging of messages with the given **ids** , from the given
        **sources** and of the given **types** and any severity.

        The logging will be enabled in the current control group.

        **See also** **disableMessages** (), **pushGroup** (), and **popGroup**
        ().
        """
        ...

    def popGroup(self) -> None:
        """
        https://doc.qt.io/qt-6/qopengldebuglogger.html#popGroup

        **void QOpenGLDebugLogger::popGroup()**

        Pops the topmost debug group from the debug groups stack. If the group
        is successfully popped, OpenGL will automatically log a message with
        message, id and source matching those of the popped group, type
        **QOpenGLDebugMessage::GroupPopType**  and severity
        **QOpenGLDebugMessage::NotificationSeverity** .

        Popping a debug group will restore the message filtering settings of the
        group that becomes the top of the debug groups stack.

        **Note:** The object must be initialized before managing debug groups.

        **See also** **pushGroup** ().
        """
        ...

    def pushGroup(
        self, name: str, id: int = ..., source: QOpenGLDebugMessage.Source = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengldebuglogger.html#pushGroup

        **void QOpenGLDebugLogger::pushGroup(const QString & name , GLuint id =
        0, QOpenGLDebugMessage::Source source =
        QOpenGLDebugMessage::ApplicationSource)**

        Pushes a debug group with name **name** , id **id** , and source
        **source** onto the debug groups stack. If the group is successfully
        pushed, OpenGL will automatically log a message with message **name** ,
        id **id** , source **source** , type
        **QOpenGLDebugMessage::GroupPushType**  and severity
        **QOpenGLDebugMessage::NotificationSeverity** .

        The newly pushed group will inherit the same filtering settings of the
        group that was on the top of the stack; that is, the filtering will not
        be changed by pushing a new group.

        **Note:** The **source** must either be
        **QOpenGLDebugMessage::ApplicationSource**  or
        **QOpenGLDebugMessage::ThirdPartySource** , otherwise the group will not
        be pushed.

        **Note:** The object must be initialized before managing debug groups.

        **See also** **popGroup** (), **enableMessages** (), and
        **disableMessages** ().
        """
        ...

    def maximumMessageLength(self) -> int:
        """
        https://doc.qt.io/qt-6/qopengldebuglogger.html#maximumMessageLength

        **qint64 QOpenGLDebugLogger::maximumMessageLength() const**

        Returns the maximum supported length, in bytes, for the text of the
        messages passed to **logMessage** (). This is also the maximum length of
        a debug group name, as pushing or popping groups will automatically log
        a message with the debug group name as the message text.

        If a message text is too long, it will be automatically truncated by
        **QOpenGLDebugLogger** .

        **Note:** Message texts are encoded in UTF-8 when they get passed to
        OpenGL, so their size in bytes does not usually match the amount of
        UTF-16 code units, as returned, for instance, by **QString::length** ().
        (It does if the message contains 7-bit ASCII only data, which is typical
        for debug messages.)
        """
        ...

    def loggingMode(self) -> "QOpenGLDebugLogger.LoggingMode":
        """
        https://doc.qt.io/qt-6/qopengldebuglogger.html#loggingMode

        **QOpenGLDebugLogger::LoggingMode QOpenGLDebugLogger::loggingMode()
        const**

        Returns the logging mode of the object.

        **Note:** Getter function for property loggingMode.

        **See also** **startLogging** ().
        """
        ...

    def isLogging(self) -> bool:
        """
        https://doc.qt.io/qt-6/qopengldebuglogger.html#isLogging

        **bool QOpenGLDebugLogger::isLogging() const**

        Returns `true` if this object is currently logging, false otherwise.

        **See also** **startLogging** ().
        """
        ...

    def initialize(self) -> bool:
        """
        https://doc.qt.io/qt-6/qopengldebuglogger.html#initialize

        **bool QOpenGLDebugLogger::initialize()**

        Initializes the object in the current OpenGL context. The context must
        support the `GL_KHR_debug` extension for the initialization to succeed.
        The object must be initialized before any logging can happen.

        It is safe to call this function multiple times from the same context.

        This function can also be used to change the context of a previously
        initialized object; note that in this case the object must not be
        logging when you call this function.

        Returns `true` if the logger is successfully initialized; false
        otherwise.

        **See also** **QOpenGLContext** .
        """
        ...

    @property
    def messageLogged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qopengldebuglogger.html#messageLogged

        **[signal] void QOpenGLDebugLogger::messageLogged(const
        QOpenGLDebugMessage & debugMessage )**

        This signal is emitted when a debug message (wrapped by the
        **debugMessage** argument) is logged from the OpenGL server.

        Depending on the OpenGL implementation, this signal can be emitted from
        other threads than the one(s) the receiver(s) lives in, and even
        different from the thread the **QOpenGLContext**  in which this object
        has been initialized lives in. Moreover, the signal could be emitted
        from multiple threads at the same time. This is normally not a problem,
        as Qt will utilize a queued connection for cross-thread signal
        emissions, but if you force the connection type to Direct then you must
        be aware of the potential races in the slots connected to this signal.

        If logging have been started in **SynchronousLogging**  mode, OpenGL
        guarantees that this signal will be emitted from the same thread the
        **QOpenGLContext**  has been bound to, and no concurrent invocations
        will ever happen.

        **Note:** Logging must have been started, or this signal will not be
        emitted.

        **See also** **startLogging** ().
        """
        ...
